/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

class Utf16RevReader
extends Reader {
    private InputStream is;

    Utf16RevReader(InputStream is) {
        this.is = is;
    }

    @Override
    public int read() throws IOException {
        int ch1 = this.is.read();
        int ch2 = this.is.read();
        if (ch2 < 0) {
            return -1;
        }
        return (ch2 << 8) + ch1;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int i = 0;
        for (i = 0; i < len; ++i) {
            int ch1 = this.is.read();
            int ch2 = this.is.read();
            if (ch1 < 0) {
                return i == 0 ? -1 : i;
            }
            cbuf[off + i] = (char)((ch2 << 8) + ch1);
        }
        return i;
    }

    @Override
    public void close() {
    }
}

