/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml.stream;

import com.caucho.util.L10N;
import com.caucho.xml.stream.NamespaceBinding;
import java.util.ArrayList;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public abstract class NamespaceContextImpl
implements NamespaceContext {
    public static final L10N L = new L10N(NamespaceContextImpl.class);
    protected final ArrayList<ElementBinding> _stack = new ArrayList();
    protected int _version = 0;

    NamespaceContextImpl() {
        this._stack.add(null);
    }

    public int getDepth() {
        return this._stack.size() - 1;
    }

    public void push() {
        this._stack.add(null);
    }

    public void pop() throws XMLStreamException {
        if (this._stack.size() == 0) {
            throw new XMLStreamException(L.l("Multiple root elements in document"));
        }
        ElementBinding eltBinding = this._stack.remove(this._stack.size() - 1);
        if (eltBinding != null) {
            ArrayList<Decl> oldBinding = eltBinding.getOldBindingList();
            for (int i = 0; oldBinding != null && i < oldBinding.size(); ++i) {
                Decl decl = oldBinding.get(i);
                NamespaceBinding binding = decl.getBinding();
                ++this._version;
                if (decl.getOldUri() == null) {
                    binding.setUri(decl.getOldUri());
                    binding.setVersion(this._version);
                    continue;
                }
                binding.setUri(decl.getOldUri());
                binding.setVersion(this._version);
            }
            eltBinding.clear();
        }
    }

    public void setElementName(QName name) {
        ElementBinding eltBinding = this._stack.get(this._stack.size() - 1);
        if (eltBinding == null) {
            eltBinding = new ElementBinding();
            this._stack.set(this._stack.size() - 1, eltBinding);
        }
        eltBinding.setName(name);
    }

    public QName getElementName() {
        ElementBinding eltBinding = this._stack.get(this._stack.size() - 1);
        if (eltBinding != null) {
            return eltBinding.getName();
        }
        return null;
    }

    public abstract void declare(String var1, String var2);

    protected abstract void remove(String var1, String var2);

    static class PrefixIterator {
        private ElementBinding _eltBinding;
        private int _index = 0;

        PrefixIterator(NamespaceContextImpl context, ElementBinding eltBinding) {
            this._eltBinding = eltBinding;
        }

        public void remove() {
            throw new RuntimeException("not supported");
        }

        public boolean hasNext() {
            if (this._eltBinding == null) {
                return false;
            }
            return this._index < this._eltBinding.getOldBindingList().size();
        }

        public Object next() {
            if (this._eltBinding == null) {
                return null;
            }
            ArrayList<Decl> oldBindingList = this._eltBinding.getOldBindingList();
            if (this._index < oldBindingList.size()) {
                return oldBindingList.get(this._index++).getPrefix();
            }
            return null;
        }
    }

    static class Decl {
        private final NamespaceBinding _binding;
        private final String _prefix;
        private final String _oldUri;
        private final String _newUri;

        Decl(NamespaceBinding binding, String prefix, String oldUri, String newUri) {
            this._binding = binding;
            this._prefix = prefix;
            this._oldUri = oldUri;
            this._newUri = newUri;
        }

        NamespaceBinding getBinding() {
            return this._binding;
        }

        String getPrefix() {
            return this._prefix;
        }

        String getOldUri() {
            return this._oldUri;
        }

        String getNewUri() {
            return this._newUri;
        }

        public String toString() {
            return "Decl[binding=" + this._binding + ",prefix=" + this._prefix + ",oldUri=" + this._oldUri + ",newUri=" + this._newUri + "]";
        }
    }

    static class ElementBinding {
        private QName _name;
        private ArrayList<Decl> _declList;

        ElementBinding() {
        }

        public void setName(QName name) {
            this._name = name;
        }

        public void clear() {
            this._declList = null;
        }

        public QName getName() {
            return this._name;
        }

        public void addOldBinding(NamespaceBinding binding, String prefix, String oldUri, String newUri) {
            if (this._declList == null) {
                this._declList = new ArrayList();
            }
            this._declList.add(new Decl(binding, prefix, oldUri, newUri));
        }

        public ArrayList<Decl> getOldBindingList() {
            return this._declList;
        }
    }
}

