/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml2;

import com.caucho.util.L10N;
import com.caucho.vfs.Depend;
import com.caucho.vfs.WriteStream;
import com.caucho.xml2.CauchoNode;
import com.caucho.xml2.QDOMException;
import com.caucho.xml2.QDocument;
import com.caucho.xml2.QEmptyNodeList;
import com.caucho.xml2.QNode;
import com.caucho.xml2.SerializedXml;
import com.caucho.xml2.XmlChar;
import com.caucho.xml2.XmlPrinter;
import com.caucho.xml2.XmlUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

public abstract class QAbstractNode
implements CauchoNode,
Serializable {
    protected static L10N L = new L10N(QAbstractNode.class);
    QDocument _owner;
    QNode _parent;
    QAbstractNode _next;
    QAbstractNode _previous;
    String _systemId;
    String _filename;
    int _line;

    protected QAbstractNode() {
    }

    protected QAbstractNode(QDocument owner) {
        this._owner = owner;
    }

    @Override
    public void setLocation(String systemId, String filename, int line, int column) {
        this._systemId = systemId;
        this._filename = filename;
        this._line = line;
    }

    @Override
    public String getFilename() {
        if (this._filename != null) {
            return this._filename;
        }
        if (this._previous != null) {
            return this._previous.getFilename();
        }
        if (this._parent != null) {
            return this._parent.getFilename();
        }
        return null;
    }

    @Override
    public String getBaseURI() {
        if (this._systemId != null) {
            return this._systemId;
        }
        if (this._previous != null) {
            return this._previous.getBaseURI();
        }
        if (this._parent != null) {
            return this._parent.getBaseURI();
        }
        return this.getFilename();
    }

    public static String baseURI(Node node) {
        if (node instanceof QAbstractNode) {
            return ((QAbstractNode)node).getBaseURI();
        }
        return null;
    }

    @Override
    public int getLine() {
        if (this._filename != null) {
            return this._line;
        }
        if (this._previous != null) {
            return this._previous.getLine();
        }
        if (this._parent != null) {
            return this._parent.getLine();
        }
        return 0;
    }

    @Override
    public int getColumn() {
        return 0;
    }

    @Override
    public Document getOwnerDocument() {
        return this._owner;
    }

    @Override
    public boolean isSupported(String feature, String version) {
        return this._owner.getImplementation().hasFeature(feature, version);
    }

    @Override
    public Object getFeature(String feature, String version) {
        return null;
    }

    public void setFeature(String feature, boolean value) {
    }

    @Override
    public short compareDocumentPosition(Node node) {
        return 0;
    }

    @Override
    public String lookupPrefix(String feature) {
        return null;
    }

    @Override
    public boolean hasAttributes() {
        return false;
    }

    @Override
    public String getPrefix() {
        return "";
    }

    @Override
    public void setPrefix(String prefix) {
    }

    @Override
    public Object setUserData(String key, Object value, UserDataHandler userData) {
        return null;
    }

    @Override
    public Object getUserData(String data) {
        return null;
    }

    @Override
    public String getCanonicalName() {
        return this.getNodeName();
    }

    @Override
    public String getLocalName() {
        return this.getNodeName();
    }

    @Override
    public String getNamespaceURI() {
        return "";
    }

    public QName getQName() {
        return new QName(this.getNodeName(), this.getNamespaceURI());
    }

    @Override
    public String getNodeValue() {
        return null;
    }

    @Override
    public void setNodeValue(String value) {
    }

    @Override
    public Node getParentNode() {
        return this._parent;
    }

    @Override
    public NodeList getChildNodes() {
        return new QEmptyNodeList();
    }

    @Override
    public Node getFirstChild() {
        return null;
    }

    @Override
    public Node getLastChild() {
        return null;
    }

    @Override
    public Node getPreviousSibling() {
        return this._previous;
    }

    @Override
    public Node getNextSibling() {
        return this._next;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return null;
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        throw new QDOMException(3, "");
    }

    @Override
    public Node replaceChild(Node newChild, Node refChild) throws DOMException {
        throw new QDOMException(3, "");
    }

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        throw new QDOMException(3, "");
    }

    @Override
    public Node appendChild(Node newNode) throws DOMException {
        throw new QDOMException(3, "");
    }

    @Override
    public boolean hasChildNodes() {
        return false;
    }

    public boolean equals(Node arg, boolean deep) {
        return this == arg;
    }

    void remove() {
        if (this._owner != null) {
            ++this._owner._changeCount;
        }
        if (this._previous != null) {
            this._previous._next = this._next;
        } else if (this._parent != null) {
            this._parent._firstChild = this._next;
        }
        if (this._next != null) {
            this._next._previous = this._previous;
        } else if (this._parent != null) {
            this._parent._lastChild = this._previous;
        }
        this._previous = null;
        this._next = null;
        this._parent = null;
    }

    public QAbstractNode getNextPreorder() {
        if (this._next != null) {
            return this._next;
        }
        QNode ptr = this._parent;
        while (ptr != null) {
            if (ptr._next != null) {
                return ptr._next;
            }
            ptr = ptr._parent;
        }
        return null;
    }

    public boolean hasContent() {
        return false;
    }

    public QAbstractNode getNextContent() {
        QAbstractNode node = this._next;
        while (node != null) {
            if (node.hasContent()) {
                return node;
            }
            node = node._next;
        }
        return null;
    }

    public QAbstractNode getPreviousContent() {
        QAbstractNode node = this._previous;
        while (node != null) {
            if (node.hasContent()) {
                return node;
            }
            node = node._previous;
        }
        return null;
    }

    @Override
    public String getTextValue() {
        return this.getNodeValue();
    }

    public boolean supports(String feature, String version) {
        return this._owner._implementation.hasFeature(feature, version);
    }

    @Override
    public void normalize() {
    }

    @Override
    public Node cloneNode(boolean deep) {
        return this._owner.importNode(this, deep);
    }

    public short compareTreePosition(Node other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getTextContent() throws DOMException {
        return XmlUtil.textValue(this);
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSameNode(Node other) {
        return this == other;
    }

    public String lookupNamespacePrefix(String namespaceURI, boolean useDefault) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEqualNode(Node arg) {
        return this.equals(arg);
    }

    public Node getInterface(String feature) {
        throw new UnsupportedOperationException();
    }

    public ArrayList<Depend> getDependencyList() {
        if (this._owner != null) {
            return this._owner.getDependencyList();
        }
        return null;
    }

    boolean isNameValid(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        if (!XmlChar.isNameStart(name.charAt(0))) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (XmlChar.isNameChar(ch)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean checkValid() throws Exception {
        if (this._parent == null) {
            if (this._next != null || this._previous != null) {
                throw new Exception("null bad: " + this);
            }
            return true;
        }
        if (this._parent._owner != this._owner && this._owner != this._parent) {
            throw new Exception("owner bad: " + this);
        }
        QAbstractNode ptr = this._parent._firstChild;
        while (ptr != null && ptr != this) {
            ptr = ptr._next;
        }
        if (ptr == null) {
            throw new Exception("not in parent: " + this);
        }
        ptr = this._parent._lastChild;
        while (ptr != null && ptr != this) {
            ptr = ptr._previous;
        }
        if (ptr == null) {
            throw new Exception("not in parent: " + this);
        }
        if (this._next == null && this._parent._lastChild != this) {
            throw new Exception("bad tail: " + this);
        }
        if (this._next != null && this._next._previous != this) {
            throw new Exception("bad link: " + this);
        }
        if (this._previous == null && this._parent._firstChild != this) {
            throw new Exception("bad head: " + this);
        }
        if (this._previous != null && this._previous._next != this) {
            throw new Exception("bad link: " + this);
        }
        return true;
    }

    void print(XmlPrinter out) throws IOException {
    }

    @Override
    public void print(WriteStream out) throws IOException {
        new XmlPrinter(out).printXml(this);
    }

    @Override
    public void printPretty(WriteStream out) throws IOException {
        new XmlPrinter(out).printPrettyXml(this);
    }

    @Override
    public void printHtml(WriteStream out) throws IOException {
        new XmlPrinter(out).printHtml(this);
    }

    private Object writeReplace() {
        return new SerializedXml(this);
    }
}

