/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml2;

import javax.xml.namespace.QName;
import org.xml.sax.Attributes;

class QAttributes
implements Attributes {
    QName[] names = new QName[32];
    String[] values = new String[32];
    int size;

    QAttributes() {
    }

    void clear() {
        this.size = 0;
    }

    void add(QName name, String value) {
        if (this.size == this.names.length) {
            QName[] newNames = new QName[2 * this.names.length];
            String[] newValues = new String[2 * this.names.length];
            System.arraycopy(this.names, 0, newNames, 0, this.names.length);
            System.arraycopy(this.values, 0, newValues, 0, this.names.length);
            this.names = newNames;
            this.values = newValues;
        }
        this.names[this.size] = name;
        this.values[this.size] = value;
        ++this.size;
    }

    @Override
    public int getLength() {
        return this.size;
    }

    public QName getName(int i) {
        return this.names[i];
    }

    @Override
    public String getQName(int i) {
        String prefix = this.names[i].getPrefix();
        if (prefix != null && prefix.length() > 0) {
            return prefix + ":" + this.names[i].getLocalPart();
        }
        return this.names[i].getLocalPart();
    }

    @Override
    public String getURI(int i) {
        String uri = this.names[i].getNamespaceURI();
        if (uri != null) {
            return uri;
        }
        return "";
    }

    @Override
    public String getLocalName(int i) {
        String name = this.names[i].getLocalPart();
        if (name != null) {
            return name;
        }
        return "";
    }

    @Override
    public String getValue(int i) {
        return this.values[i];
    }

    @Override
    public String getValue(String qName) {
        for (int i = 0; i < this.size; ++i) {
            if (!qName.equals(this.names[i].getLocalPart())) continue;
            return this.values[i];
        }
        return null;
    }

    @Override
    public String getValue(String uri, String localName) {
        for (int i = 0; i < this.size; ++i) {
            String testURI = this.names[i].getNamespaceURI();
            if (testURI == null) {
                testURI = "";
            }
            if (!uri.equals(testURI) || !localName.equals(this.names[i].getLocalPart())) continue;
            return this.values[i];
        }
        return null;
    }

    @Override
    public int getIndex(String qName) {
        for (int i = 0; i < this.size; ++i) {
            if (!qName.equals(this.names[i].getLocalPart())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getIndex(String uri, String localName) {
        for (int i = 0; i < this.size; ++i) {
            if (!uri.equals(this.names[i].getNamespaceURI()) || !localName.equals(this.names[i].getLocalPart())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getType(int i) {
        return "CDATA";
    }

    @Override
    public String getType(String uri, String localName) {
        return "CDATA";
    }

    @Override
    public String getType(String qName) {
        return "CDATA";
    }

    public String toString() {
        StringBuilder cb = new StringBuilder();
        cb.append("QAttributes[");
        for (int i = 0; i < this.size; ++i) {
            cb.append(" ");
            cb.append(this.names[i]);
            cb.append("=\"");
            cb.append(this.values[i]);
            cb.append("\"");
        }
        cb.append("]");
        return cb.toString();
    }
}

