/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl;

import com.caucho.java.LineMap;
import com.caucho.util.L10N;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.IOExceptionWrapper;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.CauchoNode;
import com.caucho.xml.DOMBuilder;
import com.caucho.xml.QDocument;
import com.caucho.xml.QNode;
import com.caucho.xml.SAXBuilder;
import com.caucho.xml.Xml;
import com.caucho.xml.XmlParser;
import com.caucho.xml.XmlPrinter;
import com.caucho.xpath.XPathFun;
import com.caucho.xsl.StringSource;
import com.caucho.xsl.StylesheetImpl;
import com.caucho.xsl.TransformerExceptionWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class TransformerImpl
extends Transformer {
    protected static L10N L = new L10N(TransformerImpl.class);
    public static final String LINE_MAP = "caucho.line-map";
    public static final String CACHE_DEPENDS = "caucho.cache.depends";
    public static final String GENERATE_LOCATION = "caucho.generate.location";
    protected StylesheetImpl _stylesheet;
    protected HashMap<String, Object> _properties = new HashMap();
    protected HashMap<String, Object> _parameters;
    private URIResolver _uriResolver;
    private ErrorListener _errorListener;
    private Properties _output;
    protected LineMap _lineMap;
    protected ArrayList<Path> _cacheDepends = new ArrayList();

    protected TransformerImpl(StylesheetImpl stylesheet) {
        this._stylesheet = stylesheet;
        this._uriResolver = stylesheet.getURIResolver();
    }

    @Override
    public URIResolver getURIResolver() {
        return this._uriResolver;
    }

    @Override
    public void setURIResolver(URIResolver uriResolver) {
        this._uriResolver = uriResolver;
    }

    @Override
    public ErrorListener getErrorListener() {
        return this._errorListener;
    }

    @Override
    public void setErrorListener(ErrorListener errorListener) {
        this._errorListener = errorListener;
    }

    public boolean getFeature(String name) {
        if (name.equals("http://javax.xml.transform.dom.DOMResult/feature")) {
            return true;
        }
        if (name.equals("http://javax.xml.transform.dom.DOMSource/feature")) {
            return true;
        }
        if (name.equals("http://javax.xml.transform.stream.StreamSource/feature")) {
            return true;
        }
        if (name.equals("http://javax.xml.transform.stream.StreamResult/feature")) {
            return true;
        }
        if (name.equals("http://javax.xml.transform.sax.SAXSource/feature")) {
            return true;
        }
        return name.equals("http://javax.xml.transform.sax.SAXResult/feature");
    }

    public void setFeature(String name, boolean enable) {
        if (name.equals(GENERATE_LOCATION)) {
            this._stylesheet.setGenerateLocation(enable);
        }
    }

    public StylesheetImpl getStylesheet() {
        return this._stylesheet;
    }

    public Object getProperty(String name) {
        Object property = this._properties.get(name);
        if (property != null) {
            return property;
        }
        if (name.equals(CACHE_DEPENDS)) {
            return this._cacheDepends;
        }
        if (name.equals(LINE_MAP)) {
            return this._lineMap;
        }
        return this._stylesheet.getProperty(name);
    }

    public void setProperty(String name, Object value) {
        this._properties.put(name, value);
    }

    @Override
    public void setParameter(String name, Object value) {
        if (this._parameters == null) {
            this._parameters = new HashMap();
        }
        this._parameters.put(name, value);
    }

    @Override
    public Properties getOutputProperties() {
        if (this._output == null) {
            this._output = (Properties)this._stylesheet.getOutputProperties().clone();
        }
        return (Properties)this._output.clone();
    }

    @Override
    public void setOutputProperties(Properties properties) {
        this._output = properties;
    }

    @Override
    public void setOutputProperty(String name, String value) {
        if (this._output == null) {
            this._output = (Properties)this._stylesheet.getOutputProperties().clone();
        }
        this._output.put(name, value);
    }

    @Override
    public String getOutputProperty(String name) {
        if (this._output == null) {
            this._output = (Properties)this._stylesheet.getOutputProperties().clone();
        }
        return (String)this._output.get(name);
    }

    @Override
    public Object getParameter(String name) {
        if (this._parameters == null) {
            return null;
        }
        return this._parameters.get(name);
    }

    @Override
    public void clearParameters() {
        if (this._parameters != null) {
            this._parameters.clear();
        }
        if (this._cacheDepends != null) {
            this._cacheDepends.clear();
        }
    }

    public void addFunction(String name, XPathFun fun) {
        this._stylesheet.addFunction(name, fun);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transform(Source source, Result result) throws TransformerException {
        block13: {
            try {
                Node node = this.parseDocument(source);
                if (result instanceof StreamResult) {
                    StreamResult stream = (StreamResult)result;
                    if (stream.getOutputStream() != null) {
                        this.transform(node, stream.getOutputStream(), null, result.getSystemId());
                        break block13;
                    }
                    if (stream.getWriter() != null) {
                        Writer writer = stream.getWriter();
                        WriteStream os = Vfs.openWrite(writer);
                        if (writer instanceof OutputStreamWriter) {
                            String javaEncoding = ((OutputStreamWriter)writer).getEncoding();
                            String mimeEncoding = Encoding.getMimeName(javaEncoding);
                            this.transform(node, os, mimeEncoding, result.getSystemId());
                        } else {
                            this.transform(node, os, null, result.getSystemId());
                        }
                        os.flush();
                        os.free();
                        break block13;
                    }
                    try (WriteStream os = Vfs.lookup(result.getSystemId()).openWrite();){
                        this.transform(node, os, null, result.getSystemId());
                        break block13;
                    }
                }
                if (result instanceof DOMResult) {
                    DOMResult domResult = (DOMResult)result;
                    Node resultNode = domResult.getNode();
                    domResult.setNode(this.transform(node, resultNode));
                    break block13;
                }
                if (result instanceof SAXResult) {
                    SAXResult sax = (SAXResult)result;
                    this.transform(node, sax.getHandler(), sax.getLexicalHandler());
                    break block13;
                }
                throw new TransformerException(String.valueOf(result));
            }
            catch (TransformerException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TransformerExceptionWrapper(e);
            }
        }
    }

    public void transform(Node node, OutputStream os) throws TransformerException {
        if (os instanceof WriteStream) {
            String encoding = ((WriteStream)os).getEncoding();
            if (encoding == null) {
                encoding = "ISO-8859-1";
            }
            this.transform(node, os, encoding, null);
        } else {
            this.transform(node, os, null, null);
        }
    }

    public void transform(Node node, OutputStream os, String encoding, String systemId) throws TransformerException {
        if (node == null) {
            throw new IllegalArgumentException("can't transform null node");
        }
        try {
            String jsp;
            WriteStream ws;
            this._lineMap = null;
            Properties output = this.getOutputProperties();
            if (os instanceof WriteStream) {
                ws = (WriteStream)os;
            } else {
                String baseURI;
                ws = Vfs.openWrite(os);
                if (systemId != null) {
                    ws.setPath(Vfs.lookup(systemId));
                } else if (node instanceof QNode && (baseURI = ((QNode)node).getBaseURI()) != null) {
                    ws.setPath(Vfs.lookup(baseURI));
                }
            }
            XmlPrinter out = new XmlPrinter(ws);
            String method = (String)output.get("method");
            out.setMethod(method);
            if (encoding == null) {
                encoding = (String)output.get("encoding");
            }
            if (encoding == null && !(os instanceof WriteStream) && !"html".equals(method)) {
                encoding = "UTF-8";
            }
            if (encoding != null) {
                out.setEncoding(encoding);
            }
            out.setMimeType((String)output.get("media-type"));
            String omit = (String)output.get("omit-xml-declaration");
            if (omit == null || omit.equals("false") || omit.equals("no")) {
                out.setPrintDeclaration(true);
            }
            out.setStandalone((String)output.get("standalone"));
            out.setSystemId((String)output.get("doctype-system"));
            out.setPublicId((String)output.get("doctype-public"));
            String indent = (String)output.get("indent");
            if (indent != null) {
                out.setPretty(indent.equals("true") || indent.equals("yes"));
            }
            if ((jsp = (String)output.get("caucho.jsp")) != null) {
                out.setJSP(jsp.equals("true") || jsp.equals("yes"));
            }
            out.setVersion((String)output.get("version"));
            String includeContentType = (String)output.get("include-content-type");
            if (includeContentType != null) {
                out.setIncludeContentType(includeContentType.equals("true") || includeContentType.equals("yes"));
            }
            if (this._stylesheet.getGenerateLocation()) {
                if (node instanceof CauchoNode) {
                    String filename = ((CauchoNode)node).getFilename();
                    if (filename != null) {
                        out.setLineMap(filename);
                    } else {
                        out.setLineMap("anonymous.xsl");
                    }
                } else {
                    out.setLineMap("anonymous.xsl");
                }
            }
            this._stylesheet.transform(node, out, this);
            this._lineMap = out.getLineMap();
            if (os != ws) {
                ws.flush();
                ws.free();
            }
        }
        catch (TransformerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TransformerExceptionWrapper(e);
        }
    }

    public Node transform(Node sourceNode, Node destNode) throws SAXException, IOException {
        this._lineMap = null;
        if (destNode == null) {
            destNode = Xml.createDocument();
        }
        DOMBuilder out = new DOMBuilder();
        out.init(destNode);
        try {
            out.startDocument();
            this._stylesheet.transform(sourceNode, out, this);
        }
        catch (Exception e) {
            throw new IOExceptionWrapper(e);
        }
        return destNode;
    }

    public void transform(Node sourceNode, ContentHandler contentHandler, LexicalHandler lexicalHandler) throws SAXException, IOException, TransformerException {
        if (contentHandler == null) {
            throw new IllegalArgumentException(L.l("null content handler"));
        }
        this._lineMap = null;
        SAXBuilder out = new SAXBuilder();
        out.setContentHandler(contentHandler);
        out.startDocument();
        this._stylesheet.transform(sourceNode, out, this);
    }

    protected Node parseDocument(Source source) throws IOException, SAXException, TransformerException {
        if (source instanceof StreamSource) {
            StreamSource stream = (StreamSource)source;
            InputSource in = new InputSource();
            in.setSystemId(stream.getSystemId());
            in.setByteStream(stream.getInputStream());
            in.setCharacterStream(stream.getReader());
            Xml parser = Xml.create();
            Document node = parser.parseDocument(in);
            ((XmlParser)parser).free();
            return node;
        }
        if (source instanceof DOMSource) {
            Node node = ((DOMSource)source).getNode();
            return node != null ? node : new QDocument();
        }
        if (source instanceof StringSource) {
            String string = ((StringSource)source).getString();
            if (string != null) {
                return this.parseStringDocument(string, source.getSystemId());
            }
            return new QDocument();
        }
        if (source instanceof SAXSource) {
            SAXSource saxSource = (SAXSource)source;
            XMLReader reader = saxSource.getXMLReader();
            if (reader == null) {
                return new QDocument();
            }
            InputSource inputSource = saxSource.getInputSource();
            QDocument doc = new QDocument();
            DOMBuilder builder = new DOMBuilder();
            builder.init(doc);
            reader.setContentHandler(builder);
            reader.parse(inputSource);
            return doc;
        }
        throw new TransformerException(L.l("unknown source {0}", (Object)source));
    }

    protected Node parseDocument(InputStream is, String systemId) throws IOException, SAXException {
        Xml parser = Xml.create();
        Document node = parser.parseDocument(is);
        ((XmlParser)parser).free();
        return node;
    }

    protected Node parseDocument(String url) throws IOException, SAXException {
        Xml parser = Xml.create();
        Document node = parser.parseDocument(url);
        ((XmlParser)parser).free();
        return node;
    }

    protected Node parseStringDocument(String source, String systemId) throws IOException, SAXException {
        Xml parser = Xml.create();
        Document node = parser.parseDocumentString(source);
        ((XmlParser)parser).free();
        return node;
    }

    public void addCacheDepend(Path path) {
        this._cacheDepends.add(path);
    }

    protected void addCacheDepend(String path) {
        this._cacheDepends.add(Vfs.lookup(path));
    }

    public ArrayList<Path> getCacheDepends() {
        return this._cacheDepends;
    }
}

