/*
 * Decompiled with CFR 0.152.
 */
package com.caverock.androidsvg;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Picture;
import android.graphics.RectF;
import android.util.Log;
import com.caverock.androidsvg.CSSParser;
import com.caverock.androidsvg.PreserveAspectRatio;
import com.caverock.androidsvg.RenderOptions;
import com.caverock.androidsvg.SVGAndroidRenderer;
import com.caverock.androidsvg.SVGExternalFileResolver;
import com.caverock.androidsvg.SVGParseException;
import com.caverock.androidsvg.SVGParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SVG {
    static final String TAG = "AndroidSVG";
    private static final String VERSION = "1.3";
    private static final int DEFAULT_PICTURE_WIDTH = 512;
    private static final int DEFAULT_PICTURE_HEIGHT = 512;
    private static final double SQRT2 = 1.414213562373095;
    private static SVGExternalFileResolver externalFileResolver = null;
    private static boolean enableInternalEntities = true;
    private Svg rootElement = null;
    private String title = "";
    private String desc = "";
    private float renderDPI = 96.0f;
    private CSSParser.Ruleset cssRules = new CSSParser.Ruleset();
    private Map<String, SvgElementBase> idToElementMap = new HashMap<String, SvgElementBase>();
    static final long SPECIFIED_FILL = 1L;
    static final long SPECIFIED_FILL_RULE = 2L;
    static final long SPECIFIED_FILL_OPACITY = 4L;
    static final long SPECIFIED_STROKE = 8L;
    static final long SPECIFIED_STROKE_OPACITY = 16L;
    static final long SPECIFIED_STROKE_WIDTH = 32L;
    static final long SPECIFIED_STROKE_LINECAP = 64L;
    static final long SPECIFIED_STROKE_LINEJOIN = 128L;
    static final long SPECIFIED_STROKE_MITERLIMIT = 256L;
    static final long SPECIFIED_STROKE_DASHARRAY = 512L;
    static final long SPECIFIED_STROKE_DASHOFFSET = 1024L;
    static final long SPECIFIED_OPACITY = 2048L;
    static final long SPECIFIED_COLOR = 4096L;
    static final long SPECIFIED_FONT_FAMILY = 8192L;
    static final long SPECIFIED_FONT_SIZE = 16384L;
    static final long SPECIFIED_FONT_WEIGHT = 32768L;
    static final long SPECIFIED_FONT_STYLE = 65536L;
    static final long SPECIFIED_TEXT_DECORATION = 131072L;
    static final long SPECIFIED_TEXT_ANCHOR = 262144L;
    static final long SPECIFIED_OVERFLOW = 524288L;
    static final long SPECIFIED_CLIP = 0x100000L;
    static final long SPECIFIED_MARKER_START = 0x200000L;
    static final long SPECIFIED_MARKER_MID = 0x400000L;
    static final long SPECIFIED_MARKER_END = 0x800000L;
    static final long SPECIFIED_DISPLAY = 0x1000000L;
    static final long SPECIFIED_VISIBILITY = 0x2000000L;
    static final long SPECIFIED_STOP_COLOR = 0x4000000L;
    static final long SPECIFIED_STOP_OPACITY = 0x8000000L;
    static final long SPECIFIED_CLIP_PATH = 0x10000000L;
    static final long SPECIFIED_CLIP_RULE = 0x20000000L;
    static final long SPECIFIED_MASK = 0x40000000L;
    static final long SPECIFIED_SOLID_COLOR = 0x80000000L;
    static final long SPECIFIED_SOLID_OPACITY = 0x100000000L;
    static final long SPECIFIED_VIEWPORT_FILL = 0x200000000L;
    static final long SPECIFIED_VIEWPORT_FILL_OPACITY = 0x400000000L;
    static final long SPECIFIED_VECTOR_EFFECT = 0x800000000L;
    static final long SPECIFIED_DIRECTION = 0x1000000000L;
    static final long SPECIFIED_IMAGE_RENDERING = 0x2000000000L;
    private static final long SPECIFIED_ALL = -1L;

    SVG() {
    }

    public static SVG getFromInputStream(InputStream is) throws SVGParseException {
        SVGParser parser = new SVGParser();
        return parser.parse(is, enableInternalEntities);
    }

    public static SVG getFromString(String svg) throws SVGParseException {
        SVGParser parser = new SVGParser();
        return parser.parse(new ByteArrayInputStream(svg.getBytes()), enableInternalEntities);
    }

    public static SVG getFromResource(Context context, int resourceId) throws SVGParseException {
        return SVG.getFromResource(context.getResources(), resourceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SVG getFromResource(Resources resources, int resourceId) throws SVGParseException {
        SVGParser parser = new SVGParser();
        InputStream is = resources.openRawResource(resourceId);
        try {
            SVG sVG = parser.parse(is, enableInternalEntities);
            return sVG;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SVG getFromAsset(AssetManager assetManager, String filename) throws SVGParseException, IOException {
        SVGParser parser = new SVGParser();
        InputStream is = assetManager.open(filename);
        try {
            SVG sVG = parser.parse(is, enableInternalEntities);
            return sVG;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void setInternalEntitiesEnabled(boolean enable) {
        enableInternalEntities = enable;
    }

    public static boolean isInternalEntitiesEnabled() {
        return enableInternalEntities;
    }

    public static void registerExternalFileResolver(SVGExternalFileResolver fileResolver) {
        externalFileResolver = fileResolver;
    }

    public static void deregisterExternalFileResolver() {
        externalFileResolver = null;
    }

    public void setRenderDPI(float dpi) {
        this.renderDPI = dpi;
    }

    public float getRenderDPI() {
        return this.renderDPI;
    }

    public Picture renderToPicture() {
        return this.renderToPicture(null);
    }

    public Picture renderToPicture(int widthInPixels, int heightInPixels) {
        return this.renderToPicture(widthInPixels, heightInPixels, null);
    }

    public Picture renderToPicture(RenderOptions renderOptions) {
        Box viewBox;
        Box box = viewBox = renderOptions != null && renderOptions.hasViewBox() ? renderOptions.viewBox : this.rootElement.viewBox;
        if (renderOptions != null && renderOptions.hasViewPort()) {
            float w = renderOptions.viewPort.maxX();
            float h = renderOptions.viewPort.maxY();
            return this.renderToPicture((int)Math.ceil(w), (int)Math.ceil(h), renderOptions);
        }
        if (this.rootElement.width != null && this.rootElement.width.unit != Unit.percent && this.rootElement.height != null && this.rootElement.height.unit != Unit.percent) {
            float w = this.rootElement.width.floatValue(this.renderDPI);
            float h = this.rootElement.height.floatValue(this.renderDPI);
            return this.renderToPicture((int)Math.ceil(w), (int)Math.ceil(h), renderOptions);
        }
        if (this.rootElement.width != null && viewBox != null) {
            float w = this.rootElement.width.floatValue(this.renderDPI);
            float h = w * viewBox.height / viewBox.width;
            return this.renderToPicture((int)Math.ceil(w), (int)Math.ceil(h), renderOptions);
        }
        if (this.rootElement.height != null && viewBox != null) {
            float h = this.rootElement.height.floatValue(this.renderDPI);
            float w = h * viewBox.width / viewBox.height;
            return this.renderToPicture((int)Math.ceil(w), (int)Math.ceil(h), renderOptions);
        }
        return this.renderToPicture(512, 512, renderOptions);
    }

    public Picture renderToPicture(int widthInPixels, int heightInPixels, RenderOptions renderOptions) {
        Picture picture = new Picture();
        Canvas canvas = picture.beginRecording(widthInPixels, heightInPixels);
        if (renderOptions == null || renderOptions.viewPort == null) {
            renderOptions = renderOptions == null ? new RenderOptions() : new RenderOptions(renderOptions);
            renderOptions.viewPort(0.0f, 0.0f, widthInPixels, heightInPixels);
        }
        SVGAndroidRenderer renderer = new SVGAndroidRenderer(canvas, this.renderDPI);
        renderer.renderDocument(this, renderOptions);
        picture.endRecording();
        return picture;
    }

    public Picture renderViewToPicture(String viewId, int widthInPixels, int heightInPixels) {
        RenderOptions renderOptions = new RenderOptions();
        renderOptions.view(viewId).viewPort(0.0f, 0.0f, widthInPixels, heightInPixels);
        Picture picture = new Picture();
        Canvas canvas = picture.beginRecording(widthInPixels, heightInPixels);
        SVGAndroidRenderer renderer = new SVGAndroidRenderer(canvas, this.renderDPI);
        renderer.renderDocument(this, renderOptions);
        picture.endRecording();
        return picture;
    }

    public void renderToCanvas(Canvas canvas) {
        this.renderToCanvas(canvas, (RenderOptions)null);
    }

    public void renderToCanvas(Canvas canvas, RectF viewPort) {
        RenderOptions renderOptions = new RenderOptions();
        if (viewPort != null) {
            renderOptions.viewPort(viewPort.left, viewPort.top, viewPort.width(), viewPort.height());
        } else {
            renderOptions.viewPort(0.0f, 0.0f, canvas.getWidth(), canvas.getHeight());
        }
        SVGAndroidRenderer renderer = new SVGAndroidRenderer(canvas, this.renderDPI);
        renderer.renderDocument(this, renderOptions);
    }

    public void renderToCanvas(Canvas canvas, RenderOptions renderOptions) {
        if (renderOptions == null) {
            renderOptions = new RenderOptions();
        }
        if (!renderOptions.hasViewPort()) {
            renderOptions.viewPort(0.0f, 0.0f, canvas.getWidth(), canvas.getHeight());
        }
        SVGAndroidRenderer renderer = new SVGAndroidRenderer(canvas, this.renderDPI);
        renderer.renderDocument(this, renderOptions);
    }

    public void renderViewToCanvas(String viewId, Canvas canvas) {
        this.renderToCanvas(canvas, RenderOptions.create().view(viewId));
    }

    public void renderViewToCanvas(String viewId, Canvas canvas, RectF viewPort) {
        RenderOptions renderOptions = RenderOptions.create().view(viewId);
        if (viewPort != null) {
            renderOptions.viewPort(viewPort.left, viewPort.top, viewPort.width(), viewPort.height());
        }
        this.renderToCanvas(canvas, renderOptions);
    }

    public static String getVersion() {
        return VERSION;
    }

    public String getDocumentTitle() {
        if (this.rootElement == null) {
            throw new IllegalArgumentException("SVG document is empty");
        }
        return this.title;
    }

    public String getDocumentDescription() {
        if (this.rootElement == null) {
            throw new IllegalArgumentException("SVG document is empty");
        }
        return this.desc;
    }

    public String getDocumentSVGVersion() {
        if (this.rootElement == null) {
            throw new IllegalArgumentException("SVG document is empty");
        }
        return this.rootElement.version;
    }

    public Set<String> getViewList() {
        if (this.rootElement == null) {
            throw new IllegalArgumentException("SVG document is empty");
        }
        List<SvgObject> viewElems = this.getElementsByTagName(View.class);
        HashSet<String> viewIds = new HashSet<String>(viewElems.size());
        for (SvgObject elem : viewElems) {
            View view = (View)elem;
            if (view.id != null) {
                viewIds.add(view.id);
                continue;
            }
            Log.w((String)TAG, (String)"getViewList(): found a <view> without an id attribute");
        }
        return viewIds;
    }

    public float getDocumentWidth() {
        if (this.rootElement == null) {
            throw new IllegalArgumentException("SVG document is empty");
        }
        return this.getDocumentDimensions((float)this.renderDPI).width;
    }

    public void setDocumentWidth(float pixels) {
        if (this.rootElement == null) {
            throw new IllegalArgumentException("SVG document is empty");
        }
        this.rootElement.width = new Length(pixels);
    }

    public void setDocumentWidth(String value) throws SVGParseException {
        if (this.rootElement == null) {
            throw new IllegalArgumentException("SVG document is empty");
        }
        this.rootElement.width = SVGParser.parseLength(value);
    }

    public float getDocumentHeight() {
        if (this.rootElement == null) {
            throw new IllegalArgumentException("SVG document is empty");
        }
        return this.getDocumentDimensions((float)this.renderDPI).height;
    }

    public void setDocumentHeight(float pixels) {
        if (this.rootElement == null) {
            throw new IllegalArgumentException("SVG document is empty");
        }
        this.rootElement.height = new Length(pixels);
    }

    public void setDocumentHeight(String value) throws SVGParseException {
        if (this.rootElement == null) {
            throw new IllegalArgumentException("SVG document is empty");
        }
        this.rootElement.height = SVGParser.parseLength(value);
    }

    public void setDocumentViewBox(float minX, float minY, float width, float height) {
        if (this.rootElement == null) {
            throw new IllegalArgumentException("SVG document is empty");
        }
        this.rootElement.viewBox = new Box(minX, minY, width, height);
    }

    public RectF getDocumentViewBox() {
        if (this.rootElement == null) {
            throw new IllegalArgumentException("SVG document is empty");
        }
        if (this.rootElement.viewBox == null) {
            return null;
        }
        return this.rootElement.viewBox.toRectF();
    }

    public void setDocumentPreserveAspectRatio(PreserveAspectRatio preserveAspectRatio) {
        if (this.rootElement == null) {
            throw new IllegalArgumentException("SVG document is empty");
        }
        this.rootElement.preserveAspectRatio = preserveAspectRatio;
    }

    public PreserveAspectRatio getDocumentPreserveAspectRatio() {
        if (this.rootElement == null) {
            throw new IllegalArgumentException("SVG document is empty");
        }
        if (this.rootElement.preserveAspectRatio == null) {
            return null;
        }
        return this.rootElement.preserveAspectRatio;
    }

    public float getDocumentAspectRatio() {
        if (this.rootElement == null) {
            throw new IllegalArgumentException("SVG document is empty");
        }
        Length w = this.rootElement.width;
        Length h = this.rootElement.height;
        if (w != null && h != null && w.unit != Unit.percent && h.unit != Unit.percent) {
            if (w.isZero() || h.isZero()) {
                return -1.0f;
            }
            return w.floatValue(this.renderDPI) / h.floatValue(this.renderDPI);
        }
        if (this.rootElement.viewBox != null && this.rootElement.viewBox.width != 0.0f && this.rootElement.viewBox.height != 0.0f) {
            return this.rootElement.viewBox.width / this.rootElement.viewBox.height;
        }
        return -1.0f;
    }

    Svg getRootElement() {
        return this.rootElement;
    }

    void setRootElement(Svg rootElement) {
        this.rootElement = rootElement;
    }

    SvgObject resolveIRI(String iri) {
        if (iri == null) {
            return null;
        }
        if ((iri = this.cssQuotedString(iri)).length() > 1 && iri.startsWith("#")) {
            return this.getElementById(iri.substring(1));
        }
        return null;
    }

    private String cssQuotedString(String str) {
        if (str.startsWith("\"") && str.endsWith("\"")) {
            str = str.substring(1, str.length() - 1).replace("\\\"", "\"");
        } else if (str.startsWith("'") && str.endsWith("'")) {
            str = str.substring(1, str.length() - 1).replace("\\'", "'");
        }
        return str.replace("\\\n", "").replace("\\A", "\n");
    }

    private Box getDocumentDimensions(float dpi) {
        float hOut;
        Length w = this.rootElement.width;
        Length h = this.rootElement.height;
        if (w == null || w.isZero() || w.unit == Unit.percent || w.unit == Unit.em || w.unit == Unit.ex) {
            return new Box(-1.0f, -1.0f, -1.0f, -1.0f);
        }
        float wOut = w.floatValue(dpi);
        if (h != null) {
            if (h.isZero() || h.unit == Unit.percent || h.unit == Unit.em || h.unit == Unit.ex) {
                return new Box(-1.0f, -1.0f, -1.0f, -1.0f);
            }
            hOut = h.floatValue(dpi);
        } else {
            hOut = this.rootElement.viewBox != null ? wOut * this.rootElement.viewBox.height / this.rootElement.viewBox.width : wOut;
        }
        return new Box(0.0f, 0.0f, wOut, hOut);
    }

    void addCSSRules(CSSParser.Ruleset ruleset) {
        this.cssRules.addAll(ruleset);
    }

    List<CSSParser.Rule> getCSSRules() {
        return this.cssRules.getRules();
    }

    boolean hasCSSRules() {
        return !this.cssRules.isEmpty();
    }

    void clearRenderCSSRules() {
        this.cssRules.removeFromSource(CSSParser.Source.RenderOptions);
    }

    void setTitle(String title) {
        this.title = title;
    }

    void setDesc(String desc) {
        this.desc = desc;
    }

    static SVGExternalFileResolver getFileResolver() {
        return externalFileResolver;
    }

    SvgElementBase getElementById(String id) {
        if (id == null || id.length() == 0) {
            return null;
        }
        if (id.equals(this.rootElement.id)) {
            return this.rootElement;
        }
        if (this.idToElementMap.containsKey(id)) {
            return this.idToElementMap.get(id);
        }
        SvgElementBase result = this.getElementById(this.rootElement, id);
        this.idToElementMap.put(id, result);
        return result;
    }

    private SvgElementBase getElementById(SvgContainer obj, String id) {
        SvgElementBase elem = (SvgElementBase)((Object)obj);
        if (id.equals(elem.id)) {
            return elem;
        }
        for (SvgObject child : obj.getChildren()) {
            SvgElementBase found;
            if (!(child instanceof SvgElementBase)) continue;
            SvgElementBase childElem = (SvgElementBase)child;
            if (id.equals(childElem.id)) {
                return childElem;
            }
            if (!(child instanceof SvgContainer) || (found = this.getElementById((SvgContainer)((Object)child), id)) == null) continue;
            return found;
        }
        return null;
    }

    private List<SvgObject> getElementsByTagName(Class clazz) {
        return this.getElementsByTagName(this.rootElement, clazz);
    }

    private List<SvgObject> getElementsByTagName(SvgContainer obj, Class clazz) {
        ArrayList<SvgObject> result = new ArrayList<SvgObject>();
        if (obj.getClass() == clazz) {
            result.add((SvgObject)((Object)obj));
        }
        for (SvgObject child : obj.getChildren()) {
            if (child.getClass() == clazz) {
                result.add(child);
            }
            if (!(child instanceof SvgContainer)) continue;
            this.getElementsByTagName((SvgContainer)((Object)child), clazz);
        }
        return result;
    }

    static class PathDefinition
    implements PathInterface {
        private byte[] commands = new byte[8];
        private int commandsLength = 0;
        private float[] coords = new float[16];
        private int coordsLength = 0;
        private static final byte MOVETO = 0;
        private static final byte LINETO = 1;
        private static final byte CUBICTO = 2;
        private static final byte QUADTO = 3;
        private static final byte ARCTO = 4;
        private static final byte CLOSE = 8;

        PathDefinition() {
        }

        boolean isEmpty() {
            return this.commandsLength == 0;
        }

        private void addCommand(byte value) {
            if (this.commandsLength == this.commands.length) {
                byte[] newCommands = new byte[this.commands.length * 2];
                System.arraycopy(this.commands, 0, newCommands, 0, this.commands.length);
                this.commands = newCommands;
            }
            this.commands[this.commandsLength++] = value;
        }

        private void coordsEnsure(int num) {
            if (this.coords.length < this.coordsLength + num) {
                float[] newCoords = new float[this.coords.length * 2];
                System.arraycopy(this.coords, 0, newCoords, 0, this.coords.length);
                this.coords = newCoords;
            }
        }

        @Override
        public void moveTo(float x, float y) {
            this.addCommand((byte)0);
            this.coordsEnsure(2);
            this.coords[this.coordsLength++] = x;
            this.coords[this.coordsLength++] = y;
        }

        @Override
        public void lineTo(float x, float y) {
            this.addCommand((byte)1);
            this.coordsEnsure(2);
            this.coords[this.coordsLength++] = x;
            this.coords[this.coordsLength++] = y;
        }

        @Override
        public void cubicTo(float x1, float y1, float x2, float y2, float x3, float y3) {
            this.addCommand((byte)2);
            this.coordsEnsure(6);
            this.coords[this.coordsLength++] = x1;
            this.coords[this.coordsLength++] = y1;
            this.coords[this.coordsLength++] = x2;
            this.coords[this.coordsLength++] = y2;
            this.coords[this.coordsLength++] = x3;
            this.coords[this.coordsLength++] = y3;
        }

        @Override
        public void quadTo(float x1, float y1, float x2, float y2) {
            this.addCommand((byte)3);
            this.coordsEnsure(4);
            this.coords[this.coordsLength++] = x1;
            this.coords[this.coordsLength++] = y1;
            this.coords[this.coordsLength++] = x2;
            this.coords[this.coordsLength++] = y2;
        }

        @Override
        public void arcTo(float rx, float ry, float xAxisRotation, boolean largeArcFlag, boolean sweepFlag, float x, float y) {
            int arc = 4 | (largeArcFlag ? 2 : 0) | (sweepFlag ? 1 : 0);
            this.addCommand((byte)arc);
            this.coordsEnsure(5);
            this.coords[this.coordsLength++] = rx;
            this.coords[this.coordsLength++] = ry;
            this.coords[this.coordsLength++] = xAxisRotation;
            this.coords[this.coordsLength++] = x;
            this.coords[this.coordsLength++] = y;
        }

        @Override
        public void close() {
            this.addCommand((byte)8);
        }

        void enumeratePath(PathInterface handler) {
            int coordsPos = 0;
            block7: for (int commandPos = 0; commandPos < this.commandsLength; ++commandPos) {
                byte command = this.commands[commandPos];
                switch (command) {
                    case 0: {
                        handler.moveTo(this.coords[coordsPos++], this.coords[coordsPos++]);
                        continue block7;
                    }
                    case 1: {
                        handler.lineTo(this.coords[coordsPos++], this.coords[coordsPos++]);
                        continue block7;
                    }
                    case 2: {
                        handler.cubicTo(this.coords[coordsPos++], this.coords[coordsPos++], this.coords[coordsPos++], this.coords[coordsPos++], this.coords[coordsPos++], this.coords[coordsPos++]);
                        continue block7;
                    }
                    case 3: {
                        handler.quadTo(this.coords[coordsPos++], this.coords[coordsPos++], this.coords[coordsPos++], this.coords[coordsPos++]);
                        continue block7;
                    }
                    case 8: {
                        handler.close();
                        continue block7;
                    }
                    default: {
                        boolean largeArcFlag = (command & 2) != 0;
                        boolean sweepFlag = (command & 1) != 0;
                        handler.arcTo(this.coords[coordsPos++], this.coords[coordsPos++], this.coords[coordsPos++], largeArcFlag, sweepFlag, this.coords[coordsPos++], this.coords[coordsPos++]);
                    }
                }
            }
        }
    }

    static interface PathInterface {
        public void moveTo(float var1, float var2);

        public void lineTo(float var1, float var2);

        public void cubicTo(float var1, float var2, float var3, float var4, float var5, float var6);

        public void quadTo(float var1, float var2, float var3, float var4);

        public void arcTo(float var1, float var2, float var3, boolean var4, boolean var5, float var6, float var7);

        public void close();
    }

    static class SolidColor
    extends SvgElementBase
    implements SvgContainer {
        SolidColor() {
        }

        @Override
        public List<SvgObject> getChildren() {
            return Collections.emptyList();
        }

        @Override
        public void addChild(SvgObject elem) throws SVGParseException {
        }

        @Override
        String getNodeName() {
            return "solidColor";
        }
    }

    static class Mask
    extends SvgConditionalContainer
    implements NotDirectlyRendered {
        Boolean maskUnitsAreUser;
        Boolean maskContentUnitsAreUser;
        Length x;
        Length y;
        Length width;
        Length height;

        Mask() {
        }

        @Override
        String getNodeName() {
            return "mask";
        }
    }

    static class View
    extends SvgViewBoxContainer
    implements NotDirectlyRendered {
        View() {
        }

        @Override
        String getNodeName() {
            return "view";
        }
    }

    static class Image
    extends SvgPreserveAspectRatioContainer
    implements HasTransform {
        String href;
        Length x;
        Length y;
        Length width;
        Length height;
        Matrix transform;

        Image() {
        }

        @Override
        public void setTransform(Matrix transform) {
            this.transform = transform;
        }

        @Override
        String getNodeName() {
            return "image";
        }
    }

    static class Pattern
    extends SvgViewBoxContainer
    implements NotDirectlyRendered {
        Boolean patternUnitsAreUser;
        Boolean patternContentUnitsAreUser;
        Matrix patternTransform;
        Length x;
        Length y;
        Length width;
        Length height;
        String href;

        Pattern() {
        }

        @Override
        String getNodeName() {
            return "pattern";
        }
    }

    static class ClipPath
    extends Group
    implements NotDirectlyRendered {
        Boolean clipPathUnitsAreUser;

        ClipPath() {
        }

        @Override
        String getNodeName() {
            return "clipPath";
        }
    }

    static class SvgRadialGradient
    extends GradientElement {
        Length cx;
        Length cy;
        Length r;
        Length fx;
        Length fy;

        SvgRadialGradient() {
        }

        @Override
        String getNodeName() {
            return "radialGradient";
        }
    }

    static class SvgLinearGradient
    extends GradientElement {
        Length x1;
        Length y1;
        Length x2;
        Length y2;

        SvgLinearGradient() {
        }

        @Override
        String getNodeName() {
            return "linearGradient";
        }
    }

    static class Stop
    extends SvgElementBase
    implements SvgContainer {
        Float offset;

        Stop() {
        }

        @Override
        public List<SvgObject> getChildren() {
            return Collections.emptyList();
        }

        @Override
        public void addChild(SvgObject elem) throws SVGParseException {
        }

        @Override
        String getNodeName() {
            return "stop";
        }
    }

    static abstract class GradientElement
    extends SvgElementBase
    implements SvgContainer {
        List<SvgObject> children = new ArrayList<SvgObject>();
        Boolean gradientUnitsAreUser;
        Matrix gradientTransform;
        GradientSpread spreadMethod;
        String href;

        GradientElement() {
        }

        @Override
        public List<SvgObject> getChildren() {
            return this.children;
        }

        @Override
        public void addChild(SvgObject elem) throws SVGParseException {
            if (!(elem instanceof Stop)) {
                throw new SVGParseException("Gradient elements cannot contain " + elem + " elements.");
            }
            this.children.add(elem);
        }
    }

    static class Marker
    extends SvgViewBoxContainer
    implements NotDirectlyRendered {
        boolean markerUnitsAreUser;
        Length refX;
        Length refY;
        Length markerWidth;
        Length markerHeight;
        Float orient;

        Marker() {
        }

        @Override
        String getNodeName() {
            return "marker";
        }
    }

    static class Symbol
    extends SvgViewBoxContainer
    implements NotDirectlyRendered {
        Symbol() {
        }

        @Override
        String getNodeName() {
            return "symbol";
        }
    }

    static class Switch
    extends Group {
        Switch() {
        }

        @Override
        String getNodeName() {
            return "switch";
        }
    }

    static class TextPath
    extends TextContainer
    implements TextChild {
        String href;
        Length startOffset;
        private TextRoot textRoot;

        TextPath() {
        }

        @Override
        public void setTextRoot(TextRoot obj) {
            this.textRoot = obj;
        }

        @Override
        public TextRoot getTextRoot() {
            return this.textRoot;
        }

        @Override
        String getNodeName() {
            return "textPath";
        }
    }

    static class TRef
    extends TextContainer
    implements TextChild {
        String href;
        private TextRoot textRoot;

        TRef() {
        }

        @Override
        public void setTextRoot(TextRoot obj) {
            this.textRoot = obj;
        }

        @Override
        public TextRoot getTextRoot() {
            return this.textRoot;
        }

        @Override
        String getNodeName() {
            return "tref";
        }
    }

    static class TextSequence
    extends SvgObject
    implements TextChild {
        String text;
        private TextRoot textRoot;

        TextSequence(String text) {
            this.text = text;
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + " '" + this.text + "'";
        }

        @Override
        public void setTextRoot(TextRoot obj) {
            this.textRoot = obj;
        }

        @Override
        public TextRoot getTextRoot() {
            return this.textRoot;
        }
    }

    static class TSpan
    extends TextPositionedContainer
    implements TextChild {
        private TextRoot textRoot;

        TSpan() {
        }

        @Override
        public void setTextRoot(TextRoot obj) {
            this.textRoot = obj;
        }

        @Override
        public TextRoot getTextRoot() {
            return this.textRoot;
        }

        @Override
        String getNodeName() {
            return "tspan";
        }
    }

    static class Text
    extends TextPositionedContainer
    implements TextRoot,
    HasTransform {
        Matrix transform;

        Text() {
        }

        @Override
        public void setTransform(Matrix transform) {
            this.transform = transform;
        }

        @Override
        String getNodeName() {
            return "text";
        }
    }

    static abstract class TextPositionedContainer
    extends TextContainer {
        List<Length> x;
        List<Length> y;
        List<Length> dx;
        List<Length> dy;

        TextPositionedContainer() {
        }
    }

    static abstract class TextContainer
    extends SvgConditionalContainer {
        TextContainer() {
        }

        @Override
        public void addChild(SvgObject elem) throws SVGParseException {
            if (!(elem instanceof TextChild)) {
                throw new SVGParseException("Text content elements cannot contain " + elem + " elements.");
            }
            this.children.add(elem);
        }
    }

    static interface TextChild {
        public void setTextRoot(TextRoot var1);

        public TextRoot getTextRoot();
    }

    static interface TextRoot {
    }

    static class Polygon
    extends PolyLine {
        Polygon() {
        }

        @Override
        String getNodeName() {
            return "polygon";
        }
    }

    static class PolyLine
    extends GraphicsElement {
        float[] points;

        PolyLine() {
        }

        @Override
        String getNodeName() {
            return "polyline";
        }
    }

    static class Line
    extends GraphicsElement {
        Length x1;
        Length y1;
        Length x2;
        Length y2;

        Line() {
        }

        @Override
        String getNodeName() {
            return "line";
        }
    }

    static class Ellipse
    extends GraphicsElement {
        Length cx;
        Length cy;
        Length rx;
        Length ry;

        Ellipse() {
        }

        @Override
        String getNodeName() {
            return "ellipse";
        }
    }

    static class Circle
    extends GraphicsElement {
        Length cx;
        Length cy;
        Length r;

        Circle() {
        }

        @Override
        String getNodeName() {
            return "circle";
        }
    }

    static class Rect
    extends GraphicsElement {
        Length x;
        Length y;
        Length width;
        Length height;
        Length rx;
        Length ry;

        Rect() {
        }

        @Override
        String getNodeName() {
            return "rect";
        }
    }

    static class Path
    extends GraphicsElement {
        PathDefinition d;
        Float pathLength;

        Path() {
        }

        @Override
        String getNodeName() {
            return "path";
        }
    }

    static class Use
    extends Group {
        String href;
        Length x;
        Length y;
        Length width;
        Length height;

        Use() {
        }

        @Override
        String getNodeName() {
            return "use";
        }
    }

    static abstract class GraphicsElement
    extends SvgConditionalElement
    implements HasTransform {
        Matrix transform;

        GraphicsElement() {
        }

        @Override
        public void setTransform(Matrix transform) {
            this.transform = transform;
        }
    }

    static class Defs
    extends Group
    implements NotDirectlyRendered {
        Defs() {
        }

        @Override
        String getNodeName() {
            return "defs";
        }
    }

    static interface NotDirectlyRendered {
    }

    static class Group
    extends SvgConditionalContainer
    implements HasTransform {
        Matrix transform;

        Group() {
        }

        @Override
        public void setTransform(Matrix transform) {
            this.transform = transform;
        }

        @Override
        String getNodeName() {
            return "group";
        }
    }

    static class Svg
    extends SvgViewBoxContainer {
        Length x;
        Length y;
        Length width;
        Length height;
        public String version;

        Svg() {
        }

        @Override
        String getNodeName() {
            return "svg";
        }
    }

    static abstract class SvgViewBoxContainer
    extends SvgPreserveAspectRatioContainer {
        Box viewBox;

        SvgViewBoxContainer() {
        }
    }

    static abstract class SvgPreserveAspectRatioContainer
    extends SvgConditionalContainer {
        PreserveAspectRatio preserveAspectRatio = null;

        SvgPreserveAspectRatioContainer() {
        }
    }

    static interface HasTransform {
        public void setTransform(Matrix var1);
    }

    static abstract class SvgConditionalContainer
    extends SvgElement
    implements SvgContainer,
    SvgConditional {
        List<SvgObject> children = new ArrayList<SvgObject>();
        Set<String> requiredFeatures = null;
        String requiredExtensions = null;
        Set<String> systemLanguage = null;
        Set<String> requiredFormats = null;
        Set<String> requiredFonts = null;

        SvgConditionalContainer() {
        }

        @Override
        public List<SvgObject> getChildren() {
            return this.children;
        }

        @Override
        public void addChild(SvgObject elem) throws SVGParseException {
            this.children.add(elem);
        }

        @Override
        public void setRequiredFeatures(Set<String> features) {
            this.requiredFeatures = features;
        }

        @Override
        public Set<String> getRequiredFeatures() {
            return this.requiredFeatures;
        }

        @Override
        public void setRequiredExtensions(String extensions) {
            this.requiredExtensions = extensions;
        }

        @Override
        public String getRequiredExtensions() {
            return this.requiredExtensions;
        }

        @Override
        public void setSystemLanguage(Set<String> languages) {
            this.systemLanguage = languages;
        }

        @Override
        public Set<String> getSystemLanguage() {
            return null;
        }

        @Override
        public void setRequiredFormats(Set<String> mimeTypes) {
            this.requiredFormats = mimeTypes;
        }

        @Override
        public Set<String> getRequiredFormats() {
            return this.requiredFormats;
        }

        @Override
        public void setRequiredFonts(Set<String> fontNames) {
            this.requiredFonts = fontNames;
        }

        @Override
        public Set<String> getRequiredFonts() {
            return this.requiredFonts;
        }
    }

    static interface SvgContainer {
        public List<SvgObject> getChildren();

        public void addChild(SvgObject var1) throws SVGParseException;
    }

    static abstract class SvgConditionalElement
    extends SvgElement
    implements SvgConditional {
        Set<String> requiredFeatures = null;
        String requiredExtensions = null;
        Set<String> systemLanguage = null;
        Set<String> requiredFormats = null;
        Set<String> requiredFonts = null;

        SvgConditionalElement() {
        }

        @Override
        public void setRequiredFeatures(Set<String> features) {
            this.requiredFeatures = features;
        }

        @Override
        public Set<String> getRequiredFeatures() {
            return this.requiredFeatures;
        }

        @Override
        public void setRequiredExtensions(String extensions) {
            this.requiredExtensions = extensions;
        }

        @Override
        public String getRequiredExtensions() {
            return this.requiredExtensions;
        }

        @Override
        public void setSystemLanguage(Set<String> languages) {
            this.systemLanguage = languages;
        }

        @Override
        public Set<String> getSystemLanguage() {
            return this.systemLanguage;
        }

        @Override
        public void setRequiredFormats(Set<String> mimeTypes) {
            this.requiredFormats = mimeTypes;
        }

        @Override
        public Set<String> getRequiredFormats() {
            return this.requiredFormats;
        }

        @Override
        public void setRequiredFonts(Set<String> fontNames) {
            this.requiredFonts = fontNames;
        }

        @Override
        public Set<String> getRequiredFonts() {
            return this.requiredFonts;
        }
    }

    static interface SvgConditional {
        public void setRequiredFeatures(Set<String> var1);

        public Set<String> getRequiredFeatures();

        public void setRequiredExtensions(String var1);

        public String getRequiredExtensions();

        public void setSystemLanguage(Set<String> var1);

        public Set<String> getSystemLanguage();

        public void setRequiredFormats(Set<String> var1);

        public Set<String> getRequiredFormats();

        public void setRequiredFonts(Set<String> var1);

        public Set<String> getRequiredFonts();
    }

    static abstract class SvgElement
    extends SvgElementBase {
        Box boundingBox = null;

        SvgElement() {
        }
    }

    static abstract class SvgElementBase
    extends SvgObject {
        String id = null;
        Boolean spacePreserve = null;
        Style baseStyle = null;
        Style style = null;
        List<String> classNames = null;

        SvgElementBase() {
        }

        abstract String getNodeName();
    }

    static class SvgObject {
        SVG document;
        SvgContainer parent;

        SvgObject() {
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    static class CSSClipRect {
        Length top;
        Length right;
        Length bottom;
        Length left;

        CSSClipRect(Length top, Length right, Length bottom, Length left) {
            this.top = top;
            this.right = right;
            this.bottom = bottom;
            this.left = left;
        }
    }

    static class Length
    implements Cloneable {
        float value = 0.0f;
        Unit unit = Unit.px;

        Length(float value, Unit unit) {
            this.value = value;
            this.unit = unit;
        }

        Length(float value) {
            this.value = value;
            this.unit = Unit.px;
        }

        float floatValue() {
            return this.value;
        }

        float floatValueX(SVGAndroidRenderer renderer) {
            switch (this.unit) {
                case px: {
                    return this.value;
                }
                case em: {
                    return this.value * renderer.getCurrentFontSize();
                }
                case ex: {
                    return this.value * renderer.getCurrentFontXHeight();
                }
                case in: {
                    return this.value * renderer.getDPI();
                }
                case cm: {
                    return this.value * renderer.getDPI() / 2.54f;
                }
                case mm: {
                    return this.value * renderer.getDPI() / 25.4f;
                }
                case pt: {
                    return this.value * renderer.getDPI() / 72.0f;
                }
                case pc: {
                    return this.value * renderer.getDPI() / 6.0f;
                }
                case percent: {
                    Box viewPortUser = renderer.getCurrentViewPortInUserUnits();
                    if (viewPortUser == null) {
                        return this.value;
                    }
                    return this.value * viewPortUser.width / 100.0f;
                }
            }
            return this.value;
        }

        float floatValueY(SVGAndroidRenderer renderer) {
            if (this.unit == Unit.percent) {
                Box viewPortUser = renderer.getCurrentViewPortInUserUnits();
                if (viewPortUser == null) {
                    return this.value;
                }
                return this.value * viewPortUser.height / 100.0f;
            }
            return this.floatValueX(renderer);
        }

        float floatValue(SVGAndroidRenderer renderer) {
            if (this.unit == Unit.percent) {
                Box viewPortUser = renderer.getCurrentViewPortInUserUnits();
                if (viewPortUser == null) {
                    return this.value;
                }
                float w = viewPortUser.width;
                float h = viewPortUser.height;
                if (w == h) {
                    return this.value * w / 100.0f;
                }
                float n = (float)(Math.sqrt(w * w + h * h) / 1.414213562373095);
                return this.value * n / 100.0f;
            }
            return this.floatValueX(renderer);
        }

        float floatValue(SVGAndroidRenderer renderer, float max) {
            if (this.unit == Unit.percent) {
                return this.value * max / 100.0f;
            }
            return this.floatValueX(renderer);
        }

        float floatValue(float dpi) {
            switch (this.unit) {
                case px: {
                    return this.value;
                }
                case in: {
                    return this.value * dpi;
                }
                case cm: {
                    return this.value * dpi / 2.54f;
                }
                case mm: {
                    return this.value * dpi / 25.4f;
                }
                case pt: {
                    return this.value * dpi / 72.0f;
                }
                case pc: {
                    return this.value * dpi / 6.0f;
                }
            }
            return this.value;
        }

        boolean isZero() {
            return this.value == 0.0f;
        }

        boolean isNegative() {
            return this.value < 0.0f;
        }

        public String toString() {
            return String.valueOf(this.value) + (Object)((Object)this.unit);
        }
    }

    static class PaintReference
    extends SvgPaint {
        String href;
        SvgPaint fallback;

        PaintReference(String href, SvgPaint fallback) {
            this.href = href;
            this.fallback = fallback;
        }

        public String toString() {
            return this.href + " " + this.fallback;
        }
    }

    static class CurrentColor
    extends SvgPaint {
        private static CurrentColor instance = new CurrentColor();

        private CurrentColor() {
        }

        static CurrentColor getInstance() {
            return instance;
        }
    }

    static class Colour
    extends SvgPaint {
        int colour;
        static final Colour BLACK = new Colour(-16777216);
        static final Colour TRANSPARENT = new Colour(0);

        Colour(int val) {
            this.colour = val;
        }

        public String toString() {
            return String.format("#%08x", this.colour);
        }
    }

    static abstract class SvgPaint
    implements Cloneable {
        SvgPaint() {
        }
    }

    static class Style
    implements Cloneable {
        long specifiedFlags = 0L;
        SvgPaint fill;
        FillRule fillRule;
        Float fillOpacity;
        SvgPaint stroke;
        Float strokeOpacity;
        Length strokeWidth;
        LineCap strokeLineCap;
        LineJoin strokeLineJoin;
        Float strokeMiterLimit;
        Length[] strokeDashArray;
        Length strokeDashOffset;
        Float opacity;
        Colour color;
        List<String> fontFamily;
        Length fontSize;
        Integer fontWeight;
        FontStyle fontStyle;
        TextDecoration textDecoration;
        TextDirection direction;
        TextAnchor textAnchor;
        Boolean overflow;
        CSSClipRect clip;
        String markerStart;
        String markerMid;
        String markerEnd;
        Boolean display;
        Boolean visibility;
        SvgPaint stopColor;
        Float stopOpacity;
        String clipPath;
        FillRule clipRule;
        String mask;
        SvgPaint solidColor;
        Float solidOpacity;
        SvgPaint viewportFill;
        Float viewportFillOpacity;
        VectorEffect vectorEffect;
        RenderQuality imageRendering;
        static final int FONT_WEIGHT_NORMAL = 400;
        static final int FONT_WEIGHT_BOLD = 700;
        static final int FONT_WEIGHT_LIGHTER = -1;
        static final int FONT_WEIGHT_BOLDER = 1;

        Style() {
        }

        static Style getDefaultStyle() {
            Style def = new Style();
            def.specifiedFlags = -1L;
            def.fill = Colour.BLACK;
            def.fillRule = FillRule.NonZero;
            def.fillOpacity = Float.valueOf(1.0f);
            def.stroke = null;
            def.strokeOpacity = Float.valueOf(1.0f);
            def.strokeWidth = new Length(1.0f);
            def.strokeLineCap = LineCap.Butt;
            def.strokeLineJoin = LineJoin.Miter;
            def.strokeMiterLimit = Float.valueOf(4.0f);
            def.strokeDashArray = null;
            def.strokeDashOffset = new Length(0.0f);
            def.opacity = Float.valueOf(1.0f);
            def.color = Colour.BLACK;
            def.fontFamily = null;
            def.fontSize = new Length(12.0f, Unit.pt);
            def.fontWeight = 400;
            def.fontStyle = FontStyle.Normal;
            def.textDecoration = TextDecoration.None;
            def.direction = TextDirection.LTR;
            def.textAnchor = TextAnchor.Start;
            def.overflow = true;
            def.clip = null;
            def.markerStart = null;
            def.markerMid = null;
            def.markerEnd = null;
            def.display = Boolean.TRUE;
            def.visibility = Boolean.TRUE;
            def.stopColor = Colour.BLACK;
            def.stopOpacity = Float.valueOf(1.0f);
            def.clipPath = null;
            def.clipRule = FillRule.NonZero;
            def.mask = null;
            def.solidColor = null;
            def.solidOpacity = Float.valueOf(1.0f);
            def.viewportFill = null;
            def.viewportFillOpacity = Float.valueOf(1.0f);
            def.vectorEffect = VectorEffect.None;
            def.imageRendering = RenderQuality.auto;
            return def;
        }

        void resetNonInheritingProperties(boolean isRootSVG) {
            this.display = Boolean.TRUE;
            this.overflow = isRootSVG ? Boolean.TRUE : Boolean.FALSE;
            this.clip = null;
            this.clipPath = null;
            this.opacity = Float.valueOf(1.0f);
            this.stopColor = Colour.BLACK;
            this.stopOpacity = Float.valueOf(1.0f);
            this.mask = null;
            this.solidColor = null;
            this.solidOpacity = Float.valueOf(1.0f);
            this.viewportFill = null;
            this.viewportFillOpacity = Float.valueOf(1.0f);
            this.vectorEffect = VectorEffect.None;
        }

        protected Object clone() throws CloneNotSupportedException {
            Style obj = (Style)super.clone();
            if (this.strokeDashArray != null) {
                obj.strokeDashArray = (Length[])this.strokeDashArray.clone();
            }
            return obj;
        }

        public static enum RenderQuality {
            auto,
            optimizeQuality,
            optimizeSpeed;

        }

        public static enum VectorEffect {
            None,
            NonScalingStroke;

        }

        public static enum TextDirection {
            LTR,
            RTL;

        }

        public static enum TextDecoration {
            None,
            Underline,
            Overline,
            LineThrough,
            Blink;

        }

        public static enum TextAnchor {
            Start,
            Middle,
            End;

        }

        public static enum FontStyle {
            Normal,
            Italic,
            Oblique;

        }

        public static enum LineJoin {
            Miter,
            Round,
            Bevel;

        }

        public static enum LineCap {
            Butt,
            Round,
            Square;

        }

        public static enum FillRule {
            NonZero,
            EvenOdd;

        }
    }

    static class Box {
        float minX;
        float minY;
        float width;
        float height;

        Box(float minX, float minY, float width, float height) {
            this.minX = minX;
            this.minY = minY;
            this.width = width;
            this.height = height;
        }

        Box(Box copy) {
            this.minX = copy.minX;
            this.minY = copy.minY;
            this.width = copy.width;
            this.height = copy.height;
        }

        static Box fromLimits(float minX, float minY, float maxX, float maxY) {
            return new Box(minX, minY, maxX - minX, maxY - minY);
        }

        static Box fromRectF(RectF rect) {
            return Box.fromLimits(rect.left, rect.top, rect.right, rect.bottom);
        }

        RectF toRectF() {
            return new RectF(this.minX, this.minY, this.maxX(), this.maxY());
        }

        float maxX() {
            return this.minX + this.width;
        }

        float maxY() {
            return this.minY + this.height;
        }

        void union(Box other) {
            if (other.minX < this.minX) {
                this.minX = other.minX;
            }
            if (other.minY < this.minY) {
                this.minY = other.minY;
            }
            if (other.maxX() > this.maxX()) {
                this.width = other.maxX() - this.minX;
            }
            if (other.maxY() > this.maxY()) {
                this.height = other.maxY() - this.minY;
            }
        }

        public String toString() {
            return "[" + this.minX + " " + this.minY + " " + this.width + " " + this.height + "]";
        }
    }

    static enum GradientSpread {
        pad,
        reflect,
        repeat;

    }

    static enum Unit {
        px,
        em,
        ex,
        in,
        cm,
        mm,
        pt,
        pc,
        percent;

    }
}

