/*
 * Decompiled with CFR 0.152.
 */
package com.caverock.androidsvg;

import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Typeface;
import android.os.Build;
import android.util.Log;
import com.caverock.androidsvg.SVGExternalFileResolver;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;

public class SimpleAssetResolver
extends SVGExternalFileResolver {
    private static final String TAG = SimpleAssetResolver.class.getSimpleName();
    private AssetManager assetManager;
    private static final Set<String> supportedFormats = new HashSet<String>(8);

    public SimpleAssetResolver(AssetManager assetManager) {
        this.assetManager = assetManager;
    }

    @Override
    public Typeface resolveFont(String fontFamily, int fontWeight, String fontStyle) {
        Log.i((String)TAG, (String)("resolveFont(" + fontFamily + "," + fontWeight + "," + fontStyle + ")"));
        try {
            return Typeface.createFromAsset((AssetManager)this.assetManager, (String)(fontFamily + ".ttf"));
        }
        catch (RuntimeException runtimeException) {
            try {
                return Typeface.createFromAsset((AssetManager)this.assetManager, (String)(fontFamily + ".otf"));
            }
            catch (RuntimeException e) {
                return null;
            }
        }
    }

    @Override
    public Bitmap resolveImage(String filename) {
        Log.i((String)TAG, (String)("resolveImage(" + filename + ")"));
        try {
            InputStream istream = this.assetManager.open(filename);
            return BitmapFactory.decodeStream((InputStream)istream);
        }
        catch (IOException e1) {
            return null;
        }
    }

    @Override
    public boolean isFormatSupported(String mimeType) {
        return supportedFormats.contains(mimeType);
    }

    @Override
    public String resolveCSSStyleSheet(String url) {
        Log.i((String)TAG, (String)("resolveCSSStyleSheet(" + url + ")"));
        return this.getAssetAsString(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAssetAsString(String url) {
        InputStream is = null;
        try {
            is = this.assetManager.open(url);
            InputStreamReader r = new InputStreamReader(is, Charset.forName("UTF-8"));
            char[] buffer = new char[4096];
            StringBuilder sb = new StringBuilder();
            int len = r.read(buffer);
            while (len > 0) {
                sb.append(buffer, 0, len);
                len = r.read(buffer);
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    static {
        supportedFormats.add("image/svg+xml");
        supportedFormats.add("image/jpeg");
        supportedFormats.add("image/png");
        supportedFormats.add("image/pjpeg");
        supportedFormats.add("image/gif");
        supportedFormats.add("image/bmp");
        supportedFormats.add("image/x-windows-bmp");
        if (Build.VERSION.SDK_INT >= 14) {
            supportedFormats.add("image/webp");
        }
    }
}

