/*
 * Decompiled with CFR 0.152.
 */
package com.caverock.androidsvg;

import android.graphics.Matrix;
import android.util.Log;
import android.util.Xml;
import com.caverock.androidsvg.CSSParser;
import com.caverock.androidsvg.IntegerParser;
import com.caverock.androidsvg.NumberParser;
import com.caverock.androidsvg.PreserveAspectRatio;
import com.caverock.androidsvg.SVG;
import com.caverock.androidsvg.SVGParseException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

class SVGParser {
    private static final String TAG = "SVGParser";
    private static final String SVG_NAMESPACE = "http://www.w3.org/2000/svg";
    private static final String XLINK_NAMESPACE = "http://www.w3.org/1999/xlink";
    private static final String FEATURE_STRING_PREFIX = "http://www.w3.org/TR/SVG11/feature#";
    private static final String XML_STYLESHEET_PROCESSING_INSTRUCTION = "xml-stylesheet";
    public static final String XML_STYLESHEET_ATTR_TYPE = "type";
    public static final String XML_STYLESHEET_ATTR_ALTERNATE = "alternate";
    public static final String XML_STYLESHEET_ATTR_HREF = "href";
    public static final String XML_STYLESHEET_ATTR_MEDIA = "media";
    public static final String XML_STYLESHEET_ATTR_MEDIA_ALL = "all";
    public static final String XML_STYLESHEET_ATTR_ALTERNATE_NO = "no";
    public static final int ENTITY_WATCH_BUFFER_SIZE = 4096;
    private SVG svgDocument = null;
    private SVG.SvgContainer currentElement = null;
    private boolean ignoring = false;
    private int ignoreDepth;
    private boolean inMetadataElement = false;
    private SVGElem metadataTag = null;
    private StringBuilder metadataElementContents = null;
    private boolean inStyleElement = false;
    private StringBuilder styleElementContents = null;
    private static final String NONE = "none";
    private static final String CURRENTCOLOR = "currentColor";
    private static final String VALID_DISPLAY_VALUES = "|inline|block|list-item|run-in|compact|marker|table|inline-table|table-row-group|table-header-group|table-footer-group|table-row|table-column-group|table-column|table-cell|table-caption|none|";
    private static final String VALID_VISIBILITY_VALUES = "|visible|hidden|collapse|";

    SVGParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SVG parse(InputStream is, boolean enableInternalEntities) throws SVGParseException {
        if (!is.markSupported()) {
            is = new BufferedInputStream(is);
        }
        try {
            is.mark(3);
            int firstTwoBytes = is.read() + (is.read() << 8);
            is.reset();
            if (firstTwoBytes == 35615) {
                is = new BufferedInputStream(new GZIPInputStream(is));
            }
        }
        catch (IOException firstTwoBytes) {
            // empty catch block
        }
        try {
            is.mark(4096);
            this.parseUsingXmlPullParser(is, enableInternalEntities);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Exception thrown closing input stream");
            }
        }
        return this.svgDocument;
    }

    private void parseUsingXmlPullParser(InputStream is, boolean enableInternalEntities) throws SVGParseException {
        try {
            XmlPullParser parser = Xml.newPullParser();
            XPPAttributesWrapper attributes = new XPPAttributesWrapper(parser);
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-docdecl", false);
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            parser.setInput(is, null);
            int eventType = parser.getEventType();
            while (eventType != 1) {
                switch (eventType) {
                    case 0: {
                        this.startDocument();
                        break;
                    }
                    case 2: {
                        String qName = parser.getName();
                        if (parser.getPrefix() != null) {
                            qName = parser.getPrefix() + ':' + qName;
                        }
                        this.startElement(parser.getNamespace(), parser.getName(), qName, attributes);
                        break;
                    }
                    case 3: {
                        String qName = parser.getName();
                        if (parser.getPrefix() != null) {
                            qName = parser.getPrefix() + ':' + qName;
                        }
                        this.endElement(parser.getNamespace(), parser.getName(), qName);
                        break;
                    }
                    case 4: {
                        int[] startAndLength = new int[2];
                        char[] text = parser.getTextCharacters(startAndLength);
                        this.text(text, startAndLength[0], startAndLength[1]);
                        break;
                    }
                    case 5: {
                        this.text(parser.getText());
                        break;
                    }
                    case 10: {
                        if (!enableInternalEntities || this.svgDocument.getRootElement() != null || !parser.getText().contains("<!ENTITY ")) break;
                        try {
                            Log.d((String)TAG, (String)"Switching to SAX parser to process entities");
                            is.reset();
                            this.parseUsingSAX(is);
                        }
                        catch (IOException e) {
                            Log.w((String)TAG, (String)"Detected internal entity definitions, but could not parse them.");
                        }
                        return;
                    }
                    case 8: {
                        Log.d((String)TAG, (String)("PROC INSTR: " + parser.getText()));
                        TextScanner scan = new TextScanner(parser.getText());
                        String instr = scan.nextToken();
                        this.handleProcessingInstruction(instr, this.parseProcessingInstructionAttributes(scan));
                    }
                }
                eventType = parser.nextToken();
            }
            this.endDocument();
        }
        catch (XmlPullParserException e) {
            throw new SVGParseException("XML parser problem", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new SVGParseException("Stream error", e);
        }
    }

    private void parseUsingSAX(InputStream is) throws SVGParseException {
        Log.d((String)TAG, (String)"Falling back to SAX parser");
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            spf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            SAXParser sp = spf.newSAXParser();
            XMLReader xr = sp.getXMLReader();
            SAXHandler handler = new SAXHandler();
            xr.setContentHandler(handler);
            xr.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            xr.parse(new InputSource(is));
        }
        catch (ParserConfigurationException e) {
            throw new SVGParseException("XML parser problem", e);
        }
        catch (SAXException e) {
            throw new SVGParseException("SVG parse error", e);
        }
        catch (IOException e) {
            throw new SVGParseException("Stream error", e);
        }
    }

    private void startDocument() {
        this.svgDocument = new SVG();
    }

    private void startElement(String uri, String localName, String qName, Attributes attributes) throws SVGParseException {
        if (this.ignoring) {
            ++this.ignoreDepth;
            return;
        }
        if (!SVG_NAMESPACE.equals(uri) && !"".equals(uri)) {
            return;
        }
        String tag = localName.length() > 0 ? localName : qName;
        SVGElem elem = SVGElem.fromString(tag);
        switch (elem) {
            case svg: {
                this.svg(attributes);
                break;
            }
            case g: 
            case a: {
                this.g(attributes);
                break;
            }
            case defs: {
                this.defs(attributes);
                break;
            }
            case use: {
                this.use(attributes);
                break;
            }
            case path: {
                this.path(attributes);
                break;
            }
            case rect: {
                this.rect(attributes);
                break;
            }
            case circle: {
                this.circle(attributes);
                break;
            }
            case ellipse: {
                this.ellipse(attributes);
                break;
            }
            case line: {
                this.line(attributes);
                break;
            }
            case polyline: {
                this.polyline(attributes);
                break;
            }
            case polygon: {
                this.polygon(attributes);
                break;
            }
            case text: {
                this.text(attributes);
                break;
            }
            case tspan: {
                this.tspan(attributes);
                break;
            }
            case tref: {
                this.tref(attributes);
                break;
            }
            case SWITCH: {
                this.zwitch(attributes);
                break;
            }
            case symbol: {
                this.symbol(attributes);
                break;
            }
            case marker: {
                this.marker(attributes);
                break;
            }
            case linearGradient: {
                this.linearGradient(attributes);
                break;
            }
            case radialGradient: {
                this.radialGradient(attributes);
                break;
            }
            case stop: {
                this.stop(attributes);
                break;
            }
            case title: 
            case desc: {
                this.inMetadataElement = true;
                this.metadataTag = elem;
                break;
            }
            case clipPath: {
                this.clipPath(attributes);
                break;
            }
            case textPath: {
                this.textPath(attributes);
                break;
            }
            case pattern: {
                this.pattern(attributes);
                break;
            }
            case image: {
                this.image(attributes);
                break;
            }
            case view: {
                this.view(attributes);
                break;
            }
            case mask: {
                this.mask(attributes);
                break;
            }
            case style: {
                this.style(attributes);
                break;
            }
            case solidColor: {
                this.solidColor(attributes);
                break;
            }
            default: {
                this.ignoring = true;
                this.ignoreDepth = 1;
            }
        }
    }

    private void text(String characters) throws SVGParseException {
        if (this.ignoring) {
            return;
        }
        if (this.inMetadataElement) {
            if (this.metadataElementContents == null) {
                this.metadataElementContents = new StringBuilder(characters.length());
            }
            this.metadataElementContents.append(characters);
        } else if (this.inStyleElement) {
            if (this.styleElementContents == null) {
                this.styleElementContents = new StringBuilder(characters.length());
            }
            this.styleElementContents.append(characters);
        } else if (this.currentElement instanceof SVG.TextContainer) {
            this.appendToTextContainer(characters);
        }
    }

    private void text(char[] ch, int start, int length) throws SVGParseException {
        if (this.ignoring) {
            return;
        }
        if (this.inMetadataElement) {
            if (this.metadataElementContents == null) {
                this.metadataElementContents = new StringBuilder(length);
            }
            this.metadataElementContents.append(ch, start, length);
        } else if (this.inStyleElement) {
            if (this.styleElementContents == null) {
                this.styleElementContents = new StringBuilder(length);
            }
            this.styleElementContents.append(ch, start, length);
        } else if (this.currentElement instanceof SVG.TextContainer) {
            this.appendToTextContainer(new String(ch, start, length));
        }
    }

    private void appendToTextContainer(String characters) throws SVGParseException {
        SVG.SvgObject previousSibling;
        SVG.SvgConditionalContainer parent = (SVG.SvgConditionalContainer)this.currentElement;
        int numOlderSiblings = parent.children.size();
        SVG.SvgObject svgObject = previousSibling = numOlderSiblings == 0 ? null : parent.children.get(numOlderSiblings - 1);
        if (previousSibling instanceof SVG.TextSequence) {
            ((SVG.TextSequence)previousSibling).text = ((SVG.TextSequence)previousSibling).text + characters;
        } else {
            this.currentElement.addChild(new SVG.TextSequence(characters));
        }
    }

    private void endElement(String uri, String localName, String qName) throws SVGParseException {
        if (this.ignoring && --this.ignoreDepth == 0) {
            this.ignoring = false;
            return;
        }
        if (!SVG_NAMESPACE.equals(uri) && !"".equals(uri)) {
            return;
        }
        String tag = localName.length() > 0 ? localName : qName;
        switch (SVGElem.fromString(tag)) {
            case title: 
            case desc: {
                this.inMetadataElement = false;
                if (this.metadataElementContents != null) {
                    if (this.metadataTag == SVGElem.title) {
                        this.svgDocument.setTitle(this.metadataElementContents.toString());
                    } else if (this.metadataTag == SVGElem.desc) {
                        this.svgDocument.setDesc(this.metadataElementContents.toString());
                    }
                    this.metadataElementContents.setLength(0);
                }
                return;
            }
            case style: {
                if (this.styleElementContents == null) break;
                this.inStyleElement = false;
                this.parseCSSStyleSheet(this.styleElementContents.toString());
                this.styleElementContents.setLength(0);
                return;
            }
            case svg: 
            case g: 
            case defs: 
            case use: 
            case text: 
            case tspan: 
            case SWITCH: 
            case symbol: 
            case marker: 
            case linearGradient: 
            case radialGradient: 
            case stop: 
            case clipPath: 
            case textPath: 
            case pattern: 
            case image: 
            case view: 
            case mask: 
            case solidColor: {
                this.currentElement = ((SVG.SvgObject)((Object)this.currentElement)).parent;
                break;
            }
        }
    }

    private void endDocument() {
    }

    private void handleProcessingInstruction(String instruction, Map<String, String> attributes) {
        if (instruction.equals(XML_STYLESHEET_PROCESSING_INSTRUCTION) && SVG.getFileResolver() != null) {
            String attr2 = attributes.get(XML_STYLESHEET_ATTR_TYPE);
            if (attr2 != null && !"text/css".equals(attributes.get(XML_STYLESHEET_ATTR_TYPE))) {
                return;
            }
            attr2 = attributes.get(XML_STYLESHEET_ATTR_ALTERNATE);
            if (attr2 != null && !XML_STYLESHEET_ATTR_ALTERNATE_NO.equals(attributes.get(XML_STYLESHEET_ATTR_ALTERNATE))) {
                return;
            }
            attr2 = attributes.get(XML_STYLESHEET_ATTR_HREF);
            if (attr2 != null) {
                String css = SVG.getFileResolver().resolveCSSStyleSheet(attr2);
                if (css == null) {
                    return;
                }
                String mediaAttr = attributes.get(XML_STYLESHEET_ATTR_MEDIA);
                if (mediaAttr != null && !XML_STYLESHEET_ATTR_MEDIA_ALL.equals(mediaAttr.trim())) {
                    css = "@media " + mediaAttr + " { " + css + "}";
                }
                this.parseCSSStyleSheet(css);
            }
        }
    }

    private Map<String, String> parseProcessingInstructionAttributes(TextScanner scan) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        scan.skipWhitespace();
        String attrName = scan.nextToken('=');
        while (attrName != null) {
            scan.consume('=');
            String value = scan.nextQuotedString();
            attributes.put(attrName, value);
            scan.skipWhitespace();
            attrName = scan.nextToken('=');
        }
        return attributes;
    }

    private void dumpNode(SVG.SvgObject elem, String indent) {
        Log.d((String)TAG, (String)(indent + elem));
        if (elem instanceof SVG.SvgConditionalContainer) {
            indent = indent + "  ";
            for (SVG.SvgObject child : ((SVG.SvgConditionalContainer)elem).children) {
                this.dumpNode(child, indent);
            }
        }
    }

    private void debug(String format, Object ... args) {
    }

    private void svg(Attributes attributes) throws SVGParseException {
        this.debug("<svg>", new Object[0]);
        SVG.Svg obj = new SVG.Svg();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesViewBox(obj, attributes);
        this.parseAttributesSVG(obj, attributes);
        if (this.currentElement == null) {
            this.svgDocument.setRootElement(obj);
        } else {
            this.currentElement.addChild(obj);
        }
        this.currentElement = obj;
    }

    private void parseAttributesSVG(SVG.Svg obj, Attributes attributes) throws SVGParseException {
        block7: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case x: {
                    obj.x = SVGParser.parseLength(val);
                    continue block7;
                }
                case y: {
                    obj.y = SVGParser.parseLength(val);
                    continue block7;
                }
                case width: {
                    obj.width = SVGParser.parseLength(val);
                    if (!obj.width.isNegative()) continue block7;
                    throw new SVGParseException("Invalid <svg> element. width cannot be negative");
                }
                case height: {
                    obj.height = SVGParser.parseLength(val);
                    if (!obj.height.isNegative()) continue block7;
                    throw new SVGParseException("Invalid <svg> element. height cannot be negative");
                }
                case version: {
                    obj.version = val;
                    continue block7;
                }
            }
        }
    }

    private void g(Attributes attributes) throws SVGParseException {
        this.debug("<g>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.Group obj = new SVG.Group();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesTransform(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void defs(Attributes attributes) throws SVGParseException {
        this.debug("<defs>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.Defs obj = new SVG.Defs();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesTransform(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void use(Attributes attributes) throws SVGParseException {
        this.debug("<use>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.Use obj = new SVG.Use();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesTransform(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesUse(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void parseAttributesUse(SVG.Use obj, Attributes attributes) throws SVGParseException {
        block7: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case x: {
                    obj.x = SVGParser.parseLength(val);
                    continue block7;
                }
                case y: {
                    obj.y = SVGParser.parseLength(val);
                    continue block7;
                }
                case width: {
                    obj.width = SVGParser.parseLength(val);
                    if (!obj.width.isNegative()) continue block7;
                    throw new SVGParseException("Invalid <use> element. width cannot be negative");
                }
                case height: {
                    obj.height = SVGParser.parseLength(val);
                    if (!obj.height.isNegative()) continue block7;
                    throw new SVGParseException("Invalid <use> element. height cannot be negative");
                }
                case href: {
                    if (!"".equals(attributes.getURI(i)) && !XLINK_NAMESPACE.equals(attributes.getURI(i))) continue block7;
                    obj.href = val;
                    continue block7;
                }
            }
        }
    }

    private void image(Attributes attributes) throws SVGParseException {
        this.debug("<image>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.Image obj = new SVG.Image();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesTransform(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesImage(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void parseAttributesImage(SVG.Image obj, Attributes attributes) throws SVGParseException {
        block8: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case x: {
                    obj.x = SVGParser.parseLength(val);
                    continue block8;
                }
                case y: {
                    obj.y = SVGParser.parseLength(val);
                    continue block8;
                }
                case width: {
                    obj.width = SVGParser.parseLength(val);
                    if (!obj.width.isNegative()) continue block8;
                    throw new SVGParseException("Invalid <use> element. width cannot be negative");
                }
                case height: {
                    obj.height = SVGParser.parseLength(val);
                    if (!obj.height.isNegative()) continue block8;
                    throw new SVGParseException("Invalid <use> element. height cannot be negative");
                }
                case href: {
                    if (!"".equals(attributes.getURI(i)) && !XLINK_NAMESPACE.equals(attributes.getURI(i))) continue block8;
                    obj.href = val;
                    continue block8;
                }
                case preserveAspectRatio: {
                    SVGParser.parsePreserveAspectRatio(obj, val);
                    continue block8;
                }
            }
        }
    }

    private void path(Attributes attributes) throws SVGParseException {
        this.debug("<path>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.Path obj = new SVG.Path();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesTransform(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesPath(obj, attributes);
        this.currentElement.addChild(obj);
    }

    private void parseAttributesPath(SVG.Path obj, Attributes attributes) throws SVGParseException {
        block4: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case d: {
                    obj.d = SVGParser.parsePath(val);
                    continue block4;
                }
                case pathLength: {
                    obj.pathLength = Float.valueOf(SVGParser.parseFloat(val));
                    if (!(obj.pathLength.floatValue() < 0.0f)) continue block4;
                    throw new SVGParseException("Invalid <path> element. pathLength cannot be negative");
                }
            }
        }
    }

    private void rect(Attributes attributes) throws SVGParseException {
        this.debug("<rect>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.Rect obj = new SVG.Rect();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesTransform(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesRect(obj, attributes);
        this.currentElement.addChild(obj);
    }

    private void parseAttributesRect(SVG.Rect obj, Attributes attributes) throws SVGParseException {
        block8: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case x: {
                    obj.x = SVGParser.parseLength(val);
                    continue block8;
                }
                case y: {
                    obj.y = SVGParser.parseLength(val);
                    continue block8;
                }
                case width: {
                    obj.width = SVGParser.parseLength(val);
                    if (!obj.width.isNegative()) continue block8;
                    throw new SVGParseException("Invalid <rect> element. width cannot be negative");
                }
                case height: {
                    obj.height = SVGParser.parseLength(val);
                    if (!obj.height.isNegative()) continue block8;
                    throw new SVGParseException("Invalid <rect> element. height cannot be negative");
                }
                case rx: {
                    obj.rx = SVGParser.parseLength(val);
                    if (!obj.rx.isNegative()) continue block8;
                    throw new SVGParseException("Invalid <rect> element. rx cannot be negative");
                }
                case ry: {
                    obj.ry = SVGParser.parseLength(val);
                    if (!obj.ry.isNegative()) continue block8;
                    throw new SVGParseException("Invalid <rect> element. ry cannot be negative");
                }
            }
        }
    }

    private void circle(Attributes attributes) throws SVGParseException {
        this.debug("<circle>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.Circle obj = new SVG.Circle();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesTransform(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesCircle(obj, attributes);
        this.currentElement.addChild(obj);
    }

    private void parseAttributesCircle(SVG.Circle obj, Attributes attributes) throws SVGParseException {
        block5: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case cx: {
                    obj.cx = SVGParser.parseLength(val);
                    continue block5;
                }
                case cy: {
                    obj.cy = SVGParser.parseLength(val);
                    continue block5;
                }
                case r: {
                    obj.r = SVGParser.parseLength(val);
                    if (!obj.r.isNegative()) continue block5;
                    throw new SVGParseException("Invalid <circle> element. r cannot be negative");
                }
            }
        }
    }

    private void ellipse(Attributes attributes) throws SVGParseException {
        this.debug("<ellipse>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.Ellipse obj = new SVG.Ellipse();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesTransform(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesEllipse(obj, attributes);
        this.currentElement.addChild(obj);
    }

    private void parseAttributesEllipse(SVG.Ellipse obj, Attributes attributes) throws SVGParseException {
        block6: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case cx: {
                    obj.cx = SVGParser.parseLength(val);
                    continue block6;
                }
                case cy: {
                    obj.cy = SVGParser.parseLength(val);
                    continue block6;
                }
                case rx: {
                    obj.rx = SVGParser.parseLength(val);
                    if (!obj.rx.isNegative()) continue block6;
                    throw new SVGParseException("Invalid <ellipse> element. rx cannot be negative");
                }
                case ry: {
                    obj.ry = SVGParser.parseLength(val);
                    if (!obj.ry.isNegative()) continue block6;
                    throw new SVGParseException("Invalid <ellipse> element. ry cannot be negative");
                }
            }
        }
    }

    private void line(Attributes attributes) throws SVGParseException {
        this.debug("<line>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.Line obj = new SVG.Line();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesTransform(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesLine(obj, attributes);
        this.currentElement.addChild(obj);
    }

    private void parseAttributesLine(SVG.Line obj, Attributes attributes) throws SVGParseException {
        block6: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case x1: {
                    obj.x1 = SVGParser.parseLength(val);
                    continue block6;
                }
                case y1: {
                    obj.y1 = SVGParser.parseLength(val);
                    continue block6;
                }
                case x2: {
                    obj.x2 = SVGParser.parseLength(val);
                    continue block6;
                }
                case y2: {
                    obj.y2 = SVGParser.parseLength(val);
                    continue block6;
                }
            }
        }
    }

    private void polyline(Attributes attributes) throws SVGParseException {
        this.debug("<polyline>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.PolyLine obj = new SVG.PolyLine();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesTransform(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesPolyLine(obj, attributes, "polyline");
        this.currentElement.addChild(obj);
    }

    private void parseAttributesPolyLine(SVG.PolyLine obj, Attributes attributes, String tag) throws SVGParseException {
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (SVGAttr.fromString(attributes.getLocalName(i)) != SVGAttr.points) continue;
            TextScanner scan = new TextScanner(attributes.getValue(i));
            ArrayList<Float> points = new ArrayList<Float>();
            scan.skipWhitespace();
            while (!scan.empty()) {
                float x = scan.nextFloat();
                if (Float.isNaN(x)) {
                    throw new SVGParseException("Invalid <" + tag + "> points attribute. Non-coordinate content found in list.");
                }
                scan.skipCommaWhitespace();
                float y = scan.nextFloat();
                if (Float.isNaN(y)) {
                    throw new SVGParseException("Invalid <" + tag + "> points attribute. There should be an even number of coordinates.");
                }
                scan.skipCommaWhitespace();
                points.add(Float.valueOf(x));
                points.add(Float.valueOf(y));
            }
            obj.points = new float[points.size()];
            int j = 0;
            Iterator iterator = points.iterator();
            while (iterator.hasNext()) {
                float f = ((Float)iterator.next()).floatValue();
                obj.points[j++] = f;
            }
        }
    }

    private void polygon(Attributes attributes) throws SVGParseException {
        this.debug("<polygon>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.Polygon obj = new SVG.Polygon();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesTransform(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesPolyLine(obj, attributes, "polygon");
        this.currentElement.addChild(obj);
    }

    private void text(Attributes attributes) throws SVGParseException {
        this.debug("<text>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.Text obj = new SVG.Text();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesTransform(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesTextPosition(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void parseAttributesTextPosition(SVG.TextPositionedContainer obj, Attributes attributes) throws SVGParseException {
        block6: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case x: {
                    obj.x = SVGParser.parseLengthList(val);
                    continue block6;
                }
                case y: {
                    obj.y = SVGParser.parseLengthList(val);
                    continue block6;
                }
                case dx: {
                    obj.dx = SVGParser.parseLengthList(val);
                    continue block6;
                }
                case dy: {
                    obj.dy = SVGParser.parseLengthList(val);
                    continue block6;
                }
            }
        }
    }

    private void tspan(Attributes attributes) throws SVGParseException {
        this.debug("<tspan>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        if (!(this.currentElement instanceof SVG.TextContainer)) {
            throw new SVGParseException("Invalid document. <tspan> elements are only valid inside <text> or other <tspan> elements.");
        }
        SVG.TSpan obj = new SVG.TSpan();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesTextPosition(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
        if (obj.parent instanceof SVG.TextRoot) {
            obj.setTextRoot((SVG.TextRoot)((Object)obj.parent));
        } else {
            obj.setTextRoot(((SVG.TextChild)((Object)obj.parent)).getTextRoot());
        }
    }

    private void tref(Attributes attributes) throws SVGParseException {
        this.debug("<tref>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        if (!(this.currentElement instanceof SVG.TextContainer)) {
            throw new SVGParseException("Invalid document. <tref> elements are only valid inside <text> or <tspan> elements.");
        }
        SVG.TRef obj = new SVG.TRef();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesTRef(obj, attributes);
        this.currentElement.addChild(obj);
        if (obj.parent instanceof SVG.TextRoot) {
            obj.setTextRoot((SVG.TextRoot)((Object)obj.parent));
        } else {
            obj.setTextRoot(((SVG.TextChild)((Object)obj.parent)).getTextRoot());
        }
    }

    private void parseAttributesTRef(SVG.TRef obj, Attributes attributes) {
        block3: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case href: {
                    if (!"".equals(attributes.getURI(i)) && !XLINK_NAMESPACE.equals(attributes.getURI(i))) continue block3;
                    obj.href = val;
                    continue block3;
                }
            }
        }
    }

    private void zwitch(Attributes attributes) throws SVGParseException {
        this.debug("<switch>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.Switch obj = new SVG.Switch();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesTransform(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void parseAttributesConditional(SVG.SvgConditional obj, Attributes attributes) throws SVGParseException {
        block7: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case requiredFeatures: {
                    obj.setRequiredFeatures(SVGParser.parseRequiredFeatures(val));
                    continue block7;
                }
                case requiredExtensions: {
                    obj.setRequiredExtensions(val);
                    continue block7;
                }
                case systemLanguage: {
                    obj.setSystemLanguage(SVGParser.parseSystemLanguage(val));
                    continue block7;
                }
                case requiredFormats: {
                    obj.setRequiredFormats(SVGParser.parseRequiredFormats(val));
                    continue block7;
                }
                case requiredFonts: {
                    List<String> fonts = SVGParser.parseFontFamily(val);
                    HashSet<String> fontSet = fonts != null ? new HashSet<String>(fonts) : new HashSet(0);
                    obj.setRequiredFonts(fontSet);
                    continue block7;
                }
            }
        }
    }

    private void symbol(Attributes attributes) throws SVGParseException {
        this.debug("<symbol>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.Symbol obj = new SVG.Symbol();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesViewBox(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void marker(Attributes attributes) throws SVGParseException {
        this.debug("<marker>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.Marker obj = new SVG.Marker();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesViewBox(obj, attributes);
        this.parseAttributesMarker(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void parseAttributesMarker(SVG.Marker obj, Attributes attributes) throws SVGParseException {
        block8: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case refX: {
                    obj.refX = SVGParser.parseLength(val);
                    continue block8;
                }
                case refY: {
                    obj.refY = SVGParser.parseLength(val);
                    continue block8;
                }
                case markerWidth: {
                    obj.markerWidth = SVGParser.parseLength(val);
                    if (!obj.markerWidth.isNegative()) continue block8;
                    throw new SVGParseException("Invalid <marker> element. markerWidth cannot be negative");
                }
                case markerHeight: {
                    obj.markerHeight = SVGParser.parseLength(val);
                    if (!obj.markerHeight.isNegative()) continue block8;
                    throw new SVGParseException("Invalid <marker> element. markerHeight cannot be negative");
                }
                case markerUnits: {
                    if ("strokeWidth".equals(val)) {
                        obj.markerUnitsAreUser = false;
                        continue block8;
                    }
                    if ("userSpaceOnUse".equals(val)) {
                        obj.markerUnitsAreUser = true;
                        continue block8;
                    }
                    throw new SVGParseException("Invalid value for attribute markerUnits");
                }
                case orient: {
                    if ("auto".equals(val)) {
                        obj.orient = Float.valueOf(Float.NaN);
                        continue block8;
                    }
                    obj.orient = Float.valueOf(SVGParser.parseFloat(val));
                    continue block8;
                }
            }
        }
    }

    private void linearGradient(Attributes attributes) throws SVGParseException {
        this.debug("<linearGradient>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.SvgLinearGradient obj = new SVG.SvgLinearGradient();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesGradient(obj, attributes);
        this.parseAttributesLinearGradient(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void parseAttributesGradient(SVG.GradientElement obj, Attributes attributes) throws SVGParseException {
        block8: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case gradientUnits: {
                    if ("objectBoundingBox".equals(val)) {
                        obj.gradientUnitsAreUser = false;
                        continue block8;
                    }
                    if ("userSpaceOnUse".equals(val)) {
                        obj.gradientUnitsAreUser = true;
                        continue block8;
                    }
                    throw new SVGParseException("Invalid value for attribute gradientUnits");
                }
                case gradientTransform: {
                    obj.gradientTransform = this.parseTransformList(val);
                    continue block8;
                }
                case spreadMethod: {
                    try {
                        obj.spreadMethod = SVG.GradientSpread.valueOf(val);
                        continue block8;
                    }
                    catch (IllegalArgumentException e) {
                        throw new SVGParseException("Invalid spreadMethod attribute. \"" + val + "\" is not a valid value.");
                    }
                }
                case href: {
                    if (!"".equals(attributes.getURI(i)) && !XLINK_NAMESPACE.equals(attributes.getURI(i))) continue block8;
                    obj.href = val;
                    continue block8;
                }
            }
        }
    }

    private void parseAttributesLinearGradient(SVG.SvgLinearGradient obj, Attributes attributes) throws SVGParseException {
        block6: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case x1: {
                    obj.x1 = SVGParser.parseLength(val);
                    continue block6;
                }
                case y1: {
                    obj.y1 = SVGParser.parseLength(val);
                    continue block6;
                }
                case x2: {
                    obj.x2 = SVGParser.parseLength(val);
                    continue block6;
                }
                case y2: {
                    obj.y2 = SVGParser.parseLength(val);
                    continue block6;
                }
            }
        }
    }

    private void radialGradient(Attributes attributes) throws SVGParseException {
        this.debug("<radialGradient>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.SvgRadialGradient obj = new SVG.SvgRadialGradient();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesGradient(obj, attributes);
        this.parseAttributesRadialGradient(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void parseAttributesRadialGradient(SVG.SvgRadialGradient obj, Attributes attributes) throws SVGParseException {
        block7: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case cx: {
                    obj.cx = SVGParser.parseLength(val);
                    continue block7;
                }
                case cy: {
                    obj.cy = SVGParser.parseLength(val);
                    continue block7;
                }
                case r: {
                    obj.r = SVGParser.parseLength(val);
                    if (!obj.r.isNegative()) continue block7;
                    throw new SVGParseException("Invalid <radialGradient> element. r cannot be negative");
                }
                case fx: {
                    obj.fx = SVGParser.parseLength(val);
                    continue block7;
                }
                case fy: {
                    obj.fy = SVGParser.parseLength(val);
                    continue block7;
                }
            }
        }
    }

    private void stop(Attributes attributes) throws SVGParseException {
        this.debug("<stop>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        if (!(this.currentElement instanceof SVG.GradientElement)) {
            throw new SVGParseException("Invalid document. <stop> elements are only valid inside <linearGradient> or <radialGradient> elements.");
        }
        SVG.Stop obj = new SVG.Stop();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesStop(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void parseAttributesStop(SVG.Stop obj, Attributes attributes) throws SVGParseException {
        block3: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case offset: {
                    obj.offset = this.parseGradientOffset(val);
                    continue block3;
                }
            }
        }
    }

    private Float parseGradientOffset(String val) throws SVGParseException {
        if (val.length() == 0) {
            throw new SVGParseException("Invalid offset value in <stop> (empty string)");
        }
        int end = val.length();
        boolean isPercent = false;
        if (val.charAt(val.length() - 1) == '%') {
            --end;
            isPercent = true;
        }
        try {
            float scalar = SVGParser.parseFloat(val, 0, end);
            if (isPercent) {
                scalar /= 100.0f;
            }
            return Float.valueOf(scalar < 0.0f ? 0.0f : (scalar > 100.0f ? 100.0f : scalar));
        }
        catch (NumberFormatException e) {
            throw new SVGParseException("Invalid offset value in <stop>: " + val, e);
        }
    }

    private void solidColor(Attributes attributes) throws SVGParseException {
        this.debug("<solidColor>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.SolidColor obj = new SVG.SolidColor();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void clipPath(Attributes attributes) throws SVGParseException {
        this.debug("<clipPath>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.ClipPath obj = new SVG.ClipPath();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesTransform(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesClipPath(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void parseAttributesClipPath(SVG.ClipPath obj, Attributes attributes) throws SVGParseException {
        block3: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case clipPathUnits: {
                    if ("objectBoundingBox".equals(val)) {
                        obj.clipPathUnitsAreUser = false;
                        continue block3;
                    }
                    if ("userSpaceOnUse".equals(val)) {
                        obj.clipPathUnitsAreUser = true;
                        continue block3;
                    }
                    throw new SVGParseException("Invalid value for attribute clipPathUnits");
                }
            }
        }
    }

    private void textPath(Attributes attributes) throws SVGParseException {
        this.debug("<textPath>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.TextPath obj = new SVG.TextPath();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesTextPath(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
        if (obj.parent instanceof SVG.TextRoot) {
            obj.setTextRoot((SVG.TextRoot)((Object)obj.parent));
        } else {
            obj.setTextRoot(((SVG.TextChild)((Object)obj.parent)).getTextRoot());
        }
    }

    private void parseAttributesTextPath(SVG.TextPath obj, Attributes attributes) throws SVGParseException {
        block4: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case href: {
                    if (!"".equals(attributes.getURI(i)) && !XLINK_NAMESPACE.equals(attributes.getURI(i))) continue block4;
                    obj.href = val;
                    continue block4;
                }
                case startOffset: {
                    obj.startOffset = SVGParser.parseLength(val);
                    continue block4;
                }
            }
        }
    }

    private void pattern(Attributes attributes) throws SVGParseException {
        this.debug("<pattern>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.Pattern obj = new SVG.Pattern();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesViewBox(obj, attributes);
        this.parseAttributesPattern(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void parseAttributesPattern(SVG.Pattern obj, Attributes attributes) throws SVGParseException {
        block10: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case patternUnits: {
                    if ("objectBoundingBox".equals(val)) {
                        obj.patternUnitsAreUser = false;
                        continue block10;
                    }
                    if ("userSpaceOnUse".equals(val)) {
                        obj.patternUnitsAreUser = true;
                        continue block10;
                    }
                    throw new SVGParseException("Invalid value for attribute patternUnits");
                }
                case patternContentUnits: {
                    if ("objectBoundingBox".equals(val)) {
                        obj.patternContentUnitsAreUser = false;
                        continue block10;
                    }
                    if ("userSpaceOnUse".equals(val)) {
                        obj.patternContentUnitsAreUser = true;
                        continue block10;
                    }
                    throw new SVGParseException("Invalid value for attribute patternContentUnits");
                }
                case patternTransform: {
                    obj.patternTransform = this.parseTransformList(val);
                    continue block10;
                }
                case x: {
                    obj.x = SVGParser.parseLength(val);
                    continue block10;
                }
                case y: {
                    obj.y = SVGParser.parseLength(val);
                    continue block10;
                }
                case width: {
                    obj.width = SVGParser.parseLength(val);
                    if (!obj.width.isNegative()) continue block10;
                    throw new SVGParseException("Invalid <pattern> element. width cannot be negative");
                }
                case height: {
                    obj.height = SVGParser.parseLength(val);
                    if (!obj.height.isNegative()) continue block10;
                    throw new SVGParseException("Invalid <pattern> element. height cannot be negative");
                }
                case href: {
                    if (!"".equals(attributes.getURI(i)) && !XLINK_NAMESPACE.equals(attributes.getURI(i))) continue block10;
                    obj.href = val;
                    continue block10;
                }
            }
        }
    }

    private void view(Attributes attributes) throws SVGParseException {
        this.debug("<view>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.View obj = new SVG.View();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesViewBox(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void mask(Attributes attributes) throws SVGParseException {
        this.debug("<mask>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        SVG.Mask obj = new SVG.Mask();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesMask(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void parseAttributesMask(SVG.Mask obj, Attributes attributes) throws SVGParseException {
        block8: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case maskUnits: {
                    if ("objectBoundingBox".equals(val)) {
                        obj.maskUnitsAreUser = false;
                        continue block8;
                    }
                    if ("userSpaceOnUse".equals(val)) {
                        obj.maskUnitsAreUser = true;
                        continue block8;
                    }
                    throw new SVGParseException("Invalid value for attribute maskUnits");
                }
                case maskContentUnits: {
                    if ("objectBoundingBox".equals(val)) {
                        obj.maskContentUnitsAreUser = false;
                        continue block8;
                    }
                    if ("userSpaceOnUse".equals(val)) {
                        obj.maskContentUnitsAreUser = true;
                        continue block8;
                    }
                    throw new SVGParseException("Invalid value for attribute maskContentUnits");
                }
                case x: {
                    obj.x = SVGParser.parseLength(val);
                    continue block8;
                }
                case y: {
                    obj.y = SVGParser.parseLength(val);
                    continue block8;
                }
                case width: {
                    obj.width = SVGParser.parseLength(val);
                    if (!obj.width.isNegative()) continue block8;
                    throw new SVGParseException("Invalid <mask> element. width cannot be negative");
                }
                case height: {
                    obj.height = SVGParser.parseLength(val);
                    if (!obj.height.isNegative()) continue block8;
                    throw new SVGParseException("Invalid <mask> element. height cannot be negative");
                }
            }
        }
    }

    private void parseAttributesCore(SVG.SvgElementBase obj, Attributes attributes) throws SVGParseException {
        for (int i = 0; i < attributes.getLength(); ++i) {
            String qname = attributes.getQName(i);
            if (qname.equals("id") || qname.equals("xml:id")) {
                obj.id = attributes.getValue(i).trim();
                break;
            }
            if (!qname.equals("xml:space")) continue;
            String val = attributes.getValue(i).trim();
            if ("default".equals(val)) {
                obj.spacePreserve = Boolean.FALSE;
                break;
            }
            if ("preserve".equals(val)) {
                obj.spacePreserve = Boolean.TRUE;
                break;
            }
            throw new SVGParseException("Invalid value for \"xml:space\" attribute: " + val);
        }
    }

    private void parseAttributesStyle(SVG.SvgElementBase obj, Attributes attributes) throws SVGParseException {
        block4: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            if (val.length() == 0) continue;
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case style: {
                    SVGParser.parseStyle(obj, val);
                    continue block4;
                }
                case CLASS: {
                    obj.classNames = CSSParser.parseClassAttribute(val);
                    continue block4;
                }
                default: {
                    if (obj.baseStyle == null) {
                        obj.baseStyle = new SVG.Style();
                    }
                    SVGParser.processStyleProperty(obj.baseStyle, attributes.getLocalName(i), attributes.getValue(i).trim());
                }
            }
        }
    }

    private static void parseStyle(SVG.SvgElementBase obj, String style) {
        TextScanner scan = new TextScanner(style.replaceAll("/\\*.*?\\*/", ""));
        while (true) {
            String propertyName = scan.nextToken(':');
            scan.skipWhitespace();
            if (!scan.consume(':')) break;
            scan.skipWhitespace();
            String propertyValue = scan.nextTokenWithWhitespace(';');
            if (propertyValue == null) break;
            scan.skipWhitespace();
            if (!scan.empty() && !scan.consume(';')) continue;
            if (obj.style == null) {
                obj.style = new SVG.Style();
            }
            SVGParser.processStyleProperty(obj.style, propertyName, propertyValue);
            scan.skipWhitespace();
        }
    }

    static void processStyleProperty(SVG.Style style, String localName, String val) {
        if (val.length() == 0) {
            return;
        }
        if (val.equals("inherit")) {
            return;
        }
        switch (SVGAttr.fromString(localName)) {
            case fill: {
                style.fill = SVGParser.parsePaintSpecifier(val);
                if (style.fill == null) break;
                style.specifiedFlags |= 1L;
                break;
            }
            case fill_rule: {
                style.fillRule = SVGParser.parseFillRule(val);
                if (style.fillRule == null) break;
                style.specifiedFlags |= 2L;
                break;
            }
            case fill_opacity: {
                style.fillOpacity = SVGParser.parseOpacity(val);
                if (style.fillOpacity == null) break;
                style.specifiedFlags |= 4L;
                break;
            }
            case stroke: {
                style.stroke = SVGParser.parsePaintSpecifier(val);
                if (style.stroke == null) break;
                style.specifiedFlags |= 8L;
                break;
            }
            case stroke_opacity: {
                style.strokeOpacity = SVGParser.parseOpacity(val);
                if (style.strokeOpacity == null) break;
                style.specifiedFlags |= 0x10L;
                break;
            }
            case stroke_width: {
                try {
                    style.strokeWidth = SVGParser.parseLength(val);
                    style.specifiedFlags |= 0x20L;
                }
                catch (SVGParseException sVGParseException) {}
                break;
            }
            case stroke_linecap: {
                style.strokeLineCap = SVGParser.parseStrokeLineCap(val);
                if (style.strokeLineCap == null) break;
                style.specifiedFlags |= 0x40L;
                break;
            }
            case stroke_linejoin: {
                style.strokeLineJoin = SVGParser.parseStrokeLineJoin(val);
                if (style.strokeLineJoin == null) break;
                style.specifiedFlags |= 0x80L;
                break;
            }
            case stroke_miterlimit: {
                try {
                    style.strokeMiterLimit = Float.valueOf(SVGParser.parseFloat(val));
                    style.specifiedFlags |= 0x100L;
                }
                catch (SVGParseException sVGParseException) {}
                break;
            }
            case stroke_dasharray: {
                if (NONE.equals(val)) {
                    style.strokeDashArray = null;
                    style.specifiedFlags |= 0x200L;
                    break;
                }
                style.strokeDashArray = SVGParser.parseStrokeDashArray(val);
                if (style.strokeDashArray == null) break;
                style.specifiedFlags |= 0x200L;
                break;
            }
            case stroke_dashoffset: {
                try {
                    style.strokeDashOffset = SVGParser.parseLength(val);
                    style.specifiedFlags |= 0x400L;
                }
                catch (SVGParseException sVGParseException) {}
                break;
            }
            case opacity: {
                style.opacity = SVGParser.parseOpacity(val);
                style.specifiedFlags |= 0x800L;
                break;
            }
            case color: {
                try {
                    style.color = SVGParser.parseColour(val);
                    style.specifiedFlags |= 0x1000L;
                }
                catch (SVGParseException sVGParseException) {}
                break;
            }
            case font: {
                SVGParser.parseFont(style, val);
                break;
            }
            case font_family: {
                style.fontFamily = SVGParser.parseFontFamily(val);
                if (style.fontFamily == null) break;
                style.specifiedFlags |= 0x2000L;
                break;
            }
            case font_size: {
                style.fontSize = SVGParser.parseFontSize(val);
                if (style.fontSize == null) break;
                style.specifiedFlags |= 0x4000L;
                break;
            }
            case font_weight: {
                style.fontWeight = SVGParser.parseFontWeight(val);
                if (style.fontWeight == null) break;
                style.specifiedFlags |= 0x8000L;
                break;
            }
            case font_style: {
                style.fontStyle = SVGParser.parseFontStyle(val);
                if (style.fontStyle == null) break;
                style.specifiedFlags |= 0x10000L;
                break;
            }
            case text_decoration: {
                style.textDecoration = SVGParser.parseTextDecoration(val);
                if (style.textDecoration == null) break;
                style.specifiedFlags |= 0x20000L;
                break;
            }
            case direction: {
                style.direction = SVGParser.parseTextDirection(val);
                if (style.direction == null) break;
                style.specifiedFlags |= 0x1000000000L;
                break;
            }
            case text_anchor: {
                style.textAnchor = SVGParser.parseTextAnchor(val);
                if (style.textAnchor == null) break;
                style.specifiedFlags |= 0x40000L;
                break;
            }
            case overflow: {
                style.overflow = SVGParser.parseOverflow(val);
                if (style.overflow == null) break;
                style.specifiedFlags |= 0x80000L;
                break;
            }
            case marker: {
                style.markerMid = style.markerStart = SVGParser.parseFunctionalIRI(val, localName);
                style.markerEnd = style.markerStart;
                style.specifiedFlags |= 0xE00000L;
                break;
            }
            case marker_start: {
                style.markerStart = SVGParser.parseFunctionalIRI(val, localName);
                style.specifiedFlags |= 0x200000L;
                break;
            }
            case marker_mid: {
                style.markerMid = SVGParser.parseFunctionalIRI(val, localName);
                style.specifiedFlags |= 0x400000L;
                break;
            }
            case marker_end: {
                style.markerEnd = SVGParser.parseFunctionalIRI(val, localName);
                style.specifiedFlags |= 0x800000L;
                break;
            }
            case display: {
                if (val.indexOf(124) >= 0 || !VALID_DISPLAY_VALUES.contains('|' + val + '|')) break;
                style.display = !val.equals(NONE);
                style.specifiedFlags |= 0x1000000L;
                break;
            }
            case visibility: {
                if (val.indexOf(124) >= 0 || !VALID_VISIBILITY_VALUES.contains('|' + val + '|')) break;
                style.visibility = val.equals("visible");
                style.specifiedFlags |= 0x2000000L;
                break;
            }
            case stop_color: {
                if (val.equals(CURRENTCOLOR)) {
                    style.stopColor = SVG.CurrentColor.getInstance();
                } else {
                    try {
                        style.stopColor = SVGParser.parseColour(val);
                    }
                    catch (SVGParseException e) {
                        Log.w((String)TAG, (String)e.getMessage());
                        break;
                    }
                }
                style.specifiedFlags |= 0x4000000L;
                break;
            }
            case stop_opacity: {
                style.stopOpacity = SVGParser.parseOpacity(val);
                style.specifiedFlags |= 0x8000000L;
                break;
            }
            case clip: {
                style.clip = SVGParser.parseClip(val);
                if (style.clip == null) break;
                style.specifiedFlags |= 0x100000L;
                break;
            }
            case clip_path: {
                style.clipPath = SVGParser.parseFunctionalIRI(val, localName);
                style.specifiedFlags |= 0x10000000L;
                break;
            }
            case clip_rule: {
                style.clipRule = SVGParser.parseFillRule(val);
                style.specifiedFlags |= 0x20000000L;
                break;
            }
            case mask: {
                style.mask = SVGParser.parseFunctionalIRI(val, localName);
                style.specifiedFlags |= 0x40000000L;
                break;
            }
            case solid_color: {
                if (val.equals(CURRENTCOLOR)) {
                    style.solidColor = SVG.CurrentColor.getInstance();
                } else {
                    try {
                        style.solidColor = SVGParser.parseColour(val);
                    }
                    catch (SVGParseException e) {
                        Log.w((String)TAG, (String)e.getMessage());
                        break;
                    }
                }
                style.specifiedFlags |= 0x80000000L;
                break;
            }
            case solid_opacity: {
                style.solidOpacity = SVGParser.parseOpacity(val);
                style.specifiedFlags |= 0x100000000L;
                break;
            }
            case viewport_fill: {
                if (val.equals(CURRENTCOLOR)) {
                    style.viewportFill = SVG.CurrentColor.getInstance();
                } else {
                    try {
                        style.viewportFill = SVGParser.parseColour(val);
                    }
                    catch (SVGParseException e) {
                        Log.w((String)TAG, (String)e.getMessage());
                        break;
                    }
                }
                style.specifiedFlags |= 0x200000000L;
                break;
            }
            case viewport_fill_opacity: {
                style.viewportFillOpacity = SVGParser.parseOpacity(val);
                style.specifiedFlags |= 0x400000000L;
                break;
            }
            case vector_effect: {
                style.vectorEffect = SVGParser.parseVectorEffect(val);
                if (style.vectorEffect == null) break;
                style.specifiedFlags |= 0x800000000L;
                break;
            }
            case image_rendering: {
                style.imageRendering = SVGParser.parseRenderQuality(val);
                if (style.imageRendering == null) break;
                style.specifiedFlags |= 0x2000000000L;
                break;
            }
        }
    }

    private void parseAttributesViewBox(SVG.SvgViewBoxContainer obj, Attributes attributes) throws SVGParseException {
        block4: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case viewBox: {
                    obj.viewBox = SVGParser.parseViewBox(val);
                    continue block4;
                }
                case preserveAspectRatio: {
                    SVGParser.parsePreserveAspectRatio(obj, val);
                    continue block4;
                }
            }
        }
    }

    private void parseAttributesTransform(SVG.HasTransform obj, Attributes attributes) throws SVGParseException {
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (SVGAttr.fromString(attributes.getLocalName(i)) != SVGAttr.transform) continue;
            obj.setTransform(this.parseTransformList(attributes.getValue(i)));
        }
    }

    private Matrix parseTransformList(String val) throws SVGParseException {
        Matrix matrix = new Matrix();
        TextScanner scan = new TextScanner(val);
        scan.skipWhitespace();
        while (!scan.empty()) {
            String cmd = scan.nextFunction();
            if (cmd == null) {
                throw new SVGParseException("Bad transform function encountered in transform list: " + val);
            }
            switch (cmd) {
                case "matrix": {
                    scan.skipWhitespace();
                    float a = scan.nextFloat();
                    scan.skipCommaWhitespace();
                    float b = scan.nextFloat();
                    scan.skipCommaWhitespace();
                    float c = scan.nextFloat();
                    scan.skipCommaWhitespace();
                    float d = scan.nextFloat();
                    scan.skipCommaWhitespace();
                    float e = scan.nextFloat();
                    scan.skipCommaWhitespace();
                    float f = scan.nextFloat();
                    scan.skipWhitespace();
                    if (Float.isNaN(f) || !scan.consume(')')) {
                        throw new SVGParseException("Invalid transform list: " + val);
                    }
                    Matrix m = new Matrix();
                    m.setValues(new float[]{a, c, e, b, d, f, 0.0f, 0.0f, 1.0f});
                    matrix.preConcat(m);
                    break;
                }
                case "translate": {
                    scan.skipWhitespace();
                    float tx = scan.nextFloat();
                    float ty = scan.possibleNextFloat();
                    scan.skipWhitespace();
                    if (Float.isNaN(tx) || !scan.consume(')')) {
                        throw new SVGParseException("Invalid transform list: " + val);
                    }
                    if (Float.isNaN(ty)) {
                        matrix.preTranslate(tx, 0.0f);
                        break;
                    }
                    matrix.preTranslate(tx, ty);
                    break;
                }
                case "scale": {
                    scan.skipWhitespace();
                    float sx = scan.nextFloat();
                    float sy = scan.possibleNextFloat();
                    scan.skipWhitespace();
                    if (Float.isNaN(sx) || !scan.consume(')')) {
                        throw new SVGParseException("Invalid transform list: " + val);
                    }
                    if (Float.isNaN(sy)) {
                        matrix.preScale(sx, sx);
                        break;
                    }
                    matrix.preScale(sx, sy);
                    break;
                }
                case "rotate": {
                    scan.skipWhitespace();
                    float ang = scan.nextFloat();
                    float cx = scan.possibleNextFloat();
                    float cy = scan.possibleNextFloat();
                    scan.skipWhitespace();
                    if (Float.isNaN(ang) || !scan.consume(')')) {
                        throw new SVGParseException("Invalid transform list: " + val);
                    }
                    if (Float.isNaN(cx)) {
                        matrix.preRotate(ang);
                        break;
                    }
                    if (!Float.isNaN(cy)) {
                        matrix.preRotate(ang, cx, cy);
                        break;
                    }
                    throw new SVGParseException("Invalid transform list: " + val);
                }
                case "skewX": {
                    scan.skipWhitespace();
                    float ang = scan.nextFloat();
                    scan.skipWhitespace();
                    if (Float.isNaN(ang) || !scan.consume(')')) {
                        throw new SVGParseException("Invalid transform list: " + val);
                    }
                    matrix.preSkew((float)Math.tan(Math.toRadians(ang)), 0.0f);
                    break;
                }
                case "skewY": {
                    scan.skipWhitespace();
                    float ang = scan.nextFloat();
                    scan.skipWhitespace();
                    if (Float.isNaN(ang) || !scan.consume(')')) {
                        throw new SVGParseException("Invalid transform list: " + val);
                    }
                    matrix.preSkew(0.0f, (float)Math.tan(Math.toRadians(ang)));
                    break;
                }
                default: {
                    throw new SVGParseException("Invalid transform list fn: " + cmd + ")");
                }
            }
            if (scan.empty()) break;
            scan.skipCommaWhitespace();
        }
        return matrix;
    }

    static SVG.Length parseLength(String val) throws SVGParseException {
        if (val.length() == 0) {
            throw new SVGParseException("Invalid length value (empty string)");
        }
        int end = val.length();
        SVG.Unit unit = SVG.Unit.px;
        char lastChar = val.charAt(end - 1);
        if (lastChar == '%') {
            --end;
            unit = SVG.Unit.percent;
        } else if (end > 2 && Character.isLetter(lastChar) && Character.isLetter(val.charAt(end - 2))) {
            String unitStr = val.substring(end -= 2);
            try {
                unit = SVG.Unit.valueOf(unitStr.toLowerCase(Locale.US));
            }
            catch (IllegalArgumentException e) {
                throw new SVGParseException("Invalid length unit specifier: " + val);
            }
        }
        try {
            float scalar = SVGParser.parseFloat(val, 0, end);
            return new SVG.Length(scalar, unit);
        }
        catch (NumberFormatException e) {
            throw new SVGParseException("Invalid length value: " + val, e);
        }
    }

    private static List<SVG.Length> parseLengthList(String val) throws SVGParseException {
        if (val.length() == 0) {
            throw new SVGParseException("Invalid length list (empty string)");
        }
        ArrayList<SVG.Length> coords = new ArrayList<SVG.Length>(1);
        TextScanner scan = new TextScanner(val);
        scan.skipWhitespace();
        while (!scan.empty()) {
            float scalar = scan.nextFloat();
            if (Float.isNaN(scalar)) {
                throw new SVGParseException("Invalid length list value: " + scan.ahead());
            }
            SVG.Unit unit = scan.nextUnit();
            if (unit == null) {
                unit = SVG.Unit.px;
            }
            coords.add(new SVG.Length(scalar, unit));
            scan.skipCommaWhitespace();
        }
        return coords;
    }

    private static float parseFloat(String val) throws SVGParseException {
        int len = val.length();
        if (len == 0) {
            throw new SVGParseException("Invalid float value (empty string)");
        }
        return SVGParser.parseFloat(val, 0, len);
    }

    private static float parseFloat(String val, int offset, int len) throws SVGParseException {
        NumberParser np = new NumberParser();
        float num = np.parseNumber(val, offset, len);
        if (!Float.isNaN(num)) {
            return num;
        }
        throw new SVGParseException("Invalid float value: " + val);
    }

    private static Float parseOpacity(String val) {
        try {
            float o = SVGParser.parseFloat(val);
            return Float.valueOf(o < 0.0f ? 0.0f : (o > 1.0f ? 1.0f : o));
        }
        catch (SVGParseException e) {
            return null;
        }
    }

    private static SVG.Box parseViewBox(String val) throws SVGParseException {
        TextScanner scan = new TextScanner(val);
        scan.skipWhitespace();
        float minX = scan.nextFloat();
        scan.skipCommaWhitespace();
        float minY = scan.nextFloat();
        scan.skipCommaWhitespace();
        float width = scan.nextFloat();
        scan.skipCommaWhitespace();
        float height = scan.nextFloat();
        if (Float.isNaN(minX) || Float.isNaN(minY) || Float.isNaN(width) || Float.isNaN(height)) {
            throw new SVGParseException("Invalid viewBox definition - should have four numbers");
        }
        if (width < 0.0f) {
            throw new SVGParseException("Invalid viewBox. width cannot be negative");
        }
        if (height < 0.0f) {
            throw new SVGParseException("Invalid viewBox. height cannot be negative");
        }
        return new SVG.Box(minX, minY, width, height);
    }

    private static void parsePreserveAspectRatio(SVG.SvgPreserveAspectRatioContainer obj, String val) throws SVGParseException {
        obj.preserveAspectRatio = SVGParser.parsePreserveAspectRatio(val);
    }

    static PreserveAspectRatio parsePreserveAspectRatio(String val) throws SVGParseException {
        TextScanner scan = new TextScanner(val);
        scan.skipWhitespace();
        String word = scan.nextToken();
        if ("defer".equals(word)) {
            scan.skipWhitespace();
            word = scan.nextToken();
        }
        PreserveAspectRatio.Alignment align = AspectRatioKeywords.get(word);
        PreserveAspectRatio.Scale scale = null;
        scan.skipWhitespace();
        if (!scan.empty()) {
            String meetOrSlice;
            switch (meetOrSlice = scan.nextToken()) {
                case "meet": {
                    scale = PreserveAspectRatio.Scale.meet;
                    break;
                }
                case "slice": {
                    scale = PreserveAspectRatio.Scale.slice;
                    break;
                }
                default: {
                    throw new SVGParseException("Invalid preserveAspectRatio definition: " + val);
                }
            }
        }
        return new PreserveAspectRatio(align, scale);
    }

    private static SVG.SvgPaint parsePaintSpecifier(String val) {
        if (val.startsWith("url(")) {
            int closeBracket = val.indexOf(")");
            if (closeBracket != -1) {
                String href = val.substring(4, closeBracket).trim();
                SVG.SvgPaint fallback = null;
                if ((val = val.substring(closeBracket + 1).trim()).length() > 0) {
                    fallback = SVGParser.parseColourSpecifer(val);
                }
                return new SVG.PaintReference(href, fallback);
            }
            String href = val.substring(4).trim();
            return new SVG.PaintReference(href, null);
        }
        return SVGParser.parseColourSpecifer(val);
    }

    private static SVG.SvgPaint parseColourSpecifer(String val) {
        switch (val) {
            case "none": {
                return SVG.Colour.TRANSPARENT;
            }
            case "currentColor": {
                return SVG.CurrentColor.getInstance();
            }
        }
        try {
            return SVGParser.parseColour(val);
        }
        catch (SVGParseException e) {
            return null;
        }
    }

    private static SVG.Colour parseColour(String val) throws SVGParseException {
        if (val.charAt(0) == '#') {
            IntegerParser ip = IntegerParser.parseHex(val, 1, val.length());
            if (ip == null) {
                throw new SVGParseException("Bad hex colour value: " + val);
            }
            int pos = ip.getEndPos();
            switch (pos) {
                case 4: {
                    int threehex = ip.value();
                    int h1 = threehex & 0xF00;
                    int h2 = threehex & 0xF0;
                    int h3 = threehex & 0xF;
                    return new SVG.Colour(0xFF000000 | h1 << 12 | h1 << 8 | h2 << 8 | h2 << 4 | h3 << 4 | h3);
                }
                case 5: {
                    int fourhex = ip.value();
                    int h1 = fourhex & 0xF000;
                    int h2 = fourhex & 0xF00;
                    int h3 = fourhex & 0xF0;
                    int h4 = fourhex & 0xF;
                    return new SVG.Colour(h4 << 28 | h4 << 24 | h1 << 8 | h1 << 4 | h2 << 4 | h2 | h3 | h3 >> 4);
                }
                case 7: {
                    return new SVG.Colour(0xFF000000 | ip.value());
                }
                case 9: {
                    return new SVG.Colour(ip.value() << 24 | ip.value() >>> 8);
                }
            }
            throw new SVGParseException("Bad hex colour value: " + val);
        }
        String valLowerCase = val.toLowerCase(Locale.US);
        boolean isRGBA = valLowerCase.startsWith("rgba(");
        if (isRGBA || valLowerCase.startsWith("rgb(")) {
            float blue;
            float green;
            TextScanner scan = new TextScanner(val.substring(isRGBA ? 5 : 4));
            scan.skipWhitespace();
            float red = scan.nextFloat();
            if (!Float.isNaN(red) && scan.consume('%')) {
                red = red * 256.0f / 100.0f;
            }
            if (!Float.isNaN(green = scan.checkedNextFloat(red)) && scan.consume('%')) {
                green = green * 256.0f / 100.0f;
            }
            if (!Float.isNaN(blue = scan.checkedNextFloat(green)) && scan.consume('%')) {
                blue = blue * 256.0f / 100.0f;
            }
            if (isRGBA) {
                float alpha = scan.checkedNextFloat(blue);
                scan.skipWhitespace();
                if (Float.isNaN(alpha) || !scan.consume(')')) {
                    throw new SVGParseException("Bad rgba() colour value: " + val);
                }
                return new SVG.Colour(SVGParser.clamp255(alpha * 256.0f) << 24 | SVGParser.clamp255(red) << 16 | SVGParser.clamp255(green) << 8 | SVGParser.clamp255(blue));
            }
            scan.skipWhitespace();
            if (Float.isNaN(blue) || !scan.consume(')')) {
                throw new SVGParseException("Bad rgb() colour value: " + val);
            }
            return new SVG.Colour(0xFF000000 | SVGParser.clamp255(red) << 16 | SVGParser.clamp255(green) << 8 | SVGParser.clamp255(blue));
        }
        boolean isHSLA = valLowerCase.startsWith("hsla(");
        if (isHSLA || valLowerCase.startsWith("hsl(")) {
            float lightness;
            TextScanner scan = new TextScanner(val.substring(isHSLA ? 5 : 4));
            scan.skipWhitespace();
            float hue = scan.nextFloat();
            float saturation = scan.checkedNextFloat(hue);
            if (!Float.isNaN(saturation)) {
                scan.consume('%');
            }
            if (!Float.isNaN(lightness = scan.checkedNextFloat(saturation))) {
                scan.consume('%');
            }
            if (isHSLA) {
                float alpha = scan.checkedNextFloat(lightness);
                scan.skipWhitespace();
                if (Float.isNaN(alpha) || !scan.consume(')')) {
                    throw new SVGParseException("Bad hsla() colour value: " + val);
                }
                return new SVG.Colour(SVGParser.clamp255(alpha * 256.0f) << 24 | SVGParser.hslToRgb(hue, saturation, lightness));
            }
            scan.skipWhitespace();
            if (Float.isNaN(lightness) || !scan.consume(')')) {
                throw new SVGParseException("Bad hsl() colour value: " + val);
            }
            return new SVG.Colour(0xFF000000 | SVGParser.hslToRgb(hue, saturation, lightness));
        }
        return SVGParser.parseColourKeyword(valLowerCase);
    }

    private static int clamp255(float val) {
        return val < 0.0f ? 0 : (val > 255.0f ? 255 : Math.round(val));
    }

    private static int hslToRgb(float hue, float sat, float light) {
        hue = hue >= 0.0f ? hue % 360.0f : hue % 360.0f + 360.0f;
        hue /= 60.0f;
        sat /= 100.0f;
        float f = sat < 0.0f ? 0.0f : (sat = sat > 1.0f ? 1.0f : sat);
        light = light < 0.0f ? 0.0f : (light > 1.0f ? 1.0f : (light /= 100.0f));
        float t2 = light <= 0.5f ? light * (sat + 1.0f) : light + sat - light * sat;
        float t1 = light * 2.0f - t2;
        float r = SVGParser.hueToRgb(t1, t2, hue + 2.0f);
        float g = SVGParser.hueToRgb(t1, t2, hue);
        float b = SVGParser.hueToRgb(t1, t2, hue - 2.0f);
        return SVGParser.clamp255(r * 256.0f) << 16 | SVGParser.clamp255(g * 256.0f) << 8 | SVGParser.clamp255(b * 256.0f);
    }

    private static float hueToRgb(float t1, float t2, float hue) {
        if (hue < 0.0f) {
            hue += 6.0f;
        }
        if (hue >= 6.0f) {
            hue -= 6.0f;
        }
        if (hue < 1.0f) {
            return (t2 - t1) * hue + t1;
        }
        if (hue < 3.0f) {
            return t2;
        }
        if (hue < 4.0f) {
            return (t2 - t1) * (4.0f - hue) + t1;
        }
        return t1;
    }

    private static SVG.Colour parseColourKeyword(String nameLowerCase) throws SVGParseException {
        Integer col = ColourKeywords.get(nameLowerCase);
        if (col == null) {
            throw new SVGParseException("Invalid colour keyword: " + nameLowerCase);
        }
        return new SVG.Colour(col);
    }

    private static void parseFont(SVG.Style style, String val) {
        String item;
        Integer fontWeight = null;
        SVG.Style.FontStyle fontStyle = null;
        String fontVariant = null;
        if (!"|caption|icon|menu|message-box|small-caption|status-bar|".contains('|' + val + '|')) {
            return;
        }
        TextScanner scan = new TextScanner(val);
        while (true) {
            item = scan.nextToken('/');
            scan.skipWhitespace();
            if (item == null) {
                return;
            }
            if (fontWeight != null && fontStyle != null) break;
            if (item.equals("normal") || fontWeight == null && (fontWeight = FontWeightKeywords.get(item)) != null || fontStyle == null && (fontStyle = SVGParser.parseFontStyle(item)) != null) continue;
            if (fontVariant != null || !item.equals("small-caps")) break;
            fontVariant = item;
        }
        SVG.Length fontSize = SVGParser.parseFontSize(item);
        if (scan.consume('/')) {
            scan.skipWhitespace();
            item = scan.nextToken();
            if (item != null) {
                try {
                    SVGParser.parseLength(item);
                }
                catch (SVGParseException e) {
                    return;
                }
            }
            scan.skipWhitespace();
        }
        style.fontFamily = SVGParser.parseFontFamily(scan.restOfText());
        style.fontSize = fontSize;
        style.fontWeight = fontWeight == null ? 400 : fontWeight;
        style.fontStyle = fontStyle == null ? SVG.Style.FontStyle.Normal : fontStyle;
        style.specifiedFlags |= 0x1E000L;
    }

    private static List<String> parseFontFamily(String val) {
        ArrayList<String> fonts = null;
        TextScanner scan = new TextScanner(val);
        do {
            String item;
            if ((item = scan.nextQuotedString()) == null) {
                item = scan.nextTokenWithWhitespace(',');
            }
            if (item == null) break;
            if (fonts == null) {
                fonts = new ArrayList<String>();
            }
            fonts.add(item);
            scan.skipCommaWhitespace();
        } while (!scan.empty());
        return fonts;
    }

    private static SVG.Length parseFontSize(String val) {
        try {
            SVG.Length size = FontSizeKeywords.get(val);
            if (size == null) {
                size = SVGParser.parseLength(val);
            }
            return size;
        }
        catch (SVGParseException e) {
            return null;
        }
    }

    private static Integer parseFontWeight(String val) {
        return FontWeightKeywords.get(val);
    }

    private static SVG.Style.FontStyle parseFontStyle(String val) {
        switch (val) {
            case "italic": {
                return SVG.Style.FontStyle.Italic;
            }
            case "normal": {
                return SVG.Style.FontStyle.Normal;
            }
            case "oblique": {
                return SVG.Style.FontStyle.Oblique;
            }
        }
        return null;
    }

    private static SVG.Style.TextDecoration parseTextDecoration(String val) {
        switch (val) {
            case "none": {
                return SVG.Style.TextDecoration.None;
            }
            case "underline": {
                return SVG.Style.TextDecoration.Underline;
            }
            case "overline": {
                return SVG.Style.TextDecoration.Overline;
            }
            case "line-through": {
                return SVG.Style.TextDecoration.LineThrough;
            }
            case "blink": {
                return SVG.Style.TextDecoration.Blink;
            }
        }
        return null;
    }

    private static SVG.Style.TextDirection parseTextDirection(String val) {
        switch (val) {
            case "ltr": {
                return SVG.Style.TextDirection.LTR;
            }
            case "rtl": {
                return SVG.Style.TextDirection.RTL;
            }
        }
        return null;
    }

    private static SVG.Style.FillRule parseFillRule(String val) {
        if ("nonzero".equals(val)) {
            return SVG.Style.FillRule.NonZero;
        }
        if ("evenodd".equals(val)) {
            return SVG.Style.FillRule.EvenOdd;
        }
        return null;
    }

    private static SVG.Style.LineCap parseStrokeLineCap(String val) {
        if ("butt".equals(val)) {
            return SVG.Style.LineCap.Butt;
        }
        if ("round".equals(val)) {
            return SVG.Style.LineCap.Round;
        }
        if ("square".equals(val)) {
            return SVG.Style.LineCap.Square;
        }
        return null;
    }

    private static SVG.Style.LineJoin parseStrokeLineJoin(String val) {
        if ("miter".equals(val)) {
            return SVG.Style.LineJoin.Miter;
        }
        if ("round".equals(val)) {
            return SVG.Style.LineJoin.Round;
        }
        if ("bevel".equals(val)) {
            return SVG.Style.LineJoin.Bevel;
        }
        return null;
    }

    private static SVG.Length[] parseStrokeDashArray(String val) {
        TextScanner scan = new TextScanner(val);
        scan.skipWhitespace();
        if (scan.empty()) {
            return null;
        }
        SVG.Length dash = scan.nextLength();
        if (dash == null) {
            return null;
        }
        if (dash.isNegative()) {
            return null;
        }
        float sum = dash.floatValue();
        ArrayList<SVG.Length> dashes = new ArrayList<SVG.Length>();
        dashes.add(dash);
        while (!scan.empty()) {
            scan.skipCommaWhitespace();
            dash = scan.nextLength();
            if (dash == null) {
                return null;
            }
            if (dash.isNegative()) {
                return null;
            }
            dashes.add(dash);
            sum += dash.floatValue();
        }
        if (sum == 0.0f) {
            return null;
        }
        return dashes.toArray(new SVG.Length[dashes.size()]);
    }

    private static SVG.Style.TextAnchor parseTextAnchor(String val) {
        switch (val) {
            case "start": {
                return SVG.Style.TextAnchor.Start;
            }
            case "middle": {
                return SVG.Style.TextAnchor.Middle;
            }
            case "end": {
                return SVG.Style.TextAnchor.End;
            }
        }
        return null;
    }

    private static Boolean parseOverflow(String val) {
        switch (val) {
            case "visible": 
            case "auto": {
                return Boolean.TRUE;
            }
            case "hidden": 
            case "scroll": {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    private static SVG.CSSClipRect parseClip(String val) {
        if ("auto".equals(val)) {
            return null;
        }
        if (!val.startsWith("rect(")) {
            return null;
        }
        TextScanner scan = new TextScanner(val.substring(5));
        scan.skipWhitespace();
        SVG.Length top = SVGParser.parseLengthOrAuto(scan);
        scan.skipCommaWhitespace();
        SVG.Length right = SVGParser.parseLengthOrAuto(scan);
        scan.skipCommaWhitespace();
        SVG.Length bottom = SVGParser.parseLengthOrAuto(scan);
        scan.skipCommaWhitespace();
        SVG.Length left = SVGParser.parseLengthOrAuto(scan);
        scan.skipWhitespace();
        if (!scan.consume(')') && !scan.empty()) {
            return null;
        }
        return new SVG.CSSClipRect(top, right, bottom, left);
    }

    private static SVG.Length parseLengthOrAuto(TextScanner scan) {
        if (scan.consume("auto")) {
            return new SVG.Length(0.0f);
        }
        return scan.nextLength();
    }

    private static SVG.Style.VectorEffect parseVectorEffect(String val) {
        switch (val) {
            case "none": {
                return SVG.Style.VectorEffect.None;
            }
            case "non-scaling-stroke": {
                return SVG.Style.VectorEffect.NonScalingStroke;
            }
        }
        return null;
    }

    private static SVG.Style.RenderQuality parseRenderQuality(String val) {
        switch (val) {
            case "auto": {
                return SVG.Style.RenderQuality.auto;
            }
            case "optimizeQuality": {
                return SVG.Style.RenderQuality.optimizeQuality;
            }
            case "optimizeSpeed": {
                return SVG.Style.RenderQuality.optimizeSpeed;
            }
        }
        return null;
    }

    private static SVG.PathDefinition parsePath(String val) {
        TextScanner scan = new TextScanner(val);
        float currentX = 0.0f;
        float currentY = 0.0f;
        float lastMoveX = 0.0f;
        float lastMoveY = 0.0f;
        float lastControlX = 0.0f;
        float lastControlY = 0.0f;
        SVG.PathDefinition path = new SVG.PathDefinition();
        if (scan.empty()) {
            return path;
        }
        int pathCommand = scan.nextChar();
        if (pathCommand != 77 && pathCommand != 109) {
            return path;
        }
        while (true) {
            scan.skipWhitespace();
            switch (pathCommand) {
                case 77: 
                case 109: {
                    float x = scan.nextFloat();
                    float y = scan.checkedNextFloat(x);
                    if (Float.isNaN(y)) {
                        Log.e((String)TAG, (String)("Bad path coords for " + (char)pathCommand + " path segment"));
                        return path;
                    }
                    if (pathCommand == 109 && !path.isEmpty()) {
                        x += currentX;
                        y += currentY;
                    }
                    path.moveTo(x, y);
                    lastMoveX = lastControlX = x;
                    currentX = lastControlX;
                    lastMoveY = lastControlY = y;
                    currentY = lastControlY;
                    pathCommand = pathCommand == 109 ? 108 : 76;
                    break;
                }
                case 76: 
                case 108: {
                    float x = scan.nextFloat();
                    float y = scan.checkedNextFloat(x);
                    if (Float.isNaN(y)) {
                        Log.e((String)TAG, (String)("Bad path coords for " + (char)pathCommand + " path segment"));
                        return path;
                    }
                    if (pathCommand == 108) {
                        x += currentX;
                        y += currentY;
                    }
                    path.lineTo(x, y);
                    currentX = lastControlX = x;
                    currentY = lastControlY = y;
                    break;
                }
                case 67: 
                case 99: {
                    float x1 = scan.nextFloat();
                    float y1 = scan.checkedNextFloat(x1);
                    float x2 = scan.checkedNextFloat(y1);
                    float y2 = scan.checkedNextFloat(x2);
                    float x = scan.checkedNextFloat(y2);
                    float y = scan.checkedNextFloat(x);
                    if (Float.isNaN(y)) {
                        Log.e((String)TAG, (String)("Bad path coords for " + (char)pathCommand + " path segment"));
                        return path;
                    }
                    if (pathCommand == 99) {
                        x += currentX;
                        y += currentY;
                        x1 += currentX;
                        y1 += currentY;
                        x2 += currentX;
                        y2 += currentY;
                    }
                    path.cubicTo(x1, y1, x2, y2, x, y);
                    lastControlX = x2;
                    lastControlY = y2;
                    currentX = x;
                    currentY = y;
                    break;
                }
                case 83: 
                case 115: {
                    float x1 = 2.0f * currentX - lastControlX;
                    float y1 = 2.0f * currentY - lastControlY;
                    float x2 = scan.nextFloat();
                    float y2 = scan.checkedNextFloat(x2);
                    float x = scan.checkedNextFloat(y2);
                    float y = scan.checkedNextFloat(x);
                    if (Float.isNaN(y)) {
                        Log.e((String)TAG, (String)("Bad path coords for " + (char)pathCommand + " path segment"));
                        return path;
                    }
                    if (pathCommand == 115) {
                        x += currentX;
                        y += currentY;
                        x2 += currentX;
                        y2 += currentY;
                    }
                    path.cubicTo(x1, y1, x2, y2, x, y);
                    lastControlX = x2;
                    lastControlY = y2;
                    currentX = x;
                    currentY = y;
                    break;
                }
                case 90: 
                case 122: {
                    path.close();
                    currentX = lastControlX = lastMoveX;
                    currentY = lastControlY = lastMoveY;
                    break;
                }
                case 72: 
                case 104: {
                    float x = scan.nextFloat();
                    if (Float.isNaN(x)) {
                        Log.e((String)TAG, (String)("Bad path coords for " + (char)pathCommand + " path segment"));
                        return path;
                    }
                    if (pathCommand == 104) {
                        x += currentX;
                    }
                    path.lineTo(x, currentY);
                    currentX = lastControlX = x;
                    break;
                }
                case 86: 
                case 118: {
                    float y = scan.nextFloat();
                    if (Float.isNaN(y)) {
                        Log.e((String)TAG, (String)("Bad path coords for " + (char)pathCommand + " path segment"));
                        return path;
                    }
                    if (pathCommand == 118) {
                        y += currentY;
                    }
                    path.lineTo(currentX, y);
                    currentY = lastControlY = y;
                    break;
                }
                case 81: 
                case 113: {
                    float x1 = scan.nextFloat();
                    float y1 = scan.checkedNextFloat(x1);
                    float x = scan.checkedNextFloat(y1);
                    float y = scan.checkedNextFloat(x);
                    if (Float.isNaN(y)) {
                        Log.e((String)TAG, (String)("Bad path coords for " + (char)pathCommand + " path segment"));
                        return path;
                    }
                    if (pathCommand == 113) {
                        x += currentX;
                        y += currentY;
                        x1 += currentX;
                        y1 += currentY;
                    }
                    path.quadTo(x1, y1, x, y);
                    lastControlX = x1;
                    lastControlY = y1;
                    currentX = x;
                    currentY = y;
                    break;
                }
                case 84: 
                case 116: {
                    float x1 = 2.0f * currentX - lastControlX;
                    float y1 = 2.0f * currentY - lastControlY;
                    float x = scan.nextFloat();
                    float y = scan.checkedNextFloat(x);
                    if (Float.isNaN(y)) {
                        Log.e((String)TAG, (String)("Bad path coords for " + (char)pathCommand + " path segment"));
                        return path;
                    }
                    if (pathCommand == 116) {
                        x += currentX;
                        y += currentY;
                    }
                    path.quadTo(x1, y1, x, y);
                    lastControlX = x1;
                    lastControlY = y1;
                    currentX = x;
                    currentY = y;
                    break;
                }
                case 65: 
                case 97: {
                    float rx = scan.nextFloat();
                    float ry = scan.checkedNextFloat(rx);
                    float xAxisRotation = scan.checkedNextFloat(ry);
                    Boolean largeArcFlag = scan.checkedNextFlag(Float.valueOf(xAxisRotation));
                    Boolean sweepFlag = scan.checkedNextFlag(largeArcFlag);
                    float x = scan.checkedNextFloat(sweepFlag);
                    float y = scan.checkedNextFloat(x);
                    if (Float.isNaN(y) || rx < 0.0f || ry < 0.0f) {
                        Log.e((String)TAG, (String)("Bad path coords for " + (char)pathCommand + " path segment"));
                        return path;
                    }
                    if (pathCommand == 97) {
                        x += currentX;
                        y += currentY;
                    }
                    path.arcTo(rx, ry, xAxisRotation, largeArcFlag, sweepFlag, x, y);
                    currentX = lastControlX = x;
                    currentY = lastControlY = y;
                    break;
                }
                default: {
                    return path;
                }
            }
            scan.skipCommaWhitespace();
            if (scan.empty()) break;
            if (!scan.hasLetter()) continue;
            pathCommand = scan.nextChar();
        }
        return path;
    }

    private static Set<String> parseRequiredFeatures(String val) {
        TextScanner scan = new TextScanner(val);
        HashSet<String> result = new HashSet<String>();
        while (!scan.empty()) {
            String feature = scan.nextToken();
            if (feature.startsWith(FEATURE_STRING_PREFIX)) {
                result.add(feature.substring(FEATURE_STRING_PREFIX.length()));
            } else {
                result.add("UNSUPPORTED");
            }
            scan.skipWhitespace();
        }
        return result;
    }

    private static Set<String> parseSystemLanguage(String val) {
        TextScanner scan = new TextScanner(val);
        HashSet<String> result = new HashSet<String>();
        while (!scan.empty()) {
            String language = scan.nextToken();
            int hyphenPos = language.indexOf(45);
            if (hyphenPos != -1) {
                language = language.substring(0, hyphenPos);
            }
            language = new Locale(language, "", "").getLanguage();
            result.add(language);
            scan.skipWhitespace();
        }
        return result;
    }

    private static Set<String> parseRequiredFormats(String val) {
        TextScanner scan = new TextScanner(val);
        HashSet<String> result = new HashSet<String>();
        while (!scan.empty()) {
            String mimetype = scan.nextToken();
            result.add(mimetype);
            scan.skipWhitespace();
        }
        return result;
    }

    private static String parseFunctionalIRI(String val, String attrName) {
        if (val.equals(NONE)) {
            return null;
        }
        if (!val.startsWith("url(")) {
            return null;
        }
        if (val.endsWith(")")) {
            return val.substring(4, val.length() - 1).trim();
        }
        return val.substring(4).trim();
    }

    private void style(Attributes attributes) throws SVGParseException {
        this.debug("<style>", new Object[0]);
        if (this.currentElement == null) {
            throw new SVGParseException("Invalid document. Root element must be <svg>");
        }
        boolean isTextCSS = true;
        String media = XML_STYLESHEET_ATTR_MEDIA_ALL;
        block4: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case type: {
                    isTextCSS = val.equals("text/css");
                    continue block4;
                }
                case media: {
                    media = val;
                    continue block4;
                }
            }
        }
        if (isTextCSS && CSSParser.mediaMatches(media, CSSParser.MediaType.screen)) {
            this.inStyleElement = true;
        } else {
            this.ignoring = true;
            this.ignoreDepth = 1;
        }
    }

    private void parseCSSStyleSheet(String sheet) {
        CSSParser cssp = new CSSParser(CSSParser.MediaType.screen, CSSParser.Source.Document);
        this.svgDocument.addCSSRules(cssp.parse(sheet));
    }

    static class TextScanner {
        String input;
        int position = 0;
        int inputLength = 0;
        private NumberParser numberParser = new NumberParser();

        TextScanner(String input) {
            this.input = input.trim();
            this.inputLength = this.input.length();
        }

        boolean empty() {
            return this.position == this.inputLength;
        }

        boolean isWhitespace(int c) {
            return c == 32 || c == 10 || c == 13 || c == 9;
        }

        void skipWhitespace() {
            while (this.position < this.inputLength && this.isWhitespace(this.input.charAt(this.position))) {
                ++this.position;
            }
        }

        boolean isEOL(int c) {
            return c == 10 || c == 13;
        }

        boolean skipCommaWhitespace() {
            this.skipWhitespace();
            if (this.position == this.inputLength) {
                return false;
            }
            if (this.input.charAt(this.position) != ',') {
                return false;
            }
            ++this.position;
            this.skipWhitespace();
            return true;
        }

        float nextFloat() {
            float val = this.numberParser.parseNumber(this.input, this.position, this.inputLength);
            if (!Float.isNaN(val)) {
                this.position = this.numberParser.getEndPos();
            }
            return val;
        }

        float possibleNextFloat() {
            this.skipCommaWhitespace();
            float val = this.numberParser.parseNumber(this.input, this.position, this.inputLength);
            if (!Float.isNaN(val)) {
                this.position = this.numberParser.getEndPos();
            }
            return val;
        }

        float checkedNextFloat(float lastRead) {
            if (Float.isNaN(lastRead)) {
                return Float.NaN;
            }
            this.skipCommaWhitespace();
            return this.nextFloat();
        }

        float checkedNextFloat(Boolean lastRead) {
            if (lastRead == null) {
                return Float.NaN;
            }
            this.skipCommaWhitespace();
            return this.nextFloat();
        }

        Integer nextChar() {
            if (this.position == this.inputLength) {
                return null;
            }
            return this.input.charAt(this.position++);
        }

        SVG.Length nextLength() {
            float scalar = this.nextFloat();
            if (Float.isNaN(scalar)) {
                return null;
            }
            SVG.Unit unit = this.nextUnit();
            if (unit == null) {
                return new SVG.Length(scalar, SVG.Unit.px);
            }
            return new SVG.Length(scalar, unit);
        }

        Boolean nextFlag() {
            if (this.position == this.inputLength) {
                return null;
            }
            char ch = this.input.charAt(this.position);
            if (ch == '0' || ch == '1') {
                ++this.position;
                return ch == '1';
            }
            return null;
        }

        Boolean checkedNextFlag(Object lastRead) {
            if (lastRead == null) {
                return null;
            }
            this.skipCommaWhitespace();
            return this.nextFlag();
        }

        boolean consume(char ch) {
            boolean found;
            boolean bl = found = this.position < this.inputLength && this.input.charAt(this.position) == ch;
            if (found) {
                ++this.position;
            }
            return found;
        }

        boolean consume(String str) {
            boolean found;
            int len = str.length();
            boolean bl = found = this.position <= this.inputLength - len && this.input.substring(this.position, this.position + len).equals(str);
            if (found) {
                this.position += len;
            }
            return found;
        }

        int advanceChar() {
            if (this.position == this.inputLength) {
                return -1;
            }
            ++this.position;
            if (this.position < this.inputLength) {
                return this.input.charAt(this.position);
            }
            return -1;
        }

        String nextToken() {
            return this.nextToken(' ', false);
        }

        String nextToken(char terminator) {
            return this.nextToken(terminator, false);
        }

        String nextTokenWithWhitespace(char terminator) {
            return this.nextToken(terminator, true);
        }

        String nextToken(char terminator, boolean allowWhitespace) {
            if (this.empty()) {
                return null;
            }
            int ch = this.input.charAt(this.position);
            if (!allowWhitespace && this.isWhitespace(ch) || ch == terminator) {
                return null;
            }
            int start = this.position;
            ch = this.advanceChar();
            while (ch != -1 && ch != terminator && (allowWhitespace || !this.isWhitespace(ch))) {
                ch = this.advanceChar();
            }
            return this.input.substring(start, this.position);
        }

        String nextWord() {
            if (this.empty()) {
                return null;
            }
            int start = this.position;
            int ch = this.input.charAt(this.position);
            if (ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122) {
                ch = this.advanceChar();
                while (ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122) {
                    ch = this.advanceChar();
                }
                return this.input.substring(start, this.position);
            }
            this.position = start;
            return null;
        }

        String nextFunction() {
            if (this.empty()) {
                return null;
            }
            int start = this.position;
            int ch = this.input.charAt(this.position);
            while (ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90) {
                ch = this.advanceChar();
            }
            int end = this.position;
            while (this.isWhitespace(ch)) {
                ch = this.advanceChar();
            }
            if (ch == 40) {
                ++this.position;
                return this.input.substring(start, end);
            }
            this.position = start;
            return null;
        }

        String ahead() {
            int start = this.position;
            while (!this.empty() && !this.isWhitespace(this.input.charAt(this.position))) {
                ++this.position;
            }
            String str = this.input.substring(start, this.position);
            this.position = start;
            return str;
        }

        SVG.Unit nextUnit() {
            if (this.empty()) {
                return null;
            }
            char ch = this.input.charAt(this.position);
            if (ch == '%') {
                ++this.position;
                return SVG.Unit.percent;
            }
            if (this.position > this.inputLength - 2) {
                return null;
            }
            try {
                SVG.Unit result = SVG.Unit.valueOf(this.input.substring(this.position, this.position + 2).toLowerCase(Locale.US));
                this.position += 2;
                return result;
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        boolean hasLetter() {
            if (this.position == this.inputLength) {
                return false;
            }
            char ch = this.input.charAt(this.position);
            return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z';
        }

        String nextQuotedString() {
            int ch;
            if (this.empty()) {
                return null;
            }
            int start = this.position;
            int endQuote = ch = this.input.charAt(this.position);
            if (ch != 39 && ch != 34) {
                return null;
            }
            ch = this.advanceChar();
            while (ch != -1 && ch != endQuote) {
                ch = this.advanceChar();
            }
            if (ch == -1) {
                this.position = start;
                return null;
            }
            ++this.position;
            return this.input.substring(start + 1, this.position - 1);
        }

        String restOfText() {
            if (this.empty()) {
                return null;
            }
            int start = this.position;
            this.position = this.inputLength;
            return this.input.substring(start);
        }
    }

    private class SAXHandler
    extends DefaultHandler2 {
        private SAXHandler() {
        }

        @Override
        public void startDocument() throws SAXException {
            SVGParser.this.startDocument();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            SVGParser.this.startElement(uri, localName, qName, attributes);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            SVGParser.this.text(new String(ch, start, length));
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            SVGParser.this.endElement(uri, localName, qName);
        }

        @Override
        public void endDocument() throws SAXException {
            SVGParser.this.endDocument();
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            TextScanner scan = new TextScanner(data);
            Map attributes = SVGParser.this.parseProcessingInstructionAttributes(scan);
            SVGParser.this.handleProcessingInstruction(target, attributes);
        }
    }

    private class XPPAttributesWrapper
    implements Attributes {
        private XmlPullParser parser;

        public XPPAttributesWrapper(XmlPullParser parser) {
            this.parser = parser;
        }

        @Override
        public int getLength() {
            return this.parser.getAttributeCount();
        }

        @Override
        public String getURI(int index) {
            return this.parser.getAttributeNamespace(index);
        }

        @Override
        public String getLocalName(int index) {
            return this.parser.getAttributeName(index);
        }

        @Override
        public String getQName(int index) {
            String qName = this.parser.getAttributeName(index);
            if (this.parser.getAttributePrefix(index) != null) {
                qName = this.parser.getAttributePrefix(index) + ':' + qName;
            }
            return qName;
        }

        @Override
        public String getValue(int index) {
            return this.parser.getAttributeValue(index);
        }

        @Override
        public String getType(int index) {
            return null;
        }

        @Override
        public int getIndex(String uri, String localName) {
            return -1;
        }

        @Override
        public int getIndex(String qName) {
            return -1;
        }

        @Override
        public String getType(String uri, String localName) {
            return null;
        }

        @Override
        public String getType(String qName) {
            return null;
        }

        @Override
        public String getValue(String uri, String localName) {
            return null;
        }

        @Override
        public String getValue(String qName) {
            return null;
        }
    }

    private static class AspectRatioKeywords {
        private static final Map<String, PreserveAspectRatio.Alignment> aspectRatioKeywords = new HashMap<String, PreserveAspectRatio.Alignment>(10);

        private AspectRatioKeywords() {
        }

        static PreserveAspectRatio.Alignment get(String aspectRatio) {
            return aspectRatioKeywords.get(aspectRatio);
        }

        static {
            aspectRatioKeywords.put(SVGParser.NONE, PreserveAspectRatio.Alignment.none);
            aspectRatioKeywords.put("xMinYMin", PreserveAspectRatio.Alignment.xMinYMin);
            aspectRatioKeywords.put("xMidYMin", PreserveAspectRatio.Alignment.xMidYMin);
            aspectRatioKeywords.put("xMaxYMin", PreserveAspectRatio.Alignment.xMaxYMin);
            aspectRatioKeywords.put("xMinYMid", PreserveAspectRatio.Alignment.xMinYMid);
            aspectRatioKeywords.put("xMidYMid", PreserveAspectRatio.Alignment.xMidYMid);
            aspectRatioKeywords.put("xMaxYMid", PreserveAspectRatio.Alignment.xMaxYMid);
            aspectRatioKeywords.put("xMinYMax", PreserveAspectRatio.Alignment.xMinYMax);
            aspectRatioKeywords.put("xMidYMax", PreserveAspectRatio.Alignment.xMidYMax);
            aspectRatioKeywords.put("xMaxYMax", PreserveAspectRatio.Alignment.xMaxYMax);
        }
    }

    private static class FontWeightKeywords {
        private static final Map<String, Integer> fontWeightKeywords = new HashMap<String, Integer>(13);

        private FontWeightKeywords() {
        }

        static Integer get(String fontWeight) {
            return fontWeightKeywords.get(fontWeight);
        }

        static {
            fontWeightKeywords.put("normal", 400);
            fontWeightKeywords.put("bold", 700);
            fontWeightKeywords.put("bolder", 1);
            fontWeightKeywords.put("lighter", -1);
            fontWeightKeywords.put("100", 100);
            fontWeightKeywords.put("200", 200);
            fontWeightKeywords.put("300", 300);
            fontWeightKeywords.put("400", 400);
            fontWeightKeywords.put("500", 500);
            fontWeightKeywords.put("600", 600);
            fontWeightKeywords.put("700", 700);
            fontWeightKeywords.put("800", 800);
            fontWeightKeywords.put("900", 900);
        }
    }

    private static class FontSizeKeywords {
        private static final Map<String, SVG.Length> fontSizeKeywords = new HashMap<String, SVG.Length>(9);

        private FontSizeKeywords() {
        }

        static SVG.Length get(String fontSize) {
            return fontSizeKeywords.get(fontSize);
        }

        static {
            fontSizeKeywords.put("xx-small", new SVG.Length(0.694f, SVG.Unit.pt));
            fontSizeKeywords.put("x-small", new SVG.Length(0.833f, SVG.Unit.pt));
            fontSizeKeywords.put("small", new SVG.Length(10.0f, SVG.Unit.pt));
            fontSizeKeywords.put("medium", new SVG.Length(12.0f, SVG.Unit.pt));
            fontSizeKeywords.put("large", new SVG.Length(14.4f, SVG.Unit.pt));
            fontSizeKeywords.put("x-large", new SVG.Length(17.3f, SVG.Unit.pt));
            fontSizeKeywords.put("xx-large", new SVG.Length(20.7f, SVG.Unit.pt));
            fontSizeKeywords.put("smaller", new SVG.Length(83.33f, SVG.Unit.percent));
            fontSizeKeywords.put("larger", new SVG.Length(120.0f, SVG.Unit.percent));
        }
    }

    private static class ColourKeywords {
        private static final Map<String, Integer> colourKeywords = new HashMap<String, Integer>(47);

        private ColourKeywords() {
        }

        static Integer get(String colourName) {
            return colourKeywords.get(colourName);
        }

        static {
            colourKeywords.put("aliceblue", -984833);
            colourKeywords.put("antiquewhite", -332841);
            colourKeywords.put("aqua", -16711681);
            colourKeywords.put("aquamarine", -8388652);
            colourKeywords.put("azure", -983041);
            colourKeywords.put("beige", -657956);
            colourKeywords.put("bisque", -6972);
            colourKeywords.put("black", -16777216);
            colourKeywords.put("blanchedalmond", -5171);
            colourKeywords.put("blue", -16776961);
            colourKeywords.put("blueviolet", -7722014);
            colourKeywords.put("brown", -5952982);
            colourKeywords.put("burlywood", -2180985);
            colourKeywords.put("cadetblue", -10510688);
            colourKeywords.put("chartreuse", -8388864);
            colourKeywords.put("chocolate", -2987746);
            colourKeywords.put("coral", -32944);
            colourKeywords.put("cornflowerblue", -10185235);
            colourKeywords.put("cornsilk", -1828);
            colourKeywords.put("crimson", -2354116);
            colourKeywords.put("cyan", -16711681);
            colourKeywords.put("darkblue", -16777077);
            colourKeywords.put("darkcyan", -16741493);
            colourKeywords.put("darkgoldenrod", -4684277);
            colourKeywords.put("darkgray", -5658199);
            colourKeywords.put("darkgreen", -16751616);
            colourKeywords.put("darkgrey", -5658199);
            colourKeywords.put("darkkhaki", -4343957);
            colourKeywords.put("darkmagenta", -7667573);
            colourKeywords.put("darkolivegreen", -11179217);
            colourKeywords.put("darkorange", -29696);
            colourKeywords.put("darkorchid", -6737204);
            colourKeywords.put("darkred", -7667712);
            colourKeywords.put("darksalmon", -1468806);
            colourKeywords.put("darkseagreen", -7357297);
            colourKeywords.put("darkslateblue", -12042869);
            colourKeywords.put("darkslategray", -13676721);
            colourKeywords.put("darkslategrey", -13676721);
            colourKeywords.put("darkturquoise", -16724271);
            colourKeywords.put("darkviolet", -7077677);
            colourKeywords.put("deeppink", -60269);
            colourKeywords.put("deepskyblue", -16728065);
            colourKeywords.put("dimgray", -9868951);
            colourKeywords.put("dimgrey", -9868951);
            colourKeywords.put("dodgerblue", -14774017);
            colourKeywords.put("firebrick", -5103070);
            colourKeywords.put("floralwhite", -1296);
            colourKeywords.put("forestgreen", -14513374);
            colourKeywords.put("fuchsia", -65281);
            colourKeywords.put("gainsboro", -2302756);
            colourKeywords.put("ghostwhite", -460545);
            colourKeywords.put("gold", -10496);
            colourKeywords.put("goldenrod", -2448096);
            colourKeywords.put("gray", -8355712);
            colourKeywords.put("green", -16744448);
            colourKeywords.put("greenyellow", -5374161);
            colourKeywords.put("grey", -8355712);
            colourKeywords.put("honeydew", -983056);
            colourKeywords.put("hotpink", -38476);
            colourKeywords.put("indianred", -3318692);
            colourKeywords.put("indigo", -11861886);
            colourKeywords.put("ivory", -16);
            colourKeywords.put("khaki", -989556);
            colourKeywords.put("lavender", -1644806);
            colourKeywords.put("lavenderblush", -3851);
            colourKeywords.put("lawngreen", -8586240);
            colourKeywords.put("lemonchiffon", -1331);
            colourKeywords.put("lightblue", -5383962);
            colourKeywords.put("lightcoral", -1015680);
            colourKeywords.put("lightcyan", -2031617);
            colourKeywords.put("lightgoldenrodyellow", -329006);
            colourKeywords.put("lightgray", -2894893);
            colourKeywords.put("lightgreen", -7278960);
            colourKeywords.put("lightgrey", -2894893);
            colourKeywords.put("lightpink", -18751);
            colourKeywords.put("lightsalmon", -24454);
            colourKeywords.put("lightseagreen", -14634326);
            colourKeywords.put("lightskyblue", -7876870);
            colourKeywords.put("lightslategray", -8943463);
            colourKeywords.put("lightslategrey", -8943463);
            colourKeywords.put("lightsteelblue", -5192482);
            colourKeywords.put("lightyellow", -32);
            colourKeywords.put("lime", -16711936);
            colourKeywords.put("limegreen", -13447886);
            colourKeywords.put("linen", -331546);
            colourKeywords.put("magenta", -65281);
            colourKeywords.put("maroon", -8388608);
            colourKeywords.put("mediumaquamarine", -10039894);
            colourKeywords.put("mediumblue", -16777011);
            colourKeywords.put("mediumorchid", -4565549);
            colourKeywords.put("mediumpurple", -7114533);
            colourKeywords.put("mediumseagreen", -12799119);
            colourKeywords.put("mediumslateblue", -8689426);
            colourKeywords.put("mediumspringgreen", -16713062);
            colourKeywords.put("mediumturquoise", -12004916);
            colourKeywords.put("mediumvioletred", -3730043);
            colourKeywords.put("midnightblue", -15132304);
            colourKeywords.put("mintcream", -655366);
            colourKeywords.put("mistyrose", -6943);
            colourKeywords.put("moccasin", -6987);
            colourKeywords.put("navajowhite", -8531);
            colourKeywords.put("navy", -16777088);
            colourKeywords.put("oldlace", -133658);
            colourKeywords.put("olive", -8355840);
            colourKeywords.put("olivedrab", -9728477);
            colourKeywords.put("orange", -23296);
            colourKeywords.put("orangered", -47872);
            colourKeywords.put("orchid", -2461482);
            colourKeywords.put("palegoldenrod", -1120086);
            colourKeywords.put("palegreen", -6751336);
            colourKeywords.put("paleturquoise", -5247250);
            colourKeywords.put("palevioletred", -2396013);
            colourKeywords.put("papayawhip", -4139);
            colourKeywords.put("peachpuff", -9543);
            colourKeywords.put("peru", -3308225);
            colourKeywords.put("pink", -16181);
            colourKeywords.put("plum", -2252579);
            colourKeywords.put("powderblue", -5185306);
            colourKeywords.put("purple", -8388480);
            colourKeywords.put("rebeccapurple", -10079335);
            colourKeywords.put("red", -65536);
            colourKeywords.put("rosybrown", -4419697);
            colourKeywords.put("royalblue", -12490271);
            colourKeywords.put("saddlebrown", -7650029);
            colourKeywords.put("salmon", -360334);
            colourKeywords.put("sandybrown", -744352);
            colourKeywords.put("seagreen", -13726889);
            colourKeywords.put("seashell", -2578);
            colourKeywords.put("sienna", -6270419);
            colourKeywords.put("silver", -4144960);
            colourKeywords.put("skyblue", -7876885);
            colourKeywords.put("slateblue", -9807155);
            colourKeywords.put("slategray", -9404272);
            colourKeywords.put("slategrey", -9404272);
            colourKeywords.put("snow", -1286);
            colourKeywords.put("springgreen", -16711809);
            colourKeywords.put("steelblue", -12156236);
            colourKeywords.put("tan", -2968436);
            colourKeywords.put("teal", -16744320);
            colourKeywords.put("thistle", -2572328);
            colourKeywords.put("tomato", -40121);
            colourKeywords.put("turquoise", -12525360);
            colourKeywords.put("violet", -1146130);
            colourKeywords.put("wheat", -663885);
            colourKeywords.put("white", -1);
            colourKeywords.put("whitesmoke", -657931);
            colourKeywords.put("yellow", -256);
            colourKeywords.put("yellowgreen", -6632142);
            colourKeywords.put("transparent", 0);
        }
    }

    private static enum SVGAttr {
        CLASS,
        clip,
        clip_path,
        clipPathUnits,
        clip_rule,
        color,
        cx,
        cy,
        direction,
        dx,
        dy,
        fx,
        fy,
        d,
        display,
        fill,
        fill_rule,
        fill_opacity,
        font,
        font_family,
        font_size,
        font_weight,
        font_style,
        gradientTransform,
        gradientUnits,
        height,
        href,
        image_rendering,
        marker,
        marker_start,
        marker_mid,
        marker_end,
        markerHeight,
        markerUnits,
        markerWidth,
        mask,
        maskContentUnits,
        maskUnits,
        media,
        offset,
        opacity,
        orient,
        overflow,
        pathLength,
        patternContentUnits,
        patternTransform,
        patternUnits,
        points,
        preserveAspectRatio,
        r,
        refX,
        refY,
        requiredFeatures,
        requiredExtensions,
        requiredFormats,
        requiredFonts,
        rx,
        ry,
        solid_color,
        solid_opacity,
        spreadMethod,
        startOffset,
        stop_color,
        stop_opacity,
        stroke,
        stroke_dasharray,
        stroke_dashoffset,
        stroke_linecap,
        stroke_linejoin,
        stroke_miterlimit,
        stroke_opacity,
        stroke_width,
        style,
        systemLanguage,
        text_anchor,
        text_decoration,
        transform,
        type,
        vector_effect,
        version,
        viewBox,
        width,
        x,
        y,
        x1,
        y1,
        x2,
        y2,
        viewport_fill,
        viewport_fill_opacity,
        visibility,
        UNSUPPORTED;

        private static final Map<String, SVGAttr> cache;

        public static SVGAttr fromString(String str) {
            SVGAttr attr2 = cache.get(str);
            if (attr2 != null) {
                return attr2;
            }
            return UNSUPPORTED;
        }

        static {
            cache = new HashMap<String, SVGAttr>();
            for (SVGAttr attr2 : SVGAttr.values()) {
                if (attr2 == CLASS) {
                    cache.put("class", attr2);
                    continue;
                }
                if (attr2 == UNSUPPORTED) continue;
                String key = attr2.name().replace('_', '-');
                cache.put(key, attr2);
            }
        }
    }

    private static enum SVGElem {
        svg,
        a,
        circle,
        clipPath,
        defs,
        desc,
        ellipse,
        g,
        image,
        line,
        linearGradient,
        marker,
        mask,
        path,
        pattern,
        polygon,
        polyline,
        radialGradient,
        rect,
        solidColor,
        stop,
        style,
        SWITCH,
        symbol,
        text,
        textPath,
        title,
        tref,
        tspan,
        use,
        view,
        UNSUPPORTED;

        private static final Map<String, SVGElem> cache;

        public static SVGElem fromString(String str) {
            SVGElem elem = cache.get(str);
            if (elem != null) {
                return elem;
            }
            return UNSUPPORTED;
        }

        static {
            cache = new HashMap<String, SVGElem>();
            for (SVGElem elem : SVGElem.values()) {
                if (elem == SWITCH) {
                    cache.put("switch", elem);
                    continue;
                }
                if (elem == UNSUPPORTED) continue;
                String key = elem.name();
                cache.put(key, elem);
            }
        }
    }
}

