/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.annotations.verification;

import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class NotStuckVerifier {
    private final long startTime;
    @Nonnull
    private static final AtomicReference<ThreadStuckEvaluator> EVALUATOR_REF = new AtomicReference();

    @Nonnull
    public static NotStuckVerifier start() {
        return new NotStuckVerifier(System.currentTimeMillis());
    }

    public NotStuckVerifier(long startTime) {
        this.startTime = startTime;
    }

    public void finished() {
        ThreadStuckEvaluator evaluator = NotStuckVerifier.getEvaluator();
        if (evaluator != null) {
            evaluator.evaluate(System.currentTimeMillis() - this.startTime);
        }
    }

    public static void setEvaluator(@Nullable ThreadStuckEvaluator threadStuckEvaluator) {
        EVALUATOR_REF.set(threadStuckEvaluator);
    }

    @Nullable
    public static ThreadStuckEvaluator getEvaluator() {
        return EVALUATOR_REF.get();
    }

    public static class ExceptionThrowingEvaluator
    implements ThreadStuckEvaluator {
        public final int maxDelay;

        public ExceptionThrowingEvaluator() {
            this(10);
        }

        public ExceptionThrowingEvaluator(int maxDelay) {
            this.maxDelay = maxDelay;
        }

        @Override
        public void evaluate(long millis) {
            if (millis > (long)this.maxDelay) {
                throw new IllegalThreadStateException("Thread stuck in method marked as non blocking for " + millis + " ms");
            }
        }
    }

    public static interface ThreadStuckEvaluator {
        public void evaluate(long var1);
    }
}

