/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.lang;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LazyField<T> {
    @Nonnull
    private final ReadWriteLock lock;
    @Nonnull
    private final InstanceFactory<T> instanceFactory;
    @Nullable
    private T instance;

    public LazyField(@Nonnull InstanceFactory<T> instanceFactory) {
        this(instanceFactory, new ReentrantReadWriteLock());
    }

    public LazyField(@Nonnull InstanceFactory<T> instanceFactory, @Nonnull ReadWriteLock lock) {
        this.instanceFactory = instanceFactory;
        this.lock = lock;
    }

    @Nonnull
    public T getInstance() {
        this.lock.readLock().lock();
        try {
            if (this.instance != null) {
                T t = this.instance;
                return t;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            if (this.instance != null) {
                T t = this.instance;
                return t;
            }
            T t = this.instance = this.instanceFactory.create();
            return t;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Nullable
    public T getInstanceNullable() {
        this.lock.readLock().lock();
        try {
            T t = this.instance;
            return t;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Nonnull
    public ReadWriteLock getLock() {
        return this.lock;
    }

    public static interface InstanceFactory<T> {
        @Nonnull
        public T create();
    }
}

