/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.mail;

import com.cedarsoft.mail.MailConfiguration;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;

public class MailManager {
    @Nonnull
    private static final Category CAT = Logger.getLogger(MailManager.class);
    @Nonnull
    private static final String MAIL_HOST = "mail.host";
    @Nonnull
    private static final String MAIL_SMTP_AUTH = "mail.smtp.auth";
    private Session session;
    private MailConfiguration configuration;

    public MailManager(@Nonnull MailConfiguration mailConfiguration) {
        this.configuration = mailConfiguration;
        this.session = this.getSession();
    }

    @Nonnull
    protected final Session getSession() {
        return Session.getInstance((Properties)this.getProperties(), (Authenticator)this.getAuthenticator());
    }

    @Nonnull
    public Authenticator getAuthenticator() {
        return new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(MailManager.this.configuration.getSmtpUser(), MailManager.this.configuration.getSmtpPass());
            }
        };
    }

    @Nonnull
    public MimeMessage createMessage() {
        MimeMessage message = new MimeMessage(this.session);
        try {
            InternetAddress from = new InternetAddress(this.configuration.getMailFrom());
            from.setPersonal(this.configuration.getMailPersonal());
            message.setFrom((Address)from);
        }
        catch (Exception e) {
            CAT.error((Object)"An error occured while creating message", (Throwable)e);
        }
        return message;
    }

    public static void sendMail(@Nonnull Message message) {
        new Thread(new MailWorker(message)).start();
    }

    @Nonnull
    private Properties getProperties() {
        Properties properties = new Properties();
        properties.setProperty(MAIL_HOST, this.configuration.getMailHost());
        properties.setProperty(MAIL_SMTP_AUTH, this.configuration.getMailSmtpAuth());
        return properties;
    }

    private static class MailWorker
    implements Runnable {
        private Message message;

        protected MailWorker(@Nonnull Message message) {
            this.message = message;
        }

        @Override
        public void run() {
            try {
                Transport.send((Message)this.message);
            }
            catch (Exception e) {
                CAT.error((Object)"Error occured on message sending", (Throwable)e);
            }
        }
    }
}

