/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.osgi.validator;

import com.cedarsoft.osgi.validator.SourceFolderAwareMojo;
import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.DirectoryScanner;

public class ValidatorMojo
extends SourceFolderAwareMojo {
    public static final String MAVEN_PLUGIN_SUFFIX = "-maven-plugin";
    private boolean fail = true;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if ("pom".equals(this.mavenProject.getPackaging())) {
            this.getLog().info((CharSequence)"Skipping for packaging \"pom\"");
            return;
        }
        this.getLog().info((CharSequence)"Validating OSGI-stuff");
        ArrayList problematicFiles = new ArrayList();
        Set<String> allowedPrefixes = this.createAllowedPrefixes();
        this.getLog().info((CharSequence)("Allowed prefixes: " + allowedPrefixes));
        this.getLog().info((CharSequence)"Source Roots:");
        for (String sourceRoot : this.getSourceRoots()) {
            this.getLog().info((CharSequence)("\t" + sourceRoot));
            File sourceRootDir = new File(sourceRoot);
            if (!sourceRootDir.isDirectory()) {
                this.getLog().info((CharSequence)("Skipping <" + sourceRoot + ">: Is not a directory."));
                continue;
            }
            Collections.addAll(problematicFiles, ValidatorMojo.validate(sourceRootDir, allowedPrefixes));
        }
        if (problematicFiles.isEmpty()) {
            this.getLog().info((CharSequence)"No problematic files found");
            return;
        }
        if (this.fail) {
            this.getLog().error((CharSequence)"Found files within a problematic package:");
            for (String problematicFile : problematicFiles) {
                this.getLog().error((CharSequence)("  " + problematicFile));
            }
            throw new MojoExecutionException("There exist " + problematicFiles.size() + " files that seem to be placed within a problematic package");
        }
        this.getLog().warn((CharSequence)"Found files within a problematic package:");
        for (String problematicFile : problematicFiles) {
            this.getLog().warn((CharSequence)("  " + problematicFile));
        }
    }

    private static String[] validate(@Nonnull File sourceRoot, @Nonnull Set<String> allowedPrefixes) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(sourceRoot);
        scanner.setIncludes(new String[]{"**/*.java"});
        HashSet excludes = Sets.newHashSet();
        for (String allowedPrefix : allowedPrefixes) {
            excludes.add(allowedPrefix + "/**");
        }
        scanner.setExcludes(excludes.toArray(new String[excludes.size()]));
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    @Nonnull
    private Set<String> createAllowedPrefixes() {
        String groupId = this.getProject().getGroupId();
        String artifactId = this.getProject().getArtifactId();
        List<String> possibleGroupIds = ValidatorMojo.createPossibleIds(groupId);
        List<String> possibleArtifactIds = ValidatorMojo.createPossibleIds(artifactId);
        HashSet<String> allowedPrefixes = new HashSet<String>();
        for (String possibleGroupId : possibleGroupIds) {
            for (String possibleArtifactId : possibleArtifactIds) {
                allowedPrefixes.add(ValidatorMojo.createPrefix(possibleGroupId, possibleArtifactId));
            }
        }
        for (String current : new ArrayList(allowedPrefixes)) {
            ArrayList idParts = Lists.newArrayList((Iterable)Splitter.on((String)"/").split((CharSequence)current));
            LinkedHashSet partsAsSet = Sets.newLinkedHashSet((Iterable)idParts);
            if (idParts.size() <= partsAsSet.size()) continue;
            allowedPrefixes.add(Joiner.on((String)"/").join((Iterable)partsAsSet));
        }
        return allowedPrefixes;
    }

    static List<String> createPossibleIds(@Nonnull String id) {
        String skipped;
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(id);
        if (id.endsWith(MAVEN_PLUGIN_SUFFIX)) {
            ids.add(id.substring(0, id.indexOf(MAVEN_PLUGIN_SUFFIX)));
        }
        if ((skipped = ValidatorMojo.skip(id, ".commons")) != null) {
            ids.add(skipped);
        }
        if ((skipped = ValidatorMojo.skip(id, "-commons")) != null) {
            ids.add(skipped);
        }
        if ((skipped = ValidatorMojo.skip(id, "commons-")) != null) {
            ids.add(skipped);
        }
        if (id.endsWith("s")) {
            ids.add(id.substring(0, id.length() - 1));
        }
        return ids;
    }

    @Nullable
    private static String skip(@Nonnull String id, @Nonnull String toSkip) {
        if (!id.contains(toSkip)) {
            return null;
        }
        int start = id.indexOf(toSkip);
        String first = id.substring(0, start);
        String second = id.substring(start + toSkip.length());
        return first + second;
    }

    @Nonnull
    public static String createAllowedPrefix(@Nonnull String groupId, @Nonnull String artifactId) {
        String relevantArtifactId = artifactId.endsWith(MAVEN_PLUGIN_SUFFIX) ? artifactId.substring(0, artifactId.indexOf(MAVEN_PLUGIN_SUFFIX)) : artifactId;
        return ValidatorMojo.createPrefix(groupId, relevantArtifactId);
    }

    @Nonnull
    private static String createPrefix(@Nonnull String relevantGroupId, @Nonnull String relevantArtifactId) {
        Splitter splitter = Splitter.on((CharMatcher)new PackageSeparatorCharMatcher());
        ArrayList partsList = Lists.newArrayList((Iterable)splitter.split((CharSequence)relevantGroupId));
        partsList.addAll(Lists.newArrayList((Iterable)splitter.split((CharSequence)relevantArtifactId)));
        return Joiner.on((String)File.separator).join((Iterable)partsList);
    }

    private static class PackageSeparatorCharMatcher
    extends CharMatcher {
        private PackageSeparatorCharMatcher() {
        }

        public boolean matches(char c) {
            return c == '.' || c == '-';
        }
    }
}

