/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.serialization.jdom;

import com.cedarsoft.Version;
import com.cedarsoft.VersionException;
import com.cedarsoft.VersionRange;
import com.cedarsoft.serialization.AbstractXmlSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractJDomSerializer<T>
extends AbstractXmlSerializer<T, Element, Element, IOException> {
    @NotNull
    @NonNls
    protected static final String LINE_SEPARATOR = "\n";

    protected AbstractJDomSerializer(@NotNull @NonNls String defaultElementName, @NonNls @NotNull String nameSpaceUriBase, @NotNull VersionRange formatVersionRange) {
        super(defaultElementName, nameSpaceUriBase, formatVersionRange);
    }

    @NotNull
    public Element serializeToElement(@NotNull T object) throws IOException {
        Element element = new Element(this.getDefaultElementName());
        this.serialize(element, object);
        return element;
    }

    public void serialize(@NotNull T object, @NotNull OutputStream out) throws IOException {
        Document document = new Document();
        Namespace namespace = Namespace.getNamespace((String)this.getNameSpaceUri());
        Element root = new Element(this.getDefaultElementName(), namespace);
        document.setRootElement(root);
        this.serialize(root, object);
        new XMLOutputter(Format.getPrettyFormat().setLineSeparator(LINE_SEPARATOR)).output(document, out);
    }

    @NotNull
    public T deserialize(@NotNull InputStream in) throws IOException, VersionException {
        try {
            Document document = new SAXBuilder().build(in);
            String namespaceURI = document.getRootElement().getNamespaceURI();
            Version formatVersion = AbstractJDomSerializer.parseVersionFromNamespaceUri((String)namespaceURI);
            Version.verifyMatch((Version)this.getFormatVersion(), (Version)formatVersion);
            return (T)this.deserialize(document.getRootElement(), formatVersion);
        }
        catch (JDOMException e) {
            throw new IOException("Could not parse stream due to " + e.getMessage(), e);
        }
    }
}

