/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io;

import com.cedarsoftware.util.io.GroovyJsonReader;
import com.cedarsoftware.util.io.JsonIoException;
import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.JsonTypeWriter;
import com.cedarsoftware.util.io.JsonTypeWriterBase;
import com.cedarsoftware.util.io.JsonTypeWriterEx;
import com.cedarsoftware.util.io.MetaUtils;
import com.cedarsoftware.util.io.Writers;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyJsonWriter
implements Closeable,
Flushable,
GroovyObject {
    private static final String DATE_FORMAT = "DATE_FORMAT";
    private static final String ISO_DATE_FORMAT = "yyyy-MM-dd";
    private static final String ISO_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String TYPE_NAME_MAP = "TYPE_NAME_MAP";
    private static final String SHORT_META_KEYS = "SHORT_META_KEYS";
    private static final String TYPE = "TYPE";
    private static final String PRETTY_PRINT = "PRETTY_PRINT";
    private static final String FIELD_SPECIFIERS = "FIELD_SPECIFIERS";
    private static final String ENUM_PUBLIC_ONLY = "ENUM_PUBLIC_ONLY";
    private static final String WRITE_LONGS_AS_STRINGS = "WLAS";
    private static final Map<Class, JsonTypeWriterBase> writers;
    private static final Set<Class> notCustom;
    private static final Object[] byteStrings;
    private static final String newLine;
    private static final Long ZERO;
    private static final Map<Class, JsonTypeWriterBase> writerCache;
    private static final NullClass nullWriter;
    private final Map<Object, Long> objVisited;
    private final Map<Object, Long> objsReferenced;
    private final Writer out;
    private Map<String, String> typeNameMap;
    private final Map<String, Object> customArgs;
    private boolean shortMetaKeys;
    private long identity;
    private int depth;
    private static final ThreadLocal<Map<String, Object>> _args;
    private static final /* synthetic */ short $const$0;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public GroovyJsonWriter(OutputStream out) {
        this(out, ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    /*
     * WARNING - void declaration
     */
    public GroovyJsonWriter(OutputStream outputStream, Map<String, Object> map) {
        boolean bl;
        Map map2;
        void optionalArgs;
        MetaClass metaClass;
        int n;
        boolean bl2;
        IdentityHashMap<Object, Long> identityHashMap = new IdentityHashMap<Object, Long>();
        this.objVisited = identityHashMap;
        IdentityHashMap<Object, Long> identityHashMap2 = new IdentityHashMap<Object, Long>();
        this.objsReferenced = identityHashMap2;
        Object var5_5 = null;
        this.typeNameMap = (Map)ScriptBytecodeAdapter.castToType(var5_5, Map.class);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        this.customArgs = hashMap;
        this.shortMetaKeys = bl2 = false;
        int n2 = 1;
        this.identity = n2;
        this.depth = n = 0;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        GroovyJsonWriter groovyJsonWriter = this;
        DefaultGroovyMethods.putAt(this.customArgs, (Object)JsonTypeWriterEx.JSON_WRITER, (Object)groovyJsonWriter);
        Map args = (Map)ScriptBytecodeAdapter.castToType(_args.get(), Map.class);
        args.clear();
        args.putAll(optionalArgs);
        this.typeNameMap = map2 = (Map)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((Map)args, (Object)TYPE_NAME_MAP), Map.class);
        this.shortMetaKeys = bl = Boolean.TRUE.equals(DefaultGroovyMethods.getAt((Map)args, (Object)SHORT_META_KEYS));
        if (optionalArgs.containsKey(FIELD_SPECIFIERS)) {
            Map specifiers = (Map)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((Map)args, (Object)FIELD_SPECIFIERS), Map.class);
            LinkedHashMap copy = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
            Map.Entry entry = null;
            Iterator iterator = specifiers.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = (Map.Entry)ScriptBytecodeAdapter.castToType(iterator.next(), Map.Entry.class);
                Class clazz = ShortTypeHandling.castToClass(entry.getKey());
                List fields = (List)ScriptBytecodeAdapter.castToType(entry.getValue(), List.class);
                ArrayList<Field> newList = new ArrayList<Field>(fields.size());
                Map<String, Field> classFields = MetaUtils.getDeepDeclaredFields(clazz);
                String field = null;
                Iterator iterator2 = fields.iterator();
                while (iterator2.hasNext()) {
                    field = ShortTypeHandling.castToString(iterator2.next());
                    Field f = (Field)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(classFields, (Object)field), Field.class);
                    if (f == null) {
                        throw (Throwable)new JsonIoException(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"Unable to locate field: ", (CharSequence)field), (CharSequence)" on class: "), (CharSequence)clazz.getName()), (CharSequence)". Make sure the fields in the FIELD_SPECIFIERS map existing on the associated class."));
                    }
                    newList.add(f);
                }
                ArrayList<Field> arrayList = newList;
                DefaultGroovyMethods.putAt((Map)copy, (Object)clazz, arrayList);
            }
            LinkedHashMap linkedHashMap = copy;
            DefaultGroovyMethods.putAt((Map)args, (Object)FIELD_SPECIFIERS, (Object)linkedHashMap);
        } else {
            Map map3 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            DefaultGroovyMethods.putAt((Map)args, (Object)FIELD_SPECIFIERS, (Object)map3);
        }
        try {
            void out;
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
            this.out = bufferedWriter;
        }
        catch (UnsupportedEncodingException e) {
            throw (Throwable)new JsonIoException("Unsupported encoding.  Get a JVM that supports UTF-8", e);
        }
    }

    static {
        1 var8_7;
        NullClass nullClass;
        String string;
        Set set;
        Map map;
        GroovyJsonWriter.__$swapInit();
        long l = 0L;
        ZERO = l;
        writers = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        notCustom = set = (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class);
        Object[] objectArray = new Object[256];
        byteStrings = objectArray;
        newLine = string = System.getProperty("line.separator");
        ConcurrentHashMap<Class, JsonTypeWriterBase> concurrentHashMap = new ConcurrentHashMap<Class, JsonTypeWriterBase>();
        writerCache = concurrentHashMap;
        nullWriter = nullClass = new NullClass();
        _args = var8_7 = new 1(GroovyJsonWriter.class);
        int i = -128;
        while (i <= 127) {
            char[] chars = Integer.toString(i).toCharArray();
            char[] cArray = chars;
            BytecodeInterface8.objectArraySet((Object[])byteStrings, (int)(i + 128), (Object)cArray);
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
        Writers.JsonStringWriter jsonStringWriter = new Writers.JsonStringWriter();
        DefaultGroovyMethods.putAt(writers, String.class, (Object)jsonStringWriter);
        Writers.DateWriter dateWriter = new Writers.DateWriter();
        DefaultGroovyMethods.putAt(writers, java.util.Date.class, (Object)dateWriter);
        Writers.BigIntegerWriter bigIntegerWriter = new Writers.BigIntegerWriter();
        DefaultGroovyMethods.putAt(writers, BigInteger.class, (Object)bigIntegerWriter);
        Writers.BigDecimalWriter bigDecimalWriter = new Writers.BigDecimalWriter();
        DefaultGroovyMethods.putAt(writers, BigDecimal.class, (Object)bigDecimalWriter);
        Writers.DateWriter dateWriter2 = new Writers.DateWriter();
        DefaultGroovyMethods.putAt(writers, Date.class, (Object)dateWriter2);
        Writers.TimestampWriter timestampWriter = new Writers.TimestampWriter();
        DefaultGroovyMethods.putAt(writers, Timestamp.class, (Object)timestampWriter);
        Writers.CalendarWriter calendarWriter = new Writers.CalendarWriter();
        DefaultGroovyMethods.putAt(writers, Calendar.class, (Object)calendarWriter);
        Writers.TimeZoneWriter timeZoneWriter = new Writers.TimeZoneWriter();
        DefaultGroovyMethods.putAt(writers, TimeZone.class, (Object)timeZoneWriter);
        Writers.LocaleWriter localeWriter = new Writers.LocaleWriter();
        DefaultGroovyMethods.putAt(writers, Locale.class, (Object)localeWriter);
        Writers.ClassWriter classWriter = new Writers.ClassWriter();
        DefaultGroovyMethods.putAt(writers, Class.class, (Object)classWriter);
        Writers.StringBuilderWriter stringBuilderWriter = new Writers.StringBuilderWriter();
        DefaultGroovyMethods.putAt(writers, StringBuilder.class, (Object)stringBuilderWriter);
        Writers.StringBufferWriter stringBufferWriter = new Writers.StringBufferWriter();
        DefaultGroovyMethods.putAt(writers, StringBuffer.class, (Object)stringBufferWriter);
    }

    public static String objectToJson(Object item) {
        return GroovyJsonWriter.objectToJson(item, new HashMap<String, Object>());
    }

    protected static Map getArgs() {
        return (Map)ScriptBytecodeAdapter.castToType(_args.get(), Map.class);
    }

    protected Map getObjectsReferenced() {
        return this.objsReferenced;
    }

    protected Map getObjectsVisited() {
        return this.objVisited;
    }

    protected String getSubstituteTypeNameIfExists(String typeName) {
        if (this.typeNameMap == null) {
            return ShortTypeHandling.castToString(null);
        }
        return ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt(this.typeNameMap, (Object)typeName));
    }

    protected String getSubstituteTypeName(String typeName) {
        if (this.typeNameMap == null) {
            return typeName;
        }
        String shortName = ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt(this.typeNameMap, (Object)typeName));
        return shortName == null ? typeName : shortName;
    }

    public static String objectToJson(Object item, Map<String, Object> optionalArgs) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        GroovyJsonWriter writer = new GroovyJsonWriter(stream, optionalArgs);
        writer.write(item);
        writer.close();
        return new String(stream.toByteArray(), "UTF-8");
    }

    public static String formatJson(String json) {
        Map map = GroovyJsonReader.jsonToMaps(json);
        return GroovyJsonWriter.objectToJson(map, ScriptBytecodeAdapter.createMap((Object[])new Object[]{PRETTY_PRINT, true}));
    }

    public static boolean isPublicEnumsOnly() {
        return GroovyJsonWriter.isTrue(DefaultGroovyMethods.getAt((Map)((Map)ScriptBytecodeAdapter.castToType(_args.get(), Map.class)), (Object)ENUM_PUBLIC_ONLY));
    }

    public static boolean isPrettyPrint() {
        return GroovyJsonWriter.isTrue(DefaultGroovyMethods.getAt((Map)((Map)ScriptBytecodeAdapter.castToType(_args.get(), Map.class)), (Object)PRETTY_PRINT));
    }

    public static boolean getWriteLongsAsStrings() {
        return GroovyJsonWriter.isTrue(DefaultGroovyMethods.getAt((Map)((Map)ScriptBytecodeAdapter.castToType(_args.get(), Map.class)), (Object)WRITE_LONGS_AS_STRINGS));
    }

    private static boolean isTrue(Object setting) {
        if (setting instanceof Boolean) {
            return Boolean.TRUE.equals(setting);
        }
        if (setting instanceof String) {
            return "true".equalsIgnoreCase(ShortTypeHandling.castToString((Object)setting));
        }
        if (setting instanceof Number) {
            return ((Number)ScriptBytecodeAdapter.castToType((Object)setting, Number.class)).intValue() != 0;
        }
        return false;
    }

    protected void tabIn() {
        this.tab(this.out, 1);
    }

    protected void newLine() {
        this.tab(this.out, 0);
    }

    protected void tabOut() {
        this.tab(this.out, -1);
    }

    private void tab(Writer output, int delta) {
        if (!GroovyJsonWriter.isPrettyPrint()) {
            return;
        }
        output.write(newLine);
        this.depth = this.depth + delta;
        int i = 0;
        while (i < this.depth) {
            output.write("  ");
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
    }

    public boolean writeIfMatching(Object o, boolean showType, Writer output) {
        Class<?> c = o.getClass();
        if (notCustom.contains(c)) {
            return false;
        }
        return this.writeCustom(c, o, showType, output);
    }

    public boolean writeArrayElementIfMatching(Class arrayComponentClass, Object o, boolean showType, Writer output) {
        if (!o.getClass().isAssignableFrom(arrayComponentClass) || notCustom.contains(o.getClass())) {
            return false;
        }
        return this.writeCustom(arrayComponentClass, o, showType, output);
    }

    protected boolean writeCustom(Class arrayComponentClass, Object o, boolean showType, Writer output) {
        JsonTypeWriterBase closestWriter = GroovyJsonWriter.getCustomWriter(arrayComponentClass);
        if (closestWriter == null) {
            return false;
        }
        if (this.writeOptionalReference(o)) {
            return true;
        }
        boolean referenced = this.objsReferenced.containsKey(o);
        if (closestWriter instanceof JsonTypeWriter) {
            JsonTypeWriter writer = (JsonTypeWriter)ScriptBytecodeAdapter.castToType((Object)closestWriter, JsonTypeWriter.class);
            if (writer.hasPrimitiveForm() && (!referenced && !showType || closestWriter instanceof Writers.JsonStringWriter)) {
                writer.writePrimitiveForm(o, output);
                return true;
            }
        }
        output.write("{");
        this.tabIn();
        if (referenced) {
            this.writeId(this.getId(o));
            if (showType) {
                output.write(",");
                this.newLine();
            }
        }
        if (showType) {
            this.writeType(o, output);
        }
        if (referenced || showType) {
            output.write(",");
            this.newLine();
        }
        if (closestWriter instanceof JsonTypeWriterEx) {
            ((JsonTypeWriterEx)ScriptBytecodeAdapter.castToType((Object)closestWriter, JsonTypeWriterEx.class)).write(o, showType || referenced, output, this.customArgs);
        } else {
            ((JsonTypeWriter)ScriptBytecodeAdapter.castToType((Object)closestWriter, JsonTypeWriter.class)).write(o, showType || referenced, output);
        }
        this.tabOut();
        output.write("}");
        return true;
    }

    private static JsonTypeWriterBase getCustomWriter(Class c) {
        JsonTypeWriterBase writer = (JsonTypeWriterBase)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(writerCache, (Object)c), JsonTypeWriterBase.class);
        if (writer == null) {
            Map<Class, JsonTypeWriterBase> map = writerCache;
            synchronized (map) {
                Object object = DefaultGroovyMethods.getAt(writerCache, (Object)c);
                writer = (JsonTypeWriterBase)ScriptBytecodeAdapter.castToType((Object)object, JsonTypeWriterBase.class);
                if (writer == null) {
                    JsonTypeWriterBase jsonTypeWriterBase;
                    writer = jsonTypeWriterBase = GroovyJsonWriter.getForceCustomWriter(c);
                    JsonTypeWriterBase jsonTypeWriterBase2 = writer;
                    DefaultGroovyMethods.putAt(writerCache, (Object)c, (Object)jsonTypeWriterBase2);
                }
            }
        }
        return (JsonTypeWriterBase)ScriptBytecodeAdapter.castToType((Object)(DefaultGroovyMethods.is((Object)writer, (Object)nullWriter) ? null : writer), JsonTypeWriterBase.class);
    }

    private static JsonTypeWriterBase getForceCustomWriter(Class c) {
        JsonTypeWriterBase closestWriter = nullWriter;
        int minDistance = Integer.MAX_VALUE;
        Map.Entry entry = null;
        Iterator<Map.Entry<Class, JsonTypeWriterBase>> iterator = writers.entrySet().iterator();
        while (iterator.hasNext()) {
            int n;
            entry = (Map.Entry)ScriptBytecodeAdapter.castToType(iterator.next(), Map.Entry.class);
            Class clz = ShortTypeHandling.castToClass(entry.getKey());
            if (ScriptBytecodeAdapter.compareEqual((Object)clz, (Object)c)) {
                return (JsonTypeWriterBase)ScriptBytecodeAdapter.castToType(entry.getValue(), JsonTypeWriterBase.class);
            }
            int distance = MetaUtils.getDistance(clz, c);
            if (!(distance < minDistance)) continue;
            minDistance = n = distance;
            Object v = entry.getValue();
            closestWriter = (JsonTypeWriterBase)ScriptBytecodeAdapter.castToType(v, JsonTypeWriterBase.class);
        }
        return closestWriter;
    }

    public static void addWriter(Class c, JsonTypeWriterBase writer) {
        Map.Entry entry = null;
        Iterator<Map.Entry<Class, JsonTypeWriterBase>> iterator = writers.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = (Map.Entry)ScriptBytecodeAdapter.castToType(iterator.next(), Map.Entry.class);
            Class clz = ShortTypeHandling.castToClass(entry.getKey());
            if (!DefaultGroovyMethods.is((Object)clz, (Object)c)) continue;
            JsonTypeWriterBase jsonTypeWriterBase = writer;
            entry.setValue(jsonTypeWriterBase);
            return;
        }
        JsonTypeWriterBase jsonTypeWriterBase = writer;
        DefaultGroovyMethods.putAt(writers, (Object)c, (Object)jsonTypeWriterBase);
    }

    public static void addNotCustomWriter(Class c) {
        NullClass nullClass = nullWriter;
        DefaultGroovyMethods.putAt(writerCache, (Object)c, (Object)nullClass);
    }

    public void write(Object obj) {
        this.traceReferences(obj);
        this.objVisited.clear();
        this.writeImpl(obj, true);
        this.flush();
        this.objVisited.clear();
        this.objsReferenced.clear();
        _args.get().clear();
        _args.remove();
    }

    protected void traceReferences(Object root) {
        if (root == null) {
            return;
        }
        ArrayDeque<Object> stack = new ArrayDeque<Object>();
        stack.addFirst(root);
        Map<Object, Long> visited = this.objVisited;
        Map<Object, Long> referenced = this.objsReferenced;
        while (!stack.isEmpty()) {
            Object obj = stack.removeFirst();
            if (!MetaUtils.isLogicalPrimitive(obj.getClass())) {
                Long id = (Long)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(visited, obj), Long.class);
                if (id != null) {
                    if (!ScriptBytecodeAdapter.compareEqual((Object)id, (Object)ZERO)) continue;
                    long l = this.identity;
                    long cfr_ignored_0 = l + 1L;
                    this.identity = this.identity;
                    long l2 = l;
                    id = l2;
                    Long l3 = id;
                    DefaultGroovyMethods.putAt(visited, obj, (Object)l3);
                    Long l4 = id;
                    DefaultGroovyMethods.putAt(referenced, obj, (Object)l4);
                    continue;
                }
                Long l = ZERO;
                DefaultGroovyMethods.putAt(visited, obj, (Object)l);
            }
            Class<?> clazz = obj.getClass();
            if (clazz.isArray()) {
                Class<?> compType = clazz.getComponentType();
                if (!(!MetaUtils.isLogicalPrimitive(compType))) continue;
                int len = Array.getLength(obj);
                int i = 0;
                while (i < len) {
                    Object o = Array.get(obj, i);
                    if (o != null) {
                        stack.addFirst(o);
                    }
                    int n = i;
                    int cfr_ignored_1 = n + 1;
                }
                continue;
            }
            if (Map.class.isAssignableFrom(clazz)) {
                Map map = (Map)ScriptBytecodeAdapter.castToType(obj, Map.class);
                Map.Entry item = null;
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = item = (Map.Entry)ScriptBytecodeAdapter.castToType(iterator.next(), Map.Entry.class);
                    if (entry.getValue() != null) {
                        stack.addFirst(entry.getValue());
                    }
                    if (!(entry.getKey() != null)) continue;
                    stack.addFirst(entry.getKey());
                }
                continue;
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                Object item2 = null;
                for (Object item2 : (Collection)ScriptBytecodeAdapter.castToType(obj, Collection.class)) {
                    if (!(item2 != null)) continue;
                    stack.addFirst(item2);
                }
                continue;
            }
            if (!(GroovyJsonWriter.getCustomWriter(obj.getClass()) == null)) continue;
            this.traceFields(stack, obj);
        }
    }

    protected void traceFields(Deque<Object> stack, Object obj) {
        Map fieldSpecifiers = (Map)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((Map)((Map)ScriptBytecodeAdapter.castToType(_args.get(), Map.class)), (Object)FIELD_SPECIFIERS), Map.class);
        Collection<Field> fields = GroovyJsonWriter.getFieldsUsingSpecifier(obj.getClass(), fieldSpecifiers);
        if (fields == null) {
            Collection<Field> collection = MetaUtils.getDeepDeclaredFields(obj.getClass()).values();
            fields = collection;
        }
        Field field = null;
        Iterator iterator = fields.iterator();
        while (iterator.hasNext()) {
            field = (Field)ScriptBytecodeAdapter.castToType(iterator.next(), Field.class);
            try {
                Object o = field.get(obj);
                if (!(o != null && !MetaUtils.isLogicalPrimitive(o.getClass()))) continue;
                stack.addFirst(o);
            }
            catch (Exception ignored) {
            }
        }
    }

    private static List<Field> getFieldsUsingSpecifier(Class classBeingWritten, Map<Class, List<Field>> fieldSpecifiers) {
        Iterator<Map.Entry<Class, List<Field>>> i = fieldSpecifiers.entrySet().iterator();
        int minDistance = Integer.MAX_VALUE;
        List fields = null;
        while (i.hasNext()) {
            int n;
            Map.Entry entry = (Map.Entry)ScriptBytecodeAdapter.castToType(i.next(), Map.Entry.class);
            Class c = ShortTypeHandling.castToClass(entry.getKey());
            if (ScriptBytecodeAdapter.compareEqual((Object)c, (Object)classBeingWritten)) {
                return (List)ScriptBytecodeAdapter.castToType(entry.getValue(), List.class);
            }
            int distance = MetaUtils.getDistance(c, classBeingWritten);
            if (!(distance < minDistance)) continue;
            minDistance = n = distance;
            Object v = entry.getValue();
            fields = (List)ScriptBytecodeAdapter.castToType(v, List.class);
        }
        return fields;
    }

    private boolean writeOptionalReference(Object obj) {
        if (obj != null && MetaUtils.isLogicalPrimitive(obj.getClass())) {
            return false;
        }
        Writer output = this.out;
        if (this.objVisited.containsKey(obj)) {
            String id = this.getId(obj);
            if (id == null) {
                return false;
            }
            output.write(this.shortMetaKeys ? "{\"@r\":" : "{\"@ref\":");
            output.write(id);
            output.write("}");
            return true;
        }
        Object var4_4 = null;
        DefaultGroovyMethods.putAt(this.objVisited, (Object)obj, var4_4);
        return false;
    }

    public void writeImpl(Object obj, boolean showType) {
        if (obj == null) {
            this.out.write("null");
            return;
        }
        if (obj.getClass().isArray()) {
            this.writeArray(obj, showType);
        } else if (obj instanceof Collection) {
            this.writeCollection((Collection)ScriptBytecodeAdapter.castToType((Object)obj, Collection.class), showType);
        } else if (obj instanceof JsonObject) {
            JsonObject jObj = (JsonObject)ScriptBytecodeAdapter.castToType((Object)obj, JsonObject.class);
            if (jObj.isArray()) {
                this.writeJsonObjectArray(jObj, showType);
            } else if (jObj.isCollection()) {
                this.writeJsonObjectCollection(jObj, showType);
            } else if (jObj.isMap()) {
                if (!this.writeJsonObjectMapWithStringKeys(jObj, showType)) {
                    this.writeJsonObjectMap(jObj, showType);
                }
            } else {
                this.writeJsonObjectObject(jObj, showType);
            }
        } else if (obj instanceof Map) {
            if (!this.writeMapWithStringKeys((Map)ScriptBytecodeAdapter.castToType((Object)obj, Map.class), showType)) {
                this.writeMap((Map)ScriptBytecodeAdapter.castToType((Object)obj, Map.class), showType);
            }
        } else {
            this.writeObject(obj, showType);
        }
    }

    private void writeId(String id) {
        this.out.write(this.shortMetaKeys ? "\"@i\":" : "\"@id\":");
        this.out.write(id == null ? "0" : id);
    }

    private void writeType(Object obj, Writer output) {
        output.write(this.shortMetaKeys ? "\"@t\":\"" : "\"@type\":\"");
        Class<?> c = obj.getClass();
        String typeName = c.getName();
        String shortName = this.getSubstituteTypeNameIfExists(typeName);
        if (shortName != null) {
            output.write(shortName);
            output.write("\"");
            return;
        }
        String string = c.getName();
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"java.lang.Boolean")) {
            output.write("boolean");
        } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"java.lang.Byte")) {
            output.write("byte");
        } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"java.lang.Character")) {
            output.write("char");
        } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"java.lang.Class")) {
            output.write("class");
        } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"java.lang.Double")) {
            output.write("double");
        } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"java.lang.Float")) {
            output.write("float");
        } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"java.lang.Integer")) {
            output.write("int");
        } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"java.lang.Long")) {
            output.write("long");
        } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"java.lang.Short")) {
            output.write("short");
        } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"java.lang.String")) {
            output.write("string");
        } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"java.util.Date")) {
            output.write("date");
        } else {
            output.write(c.getName());
        }
        output.write("\"");
    }

    private void writePrimitive(Object obj, boolean showType) throws IOException {
        if (obj instanceof Character) {
            GroovyJsonWriter.writeJsonUtf8String(String.valueOf(obj), this.out);
        } else if (obj instanceof Long && GroovyJsonWriter.getWriteLongsAsStrings()) {
            if (showType) {
                this.out.write(this.shortMetaKeys ? "{\"@t\":\"" : "{\"@type\":\"");
                this.out.write(this.getSubstituteTypeName("long"));
                this.out.write("\",\"value\":\"");
                this.out.write(DefaultGroovyMethods.toString((Object)obj));
                this.out.write("\"}");
            } else {
                this.out.write("\"");
                this.out.write(DefaultGroovyMethods.toString((Object)obj));
                this.out.write("\"");
            }
        } else {
            this.out.write(DefaultGroovyMethods.toString((Object)obj));
        }
    }

    private void writeArray(Object array, boolean showType) {
        if (this.writeOptionalReference(array)) {
            return;
        }
        Class<?> arrayType = array.getClass();
        int len = Array.getLength(array);
        boolean referenced = this.objsReferenced.containsKey(array);
        boolean typeWritten = showType && !arrayType.equals(new Object[0].getClass());
        Writer output = this.out;
        if (typeWritten || referenced) {
            output.write("{");
            this.tabIn();
        }
        if (referenced) {
            this.writeId(this.getId(array));
            output.write(",");
            this.newLine();
        }
        if (typeWritten) {
            this.writeType(array, output);
            output.write(",");
            this.newLine();
        }
        if (len == 0) {
            if (typeWritten || referenced) {
                output.write(this.shortMetaKeys ? "\"@e\":[]" : "\"@items\":[]");
                this.tabOut();
                output.write("}");
            } else {
                output.write("[]");
            }
            return;
        }
        if (typeWritten || referenced) {
            output.write(this.shortMetaKeys ? "\"@e\":[" : "\"@items\":[");
        } else {
            output.write("[");
        }
        this.tabIn();
        int lenMinus1 = len - 1;
        if (DefaultGroovyMethods.is(new byte[0].getClass(), arrayType)) {
            this.writeByteArray((byte[])ScriptBytecodeAdapter.castToType((Object)array, byte[].class), lenMinus1);
        } else if (DefaultGroovyMethods.is(new char[0].getClass(), arrayType)) {
            GroovyJsonWriter.writeJsonUtf8String(new String((char[])ScriptBytecodeAdapter.castToType((Object)array, char[].class)), output);
        } else if (DefaultGroovyMethods.is(new short[0].getClass(), arrayType)) {
            this.writeShortArray((short[])ScriptBytecodeAdapter.castToType((Object)array, short[].class), lenMinus1);
        } else if (DefaultGroovyMethods.is(new int[0].getClass(), arrayType)) {
            this.writeIntArray((int[])ScriptBytecodeAdapter.castToType((Object)array, int[].class), lenMinus1);
        } else if (DefaultGroovyMethods.is(new long[0].getClass(), arrayType)) {
            this.writeLongArray((long[])ScriptBytecodeAdapter.castToType((Object)array, long[].class), lenMinus1);
        } else if (DefaultGroovyMethods.is(new float[0].getClass(), arrayType)) {
            this.writeFloatArray((float[])ScriptBytecodeAdapter.castToType((Object)array, float[].class), lenMinus1);
        } else if (DefaultGroovyMethods.is(new double[0].getClass(), arrayType)) {
            this.writeDoubleArray((double[])ScriptBytecodeAdapter.castToType((Object)array, double[].class), lenMinus1);
        } else if (DefaultGroovyMethods.is(new boolean[0].getClass(), arrayType)) {
            this.writeBooleanArray((boolean[])ScriptBytecodeAdapter.castToType((Object)array, boolean[].class), lenMinus1);
        } else {
            Class<?> componentClass = array.getClass().getComponentType();
            boolean isPrimitiveArray = MetaUtils.isPrimitive(componentClass);
            boolean isObjectArray = DefaultGroovyMethods.is(new Object[0].getClass(), arrayType);
            int i = 0;
            while (i < len) {
                Object value = Array.get(array, i);
                if (value == null) {
                    output.write("null");
                } else if (!this.writeArrayElementIfMatching(componentClass, value, false, output)) {
                    if (isPrimitiveArray || value instanceof Boolean || value instanceof Long || value instanceof Double) {
                        this.writePrimitive(value, ScriptBytecodeAdapter.compareNotEqual(value.getClass(), componentClass));
                    } else if (isObjectArray) {
                        if (!this.writeIfMatching(value, true, output)) {
                            this.writeImpl(value, true);
                        }
                    } else {
                        boolean forceType = !ScriptBytecodeAdapter.compareEqual(value.getClass(), componentClass);
                        this.writeImpl(value, forceType || GroovyJsonWriter.alwaysShowType());
                    }
                }
                if (i != lenMinus1) {
                    output.write(",");
                    this.newLine();
                }
                int n = i;
                int cfr_ignored_0 = n + 1;
            }
        }
        this.tabOut();
        output.write("]");
        if (typeWritten || referenced) {
            this.tabOut();
            output.write("}");
        }
    }

    private static boolean alwaysShowType() {
        return Boolean.TRUE.equals(_args.get().containsKey(TYPE));
    }

    private void writeBooleanArray(boolean[] booleans, int lenMinus1) {
        Writer output = this.out;
        int i = 0;
        while (i < lenMinus1) {
            output.write(BytecodeInterface8.zArrayGet((boolean[])booleans, (int)i) ? "true," : "false,");
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
        output.write(Boolean.toString(BytecodeInterface8.zArrayGet((boolean[])booleans, (int)lenMinus1)));
    }

    private void writeDoubleArray(double[] doubles, int lenMinus1) {
        Writer output = this.out;
        int i = 0;
        while (i < lenMinus1) {
            output.write(Double.toString(BytecodeInterface8.dArrayGet((double[])doubles, (int)i)));
            output.write(",");
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
        output.write(Double.toString(BytecodeInterface8.dArrayGet((double[])doubles, (int)lenMinus1)));
    }

    private void writeFloatArray(float[] floats, int lenMinus1) {
        Writer output = this.out;
        int i = 0;
        while (i < lenMinus1) {
            output.write(Float.toString(BytecodeInterface8.fArrayGet((float[])floats, (int)i)));
            output.write(",");
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
        output.write(Float.toString(BytecodeInterface8.fArrayGet((float[])floats, (int)lenMinus1)));
    }

    private void writeLongArray(long[] longs, int lenMinus1) throws IOException {
        Writer output = this.out;
        if (GroovyJsonWriter.getWriteLongsAsStrings()) {
            int i = 0;
            while (i < lenMinus1) {
                output.write("\"");
                output.write(Long.toString(BytecodeInterface8.lArrayGet((long[])longs, (int)i)));
                output.write("\"");
                output.write(",");
                int n = i;
                int cfr_ignored_0 = n + 1;
            }
            output.write("\"");
            output.write(Long.toString(BytecodeInterface8.lArrayGet((long[])longs, (int)lenMinus1)));
            output.write("\"");
        } else {
            int i = 0;
            while (i < lenMinus1) {
                output.write(Long.toString(BytecodeInterface8.lArrayGet((long[])longs, (int)i)));
                output.write(",");
                int n = i;
                int cfr_ignored_1 = n + 1;
            }
            output.write(Long.toString(BytecodeInterface8.lArrayGet((long[])longs, (int)lenMinus1)));
        }
    }

    private void writeIntArray(int[] ints, int lenMinus1) {
        Writer output = this.out;
        int i = 0;
        while (i < lenMinus1) {
            output.write(Integer.toString(BytecodeInterface8.intArrayGet((int[])ints, (int)i)));
            output.write(",");
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
        output.write(Integer.toString(BytecodeInterface8.intArrayGet((int[])ints, (int)lenMinus1)));
    }

    private void writeShortArray(short[] shorts, int lenMinus1) {
        Writer output = this.out;
        int i = 0;
        while (i < lenMinus1) {
            output.write(Integer.toString(BytecodeInterface8.sArrayGet((short[])shorts, (int)i)));
            output.write(",");
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
        output.write(Integer.toString(BytecodeInterface8.sArrayGet((short[])shorts, (int)lenMinus1)));
    }

    private void writeByteArray(byte[] bytes, int lenMinus1) {
        Writer output = this.out;
        Object[] byteStrs = byteStrings;
        int i = 0;
        while (i < lenMinus1) {
            output.write((char[])ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])byteStrs, (int)(BytecodeInterface8.bArrayGet((byte[])bytes, (int)i) + 128)), char[].class));
            output.write(",");
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
        output.write((char[])ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])byteStrs, (int)(BytecodeInterface8.bArrayGet((byte[])bytes, (int)lenMinus1) + 128)), char[].class));
    }

    private void writeCollection(Collection col, boolean showType) {
        if (this.writeOptionalReference(col)) {
            return;
        }
        Writer output = this.out;
        boolean referenced = this.objsReferenced.containsKey(col);
        boolean isEmpty = col.isEmpty();
        if (referenced || showType) {
            output.write("{");
            this.tabIn();
        } else if (isEmpty) {
            output.write("[");
        }
        this.writeIdAndTypeIfNeeded(col, showType, referenced);
        if (isEmpty) {
            if (referenced || showType) {
                this.tabOut();
                output.write("}");
            } else {
                output.write("]");
            }
            return;
        }
        this.beginCollection(showType, referenced);
        Iterator i = col.iterator();
        while (i.hasNext()) {
            this.writeCollectionElement(i.next());
            if (!i.hasNext()) continue;
            output.write(",");
            this.newLine();
        }
        this.tabOut();
        output.write("]");
        if (showType || referenced) {
            this.tabOut();
            output.write("}");
        }
    }

    private void writeIdAndTypeIfNeeded(Object col, boolean showType, boolean referenced) {
        if (referenced) {
            this.writeId(this.getId(col));
        }
        if (showType) {
            if (referenced) {
                this.out.write(",");
                this.newLine();
            }
            this.writeType(col, this.out);
        }
    }

    private void beginCollection(boolean showType, boolean referenced) {
        if (showType || referenced) {
            this.out.write(",");
            this.newLine();
            this.out.write(this.shortMetaKeys ? "\"@e\":[" : "\"@items\":[");
        } else {
            this.out.write("[");
        }
        this.tabIn();
    }

    private void writeJsonObjectArray(JsonObject jObj, boolean showType) {
        Class<?> clazz;
        Class<?> clazz2;
        if (this.writeOptionalReference(jObj)) {
            return;
        }
        int len = jObj.getLength();
        String type = jObj.getType();
        Class<?> arrayClass = null;
        arrayClass = type == null || DefaultGroovyMethods.is(new Object[0].getClass(), (Object)type) ? (clazz2 = new Object[0].getClass()) : (clazz = MetaUtils.classForName(type));
        Writer output = this.out;
        boolean isObjectArray = DefaultGroovyMethods.is(new Object[0].getClass(), arrayClass);
        Class<?> componentClass = arrayClass.getComponentType();
        boolean referenced = this.objsReferenced.containsKey(jObj) && jObj.hasId();
        boolean typeWritten = showType && !isObjectArray;
        if (typeWritten || referenced) {
            output.write("{");
            this.tabIn();
        }
        if (referenced) {
            this.writeId(Long.toString(jObj.getId()));
            output.write(",");
            this.newLine();
        }
        if (typeWritten) {
            output.write(this.shortMetaKeys ? "\"@t\":\"" : "\"@type\":\"");
            output.write(this.getSubstituteTypeName(arrayClass.getName()));
            output.write("\",");
            this.newLine();
        }
        if (len == 0) {
            if (typeWritten || referenced) {
                output.write(this.shortMetaKeys ? "\"@e\":[]" : "\"@items\":[]");
                this.tabOut();
                output.write("}");
            } else {
                output.write("[]");
            }
            return;
        }
        if (typeWritten || referenced) {
            output.write(this.shortMetaKeys ? "\"@e\":[" : "\"@items\":[");
        } else {
            output.write("[");
        }
        this.tabIn();
        Object[] items = (Object[])ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((Map)jObj, (Object)"@items"), Object[].class);
        int lenMinus1 = len - 1;
        int i = 0;
        while (i < len) {
            Object value = BytecodeInterface8.objectArrayGet((Object[])items, (int)i);
            if (value == null) {
                output.write("null");
            } else if (ScriptBytecodeAdapter.compareEqual(Character.class, componentClass) || ScriptBytecodeAdapter.compareEqual(Character.TYPE, componentClass)) {
                GroovyJsonWriter.writeJsonUtf8String(ShortTypeHandling.castToString((Object)value), output);
            } else if (value instanceof Boolean || value instanceof Long || value instanceof Double) {
                this.writePrimitive(value, ScriptBytecodeAdapter.compareNotEqual(value.getClass(), componentClass));
            } else if (value instanceof String) {
                GroovyJsonWriter.writeJsonUtf8String(ShortTypeHandling.castToString((Object)value), output);
            } else if (isObjectArray) {
                if (!this.writeIfMatching(value, true, output)) {
                    this.writeImpl(value, true);
                }
            } else if (!this.writeArrayElementIfMatching(componentClass, value, false, output)) {
                boolean forceType = !ScriptBytecodeAdapter.compareEqual(value.getClass(), componentClass);
                this.writeImpl(value, forceType || GroovyJsonWriter.alwaysShowType());
            }
            if (i != lenMinus1) {
                output.write(",");
                this.newLine();
            }
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
        this.tabOut();
        output.write("]");
        if (typeWritten || referenced) {
            this.tabOut();
            output.write("}");
        }
    }

    private void writeJsonObjectCollection(JsonObject jObj, boolean showType) {
        if (this.writeOptionalReference(jObj)) {
            return;
        }
        String type = jObj.getType();
        Class colClass = MetaUtils.classForName(type);
        boolean referenced = this.objsReferenced.containsKey(jObj) && jObj.hasId();
        Writer output = this.out;
        int len = jObj.getLength();
        if (referenced || showType || len == 0) {
            output.write("{");
            this.tabIn();
        }
        if (referenced) {
            this.writeId(String.valueOf(jObj.getId()));
        }
        if (showType) {
            if (referenced) {
                output.write(",");
                this.newLine();
            }
            output.write(this.shortMetaKeys ? "\"@t\":\"" : "\"@type\":\"");
            output.write(this.getSubstituteTypeName(colClass.getName()));
            output.write("\"");
        }
        if (len == 0) {
            this.tabOut();
            output.write("}");
            return;
        }
        this.beginCollection(showType, referenced);
        Object[] items = (Object[])ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((Map)jObj, (Object)"@items"), Object[].class);
        int itemsLen = items.length;
        int itemsLenMinus1 = itemsLen - 1;
        int i = 0;
        while (i < itemsLen) {
            this.writeCollectionElement(BytecodeInterface8.objectArrayGet((Object[])items, (int)i));
            if (i != itemsLenMinus1) {
                output.write(",");
                this.newLine();
            }
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
        this.tabOut();
        output.write("]");
        if (showType || referenced) {
            this.tabOut();
            output.write("}");
        }
    }

    private void writeJsonObjectMap(JsonObject jObj, boolean showType) {
        if (this.writeOptionalReference(jObj)) {
            return;
        }
        boolean referenced = this.objsReferenced.containsKey(jObj) && jObj.hasId();
        Writer output = this.out;
        output.write("{");
        this.tabIn();
        if (referenced) {
            this.writeId(String.valueOf(jObj.getId()));
        }
        if (showType) {
            if (referenced) {
                output.write(",");
                this.newLine();
            }
            String type = jObj.getType();
            if (type != null) {
                Class mapClass = MetaUtils.classForName(type);
                output.write(this.shortMetaKeys ? "\"@t\":\"" : "\"@type\":\"");
                output.write(this.getSubstituteTypeName(mapClass.getName()));
                output.write("\"");
            } else {
                boolean bl;
                showType = bl = false;
            }
        }
        if (jObj.isEmpty()) {
            this.tabOut();
            output.write("}");
            return;
        }
        if (showType) {
            output.write(",");
            this.newLine();
        }
        output.write(this.shortMetaKeys ? "\"@k\":[" : "\"@keys\":[");
        this.tabIn();
        Iterator<Object> i = jObj.keySet().iterator();
        while (i.hasNext()) {
            this.writeCollectionElement(i.next());
            if (!i.hasNext()) continue;
            output.write(",");
            this.newLine();
        }
        this.tabOut();
        output.write("],");
        this.newLine();
        output.write(this.shortMetaKeys ? "\"@e\":[" : "\"@items\":[");
        this.tabIn();
        Iterator iterator = jObj.values().iterator();
        i = iterator;
        while (i.hasNext()) {
            this.writeCollectionElement(i.next());
            if (!i.hasNext()) continue;
            output.write(",");
            this.newLine();
        }
        this.tabOut();
        output.write("]");
        this.tabOut();
        output.write("}");
    }

    private boolean writeJsonObjectMapWithStringKeys(JsonObject jObj, boolean showType) {
        if (!GroovyJsonWriter.ensureJsonPrimitiveKeys(jObj)) {
            return false;
        }
        if (this.writeOptionalReference(jObj)) {
            return true;
        }
        boolean referenced = this.objsReferenced.containsKey(jObj) && jObj.hasId();
        Writer output = this.out;
        output.write("{");
        this.tabIn();
        if (referenced) {
            this.writeId(String.valueOf(jObj.getId()));
        }
        if (showType) {
            if (referenced) {
                output.write(",");
                this.newLine();
            }
            String type = jObj.getType();
            if (type != null) {
                Class mapClass = MetaUtils.classForName(type);
                output.write(this.shortMetaKeys ? "\"@t\":\"" : "\"@type\":\"");
                output.write(this.getSubstituteTypeName(mapClass.getName()));
                output.write("\"");
            } else {
                boolean bl;
                showType = bl = false;
            }
        }
        if (jObj.isEmpty()) {
            this.tabOut();
            output.write("}");
            return true;
        }
        if (showType) {
            output.write(",");
            this.newLine();
        }
        return this.writeMapBody(jObj.entrySet().iterator());
    }

    private void writeJsonObjectObject(JsonObject jObj, boolean showType) {
        boolean bl;
        if (this.writeOptionalReference(jObj)) {
            return;
        }
        Writer output = this.out;
        boolean referenced = this.objsReferenced.containsKey(jObj) && jObj.hasId();
        showType = bl = showType && jObj.getType() != null;
        Class type = null;
        output.write("{");
        this.tabIn();
        if (referenced) {
            this.writeId(String.valueOf(jObj.getId()));
        }
        if (showType) {
            if (referenced) {
                output.write(",");
                this.newLine();
            }
            output.write(this.shortMetaKeys ? "\"@t\":\"" : "\"@type\":\"");
            output.write(this.getSubstituteTypeName(jObj.getType()));
            output.write("\"");
            try {
                Class clazz;
                type = clazz = MetaUtils.classForName(jObj.getType());
            }
            catch (Exception ignored) {
                Object var9_9 = null;
                type = ShortTypeHandling.castToClass(var9_9);
            }
        }
        if (jObj.isEmpty()) {
            this.tabOut();
            output.write("}");
            return;
        }
        if (showType || referenced) {
            output.write(",");
            this.newLine();
        }
        Iterator i = jObj.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)ScriptBytecodeAdapter.castToType(i.next(), Map.Entry.class);
            String fieldName = ShortTypeHandling.castToString(entry.getKey());
            output.write("\"");
            output.write(fieldName);
            output.write("\":");
            Object value = entry.getValue();
            if (value == null) {
                output.write("null");
            } else if (value instanceof BigDecimal || value instanceof BigInteger) {
                this.writeImpl(value, !GroovyJsonWriter.doesValueTypeMatchFieldType(type, fieldName, value));
            } else if (value instanceof Number || value instanceof Boolean) {
                output.write(DefaultGroovyMethods.toString(value));
            } else if (value instanceof String) {
                GroovyJsonWriter.writeJsonUtf8String(ShortTypeHandling.castToString(value), output);
            } else if (value instanceof Character) {
                GroovyJsonWriter.writeJsonUtf8String(String.valueOf(value), output);
            } else {
                this.writeImpl(value, !GroovyJsonWriter.doesValueTypeMatchFieldType(type, fieldName, value));
            }
            if (!i.hasNext()) continue;
            output.write(",");
            this.newLine();
        }
        this.tabOut();
        output.write("}");
    }

    private static boolean doesValueTypeMatchFieldType(Class type, String fieldName, Object value) {
        if (type != null) {
            Map<String, Field> classFields = MetaUtils.getDeepDeclaredFields(type);
            Field field = (Field)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(classFields, (Object)fieldName), Field.class);
            return field != null && ScriptBytecodeAdapter.compareEqual(value.getClass(), field.getType());
        }
        return false;
    }

    private void writeMap(Map map, boolean showType) {
        if (this.writeOptionalReference(map)) {
            return;
        }
        Writer output = this.out;
        boolean referenced = this.objsReferenced.containsKey(map);
        output.write("{");
        this.tabIn();
        if (referenced) {
            this.writeId(this.getId(map));
        }
        if (showType) {
            if (referenced) {
                output.write(",");
                this.newLine();
            }
            this.writeType(map, output);
        }
        if (map.isEmpty()) {
            this.tabOut();
            output.write("}");
            return;
        }
        if (showType || referenced) {
            output.write(",");
            this.newLine();
        }
        output.write(this.shortMetaKeys ? "\"@k\":[" : "\"@keys\":[");
        this.tabIn();
        Iterator<Object> i = map.keySet().iterator();
        while (i.hasNext()) {
            this.writeCollectionElement(i.next());
            if (!i.hasNext()) continue;
            output.write(",");
            this.newLine();
        }
        this.tabOut();
        output.write("],");
        this.newLine();
        output.write(this.shortMetaKeys ? "\"@e\":[" : "\"@items\":[");
        this.tabIn();
        Iterator iterator = map.values().iterator();
        i = iterator;
        while (i.hasNext()) {
            this.writeCollectionElement(i.next());
            if (!i.hasNext()) continue;
            output.write(",");
            this.newLine();
        }
        this.tabOut();
        output.write("]");
        this.tabOut();
        output.write("}");
    }

    private boolean writeMapWithStringKeys(Map map, boolean showType) {
        if (!GroovyJsonWriter.ensureJsonPrimitiveKeys(map)) {
            return false;
        }
        if (this.writeOptionalReference(map)) {
            return true;
        }
        boolean referenced = this.objsReferenced.containsKey(map);
        this.out.write("{");
        this.tabIn();
        this.writeIdAndTypeIfNeeded(map, showType, referenced);
        if (map.isEmpty()) {
            this.tabOut();
            this.out.write("}");
            return true;
        }
        if (showType || referenced) {
            this.out.write(",");
            this.newLine();
        }
        return this.writeMapBody(map.entrySet().iterator());
    }

    private boolean writeMapBody(Iterator i) {
        Writer output = this.out;
        while (i.hasNext()) {
            Map.Entry att2value = (Map.Entry)ScriptBytecodeAdapter.castToType(i.next(), Map.Entry.class);
            output.write("\"");
            output.write(ShortTypeHandling.castToString(att2value.getKey()));
            output.write("\":");
            this.writeCollectionElement(att2value.getValue());
            if (!i.hasNext()) continue;
            output.write(",");
            this.newLine();
        }
        this.tabOut();
        output.write("}");
        return true;
    }

    public static boolean ensureJsonPrimitiveKeys(Map map) {
        Object o2 = null;
        for (Object o2 : map.keySet()) {
            if (!(!(o2 instanceof String))) continue;
            return false;
        }
        return true;
    }

    private void writeCollectionElement(Object o) {
        if (o == null) {
            this.out.write("null");
        } else if (o instanceof Boolean || o instanceof Double) {
            this.out.write(DefaultGroovyMethods.toString((Object)o));
        } else if (o instanceof Long) {
            this.writePrimitive(o, GroovyJsonWriter.getWriteLongsAsStrings());
        } else if (o instanceof String) {
            GroovyJsonWriter.writeJsonUtf8String(ShortTypeHandling.castToString((Object)o), this.out);
        } else {
            this.writeImpl(o, true);
        }
    }

    private void writeObject(Object obj, boolean showType) {
        if (this.writeIfMatching(obj, showType, this.out)) {
            return;
        }
        if (this.writeOptionalReference(obj)) {
            return;
        }
        this.out.write("{");
        this.tabIn();
        boolean referenced = this.objsReferenced.containsKey(obj);
        if (referenced) {
            this.writeId(this.getId(obj));
        }
        if (referenced && showType) {
            this.out.write(",");
            this.newLine();
        }
        if (showType) {
            this.writeType(obj, this.out);
        }
        boolean first = !showType;
        if (referenced && !showType) {
            boolean bl;
            first = bl = false;
        }
        Map fieldSpecifiers = (Map)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((Map)((Map)ScriptBytecodeAdapter.castToType(_args.get(), Map.class)), (Object)FIELD_SPECIFIERS), Map.class);
        List<Field> externallySpecifiedFields = GroovyJsonWriter.getFieldsUsingSpecifier(obj.getClass(), fieldSpecifiers);
        if (externallySpecifiedFields != null) {
            Field field = null;
            Iterator<Field> iterator = externallySpecifiedFields.iterator();
            while (iterator.hasNext()) {
                boolean bl;
                field = (Field)ScriptBytecodeAdapter.castToType((Object)iterator.next(), Field.class);
                first = bl = this.writeField(obj, first, field.getName(), field, true);
            }
        } else {
            Map<String, Field> classInfo = MetaUtils.getDeepDeclaredFields(obj.getClass());
            Map.Entry entry = null;
            Iterator<Map.Entry<String, Field>> iterator = classInfo.entrySet().iterator();
            while (iterator.hasNext()) {
                boolean bl;
                entry = (Map.Entry)ScriptBytecodeAdapter.castToType(iterator.next(), Map.Entry.class);
                String fieldName = ShortTypeHandling.castToString(entry.getKey());
                Field field = (Field)ScriptBytecodeAdapter.castToType(entry.getValue(), Field.class);
                first = bl = this.writeField(obj, first, fieldName, field, false);
            }
        }
        this.tabOut();
        this.out.write("}");
    }

    private boolean writeField(Object obj, boolean first, String fieldName, Field field, boolean allowTransient) {
        if (!allowTransient && (field.getModifiers() & Modifier.TRANSIENT) != 0) {
            return first;
        }
        int modifiers = field.getModifiers();
        if (field.getDeclaringClass().isEnum() && !Modifier.isPublic(modifiers) && GroovyJsonWriter.isPublicEnumsOnly()) {
            return first;
        }
        if (!first) {
            this.out.write(",");
            this.newLine();
        }
        GroovyJsonWriter.writeJsonUtf8String(fieldName, this.out);
        this.out.write(":");
        Object o = null;
        try {
            Object object;
            o = object = field.get(obj);
        }
        catch (Exception ignored) {
            Object var10_10 = null;
            o = var10_10;
        }
        if (o == null) {
            this.out.write("null");
            return false;
        }
        Class<?> type = field.getType();
        boolean forceType = ScriptBytecodeAdapter.compareNotEqual(o.getClass(), type);
        if (MetaUtils.isPrimitive(type)) {
            this.writePrimitive(o, false);
        } else if (!this.writeIfMatching(o, forceType, this.out)) {
            this.writeImpl(o, forceType || GroovyJsonWriter.alwaysShowType());
        }
        return false;
    }

    public static void writeJsonUtf8String(String s, Writer output) {
        output.write("\"");
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (c < ' ') {
                Character c2 = Character.valueOf(c);
                if (ScriptBytecodeAdapter.isCase((Object)c2, (Object)Character.valueOf('\b'))) {
                    output.write("\\b");
                } else if (ScriptBytecodeAdapter.isCase((Object)c2, (Object)Character.valueOf('\f'))) {
                    output.write("\\f");
                } else if (ScriptBytecodeAdapter.isCase((Object)c2, (Object)Character.valueOf('\n'))) {
                    output.write("\\n");
                } else if (ScriptBytecodeAdapter.isCase((Object)c2, (Object)Character.valueOf('\r'))) {
                    output.write("\\r");
                } else if (ScriptBytecodeAdapter.isCase((Object)c2, (Object)Character.valueOf('\t'))) {
                    output.write("\\t");
                } else {
                    String hex = Integer.toHexString(c);
                    output.write("\\u");
                    int pad = 4 - hex.length();
                    int k = 0;
                    while (k < pad) {
                        output.write("0");
                        int n = k;
                        int cfr_ignored_0 = n + 1;
                    }
                    output.write(hex);
                }
            } else if (c == '\\' || c == '\"') {
                output.write("\\");
                output.write(new char[]{c});
            } else {
                output.write(new char[]{c});
            }
            int n = i;
            int cfr_ignored_1 = n + 1;
        }
        output.write("\"");
    }

    @Override
    public void flush() {
        try {
            if (this.out != null) {
                this.out.flush();
            }
        }
        catch (Exception ignored) {
        }
    }

    @Override
    public void close() {
        try {
            this.out.close();
        }
        catch (Exception ignore) {
        }
    }

    private String getId(Object o) {
        if (o instanceof JsonObject) {
            Long id = ((JsonObject)ScriptBytecodeAdapter.castToType((Object)o, JsonObject.class)).getId();
            if (ScriptBytecodeAdapter.compareNotEqual((Object)id, (Object)-1)) {
                return String.valueOf(id);
            }
        }
        Long id = (Long)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(this.objsReferenced, (Object)o), Long.class);
        return ShortTypeHandling.castToString(id == null ? null : Long.toString(id));
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(GroovyJsonWriter.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, GroovyJsonWriter.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(GroovyJsonWriter.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != GroovyJsonWriter.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public static /* synthetic */ void __$swapInit() {
        Short s = -128;
        $const$0 = s;
    }

    public static final String getDATE_FORMAT() {
        return DATE_FORMAT;
    }

    public static final String getISO_DATE_FORMAT() {
        return ISO_DATE_FORMAT;
    }

    public static final String getISO_DATE_TIME_FORMAT() {
        return ISO_DATE_TIME_FORMAT;
    }

    public static final String getTYPE_NAME_MAP() {
        return TYPE_NAME_MAP;
    }

    public static final String getSHORT_META_KEYS() {
        return SHORT_META_KEYS;
    }

    public static final String getTYPE() {
        return TYPE;
    }

    public static final String getPRETTY_PRINT() {
        return PRETTY_PRINT;
    }

    public static final String getFIELD_SPECIFIERS() {
        return FIELD_SPECIFIERS;
    }

    public static final String getENUM_PUBLIC_ONLY() {
        return ENUM_PUBLIC_ONLY;
    }

    public static final String getWRITE_LONGS_AS_STRINGS() {
        return WRITE_LONGS_AS_STRINGS;
    }

    public long getIdentity() {
        return this.identity;
    }

    public void setIdentity(long l) {
        this.identity = l;
    }

    public static final ThreadLocal<Map<String, Object>> get_args() {
        return _args;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class 1
    extends ThreadLocal<Map<String, Object>>
    implements GroovyObject {
        public /* synthetic */ Class this$0;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        /* synthetic */ 1(Class p0) {
            MetaClass metaClass;
            Class clazz;
            this.this$0 = clazz = p0;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Override
        public Map<String, Object> initialValue() {
            return ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(1.class, GroovyJsonWriter.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, GroovyJsonWriter.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(1.class, GroovyJsonWriter.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != 1.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }
    }

    public static class NullClass
    implements JsonTypeWriterBase,
    GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        public NullClass() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(NullClass.class, GroovyJsonWriter.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, GroovyJsonWriter.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(NullClass.class, GroovyJsonWriter.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != NullClass.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }
    }
}

