/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io;

import com.cedarsoftware.util.io.FastPushbackReader;
import com.cedarsoftware.util.io.GroovyJsonReader;
import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.MetaUtils;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.util.ArrayList;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberPlus;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonParser
implements GroovyObject {
    private static final String EMPTY_OBJECT = "~!o~";
    private static final int STATE_READ_START_OBJECT = 0;
    private static final int STATE_READ_FIELD = 1;
    private static final int STATE_READ_VALUE = 2;
    private static final int STATE_READ_POST_VALUE = 3;
    private static final String EMPTY_ARRAY = "~!a~";
    private static final Map<String, String> stringCache;
    private final FastPushbackReader input;
    private final Map<Long, JsonObject> objsRead;
    private final StringBuilder strBuf;
    private final StringBuilder hexBuf;
    private final char[] numBuf;
    private final boolean useMaps;
    private final Map<String, String> typeNameMap;
    private static final int STATE_STRING_START = 0;
    private static final int STATE_STRING_SLASH = 1;
    private static final int STATE_HEX_DIGITS_START = 2;
    private static final int STATE_HEX_DIGITS = 3;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    /*
     * WARNING - void declaration
     */
    public JsonParser(FastPushbackReader fastPushbackReader, Map<Long, JsonObject> map, Map<String, Object> map2) {
        Map map3;
        void args;
        boolean bl;
        void objectsMap;
        void reader;
        MetaClass metaClass;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        this.strBuf = stringBuilder2 = new StringBuilder();
        this.hexBuf = stringBuilder = new StringBuilder();
        char[] cArray = new char[256];
        this.numBuf = cArray;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        void var8_8 = reader;
        this.input = var8_8;
        void var9_9 = objectsMap;
        this.objsRead = var9_9;
        this.useMaps = bl = Boolean.TRUE.equals(args.get(GroovyJsonReader.getUSE_MAPS()));
        this.typeNameMap = map3 = (Map)ScriptBytecodeAdapter.castToType(args.get(GroovyJsonReader.getTYPE_NAME_MAP_REVERSE()), Map.class);
    }

    private Object readJsonObject() {
        boolean done = false;
        String field = null;
        JsonObject object = new JsonObject();
        int state = STATE_READ_START_OBJECT;
        FastPushbackReader inp = this.input;
        while (!done) {
            int n;
            int c = 0;
            Integer n2 = state;
            if (ScriptBytecodeAdapter.isCase((Object)n2, (Object)STATE_READ_START_OBJECT)) {
                int n3;
                c = n3 = this.skipWhitespaceRead();
                if (c == 123) {
                    int n4;
                    int n5;
                    int n6;
                    int n7;
                    inp.getLine();
                    object.setLine(n7);
                    inp.getCol();
                    object.setColumn(n6);
                    c = n5 = this.skipWhitespaceRead();
                    if (c == 125) {
                        return EMPTY_OBJECT;
                    }
                    inp.unread(c);
                    state = n4 = STATE_READ_FIELD;
                    continue;
                }
                JsonParser.error(StringGroovyMethods.plus((CharSequence)"Input is invalid JSON; object does not start with '{', c=", (Object)c));
                continue;
            }
            if (ScriptBytecodeAdapter.isCase((Object)n2, (Object)STATE_READ_FIELD)) {
                int n8;
                c = n8 = this.skipWhitespaceRead();
                if (c == 34) {
                    int n9;
                    int n10;
                    String string;
                    field = string = this.readString();
                    c = n10 = this.skipWhitespaceRead();
                    if (c != 58) {
                        JsonParser.error("Expected ':' between string field and value");
                    }
                    this.skipWhitespace();
                    if (field.startsWith("@")) {
                        String string2 = field;
                        if (ScriptBytecodeAdapter.isCase((Object)string2, (Object)"@t")) {
                            Object object2 = DefaultGroovyMethods.getAt(stringCache, (Object)"@type");
                            field = ShortTypeHandling.castToString((Object)object2);
                        } else if (ScriptBytecodeAdapter.isCase((Object)string2, (Object)"@i")) {
                            Object object3 = DefaultGroovyMethods.getAt(stringCache, (Object)"@id");
                            field = ShortTypeHandling.castToString((Object)object3);
                        } else if (ScriptBytecodeAdapter.isCase((Object)string2, (Object)"@r")) {
                            Object object4 = DefaultGroovyMethods.getAt(stringCache, (Object)"@ref");
                            field = ShortTypeHandling.castToString((Object)object4);
                        } else if (ScriptBytecodeAdapter.isCase((Object)string2, (Object)"@k")) {
                            Object object5 = DefaultGroovyMethods.getAt(stringCache, (Object)"@keys");
                            field = ShortTypeHandling.castToString((Object)object5);
                        } else if (ScriptBytecodeAdapter.isCase((Object)string2, (Object)"@e")) {
                            Object object6 = DefaultGroovyMethods.getAt(stringCache, (Object)"@items");
                            field = ShortTypeHandling.castToString((Object)object6);
                        }
                    }
                    state = n9 = STATE_READ_VALUE;
                    continue;
                }
                JsonParser.error("Expected quote");
                continue;
            }
            if (ScriptBytecodeAdapter.isCase((Object)n2, (Object)STATE_READ_VALUE)) {
                int n11;
                if (field == null) {
                    String string;
                    field = string = "@items";
                }
                Object value = this.readValue(object);
                if ("@type".equals(field) && this.typeNameMap != null) {
                    String substitute = ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt(this.typeNameMap, (Object)value));
                    if (substitute != null) {
                        String string = substitute;
                        value = string;
                    }
                }
                Object object7 = value;
                DefaultGroovyMethods.putAt(object, (Object)field, (Object)object7);
                if ("@id".equals(field)) {
                    JsonObject jsonObject = object;
                    DefaultGroovyMethods.putAt(this.objsRead, (Object)((Long)ScriptBytecodeAdapter.castToType((Object)value, Long.class)), jsonObject);
                }
                state = n11 = STATE_READ_POST_VALUE;
                continue;
            }
            if (!ScriptBytecodeAdapter.isCase((Object)n2, (Object)STATE_READ_POST_VALUE)) continue;
            c = n = this.skipWhitespaceRead();
            if (ScriptBytecodeAdapter.compareEqual((Object)c, (Object)-1)) {
                JsonParser.error("EOF reached before closing '}'");
            }
            if (c == 125) {
                boolean bl;
                done = bl = true;
                continue;
            }
            if (c == 44) {
                int n12;
                state = n12 = STATE_READ_FIELD;
                continue;
            }
            JsonParser.error("Object not ended with '}'");
        }
        if (this.useMaps && object.isPrimitive()) {
            return object.getPrimitiveValue();
        }
        return object;
    }

    protected Object readValue(JsonObject object) {
        int c = this.input.read();
        Character c2 = Character.valueOf((char)c);
        if (ScriptBytecodeAdapter.isCase((Object)c2, (Object)"\"")) {
            return this.readString();
        }
        if (ScriptBytecodeAdapter.isCase((Object)c2, (Object)"{")) {
            this.input.unread(c);
            return this.readJsonObject();
        }
        if (ScriptBytecodeAdapter.isCase((Object)c2, (Object)"[")) {
            return this.readArray(object);
        }
        if (ScriptBytecodeAdapter.isCase((Object)c2, (Object)"]")) {
            this.input.unread(c);
            return EMPTY_ARRAY;
        }
        if (ScriptBytecodeAdapter.isCase((Object)c2, (Object)"f") || ScriptBytecodeAdapter.isCase((Object)c2, (Object)"F")) {
            this.input.unread(c);
            this.readToken("false");
            return Boolean.FALSE;
        }
        if (ScriptBytecodeAdapter.isCase((Object)c2, (Object)"n") || ScriptBytecodeAdapter.isCase((Object)c2, (Object)"N")) {
            this.input.unread(c);
            this.readToken("null");
            return null;
        }
        if (ScriptBytecodeAdapter.isCase((Object)c2, (Object)"t") || ScriptBytecodeAdapter.isCase((Object)c2, (Object)"T")) {
            this.input.unread(c);
            this.readToken("true");
            return Boolean.TRUE;
        }
        if (ScriptBytecodeAdapter.isCase((Object)c2, (Object)Character.valueOf(DefaultTypeTransformation.charUnbox((Object)ScriptBytecodeAdapter.asType((Object)-1, Character.TYPE))))) {
            JsonParser.error("EOF reached prematurely");
        }
        if (c >= 48 && c <= 57 || c == 45) {
            return this.readNumber(c);
        }
        return JsonParser.error("Unknown JSON value type");
    }

    private Object readArray(JsonObject object) {
        ArrayList<Object> array = new ArrayList<Object>();
        while (true) {
            this.skipWhitespace();
            Object o = this.readValue(object);
            if (!DefaultGroovyMethods.is((Object)EMPTY_ARRAY, (Object)o)) {
                array.add(o);
            }
            int c = this.skipWhitespaceRead();
            if (c == 93) break;
            if (!(c != 44)) continue;
            JsonParser.error("Expected ',' or ']' inside array");
        }
        return array.toArray();
    }

    private void readToken(String token) {
        int len = token.length();
        int i = 0;
        while (i < len) {
            int c = this.input.read();
            if (ScriptBytecodeAdapter.compareEqual((Object)c, (Object)-1)) {
                JsonParser.error(StringGroovyMethods.plus((String)"EOF reached while reading token: ", (CharSequence)token));
            }
            char c2 = Character.toLowerCase((char)c);
            c = c2;
            char loTokenChar = token.charAt(i);
            if (loTokenChar != c) {
                JsonParser.error(StringGroovyMethods.plus((String)"Expected token: ", (CharSequence)token));
            }
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
    }

    private Number readNumber(int c) {
        FastPushbackReader inp = this.input;
        char[] buffer = this.numBuf;
        char c2 = (char)c;
        BytecodeInterface8.cArraySet((char[])buffer, (int)0, (char)c2);
        int len = 1;
        boolean isFloat = false;
        try {
            while (true) {
                int n;
                c = n = inp.read();
                if (c >= 48 && c <= 57 || c == 45 || c == 43) {
                    char c3 = (char)c;
                    int n2 = len;
                    int cfr_ignored_0 = n2 + 1;
                    BytecodeInterface8.cArraySet((char[])buffer, (int)n2, (char)c3);
                    continue;
                }
                if (c == 46 || c == 101 || c == 69) {
                    boolean bl;
                    char c4 = (char)c;
                    int n3 = len;
                    int cfr_ignored_1 = n3 + 1;
                    BytecodeInterface8.cArraySet((char[])buffer, (int)n3, (char)c4);
                    isFloat = bl = true;
                    continue;
                }
                if (!ScriptBytecodeAdapter.compareEqual((Object)c, (Object)-1)) {
                    inp.unread(c);
                }
                break;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            JsonParser.error(StringGroovyMethods.plus((String)"Too many digits in number: ", (CharSequence)new String(buffer)));
        }
        if (isFloat) {
            String num = new String(buffer, 0, len);
            Double d = Double.parseDouble(num);
            try {
                return d;
            }
            catch (NumberFormatException e) {
                JsonParser.error(StringGroovyMethods.plus((String)"Invalid floating point number: ", (CharSequence)num), e);
            }
        }
        boolean isNeg = BytecodeInterface8.cArrayGet((char[])buffer, (int)0) == '-';
        long n = 0L;
        int i = isNeg ? 1 : 0;
        while (i < len) {
            Number number = NumberNumberPlus.plus((Number)DefaultGroovyMethods.minus((Character)Character.valueOf(BytecodeInterface8.cArrayGet((char[])buffer, (int)i)), (Character)Character.valueOf('0')), (Number)(n * (long)10));
            n = DefaultTypeTransformation.longUnbox((Object)number);
            int n4 = i;
            int cfr_ignored_2 = n4 + 1;
        }
        return isNeg ? -n : n;
    }

    private String readString() {
        StringBuilder str = this.strBuf;
        int n = 0;
        str.setLength(n);
        boolean done = false;
        int state = STATE_STRING_START;
        while (!done) {
            Integer n2;
            int c = this.input.read();
            if (ScriptBytecodeAdapter.compareEqual((Object)c, (Object)-1)) {
                JsonParser.error("EOF reached while reading JSON string");
            }
            if (ScriptBytecodeAdapter.isCase((Object)(n2 = Integer.valueOf(state)), (Object)STATE_STRING_START)) {
                if (c == 34) {
                    boolean bl;
                    done = bl = true;
                    continue;
                }
                if (c == 92) {
                    int n3;
                    state = n3 = STATE_STRING_SLASH;
                    continue;
                }
                str.appendCodePoint(c);
                continue;
            }
            if (ScriptBytecodeAdapter.isCase((Object)n2, (Object)STATE_STRING_SLASH)) {
                int n4;
                Character c2 = Character.valueOf((char)c);
                if (ScriptBytecodeAdapter.isCase((Object)c2, (Object)"\\")) {
                    str.append("\\");
                } else if (ScriptBytecodeAdapter.isCase((Object)c2, (Object)"/")) {
                    str.append("/");
                } else if (ScriptBytecodeAdapter.isCase((Object)c2, (Object)"\"")) {
                    str.append("\"");
                } else if (ScriptBytecodeAdapter.isCase((Object)c2, (Object)"'")) {
                    str.append("'");
                } else if (ScriptBytecodeAdapter.isCase((Object)c2, (Object)"b")) {
                    str.append("\b");
                } else if (ScriptBytecodeAdapter.isCase((Object)c2, (Object)"f")) {
                    str.append("\f");
                } else if (ScriptBytecodeAdapter.isCase((Object)c2, (Object)"n")) {
                    str.append("\n");
                } else if (ScriptBytecodeAdapter.isCase((Object)c2, (Object)"r")) {
                    str.append("\r");
                } else if (ScriptBytecodeAdapter.isCase((Object)c2, (Object)"t")) {
                    str.append("\t");
                } else if (ScriptBytecodeAdapter.isCase((Object)c2, (Object)"u")) {
                    int n5;
                    state = n5 = STATE_HEX_DIGITS_START;
                } else {
                    JsonParser.error(StringGroovyMethods.plus((CharSequence)"Invalid character escape sequence specified: ", (Object)c));
                }
                if (!(c != 117)) continue;
                state = n4 = STATE_STRING_START;
                continue;
            }
            if (ScriptBytecodeAdapter.isCase((Object)n2, (Object)STATE_HEX_DIGITS_START)) {
                int n6;
                int n7 = 0;
                this.hexBuf.setLength(n7);
                state = n6 = STATE_HEX_DIGITS;
            } else if (!ScriptBytecodeAdapter.isCase((Object)n2, (Object)STATE_HEX_DIGITS)) continue;
            Character c3 = Character.valueOf((char)c);
            if (ScriptBytecodeAdapter.isCase((Object)c3, (Object)"0") || ScriptBytecodeAdapter.isCase((Object)c3, (Object)"1") || ScriptBytecodeAdapter.isCase((Object)c3, (Object)"2") || ScriptBytecodeAdapter.isCase((Object)c3, (Object)"3") || ScriptBytecodeAdapter.isCase((Object)c3, (Object)"4") || ScriptBytecodeAdapter.isCase((Object)c3, (Object)"5") || ScriptBytecodeAdapter.isCase((Object)c3, (Object)"6") || ScriptBytecodeAdapter.isCase((Object)c3, (Object)"7") || ScriptBytecodeAdapter.isCase((Object)c3, (Object)"8") || ScriptBytecodeAdapter.isCase((Object)c3, (Object)"9") || ScriptBytecodeAdapter.isCase((Object)c3, (Object)"A") || ScriptBytecodeAdapter.isCase((Object)c3, (Object)"B") || ScriptBytecodeAdapter.isCase((Object)c3, (Object)"C") || ScriptBytecodeAdapter.isCase((Object)c3, (Object)"D") || ScriptBytecodeAdapter.isCase((Object)c3, (Object)"E") || ScriptBytecodeAdapter.isCase((Object)c3, (Object)"F") || ScriptBytecodeAdapter.isCase((Object)c3, (Object)"a") || ScriptBytecodeAdapter.isCase((Object)c3, (Object)"b") || ScriptBytecodeAdapter.isCase((Object)c3, (Object)"c") || ScriptBytecodeAdapter.isCase((Object)c3, (Object)"d") || ScriptBytecodeAdapter.isCase((Object)c3, (Object)"e") || ScriptBytecodeAdapter.isCase((Object)c3, (Object)"f")) {
                int n8;
                this.hexBuf.append((char)c);
                if (!(this.hexBuf.length() == 4)) continue;
                int value = Integer.parseInt(this.hexBuf.toString(), 16);
                str.append(MetaUtils.valueOf((char)value));
                state = n8 = STATE_STRING_START;
                continue;
            }
            JsonParser.error("Expected hexadecimal digits");
        }
        String s = str.toString();
        String cacheHit = ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt(stringCache, (Object)s));
        return cacheHit == null ? s : cacheHit;
    }

    private int skipWhitespaceRead() {
        FastPushbackReader inp = this.input;
        int c = inp.read();
        while (true) {
            int n;
            Character c2 = Character.valueOf((char)c);
            if (!(ScriptBytecodeAdapter.isCase((Object)c2, (Object)"\t") || ScriptBytecodeAdapter.isCase((Object)c2, (Object)"\n") || ScriptBytecodeAdapter.isCase((Object)c2, (Object)"\r") || ScriptBytecodeAdapter.isCase((Object)c2, (Object)" "))) {
                return c;
            }
            c = n = inp.read();
        }
        return DefaultTypeTransformation.intUnbox(null);
    }

    private void skipWhitespace() {
        this.input.unread(this.skipWhitespaceRead());
    }

    public static Object error(String msg) {
        return MetaUtils.error(msg);
    }

    public static Object error(String msg, Exception e) {
        return MetaUtils.error(msg, e);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != JsonParser.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Map map;
        stringCache = map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"", "", "true", "true", "True", "True", "TRUE", "TRUE", "false", "false", "False", "False", "FALSE", "FALSE", "null", "null", "yes", "yes", "Yes", "Yes", "YES", "YES", "no", "no", "No", "No", "NO", "NO", "on", "on", "On", "On", "ON", "ON", "off", "off", "Off", "Off", "OFF", "OFF", "@id", "@id", "@ref", "@ref", "@items", "@items", "@type", "@type", "@keys", "@keys", "0", "0", "1", "1", "2", "2", "3", "3", "4", "4", "5", "5", "6", "6", "7", "7", "8", "8", "9", "9"});
    }

    public static final String getEMPTY_OBJECT() {
        return EMPTY_OBJECT;
    }
}

