/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.cache;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class ThreadedLRUCacheStrategy<K, V>
implements Map<K, V> {
    private static final Object NULL_ITEM = new Object();
    private final long cleanupDelayMillis;
    private final int capacity;
    private final ConcurrentMap<Object, Node<K>> cache;
    private final AtomicBoolean cleanupScheduled = new AtomicBoolean(false);
    private final ScheduledExecutorService scheduler;
    private final ForkJoinPool cleanupPool;
    private final boolean isDefaultScheduler;

    public ThreadedLRUCacheStrategy(int capacity, int cleanupDelayMillis, ScheduledExecutorService scheduler, ForkJoinPool cleanupPool) {
        this.isDefaultScheduler = scheduler == null;
        this.scheduler = this.isDefaultScheduler ? Executors.newScheduledThreadPool(1) : scheduler;
        this.cleanupPool = cleanupPool == null ? ForkJoinPool.commonPool() : cleanupPool;
        this.capacity = capacity;
        this.cache = new ConcurrentHashMap<Object, Node<K>>(capacity);
        this.cleanupDelayMillis = cleanupDelayMillis;
    }

    private void cleanup() {
        int size = this.cache.size();
        if (size > this.capacity) {
            Node[] nodes = this.cache.values().toArray(new Node[0]);
            Arrays.sort(nodes, Comparator.comparingLong(node -> node.timestamp));
            int nodesToRemove = size - this.capacity;
            for (int i = 0; i < nodesToRemove; ++i) {
                Node node2 = nodes[i];
                this.cache.remove(this.toCacheItem(node2.key), node2);
            }
        }
        this.cleanupScheduled.set(false);
        if (this.cache.size() > this.capacity) {
            this.scheduleCleanup();
        }
    }

    @Override
    public V get(Object key) {
        Object cacheKey = this.toCacheItem(key);
        Node node = (Node)this.cache.get(cacheKey);
        if (node != null) {
            node.updateTimestamp();
            return (V)this.fromCacheItem(node.value);
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        Object cacheValue;
        Node<K> newNode;
        Object cacheKey = this.toCacheItem(key);
        Node<K> oldNode = this.cache.put(cacheKey, newNode = new Node<K>(key, cacheValue = this.toCacheItem(value)));
        if (oldNode != null) {
            newNode.updateTimestamp();
            return (V)this.fromCacheItem(oldNode.value);
        }
        if (this.size() > this.capacity) {
            this.scheduleCleanup();
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    @Override
    public V remove(Object key) {
        Object cacheKey = this.toCacheItem(key);
        Node node = (Node)this.cache.remove(cacheKey);
        if (node != null) {
            return (V)this.fromCacheItem(node.value);
        }
        return null;
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.cache.containsKey(this.toCacheItem(key));
    }

    @Override
    public boolean containsValue(Object value) {
        Object cacheValue = this.toCacheItem(value);
        for (Node node : this.cache.values()) {
            if (!node.value.equals(cacheValue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> entrySet = Collections.newSetFromMap(new ConcurrentHashMap());
        for (Node node : this.cache.values()) {
            entrySet.add(new AbstractMap.SimpleEntry(this.fromCacheItem(node.key), this.fromCacheItem(node.value)));
        }
        return entrySet;
    }

    @Override
    public Set<K> keySet() {
        Set keySet = Collections.newSetFromMap(new ConcurrentHashMap());
        for (Node node : this.cache.values()) {
            keySet.add(this.fromCacheItem(node.key));
        }
        return Collections.unmodifiableSet(keySet);
    }

    @Override
    public Collection<V> values() {
        ArrayList values = new ArrayList();
        for (Node node : this.cache.values()) {
            values.add(this.fromCacheItem(node.value));
        }
        return Collections.unmodifiableCollection(values);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map other = (Map)o;
        return this.entrySet().equals(other.entrySet());
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (Node node : this.cache.values()) {
            Object key = this.fromCacheItem(node.key);
            Object value = this.fromCacheItem(node.value);
            hashCode = 31 * hashCode + (key == null ? 0 : key.hashCode());
            hashCode = 31 * hashCode + (value == null ? 0 : value.hashCode());
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (Node node : this.cache.values()) {
            sb.append(this.fromCacheItem(node.key)).append("=").append(this.fromCacheItem(node.value)).append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append("}");
        return sb.toString();
    }

    private void scheduleCleanup() {
        if (this.cleanupScheduled.compareAndSet(false, true)) {
            this.scheduler.schedule(() -> this.cleanupPool.execute(this::cleanup), this.cleanupDelayMillis, TimeUnit.MILLISECONDS);
        }
    }

    private Object toCacheItem(Object item) {
        return item == null ? NULL_ITEM : item;
    }

    private <T> T fromCacheItem(Object cacheItem) {
        return (T)(cacheItem == NULL_ITEM ? null : cacheItem);
    }

    public void shutdown() {
        if (this.isDefaultScheduler) {
            this.scheduler.shutdown();
            try {
                if (!this.scheduler.awaitTermination(1L, TimeUnit.SECONDS)) {
                    this.scheduler.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.scheduler.shutdownNow();
            }
        }
    }

    private static class Node<K> {
        final K key;
        volatile Object value;
        volatile long timestamp;

        Node(K key, Object value) {
            this.key = key;
            this.value = value;
            this.timestamp = System.nanoTime();
        }

        void updateTimestamp() {
            this.timestamp = System.nanoTime();
        }
    }
}

