/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.Convention;
import com.cedarsoftware.util.StringUtilities;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DateUtilities {
    private static final Pattern allDigits = Pattern.compile("^\\d+$");
    private static final String days = "monday|mon|tuesday|tues|tue|wednesday|wed|thursday|thur|thu|friday|fri|saturday|sat|sunday|sun";
    private static final String mos = "January|Jan|February|Feb|March|Mar|April|Apr|May|June|Jun|July|Jul|August|Aug|September|Sept|Sep|October|Oct|November|Nov|December|Dec";
    private static final String yr = "\\d{4}";
    private static final String d1or2 = "\\d{1,2}";
    private static final String d2 = "\\d{2}";
    private static final String ord = "st|nd|rd|th";
    private static final String sep = "[./-]";
    private static final String ws = "\\s+";
    private static final String wsOp = "\\s*";
    private static final String wsOrComma = "[ ,]+";
    private static final String tzUnix = "[A-Z]{1,3}";
    private static final String tz_Hh_MM = "[+-]\\d{1,2}:\\d{2}";
    private static final String tz_HHMM = "[+-]\\d{4}";
    private static final String tz_Hh = "[+-]\\d{1,2}";
    private static final String tzNamed = "\\s*\\[?[A-Za-z][A-Za-z0-9~\\/._+-]+]?";
    private static final String nano = "\\.\\d+";
    private static final Pattern isoDatePattern = Pattern.compile("(\\d{4})([./-])(\\d{1,2})\\2(\\d{1,2})|(\\d{1,2})([./-])(\\d{1,2})\\6(\\d{4})");
    private static final Pattern alphaMonthPattern = Pattern.compile("\\b(January|Jan|February|Feb|March|Mar|April|Apr|May|June|Jun|July|Jul|August|Aug|September|Sept|Sep|October|Oct|November|Nov|December|Dec)\\b[ ,]+(\\d{1,2})(st|nd|rd|th)?[ ,]+(\\d{4})|(\\d{1,2})(st|nd|rd|th)?[ ,]+\\b(January|Jan|February|Feb|March|Mar|April|Apr|May|June|Jun|July|Jul|August|Aug|September|Sept|Sep|October|Oct|November|Nov|December|Dec)\\b[ ,]+(\\d{4})|(\\d{4})[ ,]+\\b(January|Jan|February|Feb|March|Mar|April|Apr|May|June|Jun|July|Jul|August|Aug|September|Sept|Sep|October|Oct|November|Nov|December|Dec\\b)[ ,]+(\\d{1,2})(st|nd|rd|th)?", 2);
    private static final Pattern unixDateTimePattern = Pattern.compile("\\b(monday|mon|tuesday|tues|tue|wednesday|wed|thursday|thur|thu|friday|fri|saturday|sat|sunday|sun)\\b\\s+\\b(January|Jan|February|Feb|March|Mar|April|Apr|May|June|Jun|July|Jul|August|Aug|September|Sept|Sep|October|Oct|November|Nov|December|Dec)\\b\\s+(\\d{1,2})\\s+(\\d{2}:\\d{2}:\\d{2})\\s*([A-Z]{1,3})?\\s*(\\d{4})", 2);
    private static final Pattern timePattern = Pattern.compile("(\\d{2}):(\\d{2})(?::(\\d{2})(\\.\\d+)?)?([+-]\\d{1,2}:\\d{2}|[+-]\\d{4}|[+-]\\d{1,2}|Z)?(\\s*\\[?[A-Za-z][A-Za-z0-9~\\/._+-]+]?)?", 2);
    private static final Pattern dayPattern = Pattern.compile("\\b(monday|mon|tuesday|tues|tue|wednesday|wed|thursday|thur|thu|friday|fri|saturday|sat|sunday|sun)\\b", 2);
    private static final Map<String, Integer> months = new ConcurrentHashMap<String, Integer>();

    private DateUtilities() {
    }

    public static Date parseDate(String dateStr) {
        if (StringUtilities.isWhitespace(dateStr)) {
            return null;
        }
        ZonedDateTime dateTime = DateUtilities.parseDate(dateStr, ZoneId.systemDefault(), true);
        Instant instant = Instant.from(dateTime);
        Date date = Date.from(instant);
        return date;
    }

    public static ZonedDateTime parseDate(String dateStr, ZoneId defaultZoneId, boolean ensureDateTimeAlone) {
        String remains;
        String day;
        int month;
        String year;
        Convention.throwIfNullOrEmpty(dateStr, "'dateStr' must not be null or empty String.");
        Convention.throwIfNull(defaultZoneId, "ZoneId cannot be null.  Use ZoneId.of(\"America/New_York\"), ZoneId.systemDefault(), etc.");
        dateStr = dateStr.trim();
        if (allDigits.matcher(dateStr).matches()) {
            return Instant.ofEpochMilli(Long.parseLong(dateStr)).atZone(defaultZoneId);
        }
        String tz = null;
        Matcher matcher = isoDatePattern.matcher(dateStr);
        String remnant = matcher.replaceFirst("");
        if (remnant.length() < dateStr.length()) {
            if (matcher.group(1) != null) {
                year = matcher.group(1);
                month = Integer.parseInt(matcher.group(3));
                day = matcher.group(4);
            } else {
                year = matcher.group(8);
                month = Integer.parseInt(matcher.group(5));
                day = matcher.group(7);
            }
            remains = remnant;
        } else {
            String mon;
            matcher = alphaMonthPattern.matcher(dateStr);
            remnant = matcher.replaceFirst("");
            if (remnant.length() < dateStr.length()) {
                if (matcher.group(1) != null) {
                    mon = matcher.group(1);
                    day = matcher.group(2);
                    year = matcher.group(4);
                    remains = remnant;
                } else if (matcher.group(7) != null) {
                    mon = matcher.group(7);
                    day = matcher.group(5);
                    year = matcher.group(8);
                    remains = remnant;
                } else {
                    year = matcher.group(9);
                    mon = matcher.group(10);
                    day = matcher.group(11);
                    remains = remnant;
                }
                month = months.get(mon.trim().toLowerCase());
            } else {
                matcher = unixDateTimePattern.matcher(dateStr);
                if (matcher.replaceFirst("").length() == dateStr.length()) {
                    throw new IllegalArgumentException("Unable to parse: " + dateStr + " as a date");
                }
                year = matcher.group(6);
                mon = matcher.group(2);
                month = months.get(mon.trim().toLowerCase());
                day = matcher.group(3);
                tz = matcher.group(5);
                remains = matcher.group(4);
            }
        }
        String hour = null;
        String min = null;
        String sec = "00";
        String fracSec = "0";
        remains = remains.trim();
        matcher = timePattern.matcher(remains);
        remnant = matcher.replaceFirst("");
        if (remnant.length() < remains.length()) {
            hour = matcher.group(1);
            min = matcher.group(2);
            if (matcher.group(3) != null) {
                sec = matcher.group(3);
            }
            if (matcher.group(4) != null) {
                fracSec = "0" + matcher.group(4);
            }
            if (matcher.group(5) != null) {
                tz = matcher.group(5).trim();
            }
            if (matcher.group(6) != null) {
                tz = DateUtilities.stripBrackets(matcher.group(6).trim());
            }
        }
        if (ensureDateTimeAlone) {
            DateUtilities.verifyNoGarbageLeft(remnant);
        }
        ZoneId zoneId = StringUtilities.isEmpty(tz) ? defaultZoneId : DateUtilities.getTimeZone(tz);
        ZonedDateTime dateTime = DateUtilities.getDate(dateStr, zoneId, year, month, day, hour, min, sec, fracSec);
        return dateTime;
    }

    private static ZonedDateTime getDate(String dateStr, ZoneId zoneId, String year, int month, String day, String hour, String min, String sec, String fracSec) {
        int y = Integer.parseInt(year);
        int d = Integer.parseInt(day);
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("Month must be between 1 and 12 inclusive, date: " + dateStr);
        }
        if (d < 1 || d > 31) {
            throw new IllegalArgumentException("Day must be between 1 and 31 inclusive, date: " + dateStr);
        }
        if (hour == null) {
            return ZonedDateTime.of(y, month, d, 0, 0, 0, 0, zoneId);
        }
        int h = Integer.parseInt(hour);
        int mn = Integer.parseInt(min);
        int s = Integer.parseInt(sec);
        long nanoOfSec = DateUtilities.convertFractionToNanos(fracSec);
        if (h > 23) {
            throw new IllegalArgumentException("Hour must be between 0 and 23 inclusive, time: " + dateStr);
        }
        if (mn > 59) {
            throw new IllegalArgumentException("Minute must be between 0 and 59 inclusive, time: " + dateStr);
        }
        if (s > 59) {
            throw new IllegalArgumentException("Second must be between 0 and 59 inclusive, time: " + dateStr);
        }
        return ZonedDateTime.of(y, month, d, h, mn, s, (int)nanoOfSec, zoneId);
    }

    private static long convertFractionToNanos(String fracSec) {
        double fractionalSecond = Double.parseDouble(fracSec);
        return (long)(fractionalSecond * 1.0E9);
    }

    private static ZoneId getTimeZone(String tz) {
        if (tz != null) {
            if (tz.startsWith("-") || tz.startsWith("+")) {
                ZoneOffset offset = ZoneOffset.of(tz);
                return ZoneId.ofOffset("GMT", offset);
            }
            try {
                return ZoneId.of(tz);
            }
            catch (Exception e) {
                TimeZone timeZone = TimeZone.getTimeZone(tz);
                if (timeZone.getRawOffset() == 0) {
                    throw e;
                }
                return timeZone.toZoneId();
            }
        }
        return ZoneId.systemDefault();
    }

    private static void verifyNoGarbageLeft(String remnant) {
        if (StringUtilities.length(remnant) > 0) {
            Matcher dayMatcher = dayPattern.matcher(remnant);
            remnant = dayMatcher.replaceFirst("").trim();
        }
        if (StringUtilities.length(remnant) > 0 && !(remnant = remnant.replaceAll("T|,", "").trim()).isEmpty()) {
            throw new IllegalArgumentException("Issue parsing date-time, other characters present: " + remnant);
        }
    }

    private static String stripBrackets(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        return input.replaceAll("^\\[|\\]$", "");
    }

    static {
        months.put("jan", 1);
        months.put("january", 1);
        months.put("feb", 2);
        months.put("february", 2);
        months.put("mar", 3);
        months.put("march", 3);
        months.put("apr", 4);
        months.put("april", 4);
        months.put("may", 5);
        months.put("jun", 6);
        months.put("june", 6);
        months.put("jul", 7);
        months.put("july", 7);
        months.put("aug", 8);
        months.put("august", 8);
        months.put("sep", 9);
        months.put("sept", 9);
        months.put("september", 9);
        months.put("oct", 10);
        months.put("october", 10);
        months.put("nov", 11);
        months.put("november", 11);
        months.put("dec", 12);
        months.put("december", 12);
    }
}

