/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.CompactLinkedMap;
import com.cedarsoftware.util.convert.BigDecimalConversions;
import com.cedarsoftware.util.convert.CalendarConversions;
import com.cedarsoftware.util.convert.Converter;
import com.cedarsoftware.util.convert.InstantConversions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

final class DateConversions {
    private DateConversions() {
    }

    static ZonedDateTime toZonedDateTime(Object from, Converter converter) {
        java.util.Date date = (java.util.Date)from;
        return Instant.ofEpochMilli(date.getTime()).atZone(converter.getOptions().getZoneId());
    }

    static long toLong(Object from, Converter converter) {
        return ((java.util.Date)from).getTime();
    }

    static double toDouble(Object from, Converter converter) {
        java.util.Date date = (java.util.Date)from;
        return (double)date.getTime() / 1000.0;
    }

    static Date toSqlDate(Object from, Converter converter) {
        return new Date(DateConversions.toLong(from, converter));
    }

    static java.util.Date toDate(Object from, Converter converter) {
        return new java.util.Date(DateConversions.toLong(from, converter));
    }

    static Timestamp toTimestamp(Object from, Converter converter) {
        return new Timestamp(DateConversions.toLong(from, converter));
    }

    static Calendar toCalendar(Object from, Converter converter) {
        return CalendarConversions.create(DateConversions.toLong(from, converter), converter);
    }

    static BigDecimal toBigDecimal(Object from, Converter converter) {
        java.util.Date date = (java.util.Date)from;
        long epochMillis = date.getTime();
        return new BigDecimal(epochMillis).divide(BigDecimalConversions.GRAND, 9, RoundingMode.DOWN);
    }

    static Instant toInstant(Object from, Converter converter) {
        java.util.Date date = (java.util.Date)from;
        if (date instanceof Date) {
            return new java.util.Date(date.getTime()).toInstant();
        }
        return date.toInstant();
    }

    static OffsetDateTime toOffsetDateTime(Object from, Converter converter) {
        return DateConversions.toInstant(from, converter).atZone(converter.getOptions().getZoneId()).toOffsetDateTime();
    }

    static LocalDateTime toLocalDateTime(Object from, Converter converter) {
        return DateConversions.toZonedDateTime(from, converter).toLocalDateTime();
    }

    static LocalDate toLocalDate(Object from, Converter converter) {
        return DateConversions.toZonedDateTime(from, converter).toLocalDate();
    }

    static LocalTime toLocalTime(Object from, Converter converter) {
        Instant instant = DateConversions.toInstant(from, converter);
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, converter.getOptions().getZoneId());
        return localDateTime.toLocalTime();
    }

    static BigInteger toBigInteger(Object from, Converter converter) {
        Instant instant = DateConversions.toInstant(from, converter);
        return InstantConversions.toBigInteger(instant, converter);
    }

    static AtomicLong toAtomicLong(Object from, Converter converter) {
        return new AtomicLong(DateConversions.toLong(from, converter));
    }

    static String sqlDateToString(Object from, Converter converter) {
        Date sqlDate = (Date)from;
        return DateConversions.toString(new java.util.Date(sqlDate.getTime()), converter);
    }

    static String toString(Object from, Converter converter) {
        java.util.Date date = (java.util.Date)from;
        ZonedDateTime zonedDateTime = date.toInstant().atZone(converter.getOptions().getZoneId());
        DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss.SSS").appendOffset("+HH:MM", "Z").toFormatter();
        return zonedDateTime.format(formatter);
    }

    static Map<String, Object> toMap(Object from, Converter converter) {
        java.util.Date date = (java.util.Date)from;
        CompactLinkedMap<String, Object> map = new CompactLinkedMap<String, Object>();
        ZonedDateTime zdt = DateConversions.toZonedDateTime(date, converter);
        map.put("date", zdt.toLocalDate().toString());
        map.put("time", zdt.toLocalTime().toString());
        map.put("zone", converter.getOptions().getZoneId().toString());
        map.put("epochMillis", date.getTime());
        return map;
    }
}

