/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.CompactMap;
import com.cedarsoftware.util.convert.Converter;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Map;
import java.util.TimeZone;

final class ZoneOffsetConversions {
    private ZoneOffsetConversions() {
    }

    static Map<String, Object> toMap(Object from, Converter converter) {
        ZoneOffset offset = (ZoneOffset)from;
        CompactMap<String, Object> target = CompactMap.builder().insertionOrder().build();
        int totalSeconds = offset.getTotalSeconds();
        int hours = totalSeconds / 3600;
        int minutes = totalSeconds % 3600 / 60;
        int seconds = totalSeconds % 60;
        target.put("hours", hours);
        target.put("minutes", minutes);
        if (seconds != 0) {
            target.put("seconds", seconds);
        }
        return target;
    }

    static ZoneId toZoneId(Object from, Converter converter) {
        return (ZoneId)from;
    }

    static TimeZone toTimeZone(Object from, Converter converter) {
        ZoneOffset offset = (ZoneOffset)from;
        String id = offset.equals(ZoneOffset.UTC) ? "GMT" : "GMT" + offset.getId();
        return TimeZone.getTimeZone(id);
    }
}

