/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.CompactMap;
import com.cedarsoftware.util.Convention;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class CompactSet<E>
implements Set<E> {
    private static final Object PRESENT = new Object();
    private final CompactMap<E, Object> map;

    public CompactSet() {
        CompactMap defaultMap = CompactMap.builder().compactSize(this.compactSize()).caseSensitive(!this.isCaseInsensitive()).build();
        if (defaultMap.compactSize() < 2) {
            throw new IllegalStateException("compactSize() must be >= 2");
        }
        this.map = defaultMap;
    }

    protected CompactSet(CompactMap<E, Object> map) {
        if (map.compactSize() < 2) {
            throw new IllegalStateException("compactSize() must be >= 2");
        }
        this.map = map;
    }

    public CompactSet(Collection<? extends E> c) {
        this();
        this.addAll(c);
    }

    public boolean isDefaultCompactSet() {
        if (this.map.compactSize() != 40) {
            return false;
        }
        if (this.map.isCaseInsensitive()) {
            return false;
        }
        if (!"unordered".equals(this.map.getOrdering())) {
            return false;
        }
        if (!"id".equals(this.map.getSingleValueKey())) {
            return false;
        }
        return HashMap.class.equals(this.map.getNewMap().getClass());
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean add(E e) {
        return this.map.put(e, PRESENT) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) != null;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.map.keySet().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean modified = false;
        for (E e : c) {
            if (!this.add(e)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.map.keySet().retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.map.keySet().removeAll(c);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.map.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.map.keySet().toArray(a);
    }

    @Override
    public boolean equals(Object o) {
        return this.map.keySet().equals(o);
    }

    @Override
    public int hashCode() {
        return this.map.keySet().hashCode();
    }

    public String toString() {
        return this.map.keySet().toString();
    }

    public static <E> Builder<E> builder() {
        return new Builder();
    }

    protected int compactSize() {
        return 40;
    }

    protected boolean isCaseInsensitive() {
        return false;
    }

    protected Set<E> getNewSet() {
        return null;
    }

    public Map<String, Object> getConfig() {
        Map<String, Object> mapConfig = this.map.getConfig();
        LinkedHashMap<String, Object> setConfig = new LinkedHashMap<String, Object>();
        setConfig.put("compactSize", mapConfig.get("compactSize"));
        setConfig.put("caseSensitive", mapConfig.get("caseSensitive"));
        setConfig.put("ordering", mapConfig.get("ordering"));
        return Collections.unmodifiableMap(setConfig);
    }

    public CompactSet<E> withConfig(Map<String, Object> config) {
        Convention.throwIfNull(config, "config cannot be null");
        Builder<E> builder = CompactSet.builder();
        Map<String, Object> currentConfig = this.map.getConfig();
        Integer configCompactSize = (Integer)config.get("compactSize");
        Integer currentCompactSize = (Integer)currentConfig.get("compactSize");
        int compactSizeToUse = configCompactSize != null ? configCompactSize : currentCompactSize;
        builder.compactSize(compactSizeToUse);
        Boolean configCaseSensitive = (Boolean)config.get("caseSensitive");
        Boolean currentCaseSensitive = (Boolean)currentConfig.get("caseSensitive");
        boolean caseSensitiveToUse = configCaseSensitive != null ? configCaseSensitive : currentCaseSensitive;
        builder.caseSensitive(caseSensitiveToUse);
        String configOrdering = (String)config.get("ordering");
        String currentOrdering = (String)currentConfig.get("ordering");
        String orderingToUse = configOrdering != null ? configOrdering : currentOrdering;
        this.applyOrdering(builder, orderingToUse);
        CompactSet<E> newSet = builder.build();
        newSet.addAll(this);
        return newSet;
    }

    private void applyOrdering(Builder<E> builder, String ordering) {
        if (ordering == null) {
            builder.noOrder();
            return;
        }
        switch (ordering) {
            case "sorted": {
                builder.sortedOrder();
                break;
            }
            case "reverse": {
                builder.reverseOrder();
                break;
            }
            case "insertion": {
                builder.insertionOrder();
                break;
            }
            default: {
                builder.noOrder();
            }
        }
    }

    public static final class Builder<E> {
        private final CompactMap.Builder<E, Object> mapBuilder = CompactMap.builder();

        private Builder() {
        }

        public Builder<E> caseSensitive(boolean caseSensitive) {
            this.mapBuilder.caseSensitive(caseSensitive);
            return this;
        }

        public Builder<E> compactSize(int size) {
            this.mapBuilder.compactSize(size);
            return this;
        }

        public Builder<E> sortedOrder() {
            this.mapBuilder.sortedOrder();
            return this;
        }

        public Builder<E> reverseOrder() {
            this.mapBuilder.reverseOrder();
            return this;
        }

        public Builder<E> insertionOrder() {
            this.mapBuilder.insertionOrder();
            return this;
        }

        public Builder<E> noOrder() {
            this.mapBuilder.noOrder();
            return this;
        }

        public CompactSet<E> build() {
            CompactMap<E, Object> builtMap = this.mapBuilder.build();
            return new CompactSet<E>(builtMap);
        }
    }
}

