/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.ClassUtilities;
import com.cedarsoftware.util.ClassValueMap;
import com.cedarsoftware.util.convert.ArrayConversions;
import com.cedarsoftware.util.convert.AtomicBooleanConversions;
import com.cedarsoftware.util.convert.AtomicIntegerConversions;
import com.cedarsoftware.util.convert.AtomicLongConversions;
import com.cedarsoftware.util.convert.BigDecimalConversions;
import com.cedarsoftware.util.convert.BigIntegerConversions;
import com.cedarsoftware.util.convert.BooleanConversions;
import com.cedarsoftware.util.convert.ByteArrayConversions;
import com.cedarsoftware.util.convert.ByteBufferConversions;
import com.cedarsoftware.util.convert.ByteConversions;
import com.cedarsoftware.util.convert.CalendarConversions;
import com.cedarsoftware.util.convert.CharArrayConversions;
import com.cedarsoftware.util.convert.CharBufferConversions;
import com.cedarsoftware.util.convert.CharacterArrayConversions;
import com.cedarsoftware.util.convert.CharacterConversions;
import com.cedarsoftware.util.convert.ClassConversions;
import com.cedarsoftware.util.convert.CollectionConversions;
import com.cedarsoftware.util.convert.CollectionHandling;
import com.cedarsoftware.util.convert.Convert;
import com.cedarsoftware.util.convert.ConverterOptions;
import com.cedarsoftware.util.convert.CurrencyConversions;
import com.cedarsoftware.util.convert.DateConversions;
import com.cedarsoftware.util.convert.DoubleConversions;
import com.cedarsoftware.util.convert.DurationConversions;
import com.cedarsoftware.util.convert.EnumConversions;
import com.cedarsoftware.util.convert.InstantConversions;
import com.cedarsoftware.util.convert.LocalDateConversions;
import com.cedarsoftware.util.convert.LocalDateTimeConversions;
import com.cedarsoftware.util.convert.LocalTimeConversions;
import com.cedarsoftware.util.convert.LocaleConversions;
import com.cedarsoftware.util.convert.MapConversions;
import com.cedarsoftware.util.convert.MonthDayConversions;
import com.cedarsoftware.util.convert.NumberConversions;
import com.cedarsoftware.util.convert.OffsetDateTimeConversions;
import com.cedarsoftware.util.convert.OffsetTimeConversions;
import com.cedarsoftware.util.convert.PatternConversions;
import com.cedarsoftware.util.convert.PeriodConversions;
import com.cedarsoftware.util.convert.SqlDateConversions;
import com.cedarsoftware.util.convert.StringBufferConversions;
import com.cedarsoftware.util.convert.StringBuilderConversions;
import com.cedarsoftware.util.convert.StringConversions;
import com.cedarsoftware.util.convert.ThrowableConversions;
import com.cedarsoftware.util.convert.TimeZoneConversions;
import com.cedarsoftware.util.convert.TimestampConversions;
import com.cedarsoftware.util.convert.UUIDConversions;
import com.cedarsoftware.util.convert.UriConversions;
import com.cedarsoftware.util.convert.UrlConversions;
import com.cedarsoftware.util.convert.VoidConversions;
import com.cedarsoftware.util.convert.YearConversions;
import com.cedarsoftware.util.convert.YearMonthConversions;
import com.cedarsoftware.util.convert.ZoneIdConversions;
import com.cedarsoftware.util.convert.ZoneOffsetConversions;
import com.cedarsoftware.util.convert.ZonedDateTimeConversions;
import java.io.Externalizable;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;

public final class Converter {
    private static final Convert<?> UNSUPPORTED = Converter::unsupported;
    static final String VALUE = "_v";
    private static final Map<Class<?>, SortedSet<ClassLevel>> cacheParentTypes = new ClassValueMap<SortedSet<ClassLevel>>();
    private static Map<ConversionPair, Convert<?>> CONVERSION_DB = new HashMap(860, 0.8f);
    private static final Map<ConversionPair, Convert<?>> USER_DB = new ConcurrentHashMap();
    private static final ClassValueMap<ClassValueMap<Convert<?>>> FULL_CONVERSION_CACHE = new ClassValueMap();
    private static final Map<Class<?>, String> CUSTOM_ARRAY_NAMES = new ClassValueMap<String>();
    private final ConverterOptions options;

    public static ConversionPair pair(Class<?> source, Class<?> target) {
        return new ConversionPair(source, target);
    }

    public ConverterOptions getOptions() {
        return this.options;
    }

    private static void buildFactoryConversions() {
        CONVERSION_DB.put(Converter.pair(Byte.class, Number.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(Short.class, Number.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(Integer.class, Number.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(Long.class, Number.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(Float.class, Number.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(Double.class, Number.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(AtomicInteger.class, Number.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(AtomicLong.class, Number.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, Number.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, Number.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(Void.class, Byte.TYPE), NumberConversions::toByteZero);
        CONVERSION_DB.put(Converter.pair(Void.class, Byte.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Byte.class, Byte.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(Short.class, Byte.class), NumberConversions::toByte);
        CONVERSION_DB.put(Converter.pair(Integer.class, Byte.class), NumberConversions::toByte);
        CONVERSION_DB.put(Converter.pair(Long.class, Byte.class), NumberConversions::toByte);
        CONVERSION_DB.put(Converter.pair(Float.class, Byte.class), NumberConversions::toByte);
        CONVERSION_DB.put(Converter.pair(Double.class, Byte.class), NumberConversions::toByte);
        CONVERSION_DB.put(Converter.pair(Boolean.class, Byte.class), BooleanConversions::toByte);
        CONVERSION_DB.put(Converter.pair(Character.class, Byte.class), CharacterConversions::toByte);
        CONVERSION_DB.put(Converter.pair(AtomicBoolean.class, Byte.class), AtomicBooleanConversions::toByte);
        CONVERSION_DB.put(Converter.pair(AtomicInteger.class, Byte.class), NumberConversions::toByte);
        CONVERSION_DB.put(Converter.pair(AtomicLong.class, Byte.class), NumberConversions::toByte);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, Byte.class), NumberConversions::toByte);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, Byte.class), NumberConversions::toByte);
        CONVERSION_DB.put(Converter.pair(Map.class, Byte.class), MapConversions::toByte);
        CONVERSION_DB.put(Converter.pair(String.class, Byte.class), StringConversions::toByte);
        CONVERSION_DB.put(Converter.pair(Void.class, Short.TYPE), NumberConversions::toShortZero);
        CONVERSION_DB.put(Converter.pair(Void.class, Short.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Byte.class, Short.class), NumberConversions::toShort);
        CONVERSION_DB.put(Converter.pair(Short.class, Short.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(Integer.class, Short.class), NumberConversions::toShort);
        CONVERSION_DB.put(Converter.pair(Long.class, Short.class), NumberConversions::toShort);
        CONVERSION_DB.put(Converter.pair(Float.class, Short.class), NumberConversions::toShort);
        CONVERSION_DB.put(Converter.pair(Double.class, Short.class), NumberConversions::toShort);
        CONVERSION_DB.put(Converter.pair(Boolean.class, Short.class), BooleanConversions::toShort);
        CONVERSION_DB.put(Converter.pair(Character.class, Short.class), CharacterConversions::toShort);
        CONVERSION_DB.put(Converter.pair(AtomicBoolean.class, Short.class), AtomicBooleanConversions::toShort);
        CONVERSION_DB.put(Converter.pair(AtomicInteger.class, Short.class), NumberConversions::toShort);
        CONVERSION_DB.put(Converter.pair(AtomicLong.class, Short.class), NumberConversions::toShort);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, Short.class), NumberConversions::toShort);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, Short.class), NumberConversions::toShort);
        CONVERSION_DB.put(Converter.pair(Map.class, Short.class), MapConversions::toShort);
        CONVERSION_DB.put(Converter.pair(String.class, Short.class), StringConversions::toShort);
        CONVERSION_DB.put(Converter.pair(Year.class, Short.class), YearConversions::toShort);
        CONVERSION_DB.put(Converter.pair(Void.class, Integer.TYPE), NumberConversions::toIntZero);
        CONVERSION_DB.put(Converter.pair(Void.class, Integer.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Byte.class, Integer.class), NumberConversions::toInt);
        CONVERSION_DB.put(Converter.pair(Short.class, Integer.class), NumberConversions::toInt);
        CONVERSION_DB.put(Converter.pair(Integer.class, Integer.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(Long.class, Integer.class), NumberConversions::toInt);
        CONVERSION_DB.put(Converter.pair(Float.class, Integer.class), NumberConversions::toInt);
        CONVERSION_DB.put(Converter.pair(Double.class, Integer.class), NumberConversions::toInt);
        CONVERSION_DB.put(Converter.pair(Boolean.class, Integer.class), BooleanConversions::toInt);
        CONVERSION_DB.put(Converter.pair(Character.class, Integer.class), CharacterConversions::toInt);
        CONVERSION_DB.put(Converter.pair(AtomicBoolean.class, Integer.class), AtomicBooleanConversions::toInt);
        CONVERSION_DB.put(Converter.pair(AtomicInteger.class, Integer.class), NumberConversions::toInt);
        CONVERSION_DB.put(Converter.pair(AtomicLong.class, Integer.class), NumberConversions::toInt);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, Integer.class), NumberConversions::toInt);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, Integer.class), NumberConversions::toInt);
        CONVERSION_DB.put(Converter.pair(Map.class, Integer.class), MapConversions::toInt);
        CONVERSION_DB.put(Converter.pair(String.class, Integer.class), StringConversions::toInt);
        CONVERSION_DB.put(Converter.pair(LocalTime.class, Integer.class), LocalTimeConversions::toInteger);
        CONVERSION_DB.put(Converter.pair(OffsetTime.class, Integer.class), OffsetTimeConversions::toInteger);
        CONVERSION_DB.put(Converter.pair(Year.class, Integer.class), YearConversions::toInt);
        CONVERSION_DB.put(Converter.pair(Void.class, Long.TYPE), NumberConversions::toLongZero);
        CONVERSION_DB.put(Converter.pair(Void.class, Long.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Byte.class, Long.class), NumberConversions::toLong);
        CONVERSION_DB.put(Converter.pair(Short.class, Long.class), NumberConversions::toLong);
        CONVERSION_DB.put(Converter.pair(Integer.class, Long.class), NumberConversions::toLong);
        CONVERSION_DB.put(Converter.pair(Long.class, Long.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(Float.class, Long.class), NumberConversions::toLong);
        CONVERSION_DB.put(Converter.pair(Double.class, Long.class), NumberConversions::toLong);
        CONVERSION_DB.put(Converter.pair(Boolean.class, Long.class), BooleanConversions::toLong);
        CONVERSION_DB.put(Converter.pair(Character.class, Long.class), CharacterConversions::toLong);
        CONVERSION_DB.put(Converter.pair(AtomicBoolean.class, Long.class), AtomicBooleanConversions::toLong);
        CONVERSION_DB.put(Converter.pair(AtomicInteger.class, Long.class), NumberConversions::toLong);
        CONVERSION_DB.put(Converter.pair(AtomicLong.class, Long.class), NumberConversions::toLong);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, Long.class), NumberConversions::toLong);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, Long.class), NumberConversions::toLong);
        CONVERSION_DB.put(Converter.pair(Date.class, Long.class), DateConversions::toLong);
        CONVERSION_DB.put(Converter.pair(java.sql.Date.class, Long.class), SqlDateConversions::toLong);
        CONVERSION_DB.put(Converter.pair(Timestamp.class, Long.class), TimestampConversions::toLong);
        CONVERSION_DB.put(Converter.pair(Instant.class, Long.class), InstantConversions::toLong);
        CONVERSION_DB.put(Converter.pair(Duration.class, Long.class), DurationConversions::toLong);
        CONVERSION_DB.put(Converter.pair(LocalDate.class, Long.class), LocalDateConversions::toLong);
        CONVERSION_DB.put(Converter.pair(LocalTime.class, Long.class), LocalTimeConversions::toLong);
        CONVERSION_DB.put(Converter.pair(LocalDateTime.class, Long.class), LocalDateTimeConversions::toLong);
        CONVERSION_DB.put(Converter.pair(OffsetTime.class, Long.class), OffsetTimeConversions::toLong);
        CONVERSION_DB.put(Converter.pair(OffsetDateTime.class, Long.class), OffsetDateTimeConversions::toLong);
        CONVERSION_DB.put(Converter.pair(ZonedDateTime.class, Long.class), ZonedDateTimeConversions::toLong);
        CONVERSION_DB.put(Converter.pair(Calendar.class, Long.class), CalendarConversions::toLong);
        CONVERSION_DB.put(Converter.pair(Map.class, Long.class), MapConversions::toLong);
        CONVERSION_DB.put(Converter.pair(String.class, Long.class), StringConversions::toLong);
        CONVERSION_DB.put(Converter.pair(Year.class, Long.class), YearConversions::toLong);
        CONVERSION_DB.put(Converter.pair(Void.class, Float.TYPE), NumberConversions::toFloatZero);
        CONVERSION_DB.put(Converter.pair(Void.class, Float.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Byte.class, Float.class), NumberConversions::toFloat);
        CONVERSION_DB.put(Converter.pair(Short.class, Float.class), NumberConversions::toFloat);
        CONVERSION_DB.put(Converter.pair(Integer.class, Float.class), NumberConversions::toFloat);
        CONVERSION_DB.put(Converter.pair(Long.class, Float.class), NumberConversions::toFloat);
        CONVERSION_DB.put(Converter.pair(Float.class, Float.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(Double.class, Float.class), NumberConversions::toFloat);
        CONVERSION_DB.put(Converter.pair(Boolean.class, Float.class), BooleanConversions::toFloat);
        CONVERSION_DB.put(Converter.pair(Character.class, Float.class), CharacterConversions::toFloat);
        CONVERSION_DB.put(Converter.pair(AtomicBoolean.class, Float.class), AtomicBooleanConversions::toFloat);
        CONVERSION_DB.put(Converter.pair(AtomicInteger.class, Float.class), NumberConversions::toFloat);
        CONVERSION_DB.put(Converter.pair(AtomicLong.class, Float.class), NumberConversions::toFloat);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, Float.class), NumberConversions::toFloat);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, Float.class), NumberConversions::toFloat);
        CONVERSION_DB.put(Converter.pair(Map.class, Float.class), MapConversions::toFloat);
        CONVERSION_DB.put(Converter.pair(String.class, Float.class), StringConversions::toFloat);
        CONVERSION_DB.put(Converter.pair(Year.class, Float.class), YearConversions::toFloat);
        CONVERSION_DB.put(Converter.pair(Void.class, Double.TYPE), NumberConversions::toDoubleZero);
        CONVERSION_DB.put(Converter.pair(Void.class, Double.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Byte.class, Double.class), NumberConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(Short.class, Double.class), NumberConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(Integer.class, Double.class), NumberConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(Long.class, Double.class), NumberConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(Float.class, Double.class), NumberConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(Double.class, Double.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(Boolean.class, Double.class), BooleanConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(Character.class, Double.class), CharacterConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(Duration.class, Double.class), DurationConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(Instant.class, Double.class), InstantConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(LocalTime.class, Double.class), LocalTimeConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(LocalDate.class, Double.class), LocalDateConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(LocalDateTime.class, Double.class), LocalDateTimeConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(ZonedDateTime.class, Double.class), ZonedDateTimeConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(OffsetTime.class, Double.class), OffsetTimeConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(OffsetDateTime.class, Double.class), OffsetDateTimeConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(Date.class, Double.class), DateConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(java.sql.Date.class, Double.class), SqlDateConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(Timestamp.class, Double.class), TimestampConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(AtomicBoolean.class, Double.class), AtomicBooleanConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(AtomicInteger.class, Double.class), NumberConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(AtomicLong.class, Double.class), NumberConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, Double.class), NumberConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, Double.class), NumberConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(Calendar.class, Double.class), CalendarConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(Map.class, Double.class), MapConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(String.class, Double.class), StringConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(Year.class, Double.class), YearConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(Void.class, Boolean.TYPE), VoidConversions::toBoolean);
        CONVERSION_DB.put(Converter.pair(Void.class, Boolean.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Byte.class, Boolean.class), NumberConversions::isIntTypeNotZero);
        CONVERSION_DB.put(Converter.pair(Short.class, Boolean.class), NumberConversions::isIntTypeNotZero);
        CONVERSION_DB.put(Converter.pair(Integer.class, Boolean.class), NumberConversions::isIntTypeNotZero);
        CONVERSION_DB.put(Converter.pair(Long.class, Boolean.class), NumberConversions::isIntTypeNotZero);
        CONVERSION_DB.put(Converter.pair(Float.class, Boolean.class), NumberConversions::isFloatTypeNotZero);
        CONVERSION_DB.put(Converter.pair(Double.class, Boolean.class), NumberConversions::isFloatTypeNotZero);
        CONVERSION_DB.put(Converter.pair(Boolean.class, Boolean.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(Character.class, Boolean.class), CharacterConversions::toBoolean);
        CONVERSION_DB.put(Converter.pair(AtomicBoolean.class, Boolean.class), AtomicBooleanConversions::toBoolean);
        CONVERSION_DB.put(Converter.pair(AtomicInteger.class, Boolean.class), NumberConversions::isIntTypeNotZero);
        CONVERSION_DB.put(Converter.pair(AtomicLong.class, Boolean.class), NumberConversions::isIntTypeNotZero);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, Boolean.class), NumberConversions::isBigIntegerNotZero);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, Boolean.class), NumberConversions::isBigDecimalNotZero);
        CONVERSION_DB.put(Converter.pair(Map.class, Boolean.class), MapConversions::toBoolean);
        CONVERSION_DB.put(Converter.pair(String.class, Boolean.class), StringConversions::toBoolean);
        CONVERSION_DB.put(Converter.pair(Void.class, Character.TYPE), VoidConversions::toCharacter);
        CONVERSION_DB.put(Converter.pair(Void.class, Character.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Byte.class, Character.class), ByteConversions::toCharacter);
        CONVERSION_DB.put(Converter.pair(Short.class, Character.class), NumberConversions::toCharacter);
        CONVERSION_DB.put(Converter.pair(Integer.class, Character.class), NumberConversions::toCharacter);
        CONVERSION_DB.put(Converter.pair(Long.class, Character.class), NumberConversions::toCharacter);
        CONVERSION_DB.put(Converter.pair(Float.class, Character.class), NumberConversions::toCharacter);
        CONVERSION_DB.put(Converter.pair(Double.class, Character.class), NumberConversions::toCharacter);
        CONVERSION_DB.put(Converter.pair(Boolean.class, Character.class), BooleanConversions::toCharacter);
        CONVERSION_DB.put(Converter.pair(Character.class, Character.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(AtomicBoolean.class, Character.class), AtomicBooleanConversions::toCharacter);
        CONVERSION_DB.put(Converter.pair(AtomicInteger.class, Character.class), NumberConversions::toCharacter);
        CONVERSION_DB.put(Converter.pair(AtomicLong.class, Character.class), NumberConversions::toCharacter);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, Character.class), NumberConversions::toCharacter);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, Character.class), NumberConversions::toCharacter);
        CONVERSION_DB.put(Converter.pair(Map.class, Character.class), MapConversions::toCharacter);
        CONVERSION_DB.put(Converter.pair(String.class, Character.class), StringConversions::toCharacter);
        CONVERSION_DB.put(Converter.pair(Void.class, BigInteger.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Byte.class, BigInteger.class), NumberConversions::integerTypeToBigInteger);
        CONVERSION_DB.put(Converter.pair(Short.class, BigInteger.class), NumberConversions::integerTypeToBigInteger);
        CONVERSION_DB.put(Converter.pair(Integer.class, BigInteger.class), NumberConversions::integerTypeToBigInteger);
        CONVERSION_DB.put(Converter.pair(Long.class, BigInteger.class), NumberConversions::integerTypeToBigInteger);
        CONVERSION_DB.put(Converter.pair(Float.class, BigInteger.class), NumberConversions::floatingPointToBigInteger);
        CONVERSION_DB.put(Converter.pair(Double.class, BigInteger.class), NumberConversions::floatingPointToBigInteger);
        CONVERSION_DB.put(Converter.pair(Boolean.class, BigInteger.class), BooleanConversions::toBigInteger);
        CONVERSION_DB.put(Converter.pair(Character.class, BigInteger.class), CharacterConversions::toBigInteger);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, BigInteger.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, BigInteger.class), BigDecimalConversions::toBigInteger);
        CONVERSION_DB.put(Converter.pair(AtomicBoolean.class, BigInteger.class), AtomicBooleanConversions::toBigInteger);
        CONVERSION_DB.put(Converter.pair(AtomicInteger.class, BigInteger.class), NumberConversions::integerTypeToBigInteger);
        CONVERSION_DB.put(Converter.pair(AtomicLong.class, BigInteger.class), NumberConversions::integerTypeToBigInteger);
        CONVERSION_DB.put(Converter.pair(Date.class, BigInteger.class), DateConversions::toBigInteger);
        CONVERSION_DB.put(Converter.pair(java.sql.Date.class, BigInteger.class), SqlDateConversions::toBigInteger);
        CONVERSION_DB.put(Converter.pair(Timestamp.class, BigInteger.class), TimestampConversions::toBigInteger);
        CONVERSION_DB.put(Converter.pair(Duration.class, BigInteger.class), DurationConversions::toBigInteger);
        CONVERSION_DB.put(Converter.pair(Instant.class, BigInteger.class), InstantConversions::toBigInteger);
        CONVERSION_DB.put(Converter.pair(LocalTime.class, BigInteger.class), LocalTimeConversions::toBigInteger);
        CONVERSION_DB.put(Converter.pair(LocalDate.class, BigInteger.class), LocalDateConversions::toBigInteger);
        CONVERSION_DB.put(Converter.pair(LocalDateTime.class, BigInteger.class), LocalDateTimeConversions::toBigInteger);
        CONVERSION_DB.put(Converter.pair(ZonedDateTime.class, BigInteger.class), ZonedDateTimeConversions::toBigInteger);
        CONVERSION_DB.put(Converter.pair(OffsetTime.class, BigInteger.class), OffsetTimeConversions::toBigInteger);
        CONVERSION_DB.put(Converter.pair(OffsetDateTime.class, BigInteger.class), OffsetDateTimeConversions::toBigInteger);
        CONVERSION_DB.put(Converter.pair(UUID.class, BigInteger.class), UUIDConversions::toBigInteger);
        CONVERSION_DB.put(Converter.pair(Calendar.class, BigInteger.class), CalendarConversions::toBigInteger);
        CONVERSION_DB.put(Converter.pair(Map.class, BigInteger.class), MapConversions::toBigInteger);
        CONVERSION_DB.put(Converter.pair(String.class, BigInteger.class), StringConversions::toBigInteger);
        CONVERSION_DB.put(Converter.pair(Year.class, BigInteger.class), YearConversions::toBigInteger);
        CONVERSION_DB.put(Converter.pair(Void.class, BigDecimal.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Byte.class, BigDecimal.class), NumberConversions::integerTypeToBigDecimal);
        CONVERSION_DB.put(Converter.pair(Short.class, BigDecimal.class), NumberConversions::integerTypeToBigDecimal);
        CONVERSION_DB.put(Converter.pair(Integer.class, BigDecimal.class), NumberConversions::integerTypeToBigDecimal);
        CONVERSION_DB.put(Converter.pair(Long.class, BigDecimal.class), NumberConversions::integerTypeToBigDecimal);
        CONVERSION_DB.put(Converter.pair(Float.class, BigDecimal.class), NumberConversions::floatingPointToBigDecimal);
        CONVERSION_DB.put(Converter.pair(Double.class, BigDecimal.class), NumberConversions::floatingPointToBigDecimal);
        CONVERSION_DB.put(Converter.pair(Boolean.class, BigDecimal.class), BooleanConversions::toBigDecimal);
        CONVERSION_DB.put(Converter.pair(Character.class, BigDecimal.class), CharacterConversions::toBigDecimal);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, BigDecimal.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, BigDecimal.class), BigIntegerConversions::toBigDecimal);
        CONVERSION_DB.put(Converter.pair(AtomicBoolean.class, BigDecimal.class), AtomicBooleanConversions::toBigDecimal);
        CONVERSION_DB.put(Converter.pair(AtomicInteger.class, BigDecimal.class), NumberConversions::integerTypeToBigDecimal);
        CONVERSION_DB.put(Converter.pair(AtomicLong.class, BigDecimal.class), NumberConversions::integerTypeToBigDecimal);
        CONVERSION_DB.put(Converter.pair(Date.class, BigDecimal.class), DateConversions::toBigDecimal);
        CONVERSION_DB.put(Converter.pair(java.sql.Date.class, BigDecimal.class), SqlDateConversions::toBigDecimal);
        CONVERSION_DB.put(Converter.pair(Timestamp.class, BigDecimal.class), TimestampConversions::toBigDecimal);
        CONVERSION_DB.put(Converter.pair(Instant.class, BigDecimal.class), InstantConversions::toBigDecimal);
        CONVERSION_DB.put(Converter.pair(Duration.class, BigDecimal.class), DurationConversions::toBigDecimal);
        CONVERSION_DB.put(Converter.pair(LocalTime.class, BigDecimal.class), LocalTimeConversions::toBigDecimal);
        CONVERSION_DB.put(Converter.pair(LocalDate.class, BigDecimal.class), LocalDateConversions::toBigDecimal);
        CONVERSION_DB.put(Converter.pair(LocalDateTime.class, BigDecimal.class), LocalDateTimeConversions::toBigDecimal);
        CONVERSION_DB.put(Converter.pair(ZonedDateTime.class, BigDecimal.class), ZonedDateTimeConversions::toBigDecimal);
        CONVERSION_DB.put(Converter.pair(OffsetTime.class, BigDecimal.class), OffsetTimeConversions::toBigDecimal);
        CONVERSION_DB.put(Converter.pair(OffsetDateTime.class, BigDecimal.class), OffsetDateTimeConversions::toBigDecimal);
        CONVERSION_DB.put(Converter.pair(UUID.class, BigDecimal.class), UUIDConversions::toBigDecimal);
        CONVERSION_DB.put(Converter.pair(Calendar.class, BigDecimal.class), CalendarConversions::toBigDecimal);
        CONVERSION_DB.put(Converter.pair(Map.class, BigDecimal.class), MapConversions::toBigDecimal);
        CONVERSION_DB.put(Converter.pair(String.class, BigDecimal.class), StringConversions::toBigDecimal);
        CONVERSION_DB.put(Converter.pair(Year.class, BigDecimal.class), YearConversions::toBigDecimal);
        CONVERSION_DB.put(Converter.pair(Void.class, AtomicBoolean.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Byte.class, AtomicBoolean.class), NumberConversions::toAtomicBoolean);
        CONVERSION_DB.put(Converter.pair(Short.class, AtomicBoolean.class), NumberConversions::toAtomicBoolean);
        CONVERSION_DB.put(Converter.pair(Integer.class, AtomicBoolean.class), NumberConversions::toAtomicBoolean);
        CONVERSION_DB.put(Converter.pair(Long.class, AtomicBoolean.class), NumberConversions::toAtomicBoolean);
        CONVERSION_DB.put(Converter.pair(Float.class, AtomicBoolean.class), NumberConversions::toAtomicBoolean);
        CONVERSION_DB.put(Converter.pair(Double.class, AtomicBoolean.class), NumberConversions::toAtomicBoolean);
        CONVERSION_DB.put(Converter.pair(Boolean.class, AtomicBoolean.class), BooleanConversions::toAtomicBoolean);
        CONVERSION_DB.put(Converter.pair(Character.class, AtomicBoolean.class), CharacterConversions::toAtomicBoolean);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, AtomicBoolean.class), NumberConversions::toAtomicBoolean);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, AtomicBoolean.class), NumberConversions::toAtomicBoolean);
        CONVERSION_DB.put(Converter.pair(AtomicBoolean.class, AtomicBoolean.class), AtomicBooleanConversions::toAtomicBoolean);
        CONVERSION_DB.put(Converter.pair(AtomicInteger.class, AtomicBoolean.class), NumberConversions::toAtomicBoolean);
        CONVERSION_DB.put(Converter.pair(AtomicLong.class, AtomicBoolean.class), NumberConversions::toAtomicBoolean);
        CONVERSION_DB.put(Converter.pair(Map.class, AtomicBoolean.class), MapConversions::toAtomicBoolean);
        CONVERSION_DB.put(Converter.pair(String.class, AtomicBoolean.class), StringConversions::toAtomicBoolean);
        CONVERSION_DB.put(Converter.pair(Year.class, AtomicBoolean.class), YearConversions::toAtomicBoolean);
        CONVERSION_DB.put(Converter.pair(Void.class, AtomicInteger.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Byte.class, AtomicInteger.class), NumberConversions::toAtomicInteger);
        CONVERSION_DB.put(Converter.pair(Short.class, AtomicInteger.class), NumberConversions::toAtomicInteger);
        CONVERSION_DB.put(Converter.pair(Integer.class, AtomicInteger.class), NumberConversions::toAtomicInteger);
        CONVERSION_DB.put(Converter.pair(Long.class, AtomicInteger.class), NumberConversions::toAtomicInteger);
        CONVERSION_DB.put(Converter.pair(Float.class, AtomicInteger.class), NumberConversions::toAtomicInteger);
        CONVERSION_DB.put(Converter.pair(Double.class, AtomicInteger.class), NumberConversions::toAtomicInteger);
        CONVERSION_DB.put(Converter.pair(Boolean.class, AtomicInteger.class), BooleanConversions::toAtomicInteger);
        CONVERSION_DB.put(Converter.pair(Character.class, AtomicInteger.class), CharacterConversions::toAtomicInteger);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, AtomicInteger.class), NumberConversions::toAtomicInteger);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, AtomicInteger.class), NumberConversions::toAtomicInteger);
        CONVERSION_DB.put(Converter.pair(AtomicInteger.class, AtomicInteger.class), AtomicIntegerConversions::toAtomicInteger);
        CONVERSION_DB.put(Converter.pair(AtomicBoolean.class, AtomicInteger.class), AtomicBooleanConversions::toAtomicInteger);
        CONVERSION_DB.put(Converter.pair(AtomicLong.class, AtomicInteger.class), NumberConversions::toAtomicInteger);
        CONVERSION_DB.put(Converter.pair(LocalTime.class, AtomicInteger.class), LocalTimeConversions::toAtomicInteger);
        CONVERSION_DB.put(Converter.pair(OffsetTime.class, AtomicInteger.class), OffsetTimeConversions::toAtomicInteger);
        CONVERSION_DB.put(Converter.pair(Map.class, AtomicInteger.class), MapConversions::toAtomicInteger);
        CONVERSION_DB.put(Converter.pair(String.class, AtomicInteger.class), StringConversions::toAtomicInteger);
        CONVERSION_DB.put(Converter.pair(Year.class, AtomicInteger.class), YearConversions::toAtomicInteger);
        CONVERSION_DB.put(Converter.pair(Void.class, AtomicLong.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Byte.class, AtomicLong.class), NumberConversions::toAtomicLong);
        CONVERSION_DB.put(Converter.pair(Short.class, AtomicLong.class), NumberConversions::toAtomicLong);
        CONVERSION_DB.put(Converter.pair(Integer.class, AtomicLong.class), NumberConversions::toAtomicLong);
        CONVERSION_DB.put(Converter.pair(Long.class, AtomicLong.class), NumberConversions::toAtomicLong);
        CONVERSION_DB.put(Converter.pair(Float.class, AtomicLong.class), NumberConversions::toAtomicLong);
        CONVERSION_DB.put(Converter.pair(Double.class, AtomicLong.class), NumberConversions::toAtomicLong);
        CONVERSION_DB.put(Converter.pair(Boolean.class, AtomicLong.class), BooleanConversions::toAtomicLong);
        CONVERSION_DB.put(Converter.pair(Character.class, AtomicLong.class), CharacterConversions::toAtomicLong);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, AtomicLong.class), NumberConversions::toAtomicLong);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, AtomicLong.class), NumberConversions::toAtomicLong);
        CONVERSION_DB.put(Converter.pair(AtomicBoolean.class, AtomicLong.class), AtomicBooleanConversions::toAtomicLong);
        CONVERSION_DB.put(Converter.pair(AtomicInteger.class, AtomicLong.class), NumberConversions::toAtomicLong);
        CONVERSION_DB.put(Converter.pair(AtomicLong.class, AtomicLong.class), AtomicLongConversions::toAtomicLong);
        CONVERSION_DB.put(Converter.pair(Date.class, AtomicLong.class), DateConversions::toAtomicLong);
        CONVERSION_DB.put(Converter.pair(java.sql.Date.class, AtomicLong.class), SqlDateConversions::toAtomicLong);
        CONVERSION_DB.put(Converter.pair(Timestamp.class, AtomicLong.class), DateConversions::toAtomicLong);
        CONVERSION_DB.put(Converter.pair(Instant.class, AtomicLong.class), InstantConversions::toAtomicLong);
        CONVERSION_DB.put(Converter.pair(Duration.class, AtomicLong.class), DurationConversions::toAtomicLong);
        CONVERSION_DB.put(Converter.pair(LocalDate.class, AtomicLong.class), LocalDateConversions::toAtomicLong);
        CONVERSION_DB.put(Converter.pair(LocalTime.class, AtomicLong.class), LocalTimeConversions::toAtomicLong);
        CONVERSION_DB.put(Converter.pair(LocalDateTime.class, AtomicLong.class), LocalDateTimeConversions::toAtomicLong);
        CONVERSION_DB.put(Converter.pair(ZonedDateTime.class, AtomicLong.class), ZonedDateTimeConversions::toAtomicLong);
        CONVERSION_DB.put(Converter.pair(OffsetTime.class, AtomicLong.class), OffsetTimeConversions::toAtomicLong);
        CONVERSION_DB.put(Converter.pair(OffsetDateTime.class, AtomicLong.class), OffsetDateTimeConversions::toAtomicLong);
        CONVERSION_DB.put(Converter.pair(Calendar.class, AtomicLong.class), CalendarConversions::toAtomicLong);
        CONVERSION_DB.put(Converter.pair(Map.class, AtomicLong.class), MapConversions::toAtomicLong);
        CONVERSION_DB.put(Converter.pair(String.class, AtomicLong.class), StringConversions::toAtomicLong);
        CONVERSION_DB.put(Converter.pair(Year.class, AtomicLong.class), YearConversions::toAtomicLong);
        CONVERSION_DB.put(Converter.pair(Void.class, Date.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Long.class, Date.class), NumberConversions::toDate);
        CONVERSION_DB.put(Converter.pair(Double.class, Date.class), DoubleConversions::toDate);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, Date.class), BigIntegerConversions::toDate);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, Date.class), BigDecimalConversions::toDate);
        CONVERSION_DB.put(Converter.pair(AtomicLong.class, Date.class), NumberConversions::toDate);
        CONVERSION_DB.put(Converter.pair(Date.class, Date.class), DateConversions::toDate);
        CONVERSION_DB.put(Converter.pair(java.sql.Date.class, Date.class), SqlDateConversions::toDate);
        CONVERSION_DB.put(Converter.pair(Timestamp.class, Date.class), TimestampConversions::toDate);
        CONVERSION_DB.put(Converter.pair(Instant.class, Date.class), InstantConversions::toDate);
        CONVERSION_DB.put(Converter.pair(LocalDate.class, Date.class), LocalDateConversions::toDate);
        CONVERSION_DB.put(Converter.pair(LocalDateTime.class, Date.class), LocalDateTimeConversions::toDate);
        CONVERSION_DB.put(Converter.pair(ZonedDateTime.class, Date.class), ZonedDateTimeConversions::toDate);
        CONVERSION_DB.put(Converter.pair(OffsetDateTime.class, Date.class), OffsetDateTimeConversions::toDate);
        CONVERSION_DB.put(Converter.pair(Calendar.class, Date.class), CalendarConversions::toDate);
        CONVERSION_DB.put(Converter.pair(Map.class, Date.class), MapConversions::toDate);
        CONVERSION_DB.put(Converter.pair(String.class, Date.class), StringConversions::toDate);
        CONVERSION_DB.put(Converter.pair(Void.class, java.sql.Date.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Long.class, java.sql.Date.class), NumberConversions::toSqlDate);
        CONVERSION_DB.put(Converter.pair(Double.class, java.sql.Date.class), DoubleConversions::toSqlDate);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, java.sql.Date.class), BigIntegerConversions::toSqlDate);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, java.sql.Date.class), BigDecimalConversions::toSqlDate);
        CONVERSION_DB.put(Converter.pair(AtomicLong.class, java.sql.Date.class), NumberConversions::toSqlDate);
        CONVERSION_DB.put(Converter.pair(java.sql.Date.class, java.sql.Date.class), SqlDateConversions::toSqlDate);
        CONVERSION_DB.put(Converter.pair(Date.class, java.sql.Date.class), DateConversions::toSqlDate);
        CONVERSION_DB.put(Converter.pair(Timestamp.class, java.sql.Date.class), TimestampConversions::toSqlDate);
        CONVERSION_DB.put(Converter.pair(Instant.class, java.sql.Date.class), InstantConversions::toSqlDate);
        CONVERSION_DB.put(Converter.pair(LocalDate.class, java.sql.Date.class), LocalDateConversions::toSqlDate);
        CONVERSION_DB.put(Converter.pair(LocalDateTime.class, java.sql.Date.class), LocalDateTimeConversions::toSqlDate);
        CONVERSION_DB.put(Converter.pair(ZonedDateTime.class, java.sql.Date.class), ZonedDateTimeConversions::toSqlDate);
        CONVERSION_DB.put(Converter.pair(OffsetDateTime.class, java.sql.Date.class), OffsetDateTimeConversions::toSqlDate);
        CONVERSION_DB.put(Converter.pair(Calendar.class, java.sql.Date.class), CalendarConversions::toSqlDate);
        CONVERSION_DB.put(Converter.pair(Map.class, java.sql.Date.class), MapConversions::toSqlDate);
        CONVERSION_DB.put(Converter.pair(String.class, java.sql.Date.class), StringConversions::toSqlDate);
        CONVERSION_DB.put(Converter.pair(Void.class, Timestamp.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Long.class, Timestamp.class), NumberConversions::toTimestamp);
        CONVERSION_DB.put(Converter.pair(Double.class, Timestamp.class), DoubleConversions::toTimestamp);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, Timestamp.class), BigIntegerConversions::toTimestamp);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, Timestamp.class), BigDecimalConversions::toTimestamp);
        CONVERSION_DB.put(Converter.pair(AtomicLong.class, Timestamp.class), NumberConversions::toTimestamp);
        CONVERSION_DB.put(Converter.pair(Timestamp.class, Timestamp.class), DateConversions::toTimestamp);
        CONVERSION_DB.put(Converter.pair(java.sql.Date.class, Timestamp.class), SqlDateConversions::toTimestamp);
        CONVERSION_DB.put(Converter.pair(Date.class, Timestamp.class), DateConversions::toTimestamp);
        CONVERSION_DB.put(Converter.pair(Duration.class, Timestamp.class), DurationConversions::toTimestamp);
        CONVERSION_DB.put(Converter.pair(Instant.class, Timestamp.class), InstantConversions::toTimestamp);
        CONVERSION_DB.put(Converter.pair(LocalDate.class, Timestamp.class), LocalDateConversions::toTimestamp);
        CONVERSION_DB.put(Converter.pair(LocalDateTime.class, Timestamp.class), LocalDateTimeConversions::toTimestamp);
        CONVERSION_DB.put(Converter.pair(ZonedDateTime.class, Timestamp.class), ZonedDateTimeConversions::toTimestamp);
        CONVERSION_DB.put(Converter.pair(OffsetDateTime.class, Timestamp.class), OffsetDateTimeConversions::toTimestamp);
        CONVERSION_DB.put(Converter.pair(Calendar.class, Timestamp.class), CalendarConversions::toTimestamp);
        CONVERSION_DB.put(Converter.pair(Map.class, Timestamp.class), MapConversions::toTimestamp);
        CONVERSION_DB.put(Converter.pair(String.class, Timestamp.class), StringConversions::toTimestamp);
        CONVERSION_DB.put(Converter.pair(Void.class, Calendar.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Long.class, Calendar.class), NumberConversions::toCalendar);
        CONVERSION_DB.put(Converter.pair(Double.class, Calendar.class), DoubleConversions::toCalendar);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, Calendar.class), BigIntegerConversions::toCalendar);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, Calendar.class), BigDecimalConversions::toCalendar);
        CONVERSION_DB.put(Converter.pair(AtomicLong.class, Calendar.class), NumberConversions::toCalendar);
        CONVERSION_DB.put(Converter.pair(Date.class, Calendar.class), DateConversions::toCalendar);
        CONVERSION_DB.put(Converter.pair(java.sql.Date.class, Calendar.class), SqlDateConversions::toCalendar);
        CONVERSION_DB.put(Converter.pair(Timestamp.class, Calendar.class), TimestampConversions::toCalendar);
        CONVERSION_DB.put(Converter.pair(Instant.class, Calendar.class), InstantConversions::toCalendar);
        CONVERSION_DB.put(Converter.pair(LocalTime.class, Calendar.class), LocalTimeConversions::toCalendar);
        CONVERSION_DB.put(Converter.pair(LocalDate.class, Calendar.class), LocalDateConversions::toCalendar);
        CONVERSION_DB.put(Converter.pair(LocalDateTime.class, Calendar.class), LocalDateTimeConversions::toCalendar);
        CONVERSION_DB.put(Converter.pair(ZonedDateTime.class, Calendar.class), ZonedDateTimeConversions::toCalendar);
        CONVERSION_DB.put(Converter.pair(OffsetDateTime.class, Calendar.class), OffsetDateTimeConversions::toCalendar);
        CONVERSION_DB.put(Converter.pair(Calendar.class, Calendar.class), CalendarConversions::clone);
        CONVERSION_DB.put(Converter.pair(Map.class, Calendar.class), MapConversions::toCalendar);
        CONVERSION_DB.put(Converter.pair(String.class, Calendar.class), StringConversions::toCalendar);
        CONVERSION_DB.put(Converter.pair(Void.class, LocalDate.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Long.class, LocalDate.class), NumberConversions::toLocalDate);
        CONVERSION_DB.put(Converter.pair(Double.class, LocalDate.class), DoubleConversions::toLocalDate);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, LocalDate.class), BigIntegerConversions::toLocalDate);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, LocalDate.class), BigDecimalConversions::toLocalDate);
        CONVERSION_DB.put(Converter.pair(AtomicLong.class, LocalDate.class), NumberConversions::toLocalDate);
        CONVERSION_DB.put(Converter.pair(java.sql.Date.class, LocalDate.class), SqlDateConversions::toLocalDate);
        CONVERSION_DB.put(Converter.pair(Timestamp.class, LocalDate.class), DateConversions::toLocalDate);
        CONVERSION_DB.put(Converter.pair(Date.class, LocalDate.class), DateConversions::toLocalDate);
        CONVERSION_DB.put(Converter.pair(Instant.class, LocalDate.class), InstantConversions::toLocalDate);
        CONVERSION_DB.put(Converter.pair(LocalDate.class, LocalDate.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(LocalDateTime.class, LocalDate.class), LocalDateTimeConversions::toLocalDate);
        CONVERSION_DB.put(Converter.pair(ZonedDateTime.class, LocalDate.class), ZonedDateTimeConversions::toLocalDate);
        CONVERSION_DB.put(Converter.pair(OffsetDateTime.class, LocalDate.class), OffsetDateTimeConversions::toLocalDate);
        CONVERSION_DB.put(Converter.pair(Calendar.class, LocalDate.class), CalendarConversions::toLocalDate);
        CONVERSION_DB.put(Converter.pair(Map.class, LocalDate.class), MapConversions::toLocalDate);
        CONVERSION_DB.put(Converter.pair(String.class, LocalDate.class), StringConversions::toLocalDate);
        CONVERSION_DB.put(Converter.pair(Void.class, LocalDateTime.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Long.class, LocalDateTime.class), NumberConversions::toLocalDateTime);
        CONVERSION_DB.put(Converter.pair(Double.class, LocalDateTime.class), DoubleConversions::toLocalDateTime);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, LocalDateTime.class), BigIntegerConversions::toLocalDateTime);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, LocalDateTime.class), BigDecimalConversions::toLocalDateTime);
        CONVERSION_DB.put(Converter.pair(AtomicLong.class, LocalDateTime.class), NumberConversions::toLocalDateTime);
        CONVERSION_DB.put(Converter.pair(java.sql.Date.class, LocalDateTime.class), SqlDateConversions::toLocalDateTime);
        CONVERSION_DB.put(Converter.pair(Timestamp.class, LocalDateTime.class), TimestampConversions::toLocalDateTime);
        CONVERSION_DB.put(Converter.pair(Date.class, LocalDateTime.class), DateConversions::toLocalDateTime);
        CONVERSION_DB.put(Converter.pair(Instant.class, LocalDateTime.class), InstantConversions::toLocalDateTime);
        CONVERSION_DB.put(Converter.pair(LocalDateTime.class, LocalDateTime.class), LocalDateTimeConversions::toLocalDateTime);
        CONVERSION_DB.put(Converter.pair(LocalDate.class, LocalDateTime.class), LocalDateConversions::toLocalDateTime);
        CONVERSION_DB.put(Converter.pair(ZonedDateTime.class, LocalDateTime.class), ZonedDateTimeConversions::toLocalDateTime);
        CONVERSION_DB.put(Converter.pair(OffsetDateTime.class, LocalDateTime.class), OffsetDateTimeConversions::toLocalDateTime);
        CONVERSION_DB.put(Converter.pair(Calendar.class, LocalDateTime.class), CalendarConversions::toLocalDateTime);
        CONVERSION_DB.put(Converter.pair(Map.class, LocalDateTime.class), MapConversions::toLocalDateTime);
        CONVERSION_DB.put(Converter.pair(String.class, LocalDateTime.class), StringConversions::toLocalDateTime);
        CONVERSION_DB.put(Converter.pair(Void.class, LocalTime.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Integer.class, LocalTime.class), NumberConversions::toLocalTime);
        CONVERSION_DB.put(Converter.pair(Long.class, LocalTime.class), NumberConversions::toLocalTime);
        CONVERSION_DB.put(Converter.pair(Double.class, LocalTime.class), DoubleConversions::toLocalTime);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, LocalTime.class), BigIntegerConversions::toLocalTime);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, LocalTime.class), BigDecimalConversions::toLocalTime);
        CONVERSION_DB.put(Converter.pair(AtomicInteger.class, LocalTime.class), NumberConversions::toLocalTime);
        CONVERSION_DB.put(Converter.pair(AtomicLong.class, LocalTime.class), NumberConversions::toLocalTime);
        CONVERSION_DB.put(Converter.pair(Timestamp.class, LocalTime.class), DateConversions::toLocalTime);
        CONVERSION_DB.put(Converter.pair(Date.class, LocalTime.class), DateConversions::toLocalTime);
        CONVERSION_DB.put(Converter.pair(Instant.class, LocalTime.class), InstantConversions::toLocalTime);
        CONVERSION_DB.put(Converter.pair(LocalDateTime.class, LocalTime.class), LocalDateTimeConversions::toLocalTime);
        CONVERSION_DB.put(Converter.pair(LocalTime.class, LocalTime.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(ZonedDateTime.class, LocalTime.class), ZonedDateTimeConversions::toLocalTime);
        CONVERSION_DB.put(Converter.pair(OffsetDateTime.class, LocalTime.class), OffsetDateTimeConversions::toLocalTime);
        CONVERSION_DB.put(Converter.pair(Calendar.class, LocalTime.class), CalendarConversions::toLocalTime);
        CONVERSION_DB.put(Converter.pair(Map.class, LocalTime.class), MapConversions::toLocalTime);
        CONVERSION_DB.put(Converter.pair(String.class, LocalTime.class), StringConversions::toLocalTime);
        CONVERSION_DB.put(Converter.pair(Void.class, ZonedDateTime.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Long.class, ZonedDateTime.class), NumberConversions::toZonedDateTime);
        CONVERSION_DB.put(Converter.pair(Double.class, ZonedDateTime.class), DoubleConversions::toZonedDateTime);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, ZonedDateTime.class), BigIntegerConversions::toZonedDateTime);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, ZonedDateTime.class), BigDecimalConversions::toZonedDateTime);
        CONVERSION_DB.put(Converter.pair(AtomicLong.class, ZonedDateTime.class), NumberConversions::toZonedDateTime);
        CONVERSION_DB.put(Converter.pair(java.sql.Date.class, ZonedDateTime.class), SqlDateConversions::toZonedDateTime);
        CONVERSION_DB.put(Converter.pair(Timestamp.class, ZonedDateTime.class), DateConversions::toZonedDateTime);
        CONVERSION_DB.put(Converter.pair(Date.class, ZonedDateTime.class), DateConversions::toZonedDateTime);
        CONVERSION_DB.put(Converter.pair(Instant.class, ZonedDateTime.class), InstantConversions::toZonedDateTime);
        CONVERSION_DB.put(Converter.pair(LocalDate.class, ZonedDateTime.class), LocalDateConversions::toZonedDateTime);
        CONVERSION_DB.put(Converter.pair(LocalDateTime.class, ZonedDateTime.class), LocalDateTimeConversions::toZonedDateTime);
        CONVERSION_DB.put(Converter.pair(ZonedDateTime.class, ZonedDateTime.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(OffsetDateTime.class, ZonedDateTime.class), OffsetDateTimeConversions::toZonedDateTime);
        CONVERSION_DB.put(Converter.pair(Calendar.class, ZonedDateTime.class), CalendarConversions::toZonedDateTime);
        CONVERSION_DB.put(Converter.pair(Map.class, ZonedDateTime.class), MapConversions::toZonedDateTime);
        CONVERSION_DB.put(Converter.pair(String.class, ZonedDateTime.class), StringConversions::toZonedDateTime);
        CONVERSION_DB.put(Converter.pair(Void.class, OffsetDateTime.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(OffsetDateTime.class, OffsetDateTime.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(Map.class, OffsetDateTime.class), MapConversions::toOffsetDateTime);
        CONVERSION_DB.put(Converter.pair(String.class, OffsetDateTime.class), StringConversions::toOffsetDateTime);
        CONVERSION_DB.put(Converter.pair(Long.class, OffsetDateTime.class), NumberConversions::toOffsetDateTime);
        CONVERSION_DB.put(Converter.pair(AtomicLong.class, OffsetDateTime.class), NumberConversions::toOffsetDateTime);
        CONVERSION_DB.put(Converter.pair(Double.class, OffsetDateTime.class), DoubleConversions::toOffsetDateTime);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, OffsetDateTime.class), BigIntegerConversions::toOffsetDateTime);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, OffsetDateTime.class), BigDecimalConversions::toOffsetDateTime);
        CONVERSION_DB.put(Converter.pair(java.sql.Date.class, OffsetDateTime.class), SqlDateConversions::toOffsetDateTime);
        CONVERSION_DB.put(Converter.pair(Date.class, OffsetDateTime.class), DateConversions::toOffsetDateTime);
        CONVERSION_DB.put(Converter.pair(Calendar.class, OffsetDateTime.class), CalendarConversions::toOffsetDateTime);
        CONVERSION_DB.put(Converter.pair(Timestamp.class, OffsetDateTime.class), TimestampConversions::toOffsetDateTime);
        CONVERSION_DB.put(Converter.pair(LocalDate.class, OffsetDateTime.class), LocalDateConversions::toOffsetDateTime);
        CONVERSION_DB.put(Converter.pair(Instant.class, OffsetDateTime.class), InstantConversions::toOffsetDateTime);
        CONVERSION_DB.put(Converter.pair(ZonedDateTime.class, OffsetDateTime.class), ZonedDateTimeConversions::toOffsetDateTime);
        CONVERSION_DB.put(Converter.pair(LocalDateTime.class, OffsetDateTime.class), LocalDateTimeConversions::toOffsetDateTime);
        CONVERSION_DB.put(Converter.pair(Void.class, OffsetTime.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Integer.class, OffsetTime.class), NumberConversions::toOffsetTime);
        CONVERSION_DB.put(Converter.pair(Long.class, OffsetTime.class), NumberConversions::toOffsetTime);
        CONVERSION_DB.put(Converter.pair(Double.class, OffsetTime.class), DoubleConversions::toOffsetTime);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, OffsetTime.class), BigIntegerConversions::toOffsetTime);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, OffsetTime.class), BigDecimalConversions::toOffsetTime);
        CONVERSION_DB.put(Converter.pair(AtomicInteger.class, OffsetTime.class), NumberConversions::toOffsetTime);
        CONVERSION_DB.put(Converter.pair(AtomicLong.class, OffsetTime.class), NumberConversions::toOffsetTime);
        CONVERSION_DB.put(Converter.pair(OffsetTime.class, OffsetTime.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(OffsetDateTime.class, OffsetTime.class), OffsetDateTimeConversions::toOffsetTime);
        CONVERSION_DB.put(Converter.pair(Map.class, OffsetTime.class), MapConversions::toOffsetTime);
        CONVERSION_DB.put(Converter.pair(String.class, OffsetTime.class), StringConversions::toOffsetTime);
        CONVERSION_DB.put(Converter.pair(Void.class, UUID.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(UUID.class, UUID.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(String.class, UUID.class), StringConversions::toUUID);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, UUID.class), BigIntegerConversions::toUUID);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, UUID.class), BigDecimalConversions::toUUID);
        CONVERSION_DB.put(Converter.pair(Map.class, UUID.class), MapConversions::toUUID);
        CONVERSION_DB.put(Converter.pair(Void.class, Class.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Class.class, Class.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(Map.class, Class.class), MapConversions::toClass);
        CONVERSION_DB.put(Converter.pair(String.class, Class.class), StringConversions::toClass);
        CONVERSION_DB.put(Converter.pair(Void.class, Locale.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Locale.class, Locale.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(String.class, Locale.class), StringConversions::toLocale);
        CONVERSION_DB.put(Converter.pair(Map.class, Locale.class), MapConversions::toLocale);
        CONVERSION_DB.put(Converter.pair(Void.class, String.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Byte.class, String.class), StringConversions::toString);
        CONVERSION_DB.put(Converter.pair(Short.class, String.class), StringConversions::toString);
        CONVERSION_DB.put(Converter.pair(Integer.class, String.class), StringConversions::toString);
        CONVERSION_DB.put(Converter.pair(Long.class, String.class), StringConversions::toString);
        CONVERSION_DB.put(Converter.pair(Float.class, String.class), NumberConversions::floatToString);
        CONVERSION_DB.put(Converter.pair(Double.class, String.class), NumberConversions::doubleToString);
        CONVERSION_DB.put(Converter.pair(Boolean.class, String.class), StringConversions::toString);
        CONVERSION_DB.put(Converter.pair(Character.class, String.class), CharacterConversions::toString);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, String.class), StringConversions::toString);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, String.class), BigDecimalConversions::toString);
        CONVERSION_DB.put(Converter.pair(AtomicBoolean.class, String.class), StringConversions::toString);
        CONVERSION_DB.put(Converter.pair(AtomicInteger.class, String.class), StringConversions::toString);
        CONVERSION_DB.put(Converter.pair(AtomicLong.class, String.class), StringConversions::toString);
        CONVERSION_DB.put(Converter.pair(byte[].class, String.class), ByteArrayConversions::toString);
        CONVERSION_DB.put(Converter.pair(char[].class, String.class), CharArrayConversions::toString);
        CONVERSION_DB.put(Converter.pair(Character[].class, String.class), CharacterArrayConversions::toString);
        CONVERSION_DB.put(Converter.pair(ByteBuffer.class, String.class), ByteBufferConversions::toString);
        CONVERSION_DB.put(Converter.pair(CharBuffer.class, String.class), CharBufferConversions::toString);
        CONVERSION_DB.put(Converter.pair(Class.class, String.class), ClassConversions::toString);
        CONVERSION_DB.put(Converter.pair(Date.class, String.class), DateConversions::toString);
        CONVERSION_DB.put(Converter.pair(java.sql.Date.class, String.class), SqlDateConversions::toString);
        CONVERSION_DB.put(Converter.pair(Timestamp.class, String.class), TimestampConversions::toString);
        CONVERSION_DB.put(Converter.pair(LocalDate.class, String.class), LocalDateConversions::toString);
        CONVERSION_DB.put(Converter.pair(LocalTime.class, String.class), LocalTimeConversions::toString);
        CONVERSION_DB.put(Converter.pair(LocalDateTime.class, String.class), LocalDateTimeConversions::toString);
        CONVERSION_DB.put(Converter.pair(ZonedDateTime.class, String.class), ZonedDateTimeConversions::toString);
        CONVERSION_DB.put(Converter.pair(UUID.class, String.class), StringConversions::toString);
        CONVERSION_DB.put(Converter.pair(Calendar.class, String.class), CalendarConversions::toString);
        CONVERSION_DB.put(Converter.pair(Map.class, String.class), MapConversions::toString);
        CONVERSION_DB.put(Converter.pair(Enum.class, String.class), StringConversions::enumToString);
        CONVERSION_DB.put(Converter.pair(String.class, String.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(Duration.class, String.class), StringConversions::toString);
        CONVERSION_DB.put(Converter.pair(Instant.class, String.class), StringConversions::toString);
        CONVERSION_DB.put(Converter.pair(MonthDay.class, String.class), StringConversions::toString);
        CONVERSION_DB.put(Converter.pair(YearMonth.class, String.class), StringConversions::toString);
        CONVERSION_DB.put(Converter.pair(Period.class, String.class), StringConversions::toString);
        CONVERSION_DB.put(Converter.pair(ZoneId.class, String.class), StringConversions::toString);
        CONVERSION_DB.put(Converter.pair(ZoneOffset.class, String.class), StringConversions::toString);
        CONVERSION_DB.put(Converter.pair(OffsetTime.class, String.class), OffsetTimeConversions::toString);
        CONVERSION_DB.put(Converter.pair(OffsetDateTime.class, String.class), OffsetDateTimeConversions::toString);
        CONVERSION_DB.put(Converter.pair(Year.class, String.class), YearConversions::toString);
        CONVERSION_DB.put(Converter.pair(Locale.class, String.class), LocaleConversions::toString);
        CONVERSION_DB.put(Converter.pair(URL.class, String.class), StringConversions::toString);
        CONVERSION_DB.put(Converter.pair(URI.class, String.class), StringConversions::toString);
        CONVERSION_DB.put(Converter.pair(TimeZone.class, String.class), TimeZoneConversions::toString);
        CONVERSION_DB.put(Converter.pair(StringBuilder.class, String.class), StringBuilderConversions::toString);
        CONVERSION_DB.put(Converter.pair(StringBuffer.class, String.class), StringBufferConversions::toString);
        CONVERSION_DB.put(Converter.pair(Pattern.class, String.class), PatternConversions::toString);
        CONVERSION_DB.put(Converter.pair(Currency.class, String.class), CurrencyConversions::toString);
        CONVERSION_DB.put(Converter.pair(Void.class, Currency.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Currency.class, Currency.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(String.class, Currency.class), StringConversions::toCurrency);
        CONVERSION_DB.put(Converter.pair(Map.class, Currency.class), MapConversions::toCurrency);
        CONVERSION_DB.put(Converter.pair(Void.class, Pattern.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Pattern.class, Pattern.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(String.class, Pattern.class), StringConversions::toPattern);
        CONVERSION_DB.put(Converter.pair(Map.class, Pattern.class), MapConversions::toPattern);
        CONVERSION_DB.put(Converter.pair(Void.class, URL.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(URL.class, URL.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(URI.class, URL.class), UriConversions::toURL);
        CONVERSION_DB.put(Converter.pair(String.class, URL.class), StringConversions::toURL);
        CONVERSION_DB.put(Converter.pair(Map.class, URL.class), MapConversions::toURL);
        CONVERSION_DB.put(Converter.pair(Void.class, URI.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(URI.class, URI.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(URL.class, URI.class), UrlConversions::toURI);
        CONVERSION_DB.put(Converter.pair(String.class, URI.class), StringConversions::toURI);
        CONVERSION_DB.put(Converter.pair(Map.class, URI.class), MapConversions::toURI);
        CONVERSION_DB.put(Converter.pair(Void.class, TimeZone.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(TimeZone.class, TimeZone.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(String.class, TimeZone.class), StringConversions::toTimeZone);
        CONVERSION_DB.put(Converter.pair(Map.class, TimeZone.class), MapConversions::toTimeZone);
        CONVERSION_DB.put(Converter.pair(ZoneId.class, TimeZone.class), ZoneIdConversions::toTimeZone);
        CONVERSION_DB.put(Converter.pair(ZoneOffset.class, TimeZone.class), ZoneOffsetConversions::toTimeZone);
        CONVERSION_DB.put(Converter.pair(Void.class, Duration.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Duration.class, Duration.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(Long.class, Duration.class), NumberConversions::toDuration);
        CONVERSION_DB.put(Converter.pair(Double.class, Duration.class), DoubleConversions::toDuration);
        CONVERSION_DB.put(Converter.pair(AtomicLong.class, Duration.class), NumberConversions::toDuration);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, Duration.class), BigIntegerConversions::toDuration);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, Duration.class), BigDecimalConversions::toDuration);
        CONVERSION_DB.put(Converter.pair(Timestamp.class, Duration.class), TimestampConversions::toDuration);
        CONVERSION_DB.put(Converter.pair(String.class, Duration.class), StringConversions::toDuration);
        CONVERSION_DB.put(Converter.pair(Map.class, Duration.class), MapConversions::toDuration);
        CONVERSION_DB.put(Converter.pair(Void.class, Instant.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Instant.class, Instant.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(Long.class, Instant.class), NumberConversions::toInstant);
        CONVERSION_DB.put(Converter.pair(Double.class, Instant.class), DoubleConversions::toInstant);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, Instant.class), BigIntegerConversions::toInstant);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, Instant.class), BigDecimalConversions::toInstant);
        CONVERSION_DB.put(Converter.pair(AtomicLong.class, Instant.class), NumberConversions::toInstant);
        CONVERSION_DB.put(Converter.pair(java.sql.Date.class, Instant.class), SqlDateConversions::toInstant);
        CONVERSION_DB.put(Converter.pair(Timestamp.class, Instant.class), DateConversions::toInstant);
        CONVERSION_DB.put(Converter.pair(Date.class, Instant.class), DateConversions::toInstant);
        CONVERSION_DB.put(Converter.pair(LocalDate.class, Instant.class), LocalDateConversions::toInstant);
        CONVERSION_DB.put(Converter.pair(LocalDateTime.class, Instant.class), LocalDateTimeConversions::toInstant);
        CONVERSION_DB.put(Converter.pair(ZonedDateTime.class, Instant.class), ZonedDateTimeConversions::toInstant);
        CONVERSION_DB.put(Converter.pair(OffsetDateTime.class, Instant.class), OffsetDateTimeConversions::toInstant);
        CONVERSION_DB.put(Converter.pair(Calendar.class, Instant.class), CalendarConversions::toInstant);
        CONVERSION_DB.put(Converter.pair(String.class, Instant.class), StringConversions::toInstant);
        CONVERSION_DB.put(Converter.pair(Map.class, Instant.class), MapConversions::toInstant);
        CONVERSION_DB.put(Converter.pair(Void.class, ZoneId.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(ZoneId.class, ZoneId.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(String.class, ZoneId.class), StringConversions::toZoneId);
        CONVERSION_DB.put(Converter.pair(Map.class, ZoneId.class), MapConversions::toZoneId);
        CONVERSION_DB.put(Converter.pair(TimeZone.class, ZoneId.class), TimeZoneConversions::toZoneId);
        CONVERSION_DB.put(Converter.pair(ZoneOffset.class, ZoneId.class), ZoneOffsetConversions::toZoneId);
        CONVERSION_DB.put(Converter.pair(Void.class, ZoneOffset.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(ZoneOffset.class, ZoneOffset.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(String.class, ZoneOffset.class), StringConversions::toZoneOffset);
        CONVERSION_DB.put(Converter.pair(Map.class, ZoneOffset.class), MapConversions::toZoneOffset);
        CONVERSION_DB.put(Converter.pair(ZoneId.class, ZoneOffset.class), ZoneIdConversions::toZoneOffset);
        CONVERSION_DB.put(Converter.pair(TimeZone.class, ZoneOffset.class), TimeZoneConversions::toZoneOffset);
        CONVERSION_DB.put(Converter.pair(Void.class, MonthDay.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(MonthDay.class, MonthDay.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(java.sql.Date.class, MonthDay.class), SqlDateConversions::toMonthDay);
        CONVERSION_DB.put(Converter.pair(Date.class, MonthDay.class), DateConversions::toMonthDay);
        CONVERSION_DB.put(Converter.pair(Timestamp.class, MonthDay.class), TimestampConversions::toMonthDay);
        CONVERSION_DB.put(Converter.pair(LocalDate.class, MonthDay.class), LocalDateConversions::toMonthDay);
        CONVERSION_DB.put(Converter.pair(LocalDateTime.class, MonthDay.class), LocalDateTimeConversions::toMonthDay);
        CONVERSION_DB.put(Converter.pair(ZonedDateTime.class, MonthDay.class), ZonedDateTimeConversions::toMonthDay);
        CONVERSION_DB.put(Converter.pair(OffsetDateTime.class, MonthDay.class), OffsetDateTimeConversions::toMonthDay);
        CONVERSION_DB.put(Converter.pair(Calendar.class, MonthDay.class), CalendarConversions::toMonthDay);
        CONVERSION_DB.put(Converter.pair(String.class, MonthDay.class), StringConversions::toMonthDay);
        CONVERSION_DB.put(Converter.pair(Map.class, MonthDay.class), MapConversions::toMonthDay);
        CONVERSION_DB.put(Converter.pair(Void.class, YearMonth.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(YearMonth.class, YearMonth.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(java.sql.Date.class, YearMonth.class), SqlDateConversions::toYearMonth);
        CONVERSION_DB.put(Converter.pair(Date.class, YearMonth.class), DateConversions::toYearMonth);
        CONVERSION_DB.put(Converter.pair(Timestamp.class, YearMonth.class), TimestampConversions::toYearMonth);
        CONVERSION_DB.put(Converter.pair(LocalDate.class, YearMonth.class), LocalDateConversions::toYearMonth);
        CONVERSION_DB.put(Converter.pair(LocalDateTime.class, YearMonth.class), LocalDateTimeConversions::toYearMonth);
        CONVERSION_DB.put(Converter.pair(ZonedDateTime.class, YearMonth.class), ZonedDateTimeConversions::toYearMonth);
        CONVERSION_DB.put(Converter.pair(OffsetDateTime.class, YearMonth.class), OffsetDateTimeConversions::toYearMonth);
        CONVERSION_DB.put(Converter.pair(Calendar.class, YearMonth.class), CalendarConversions::toYearMonth);
        CONVERSION_DB.put(Converter.pair(String.class, YearMonth.class), StringConversions::toYearMonth);
        CONVERSION_DB.put(Converter.pair(Map.class, YearMonth.class), MapConversions::toYearMonth);
        CONVERSION_DB.put(Converter.pair(Void.class, Period.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Period.class, Period.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(String.class, Period.class), StringConversions::toPeriod);
        CONVERSION_DB.put(Converter.pair(Map.class, Period.class), MapConversions::toPeriod);
        CONVERSION_DB.put(Converter.pair(Void.class, StringBuffer.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(String.class, StringBuffer.class), StringConversions::toStringBuffer);
        CONVERSION_DB.put(Converter.pair(StringBuilder.class, StringBuffer.class), StringConversions::toStringBuffer);
        CONVERSION_DB.put(Converter.pair(StringBuffer.class, StringBuffer.class), StringConversions::toStringBuffer);
        CONVERSION_DB.put(Converter.pair(ByteBuffer.class, StringBuffer.class), ByteBufferConversions::toStringBuffer);
        CONVERSION_DB.put(Converter.pair(CharBuffer.class, StringBuffer.class), CharBufferConversions::toStringBuffer);
        CONVERSION_DB.put(Converter.pair(Character[].class, StringBuffer.class), CharacterArrayConversions::toStringBuffer);
        CONVERSION_DB.put(Converter.pair(char[].class, StringBuffer.class), CharArrayConversions::toStringBuffer);
        CONVERSION_DB.put(Converter.pair(byte[].class, StringBuffer.class), ByteArrayConversions::toStringBuffer);
        CONVERSION_DB.put(Converter.pair(Map.class, StringBuffer.class), MapConversions::toStringBuffer);
        CONVERSION_DB.put(Converter.pair(Void.class, StringBuilder.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(String.class, StringBuilder.class), StringConversions::toStringBuilder);
        CONVERSION_DB.put(Converter.pair(StringBuilder.class, StringBuilder.class), StringConversions::toStringBuilder);
        CONVERSION_DB.put(Converter.pair(StringBuffer.class, StringBuilder.class), StringConversions::toStringBuilder);
        CONVERSION_DB.put(Converter.pair(ByteBuffer.class, StringBuilder.class), ByteBufferConversions::toStringBuilder);
        CONVERSION_DB.put(Converter.pair(CharBuffer.class, StringBuilder.class), CharBufferConversions::toStringBuilder);
        CONVERSION_DB.put(Converter.pair(Character[].class, StringBuilder.class), CharacterArrayConversions::toStringBuilder);
        CONVERSION_DB.put(Converter.pair(char[].class, StringBuilder.class), CharArrayConversions::toStringBuilder);
        CONVERSION_DB.put(Converter.pair(byte[].class, StringBuilder.class), ByteArrayConversions::toStringBuilder);
        CONVERSION_DB.put(Converter.pair(Map.class, StringBuilder.class), MapConversions::toStringBuilder);
        CONVERSION_DB.put(Converter.pair(Void.class, byte[].class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(String.class, byte[].class), StringConversions::toByteArray);
        CONVERSION_DB.put(Converter.pair(StringBuilder.class, byte[].class), StringConversions::toByteArray);
        CONVERSION_DB.put(Converter.pair(StringBuffer.class, byte[].class), StringConversions::toByteArray);
        CONVERSION_DB.put(Converter.pair(ByteBuffer.class, byte[].class), ByteBufferConversions::toByteArray);
        CONVERSION_DB.put(Converter.pair(CharBuffer.class, byte[].class), CharBufferConversions::toByteArray);
        CONVERSION_DB.put(Converter.pair(char[].class, byte[].class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(byte[].class, byte[].class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(Void.class, char[].class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(String.class, char[].class), StringConversions::toCharArray);
        CONVERSION_DB.put(Converter.pair(StringBuilder.class, char[].class), StringConversions::toCharArray);
        CONVERSION_DB.put(Converter.pair(StringBuffer.class, char[].class), StringConversions::toCharArray);
        CONVERSION_DB.put(Converter.pair(ByteBuffer.class, char[].class), ByteBufferConversions::toCharArray);
        CONVERSION_DB.put(Converter.pair(CharBuffer.class, char[].class), CharBufferConversions::toCharArray);
        CONVERSION_DB.put(Converter.pair(char[].class, char[].class), CharArrayConversions::toCharArray);
        CONVERSION_DB.put(Converter.pair(byte[].class, char[].class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Void.class, Character[].class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(String.class, Character[].class), StringConversions::toCharacterArray);
        CONVERSION_DB.put(Converter.pair(StringBuffer.class, Character[].class), StringConversions::toCharacterArray);
        CONVERSION_DB.put(Converter.pair(StringBuilder.class, Character[].class), StringConversions::toCharacterArray);
        CONVERSION_DB.put(Converter.pair(Void.class, CharBuffer.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(String.class, CharBuffer.class), StringConversions::toCharBuffer);
        CONVERSION_DB.put(Converter.pair(StringBuilder.class, CharBuffer.class), StringConversions::toCharBuffer);
        CONVERSION_DB.put(Converter.pair(StringBuffer.class, CharBuffer.class), StringConversions::toCharBuffer);
        CONVERSION_DB.put(Converter.pair(ByteBuffer.class, CharBuffer.class), ByteBufferConversions::toCharBuffer);
        CONVERSION_DB.put(Converter.pair(CharBuffer.class, CharBuffer.class), CharBufferConversions::toCharBuffer);
        CONVERSION_DB.put(Converter.pair(char[].class, CharBuffer.class), CharArrayConversions::toCharBuffer);
        CONVERSION_DB.put(Converter.pair(byte[].class, CharBuffer.class), ByteArrayConversions::toCharBuffer);
        CONVERSION_DB.put(Converter.pair(Map.class, CharBuffer.class), MapConversions::toCharBuffer);
        CONVERSION_DB.put(Converter.pair(Void.class, ByteBuffer.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(String.class, ByteBuffer.class), StringConversions::toByteBuffer);
        CONVERSION_DB.put(Converter.pair(StringBuilder.class, ByteBuffer.class), StringConversions::toByteBuffer);
        CONVERSION_DB.put(Converter.pair(StringBuffer.class, ByteBuffer.class), StringConversions::toByteBuffer);
        CONVERSION_DB.put(Converter.pair(ByteBuffer.class, ByteBuffer.class), ByteBufferConversions::toByteBuffer);
        CONVERSION_DB.put(Converter.pair(CharBuffer.class, ByteBuffer.class), CharBufferConversions::toByteBuffer);
        CONVERSION_DB.put(Converter.pair(char[].class, ByteBuffer.class), CharArrayConversions::toByteBuffer);
        CONVERSION_DB.put(Converter.pair(byte[].class, ByteBuffer.class), ByteArrayConversions::toByteBuffer);
        CONVERSION_DB.put(Converter.pair(Map.class, ByteBuffer.class), MapConversions::toByteBuffer);
        CONVERSION_DB.put(Converter.pair(Void.class, Year.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Year.class, Year.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(Short.class, Year.class), NumberConversions::toYear);
        CONVERSION_DB.put(Converter.pair(Integer.class, Year.class), NumberConversions::toYear);
        CONVERSION_DB.put(Converter.pair(Long.class, Year.class), NumberConversions::toYear);
        CONVERSION_DB.put(Converter.pair(Float.class, Year.class), NumberConversions::toYear);
        CONVERSION_DB.put(Converter.pair(Double.class, Year.class), NumberConversions::toYear);
        CONVERSION_DB.put(Converter.pair(AtomicInteger.class, Year.class), NumberConversions::toYear);
        CONVERSION_DB.put(Converter.pair(AtomicLong.class, Year.class), NumberConversions::toYear);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, Year.class), NumberConversions::toYear);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, Year.class), NumberConversions::toYear);
        CONVERSION_DB.put(Converter.pair(java.sql.Date.class, Year.class), SqlDateConversions::toYear);
        CONVERSION_DB.put(Converter.pair(Date.class, Year.class), DateConversions::toYear);
        CONVERSION_DB.put(Converter.pair(Timestamp.class, Year.class), TimestampConversions::toYear);
        CONVERSION_DB.put(Converter.pair(LocalDate.class, Year.class), LocalDateConversions::toYear);
        CONVERSION_DB.put(Converter.pair(LocalDateTime.class, Year.class), LocalDateTimeConversions::toYear);
        CONVERSION_DB.put(Converter.pair(ZonedDateTime.class, Year.class), ZonedDateTimeConversions::toYear);
        CONVERSION_DB.put(Converter.pair(OffsetDateTime.class, Year.class), OffsetDateTimeConversions::toYear);
        CONVERSION_DB.put(Converter.pair(Calendar.class, Year.class), CalendarConversions::toYear);
        CONVERSION_DB.put(Converter.pair(String.class, Year.class), StringConversions::toYear);
        CONVERSION_DB.put(Converter.pair(Map.class, Year.class), MapConversions::toYear);
        CONVERSION_DB.put(Converter.pair(Void.class, Throwable.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Map.class, Throwable.class), MapConversions::toThrowable);
        CONVERSION_DB.put(Converter.pair(Void.class, Map.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Byte.class, Map.class), MapConversions::initMap);
        CONVERSION_DB.put(Converter.pair(Short.class, Map.class), MapConversions::initMap);
        CONVERSION_DB.put(Converter.pair(Integer.class, Map.class), MapConversions::initMap);
        CONVERSION_DB.put(Converter.pair(Long.class, Map.class), MapConversions::initMap);
        CONVERSION_DB.put(Converter.pair(Float.class, Map.class), MapConversions::initMap);
        CONVERSION_DB.put(Converter.pair(Double.class, Map.class), MapConversions::initMap);
        CONVERSION_DB.put(Converter.pair(Boolean.class, Map.class), MapConversions::initMap);
        CONVERSION_DB.put(Converter.pair(Character.class, Map.class), MapConversions::initMap);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, Map.class), MapConversions::initMap);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, Map.class), MapConversions::initMap);
        CONVERSION_DB.put(Converter.pair(AtomicBoolean.class, Map.class), MapConversions::initMap);
        CONVERSION_DB.put(Converter.pair(AtomicInteger.class, Map.class), MapConversions::initMap);
        CONVERSION_DB.put(Converter.pair(AtomicLong.class, Map.class), MapConversions::initMap);
        CONVERSION_DB.put(Converter.pair(Date.class, Map.class), DateConversions::toMap);
        CONVERSION_DB.put(Converter.pair(java.sql.Date.class, Map.class), SqlDateConversions::toMap);
        CONVERSION_DB.put(Converter.pair(Timestamp.class, Map.class), TimestampConversions::toMap);
        CONVERSION_DB.put(Converter.pair(Calendar.class, Map.class), CalendarConversions::toMap);
        CONVERSION_DB.put(Converter.pair(LocalDate.class, Map.class), LocalDateConversions::toMap);
        CONVERSION_DB.put(Converter.pair(LocalDateTime.class, Map.class), LocalDateTimeConversions::toMap);
        CONVERSION_DB.put(Converter.pair(ZonedDateTime.class, Map.class), ZonedDateTimeConversions::toMap);
        CONVERSION_DB.put(Converter.pair(Duration.class, Map.class), DurationConversions::toMap);
        CONVERSION_DB.put(Converter.pair(Instant.class, Map.class), InstantConversions::toMap);
        CONVERSION_DB.put(Converter.pair(LocalTime.class, Map.class), LocalTimeConversions::toMap);
        CONVERSION_DB.put(Converter.pair(MonthDay.class, Map.class), MonthDayConversions::toMap);
        CONVERSION_DB.put(Converter.pair(YearMonth.class, Map.class), YearMonthConversions::toMap);
        CONVERSION_DB.put(Converter.pair(Period.class, Map.class), PeriodConversions::toMap);
        CONVERSION_DB.put(Converter.pair(TimeZone.class, Map.class), TimeZoneConversions::toMap);
        CONVERSION_DB.put(Converter.pair(ZoneId.class, Map.class), ZoneIdConversions::toMap);
        CONVERSION_DB.put(Converter.pair(ZoneOffset.class, Map.class), ZoneOffsetConversions::toMap);
        CONVERSION_DB.put(Converter.pair(Class.class, Map.class), MapConversions::initMap);
        CONVERSION_DB.put(Converter.pair(UUID.class, Map.class), UUIDConversions::toMap);
        CONVERSION_DB.put(Converter.pair(Map.class, Map.class), UNSUPPORTED);
        CONVERSION_DB.put(Converter.pair(Enum.class, Map.class), EnumConversions::toMap);
        CONVERSION_DB.put(Converter.pair(OffsetDateTime.class, Map.class), OffsetDateTimeConversions::toMap);
        CONVERSION_DB.put(Converter.pair(OffsetTime.class, Map.class), OffsetTimeConversions::toMap);
        CONVERSION_DB.put(Converter.pair(Year.class, Map.class), YearConversions::toMap);
        CONVERSION_DB.put(Converter.pair(Locale.class, Map.class), LocaleConversions::toMap);
        CONVERSION_DB.put(Converter.pair(URI.class, Map.class), UriConversions::toMap);
        CONVERSION_DB.put(Converter.pair(URL.class, Map.class), UrlConversions::toMap);
        CONVERSION_DB.put(Converter.pair(Throwable.class, Map.class), ThrowableConversions::toMap);
        CONVERSION_DB.put(Converter.pair(Pattern.class, Map.class), PatternConversions::toMap);
        CONVERSION_DB.put(Converter.pair(Currency.class, Map.class), CurrencyConversions::toMap);
        CONVERSION_DB.put(Converter.pair(ByteBuffer.class, Map.class), ByteBufferConversions::toMap);
        CONVERSION_DB.put(Converter.pair(CharBuffer.class, Map.class), CharBufferConversions::toMap);
    }

    public Converter(ConverterOptions options) {
        this.options = options;
        USER_DB.putAll(this.options.getConverterOverrides());
    }

    public <T> T convert(Object from, Class<T> toType) {
        ConversionPair key;
        Convert<Object> conversionMethod;
        Convert<T> cached;
        Class sourceType;
        if (toType == null) {
            throw new IllegalArgumentException("toType cannot be null");
        }
        if (from == null) {
            sourceType = Void.class;
            cached = Converter.getCachedConverter(sourceType, toType);
            if (cached != null) {
                return (T)cached.convert(from, this, toType);
            }
        } else {
            sourceType = from.getClass();
            if (toType.isPrimitive()) {
                toType = ClassUtilities.toPrimitiveWrapperClass(toType);
            }
            if ((cached = Converter.getCachedConverter(sourceType, toType)) != null) {
                return (T)cached.convert(from, this, toType);
            }
            T result = this.attemptCollectionConversion(from, sourceType, toType);
            if (result != null) {
                return result;
            }
        }
        if (Converter.isValidConversion(conversionMethod = USER_DB.get(key = Converter.pair(sourceType, toType)))) {
            Converter.cacheConverter(sourceType, toType, conversionMethod);
            return (T)conversionMethod.convert(from, this, toType);
        }
        conversionMethod = CONVERSION_DB.get(key);
        if (Converter.isValidConversion(conversionMethod)) {
            Converter.cacheConverter(sourceType, toType, conversionMethod);
            return (T)conversionMethod.convert(from, this, toType);
        }
        conversionMethod = Converter.getInheritedConverter(sourceType, toType);
        if (Converter.isValidConversion(conversionMethod)) {
            Converter.cacheConverter(sourceType, toType, conversionMethod);
            return (T)conversionMethod.convert(from, this, toType);
        }
        throw new IllegalArgumentException("Unsupported conversion, source type [" + Converter.name(from) + "] target type '" + Converter.getShortName(toType) + "'");
    }

    private static Convert<?> getCachedConverter(Class<?> source, Class<?> target) {
        ClassValueMap<Convert<?>> targetMap = FULL_CONVERSION_CACHE.get(source);
        if (targetMap != null) {
            return targetMap.get(target);
        }
        return null;
    }

    private static void cacheConverter(Class<?> source, Class<?> target, Convert<?> converter) {
        FULL_CONVERSION_CACHE.computeIfAbsent(source, s -> new ClassValueMap()).put(target, converter);
    }

    private <T> T attemptCollectionConversion(Object from, Class<?> sourceType, Class<T> toType) {
        if (!from.getClass().isArray() && !(from instanceof Collection)) {
            return null;
        }
        if (EnumSet.class.isAssignableFrom(toType)) {
            throw new IllegalArgumentException("To convert to EnumSet, specify the Enum class to convert to as the 'toType.' Example: EnumSet<Day> daySet = (EnumSet<Day>)(Object)converter.convert(array, Day.class);");
        }
        if (toType.isEnum()) {
            if (sourceType.isArray() || Collection.class.isAssignableFrom(sourceType)) {
                return (T)EnumConversions.toEnumSet(from, toType);
            }
        } else if (EnumSet.class.isAssignableFrom(sourceType)) {
            if (Collection.class.isAssignableFrom(toType)) {
                Collection<?> target = CollectionHandling.createCollection(from, toType);
                target.addAll((Collection)from);
                return (T)target;
            }
            if (toType.isArray()) {
                return (T)ArrayConversions.enumSetToArray((EnumSet)from, toType);
            }
        } else if (Collection.class.isAssignableFrom(sourceType)) {
            if (toType.isArray()) {
                return (T)ArrayConversions.collectionToArray((Collection)from, toType, this);
            }
            if (Collection.class.isAssignableFrom(toType)) {
                return (T)CollectionConversions.collectionToCollection((Collection)from, toType);
            }
        } else if (sourceType.isArray()) {
            if (Collection.class.isAssignableFrom(toType)) {
                return CollectionConversions.arrayToCollection(from, toType);
            }
            if (toType.isArray() && !sourceType.getComponentType().equals(toType.getComponentType())) {
                return (T)ArrayConversions.arrayToArray(from, toType, this);
            }
        }
        return null;
    }

    private static Convert<?> getInheritedConverter(Class<?> sourceType, Class<?> toType) {
        TreeSet<ClassLevel> sourceTypes = new TreeSet<ClassLevel>(Converter.getSuperClassesAndInterfaces(sourceType));
        sourceTypes.add(new ClassLevel(sourceType, 0));
        TreeSet<ClassLevel> targetTypes = new TreeSet<ClassLevel>(Converter.getSuperClassesAndInterfaces(toType));
        targetTypes.add(new ClassLevel(toType, 0));
        class ConversionPairWithLevel {
            private final ConversionPair pair;
            private final int sourceLevel;
            private final int targetLevel;

            ConversionPairWithLevel(Class<?> source, Class<?> target, int sourceLevel, int targetLevel) {
                this.pair = Converter.pair(source, target);
                this.sourceLevel = sourceLevel;
                this.targetLevel = targetLevel;
            }
        }
        ArrayList<ConversionPairWithLevel> pairs = new ArrayList<ConversionPairWithLevel>();
        for (ClassLevel source : sourceTypes) {
            for (ClassLevel target : targetTypes) {
                pairs.add(new ConversionPairWithLevel(source.clazz, target.clazz, source.level, target.level));
            }
        }
        pairs.sort((p1, p2) -> {
            boolean p2ToInterface;
            boolean p2FromInterface;
            int dist2;
            boolean p2AssignableToP1;
            boolean p1AssignableToP2;
            boolean p2ExactTarget;
            boolean p1ExactTarget = ((ConversionPairWithLevel)p1).pair.getTarget() == toType;
            boolean bl = p2ExactTarget = ((ConversionPairWithLevel)p2).pair.getTarget() == toType;
            if (p1ExactTarget != p2ExactTarget) {
                return p1ExactTarget ? -1 : 1;
            }
            if (((ConversionPairWithLevel)p1).pair.getTarget() != ((ConversionPairWithLevel)p2).pair.getTarget() && (p1AssignableToP2 = ((ConversionPairWithLevel)p2).pair.getTarget().isAssignableFrom(((ConversionPairWithLevel)p1).pair.getTarget())) != (p2AssignableToP1 = ((ConversionPairWithLevel)p1).pair.getTarget().isAssignableFrom(((ConversionPairWithLevel)p2).pair.getTarget()))) {
                return p1AssignableToP2 ? -1 : 1;
            }
            int dist1 = ((ConversionPairWithLevel)p1).sourceLevel + ((ConversionPairWithLevel)p1).targetLevel;
            if (dist1 != (dist2 = ((ConversionPairWithLevel)p2).sourceLevel + ((ConversionPairWithLevel)p2).targetLevel)) {
                return dist1 - dist2;
            }
            boolean p1FromInterface = ((ConversionPairWithLevel)p1).pair.getSource().isInterface();
            if (p1FromInterface != (p2FromInterface = ((ConversionPairWithLevel)p2).pair.getSource().isInterface())) {
                return p1FromInterface ? 1 : -1;
            }
            boolean p1ToInterface = ((ConversionPairWithLevel)p1).pair.getTarget().isInterface();
            if (p1ToInterface != (p2ToInterface = ((ConversionPairWithLevel)p2).pair.getTarget().isInterface())) {
                return p1ToInterface ? 1 : -1;
            }
            return 0;
        });
        for (ConversionPairWithLevel pairWithLevel : pairs) {
            Convert<?> tempConverter = USER_DB.get(pairWithLevel.pair);
            if (tempConverter != null) {
                return tempConverter;
            }
            tempConverter = CONVERSION_DB.get(pairWithLevel.pair);
            if (tempConverter == null) continue;
            return tempConverter;
        }
        return null;
    }

    private static SortedSet<ClassLevel> getSuperClassesAndInterfaces(Class<?> clazz) {
        return cacheParentTypes.computeIfAbsent(clazz, key -> {
            TreeSet<ClassLevel> parentTypes = new TreeSet<ClassLevel>();
            ClassUtilities.ClassHierarchyInfo info = ClassUtilities.getClassHierarchyInfo(key);
            for (Map.Entry<Class<?>, Integer> entry : info.getDistanceMap().entrySet()) {
                Class<?> type = entry.getKey();
                int distance = entry.getValue();
                if (distance <= 0 || type == Serializable.class || type == Cloneable.class || type == Comparable.class || type == Externalizable.class) continue;
                parentTypes.add(new ClassLevel(type, distance));
            }
            return parentTypes;
        });
    }

    static String getShortName(Class<?> type) {
        if (type.isArray()) {
            String customName = CUSTOM_ARRAY_NAMES.get(type);
            if (customName != null) {
                return customName;
            }
            Class<?> componentType = type.getComponentType();
            return componentType.getSimpleName() + "[]";
        }
        if (java.sql.Date.class.equals(type)) {
            return type.getName();
        }
        return type.getSimpleName();
    }

    private static String name(Object from) {
        if (from == null) {
            return "null";
        }
        return Converter.getShortName(from.getClass()) + " (" + from + ")";
    }

    public static boolean isCollectionConversionSupported(Class<?> sourceType, Class<?> target) {
        if (!(sourceType.isArray() || Collection.class.isAssignableFrom(sourceType) || EnumSet.class.isAssignableFrom(sourceType))) {
            return false;
        }
        if (EnumSet.class.isAssignableFrom(target)) {
            throw new IllegalArgumentException("To convert to EnumSet, specify the Enum class to convert to as the 'toType.' Example: EnumSet<Day> daySet = (EnumSet<Day>)(Object)converter.convert(array, Day.class);");
        }
        if (target.isEnum()) {
            return sourceType.isArray() || Collection.class.isAssignableFrom(sourceType);
        }
        if (EnumSet.class.isAssignableFrom(sourceType)) {
            return target.isArray() || Collection.class.isAssignableFrom(target);
        }
        if (Collection.class.isAssignableFrom(sourceType)) {
            return target.isArray() || Collection.class.isAssignableFrom(target);
        }
        if (sourceType.isArray()) {
            if (Collection.class.isAssignableFrom(target)) {
                return true;
            }
            return target.isArray() && !sourceType.getComponentType().equals(target.getComponentType());
        }
        return false;
    }

    public boolean isSimpleTypeConversionSupported(Class<?> source, Class<?> target) {
        Convert<?> cached = Converter.getCachedConverter(source, target);
        if (cached != null) {
            return cached != UNSUPPORTED;
        }
        if (source.isArray() || target.isArray() || Collection.class.isAssignableFrom(source) || Collection.class.isAssignableFrom(target)) {
            return false;
        }
        if (source.equals(Number.class)) {
            Convert<?> method = Converter.getConversionFromDBs(Long.class, target);
            Converter.cacheConverter(source, target, method);
            return Converter.isValidConversion(method);
        }
        Convert<?> method = Converter.getConversionFromDBs(source, target);
        if (Converter.isValidConversion(method)) {
            Converter.cacheConverter(source, target, method);
            return true;
        }
        method = Converter.getInheritedConverter(source, target);
        if (Converter.isValidConversion(method)) {
            Converter.cacheConverter(source, target, method);
            return true;
        }
        Converter.cacheConverter(source, target, UNSUPPORTED);
        return false;
    }

    public boolean isConversionSupportedFor(Class<?> source, Class<?> target) {
        Convert<?> cached = Converter.getCachedConverter(source, target);
        if (cached != null) {
            return cached != UNSUPPORTED;
        }
        Convert<?> method = Converter.getConversionFromDBs(source, target);
        if (Converter.isValidConversion(method)) {
            Converter.cacheConverter(source, target, method);
            return true;
        }
        if (Converter.isCollectionConversionSupported(source, target)) {
            if (source.isArray() && target.isArray()) {
                return target.getComponentType() == Object.class || this.isConversionSupportedFor(source.getComponentType(), target.getComponentType());
            }
            return true;
        }
        method = Converter.getInheritedConverter(source, target);
        if (Converter.isValidConversion(method)) {
            Converter.cacheConverter(source, target, method);
            return true;
        }
        return false;
    }

    private static boolean isValidConversion(Convert<?> method) {
        return method != null && method != UNSUPPORTED;
    }

    private static Convert<?> getConversionFromDBs(Class<?> source, Class<?> target) {
        ConversionPair key = Converter.pair(source = ClassUtilities.toPrimitiveWrapperClass(source), target = ClassUtilities.toPrimitiveWrapperClass(target));
        Convert<?> method = USER_DB.get(key);
        if (Converter.isValidConversion(method)) {
            return method;
        }
        method = CONVERSION_DB.get(key);
        if (Converter.isValidConversion(method)) {
            return method;
        }
        return UNSUPPORTED;
    }

    public static Map<Class<?>, Set<Class<?>>> allSupportedConversions() {
        TreeMap toFrom = new TreeMap(Comparator.comparing(Class::getName));
        Converter.addSupportedConversion(CONVERSION_DB, toFrom);
        Converter.addSupportedConversion(USER_DB, toFrom);
        return toFrom;
    }

    public static Map<String, Set<String>> getSupportedConversions() {
        TreeMap<String, Set<String>> toFrom = new TreeMap<String, Set<String>>(String::compareTo);
        Converter.addSupportedConversionName(CONVERSION_DB, toFrom);
        Converter.addSupportedConversionName(USER_DB, toFrom);
        return toFrom;
    }

    private static void addSupportedConversion(Map<ConversionPair, Convert<?>> db, Map<Class<?>, Set<Class<?>>> toFrom) {
        for (Map.Entry<ConversionPair, Convert<?>> entry : db.entrySet()) {
            if (entry.getValue() == UNSUPPORTED) continue;
            ConversionPair pair = entry.getKey();
            toFrom.computeIfAbsent(pair.getSource(), k -> new TreeSet<Class>(Comparator.comparing(c -> c.getName()))).add(pair.getTarget());
        }
    }

    private static void addSupportedConversionName(Map<ConversionPair, Convert<?>> db, Map<String, Set<String>> toFrom) {
        for (Map.Entry<ConversionPair, Convert<?>> entry : db.entrySet()) {
            if (entry.getValue() == UNSUPPORTED) continue;
            ConversionPair pair = entry.getKey();
            toFrom.computeIfAbsent(Converter.getShortName(pair.getSource()), k -> new TreeSet(String::compareTo)).add(Converter.getShortName(pair.getTarget()));
        }
    }

    public static Convert<?> addConversion(Class<?> source, Class<?> target, Convert<?> conversionMethod) {
        source = ClassUtilities.toPrimitiveWrapperClass(source);
        target = ClassUtilities.toPrimitiveWrapperClass(target);
        Converter.clearCachesForType(source, target);
        return USER_DB.put(Converter.pair(source, target), conversionMethod);
    }

    public static <T> T identity(T from, Converter converter) {
        return from;
    }

    private static <T> T unsupported(T from, Converter converter) {
        return null;
    }

    private static void clearCachesForType(Class<?> source, Class<?> target) {
        ClassValueMap<Convert<?>> targetMap = FULL_CONVERSION_CACHE.get(source);
        if (targetMap != null) {
            targetMap.remove(target);
        }
    }

    static {
        CUSTOM_ARRAY_NAMES.put(java.sql.Date[].class, "java.sql.Date[]");
        Converter.buildFactoryConversions();
        CONVERSION_DB = Collections.unmodifiableMap(CONVERSION_DB);
    }

    public static final class ConversionPair {
        private final Class<?> source;
        private final Class<?> target;
        private final int hash;

        private ConversionPair(Class<?> source, Class<?> target) {
            this.source = source;
            this.target = target;
            this.hash = 31 * source.hashCode() + target.hashCode();
        }

        public Class<?> getSource() {
            return this.source;
        }

        public Class<?> getTarget() {
            return this.target;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ConversionPair)) {
                return false;
            }
            ConversionPair other = (ConversionPair)obj;
            return this.source == other.source && this.target == other.target;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    static class ClassLevel
    implements Comparable<ClassLevel> {
        private final Class<?> clazz;
        private final int level;
        private final boolean isInterface;

        ClassLevel(Class<?> c, int level) {
            this.clazz = c;
            this.level = level;
            this.isInterface = c.isInterface();
        }

        @Override
        public int compareTo(ClassLevel other) {
            int levelComparison = Integer.compare(this.level, other.level);
            if (levelComparison != 0) {
                return levelComparison;
            }
            if (this.isInterface && !other.isInterface) {
                return 1;
            }
            if (!this.isInterface && other.isInterface) {
                return -1;
            }
            return this.clazz.getName().compareTo(other.clazz.getName());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ClassLevel)) {
                return false;
            }
            ClassLevel other = (ClassLevel)obj;
            return this.clazz.equals(other.clazz) && this.level == other.level;
        }

        public int hashCode() {
            return this.clazz.hashCode() * 31 + this.level;
        }
    }
}

