/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.convert.Converter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

final class LocalTimeConversions {
    static final BigDecimal BILLION = BigDecimal.valueOf(1000000000L);
    public static final String LOCALTIME_LONG_PRECISION = "localtime.long.precision";

    private LocalTimeConversions() {
    }

    static Map<String, Object> toMap(Object from, Converter converter) {
        LocalTime localTime = (LocalTime)from;
        LinkedHashMap<String, Object> target = new LinkedHashMap<String, Object>();
        target.put("localTime", localTime.toString());
        return target;
    }

    static long toLong(Object from, Converter converter) {
        LocalTime lt = (LocalTime)from;
        String systemPrecision = System.getProperty("cedarsoftware.converter.localtime.long.precision");
        String precision = systemPrecision;
        if (precision == null) {
            precision = (String)converter.getOptions().getCustomOption(LOCALTIME_LONG_PRECISION);
        }
        if ("nanos".equals(precision)) {
            return lt.toNanoOfDay();
        }
        return lt.toNanoOfDay() / 1000000L;
    }

    static double toDouble(Object from, Converter converter) {
        LocalTime lt = (LocalTime)from;
        return (double)lt.toNanoOfDay() / 1.0E9;
    }

    static BigInteger toBigInteger(Object from, Converter converter) {
        LocalTime lt = (LocalTime)from;
        return BigInteger.valueOf(lt.toNanoOfDay());
    }

    static BigDecimal toBigDecimal(Object from, Converter converter) {
        LocalTime lt = (LocalTime)from;
        return new BigDecimal(lt.toNanoOfDay()).divide(BILLION, 9, RoundingMode.HALF_UP);
    }

    static AtomicLong toAtomicLong(Object from, Converter converter) {
        return new AtomicLong(LocalTimeConversions.toLong(from, converter));
    }

    static String toString(Object from, Converter converter) {
        LocalTime localTime = (LocalTime)from;
        return localTime.format(DateTimeFormatter.ISO_LOCAL_TIME);
    }

    static Calendar toCalendar(Object from, Converter converter) {
        LocalTime localTime = (LocalTime)from;
        Calendar cal = Calendar.getInstance(converter.getOptions().getTimeZone());
        cal.set(11, localTime.getHour());
        cal.set(12, localTime.getMinute());
        cal.set(13, localTime.getSecond());
        cal.set(14, localTime.getNano() / 1000000);
        return cal;
    }
}

