/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io;

import com.cedarsoftware.util.io.JsonIoException;
import com.cedarsoftware.util.io.JsonReader;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class JsonObject<K, V>
extends LinkedHashMap<K, V> {
    Object target;
    boolean isMap = false;
    String type;
    long id = -1L;
    int line;
    int col;

    public long getId() {
        return this.id;
    }

    public boolean hasId() {
        return this.id != -1L;
    }

    public void setType(String type) {
        this.type = type != null ? type.intern() : null;
    }

    public String getType() {
        return this.type;
    }

    public Object getTarget() {
        return this.target;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public Class getTargetClass() {
        return this.target.getClass();
    }

    public boolean isPrimitive() {
        if (this.type == null) {
            return false;
        }
        switch (this.type) {
            case "double": 
            case "int": 
            case "byte": 
            case "char": 
            case "long": 
            case "boolean": 
            case "float": 
            case "short": {
                return true;
            }
        }
        return false;
    }

    public static boolean isPrimitiveWrapper(Class c) {
        String cname;
        switch (cname = c.getName()) {
            case "java.lang.Integer": 
            case "java.lang.Float": 
            case "java.lang.Short": 
            case "java.lang.Character": 
            case "java.lang.Boolean": 
            case "java.lang.Byte": 
            case "java.lang.Long": 
            case "java.lang.Double": {
                return true;
            }
        }
        return false;
    }

    public Object getPrimitiveValue() {
        switch (this.type) {
            case "byte": {
                Number b = (Number)this.get("value");
                return b.byteValue();
            }
            case "char": {
                String c = (String)this.get("value");
                return Character.valueOf(c.charAt(0));
            }
            case "double": 
            case "long": 
            case "boolean": {
                return this.get("value");
            }
            case "float": {
                Number f = (Number)this.get("value");
                return Float.valueOf(f.floatValue());
            }
            case "int": {
                Number integer = (Number)this.get("value");
                return integer.intValue();
            }
            case "short": {
                Number s = (Number)this.get("value");
                return s.shortValue();
            }
        }
        return JsonReader.error("Invalid primitive type");
    }

    public boolean isMap() {
        return this.isMap || this.target instanceof Map;
    }

    public boolean isCollection() {
        if (this.containsKey("@items") && !this.containsKey("@keys")) {
            return this.target instanceof Collection || this.type != null && !this.type.contains("[");
        }
        return this.target instanceof Collection;
    }

    public boolean isArray() {
        if (this.target == null) {
            if (this.type != null) {
                return this.type.contains("[");
            }
            return this.containsKey("@items") && !this.containsKey("@keys");
        }
        return this.target.getClass().isArray();
    }

    public Object[] getArray() {
        return (Object[])this.get("@items");
    }

    public int getLength() {
        if (this.isArray()) {
            if (this.target == null) {
                Object[] items = (Object[])this.get("@items");
                return items == null ? 0 : items.length;
            }
            return Array.getLength(this.target);
        }
        if (this.isCollection() || this.isMap()) {
            Object[] items = (Object[])this.get("@items");
            return items == null ? 0 : items.length;
        }
        throw new JsonIoException("getLength() called on a non-collection, line " + this.line + ", col " + this.col);
    }

    public Class getComponentType() {
        return this.target.getClass().getComponentType();
    }

    void moveBytesToMate() {
        byte[] bytes = (byte[])this.target;
        Object[] items = this.getArray();
        int len = items.length;
        int i = 0;
        while (i < len) {
            bytes[i] = ((Number)items[i]).byteValue();
            ++i;
        }
    }

    void moveCharsToMate() {
        Object[] items = this.getArray();
        if (items == null) {
            this.target = null;
        } else if (items.length == 0) {
            this.target = new char[0];
        } else if (items.length == 1) {
            String s = (String)items[0];
            this.target = s.toCharArray();
        } else {
            throw new JsonIoException("char[] should only have one String in the [], found " + items.length + ", line " + this.line + ", col " + this.col);
        }
    }

    @Override
    public V put(K key, V value) {
        if (key == null) {
            return super.put(null, value);
        }
        if (key.equals("@type")) {
            String oldType = this.type;
            this.type = (String)value;
            return (V)oldType;
        }
        if (key.equals("@id")) {
            Long oldId = this.id;
            this.id = (Long)value;
            return (V)oldId;
        }
        if ("@items".equals(key) && this.containsKey("@keys") || "@keys".equals(key) && this.containsKey("@items")) {
            this.isMap = true;
        }
        return super.put(key, value);
    }

    @Override
    public void clear() {
        super.clear();
        this.type = null;
    }

    void clearArray() {
        this.remove("@items");
    }

    public int getLine() {
        return this.line;
    }

    public int getCol() {
        return this.col;
    }

    @Override
    public int size() {
        if (this.containsKey("@items")) {
            Object value = this.get("@items");
            if (value instanceof Object[]) {
                return ((Object[])value).length;
            }
            if (value == null) {
                return 0;
            }
            throw new JsonIoException("JsonObject with @items, but no array [] associated to it, line " + this.line + ", col " + this.col);
        }
        if (this.containsKey("@ref")) {
            return 0;
        }
        return super.size();
    }
}

