/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class CollectionUtilities {
    private static final Set<?> unmodifiableEmptySet = Collections.unmodifiableSet(new HashSet());
    private static final List<?> unmodifiableEmptyList = Collections.unmodifiableList(new ArrayList());

    @SafeVarargs
    public static <T> List<T> listOf(T ... items) {
        if (items == null || items.length == 0) {
            return unmodifiableEmptyList;
        }
        ArrayList list = new ArrayList();
        Collections.addAll(list, items);
        return Collections.unmodifiableList(list);
    }

    @SafeVarargs
    public static <T> Set<T> setOf(T ... items) {
        if (items == null || items.length == 0) {
            return unmodifiableEmptySet;
        }
        LinkedHashSet set = new LinkedHashSet();
        Collections.addAll(set, items);
        return Collections.unmodifiableSet(set);
    }
}

