/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io;

import com.cedarsoftware.util.io.JsonObject;
import java.util.HashMap;
import java.util.Map;

public class ReferenceTracker {
    private static final ThreadLocal<ReferenceTracker> referenceTracker = ThreadLocal.withInitial(ReferenceTracker::new);
    private final Map<Long, JsonObject> references = new HashMap<Long, JsonObject>();

    public static ReferenceTracker instance() {
        return referenceTracker.get();
    }

    public JsonObject put(Long id, JsonObject target) {
        return this.references.put(id, target);
    }

    public void clear() {
        this.references.clear();
    }

    public JsonObject getRef(Long id) {
        return this.getRefTarget(this.references.get(id));
    }

    public JsonObject getRefTarget(JsonObject jObj) {
        while (jObj != null && jObj.isReference()) {
            jObj = this.references.get(jObj.getReferenceId());
        }
        if (jObj == null) {
            throw new IllegalStateException("The JSON input had an @ref to an object that does not exist.");
        }
        return jObj;
    }
}

