/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io;

import com.cedarsoftware.util.io.ArgumentHelper;
import com.cedarsoftware.util.io.JsonReader;
import com.cedarsoftware.util.io.MetaUtils;
import com.cedarsoftware.util.io.ReadOptions;
import com.cedarsoftware.util.io.Readers;
import com.cedarsoftware.util.io.factory.EnumClassFactory;
import com.cedarsoftware.util.io.factory.LocalDateFactory;
import com.cedarsoftware.util.io.factory.LocalDateTimeFactory;
import com.cedarsoftware.util.io.factory.LocalTimeFactory;
import com.cedarsoftware.util.io.factory.OffsetDateTimeFactory;
import com.cedarsoftware.util.io.factory.OffsetTimeFactory;
import com.cedarsoftware.util.io.factory.StackTraceElementFactory;
import com.cedarsoftware.util.io.factory.ThrowableFactory;
import com.cedarsoftware.util.io.factory.TimeZoneFactory;
import com.cedarsoftware.util.io.factory.YearFactory;
import com.cedarsoftware.util.io.factory.YearMonthFactory;
import com.cedarsoftware.util.io.factory.ZoneOffsetFactory;
import com.cedarsoftware.util.io.factory.ZonedDateTimeFactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class ReadOptionsBuilder {
    private final ReadOptionsImplementation readOptions = new ReadOptionsImplementation();
    private final Map<String, String> typeNameMap = new LinkedHashMap<String, String>();
    private static final Map<Class<?>, JsonReader.JsonClassReader> BASE_READERS = new ConcurrentHashMap();
    private static final Map<Class<?>, JsonReader.ClassFactory> BASE_CLASS_FACTORIES = new ConcurrentHashMap();
    private static final Map<String, Class<?>> BASE_COERCED_TYPES = new LinkedHashMap();

    static void addPossiblePermanentReader(Map map, String fqClassName, Supplier<JsonReader.JsonClassReader> reader) {
        try {
            map.put(Class.forName(fqClassName), reader.get());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static void addPermanentCoercedType(String fqName, Class<?> c) {
        BASE_COERCED_TYPES.put(fqName, c);
    }

    public static void addReaderPermanent(Class c, JsonReader.JsonClassReader reader) {
        BASE_READERS.put(c, reader);
    }

    public static void assignInstantiator(String className, JsonReader.ClassFactory factory) {
        BASE_CLASS_FACTORIES.put(MetaUtils.classForName(className, JsonReader.class.getClassLoader()), factory);
    }

    public static void assignInstantiator(Class c, JsonReader.ClassFactory factory) {
        BASE_CLASS_FACTORIES.put(c, factory);
    }

    public ReadOptionsBuilder setUnknownTypeClass(Class<?> c) {
        this.readOptions.setUnknownTypeClass(c);
        return this;
    }

    public ReadOptionsBuilder setMissingFieldHandler(JsonReader.MissingFieldHandler missingFieldHandler) {
        this.readOptions.setMissingFieldHandler(missingFieldHandler);
        return this;
    }

    public ReadOptionsBuilder failOnUnknownType() {
        this.readOptions.setFailOnUnknownType(true);
        return this;
    }

    public ReadOptionsBuilder withClassLoader(ClassLoader classLoader) {
        this.readOptions.setClassLoader(classLoader);
        return this;
    }

    public ReadOptionsBuilder returnAsMaps() {
        this.readOptions.setUsingMaps(true);
        return this;
    }

    public ReadOptionsBuilder withCoercedType(Class<?> oldType, Class<?> newType) {
        return this.withCoercedType(oldType.getName(), newType);
    }

    public ReadOptionsBuilder withCoercedType(String fullyQualifedNameOldType, Class<?> newType) {
        this.readOptions.coercedTypes.put(fullyQualifedNameOldType, newType);
        return this;
    }

    public ReadOptionsBuilder withCustomTypeName(Class<?> type, String newTypeName) {
        return this.withCustomTypeName(type.getName(), newTypeName);
    }

    public ReadOptionsBuilder withCustomTypeName(String type, String newTypeName) {
        this.typeNameMap.put(type, newTypeName);
        return this;
    }

    public ReadOptionsBuilder withCustomTypeNames(Map<String, String> map) {
        this.typeNameMap.putAll(map);
        return this;
    }

    public ReadOptionsBuilder withCustomReader(Class<?> c, JsonReader.JsonClassReader reader) {
        this.readOptions.readers.put(c, reader);
        return this;
    }

    public ReadOptionsBuilder withCustomReaders(Map<? extends Class<?>, ? extends JsonReader.JsonClassReader> map) {
        this.readOptions.readers.putAll(map);
        return this;
    }

    public ReadOptionsBuilder withNonCustomizableClass(Class<?> c) {
        this.readOptions.getNonCustomizableClasses().add(c);
        return this;
    }

    public ReadOptionsBuilder withMaxDepth(int maxDepth) {
        this.readOptions.setMaxDepth(maxDepth);
        return this;
    }

    public ReadOptionsBuilder withNonCustomizableClasses(Collection<Class<?>> collection) {
        this.readOptions.getNonCustomizableClasses().addAll(collection);
        return this;
    }

    public ReadOptionsBuilder withClassFactory(Class<?> type, JsonReader.ClassFactory factory) {
        this.readOptions.classFactoryMap.put(type, factory);
        return this;
    }

    public ReadOptionsBuilder withClassFactories(Map<Class<?>, ? extends JsonReader.ClassFactory> factories) {
        this.readOptions.classFactoryMap.putAll(factories);
        return this;
    }

    public static ReadOptionsBuilder fromMap(Map<String, Object> args) {
        Map factories;
        Object unknownObjectClass;
        Collection nonCustomizableClasses;
        boolean isFailOnUnknownType;
        boolean useMaps;
        Map customReaders;
        JsonReader.MissingFieldHandler handler;
        ReadOptionsBuilder builder = new ReadOptionsBuilder();
        ClassLoader classLoader = args.get("CLASSLOADER") == null ? ReadOptionsBuilder.class.getClassLoader() : (ClassLoader)args.get("CLASSLOADER");
        builder.withClassLoader(classLoader);
        Map typeNames = (Map)args.get("TYPE_NAME_MAP");
        if (typeNames != null) {
            builder.withCustomTypeNames(typeNames);
        }
        if ((handler = (JsonReader.MissingFieldHandler)args.get("MISSING_FIELD_HANDLER")) != null) {
            builder.setMissingFieldHandler(handler);
        }
        if ((customReaders = (Map)args.get("CUSTOM_READERS")) != null) {
            builder.withCustomReaders(customReaders);
        }
        if (useMaps = ArgumentHelper.isTrue(args.get("USE_MAPS"))) {
            builder.returnAsMaps();
        }
        if (isFailOnUnknownType = ArgumentHelper.isTrue(args.get("FAIL_ON_UNKNOWN_TYPE"))) {
            builder.failOnUnknownType();
        }
        if ((nonCustomizableClasses = (Collection)args.get("NOT_CUSTOM_READERS")) != null) {
            builder.withNonCustomizableClasses(nonCustomizableClasses);
        }
        if ((unknownObjectClass = args.get("UNKNOWN_OBJECT")) instanceof String) {
            try {
                builder.setUnknownTypeClass(MetaUtils.classForName((String)unknownObjectClass, classLoader));
            }
            catch (Exception exception) {}
        } else if (unknownObjectClass instanceof Class) {
            builder.setUnknownTypeClass((Class)unknownObjectClass);
        }
        if ((factories = (Map)args.get("FACTORIES")) != null) {
            factories.entrySet().stream().forEach(entry -> builder.withClassFactory(MetaUtils.classForName((String)entry.getKey(), classLoader), (JsonReader.ClassFactory)entry.getValue()));
        }
        return builder;
    }

    public ReadOptions build() {
        this.readOptions.typeNameMap = this.typeNameMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        return new ReadOptionsImplementation(this.readOptions, this.readOptions.isUsingMaps());
    }

    static {
        JsonReader.MapFactory mapFactory = new JsonReader.MapFactory();
        ReadOptionsBuilder.assignInstantiator(Map.class, (JsonReader.ClassFactory)mapFactory);
        ReadOptionsBuilder.assignInstantiator(SortedMap.class, (JsonReader.ClassFactory)mapFactory);
        JsonReader.CollectionFactory colFactory = new JsonReader.CollectionFactory();
        ReadOptionsBuilder.assignInstantiator(Collection.class, (JsonReader.ClassFactory)colFactory);
        ReadOptionsBuilder.assignInstantiator(List.class, (JsonReader.ClassFactory)colFactory);
        ReadOptionsBuilder.assignInstantiator(Set.class, (JsonReader.ClassFactory)colFactory);
        ReadOptionsBuilder.assignInstantiator(SortedSet.class, (JsonReader.ClassFactory)colFactory);
        ReadOptionsBuilder.assignInstantiator(LocalDate.class, (JsonReader.ClassFactory)new LocalDateFactory());
        ReadOptionsBuilder.assignInstantiator(LocalTime.class, (JsonReader.ClassFactory)new LocalTimeFactory());
        ReadOptionsBuilder.assignInstantiator(LocalDateTime.class, (JsonReader.ClassFactory)new LocalDateTimeFactory());
        ReadOptionsBuilder.assignInstantiator(ZonedDateTime.class, (JsonReader.ClassFactory)new ZonedDateTimeFactory());
        ReadOptionsBuilder.assignInstantiator(OffsetDateTime.class, (JsonReader.ClassFactory)new OffsetDateTimeFactory());
        ReadOptionsBuilder.assignInstantiator(OffsetTime.class, (JsonReader.ClassFactory)new OffsetTimeFactory());
        ReadOptionsBuilder.assignInstantiator(YearMonth.class, (JsonReader.ClassFactory)new YearMonthFactory());
        ReadOptionsBuilder.assignInstantiator(Year.class, (JsonReader.ClassFactory)new YearFactory());
        ReadOptionsBuilder.assignInstantiator(ZoneOffset.class, (JsonReader.ClassFactory)new ZoneOffsetFactory());
        TimeZoneFactory timeZoneFactory = new TimeZoneFactory();
        ReadOptionsBuilder.assignInstantiator(TimeZone.class, (JsonReader.ClassFactory)timeZoneFactory);
        try {
            ReadOptionsBuilder.assignInstantiator(Class.forName("sun.util.calendar.ZoneInfo"), (JsonReader.ClassFactory)timeZoneFactory);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ThrowableFactory throwableFactory = new ThrowableFactory();
        ReadOptionsBuilder.assignInstantiator(Throwable.class, (JsonReader.ClassFactory)throwableFactory);
        ReadOptionsBuilder.assignInstantiator(Exception.class, (JsonReader.ClassFactory)throwableFactory);
        ReadOptionsBuilder.assignInstantiator(RuntimeException.class, (JsonReader.ClassFactory)throwableFactory);
        ReadOptionsBuilder.assignInstantiator(StackTraceElement.class, (JsonReader.ClassFactory)new StackTraceElementFactory());
        ReadOptionsBuilder.addReaderPermanent(String.class, new Readers.StringReader());
        ReadOptionsBuilder.addReaderPermanent(java.util.Date.class, new Readers.DateReader());
        ReadOptionsBuilder.addReaderPermanent(AtomicBoolean.class, new Readers.AtomicBooleanReader());
        ReadOptionsBuilder.addReaderPermanent(AtomicInteger.class, new Readers.AtomicIntegerReader());
        ReadOptionsBuilder.addReaderPermanent(AtomicLong.class, new Readers.AtomicLongReader());
        ReadOptionsBuilder.addReaderPermanent(BigInteger.class, new Readers.BigIntegerReader());
        ReadOptionsBuilder.addReaderPermanent(BigDecimal.class, new Readers.BigDecimalReader());
        ReadOptionsBuilder.addReaderPermanent(Date.class, new Readers.SqlDateReader());
        ReadOptionsBuilder.addReaderPermanent(Timestamp.class, new Readers.TimestampReader());
        ReadOptionsBuilder.addReaderPermanent(Calendar.class, new Readers.CalendarReader());
        ReadOptionsBuilder.addReaderPermanent(Locale.class, new Readers.LocaleReader());
        ReadOptionsBuilder.addReaderPermanent(Class.class, new Readers.ClassReader());
        ReadOptionsBuilder.addReaderPermanent(StringBuilder.class, new Readers.StringBuilderReader());
        ReadOptionsBuilder.addReaderPermanent(StringBuffer.class, new Readers.StringBufferReader());
        ReadOptionsBuilder.addReaderPermanent(UUID.class, new Readers.UUIDReader());
        ReadOptionsBuilder.addReaderPermanent(URL.class, new Readers.URLReader());
        ReadOptionsBuilder.addPossiblePermanentReader(BASE_READERS, "java.lang.Record", Readers.RecordReader::new);
        ReadOptionsBuilder.addPermanentCoercedType("java.util.Arrays$ArrayList", ArrayList.class);
        ReadOptionsBuilder.addPermanentCoercedType("java.util.LinkedHashMap$LinkedKeySet", LinkedHashSet.class);
        ReadOptionsBuilder.addPermanentCoercedType("java.util.LinkedHashMap$LinkedValues", ArrayList.class);
        ReadOptionsBuilder.addPermanentCoercedType("java.util.HashMap$KeySet", HashSet.class);
        ReadOptionsBuilder.addPermanentCoercedType("java.util.HashMap$Values", ArrayList.class);
        ReadOptionsBuilder.addPermanentCoercedType("java.util.TreeMap$KeySet", TreeSet.class);
        ReadOptionsBuilder.addPermanentCoercedType("java.util.TreeMap$Values", ArrayList.class);
        ReadOptionsBuilder.addPermanentCoercedType("java.util.concurrent.ConcurrentHashMap$KeySet", LinkedHashSet.class);
        ReadOptionsBuilder.addPermanentCoercedType("java.util.concurrent.ConcurrentHashMap$KeySetView", LinkedHashSet.class);
        ReadOptionsBuilder.addPermanentCoercedType("java.util.concurrent.ConcurrentHashMap$Values", ArrayList.class);
        ReadOptionsBuilder.addPermanentCoercedType("java.util.concurrent.ConcurrentHashMap$ValuesView", ArrayList.class);
        ReadOptionsBuilder.addPermanentCoercedType("java.util.concurrent.ConcurrentSkipListMap$KeySet", LinkedHashSet.class);
        ReadOptionsBuilder.addPermanentCoercedType("java.util.concurrent.ConcurrentSkipListMap$Values", ArrayList.class);
        ReadOptionsBuilder.addPermanentCoercedType("java.util.IdentityHashMap$KeySet", LinkedHashSet.class);
        ReadOptionsBuilder.addPermanentCoercedType("java.util.IdentityHashMap$Values", ArrayList.class);
        ReadOptionsBuilder.addPermanentCoercedType("java.util.Collections$EmptyList", Collections.EMPTY_LIST.getClass());
        ReadOptionsBuilder.addPermanentCoercedType("java.util.Collections$SingletonSet", LinkedHashSet.class);
        ReadOptionsBuilder.addPermanentCoercedType("java.util.Collections$SingletonList", ArrayList.class);
        ReadOptionsBuilder.addPermanentCoercedType("java.util.Collections$SingletonMap", LinkedHashMap.class);
        ReadOptionsBuilder.addPermanentCoercedType("java.util.Collections$UnmodifiableRandomAccessList", ArrayList.class);
        ReadOptionsBuilder.addPermanentCoercedType("java.util.Collections$UnmodifiableSet", LinkedHashSet.class);
        ReadOptionsBuilder.addPermanentCoercedType("java.util.Collections$UnmodifiableMap", LinkedHashMap.class);
    }

    private static class ReadOptionsImplementation
    implements ReadOptions {
        private static final int DEFAULT_MAX_PARSE_DEPTH = 1000;
        private boolean isUsingMaps;
        private boolean isFailOnUnknownType;
        private int maxDepth;
        private ClassLoader classLoader;
        private JsonReader.MissingFieldHandler missingFieldHandler;
        private Class<?> unknownTypeClass;
        private final Collection<Class<?>> nonCustomizableClasses;
        private final Map<Class<?>, JsonReader.JsonClassReader> readers;
        private final Map<Class, JsonReader.ClassFactory> classFactoryMap;
        private final Map<String, Object> customArguments;
        private final Map<String, Class<?>> coercedTypes;
        private Map<String, String> typeNameMap;
        private JsonReader.ClassFactory throwableFactory = new ThrowableFactory();
        private JsonReader.ClassFactory enumFactory = new EnumClassFactory();

        private ReadOptionsImplementation() {
            this.maxDepth = 1000;
            this.classLoader = ReadOptions.class.getClassLoader();
            this.typeNameMap = new HashMap<String, String>();
            this.readers = new HashMap(BASE_READERS);
            this.nonCustomizableClasses = new LinkedHashSet();
            this.classFactoryMap = new HashMap<Class, JsonReader.ClassFactory>(BASE_CLASS_FACTORIES);
            this.customArguments = new HashMap<String, Object>();
            this.coercedTypes = new LinkedHashMap(BASE_COERCED_TYPES);
            this.unknownTypeClass = null;
        }

        private ReadOptionsImplementation(ReadOptionsImplementation options, boolean isUsingMaps) {
            this.isUsingMaps = isUsingMaps;
            this.maxDepth = options.maxDepth;
            this.classLoader = options.classLoader;
            this.typeNameMap = Collections.unmodifiableMap(options.typeNameMap);
            this.classFactoryMap = Collections.unmodifiableMap(options.classFactoryMap);
            this.customArguments = Collections.unmodifiableMap(options.customArguments);
            this.coercedTypes = Collections.unmodifiableMap(options.coercedTypes);
            this.isFailOnUnknownType = options.isFailOnUnknownType;
            this.unknownTypeClass = options.unknownTypeClass;
            this.missingFieldHandler = options.missingFieldHandler;
            this.readers = options.readers;
            this.nonCustomizableClasses = options.nonCustomizableClasses;
        }

        @Override
        public JsonReader.JsonClassReader getReader(Class<?> c) {
            return this.readers.get(c);
        }

        @Override
        public JsonReader.ClassFactory getClassFactory(Class<?> c) {
            if (c == null) {
                return null;
            }
            JsonReader.ClassFactory factory = this.classFactoryMap.get(c);
            if (factory != null) {
                return factory;
            }
            if (Throwable.class.isAssignableFrom(c)) {
                return this.throwableFactory;
            }
            Optional<Class> optional = MetaUtils.getClassIfEnum(c);
            if (optional.isPresent()) {
                return this.enumFactory;
            }
            return null;
        }

        @Override
        public <T> T getCustomArgument(String name) {
            return (T)this.customArguments.get(name);
        }

        @Override
        public Class<?> getCoercedType(String fqName) {
            return this.coercedTypes.get(fqName);
        }

        @Override
        public boolean isNonCustomizable(Class<?> c) {
            return this.nonCustomizableClasses.contains(c);
        }

        @Override
        public ReadOptions ensureUsingMaps() {
            if (this.isUsingMaps) {
                return this;
            }
            return new ReadOptionsImplementation(this, true);
        }

        @Override
        public ReadOptions ensureUsingObjects() {
            if (!this.isUsingMaps) {
                return this;
            }
            return new ReadOptionsImplementation(this, false);
        }

        @Override
        public void addReader(Class<?> c, JsonReader.JsonClassReader reader) {
            this.readers.put(c, reader);
        }

        @Override
        public void addNonCustomizableClass(Class<?> c) {
            this.nonCustomizableClasses.add(c);
        }

        @Override
        public Optional<JsonReader.JsonClassReader> getClosestReader(Class<?> c) {
            Optional<JsonReader.JsonClassReader> closestReader = Optional.empty();
            int minDistance = Integer.MAX_VALUE;
            for (Map.Entry<Class<?>, JsonReader.JsonClassReader> entry : this.readers.entrySet()) {
                Class<?> key = entry.getKey();
                if (key == c) {
                    return Optional.of(entry.getValue());
                }
                int distance = MetaUtils.getDistance(key, c);
                if (distance >= minDistance) continue;
                minDistance = distance;
                closestReader = Optional.of(entry.getValue());
            }
            return closestReader;
        }

        @Override
        public String getTypeName(String name) {
            return this.typeNameMap.get(name);
        }

        @Override
        public Map toMap() {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("CLASSLOADER", this.classLoader);
            args.put("TYPE_NAME_MAP_REVERSE", this.typeNameMap);
            args.put("MISSING_FIELD_HANDLER", this.missingFieldHandler);
            args.put("CUSTOM_READERS", this.readers);
            args.put("NOT_CUSTOM_READERS", this.nonCustomizableClasses);
            args.put("USE_MAPS", this.isUsingMaps);
            args.put("UNKNOWN_OBJECT", this.unknownTypeClass);
            args.put("FAIL_ON_UNKNOWN_TYPE", this.isFailOnUnknownType);
            args.put("FACTORIES", this.classFactoryMap);
            return args;
        }

        private void setUsingMaps(boolean isUsingMaps) {
            this.isUsingMaps = isUsingMaps;
        }

        private void setFailOnUnknownType(boolean isFailOnUnknownType) {
            this.isFailOnUnknownType = isFailOnUnknownType;
        }

        private void setMaxDepth(int maxDepth) {
            this.maxDepth = maxDepth;
        }

        private void setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        private void setMissingFieldHandler(JsonReader.MissingFieldHandler missingFieldHandler) {
            this.missingFieldHandler = missingFieldHandler;
        }

        private void setUnknownTypeClass(Class<?> unknownTypeClass) {
            this.unknownTypeClass = unknownTypeClass;
        }

        private void setTypeNameMap(Map<String, String> typeNameMap) {
            this.typeNameMap = typeNameMap;
        }

        private void setThrowableFactory(JsonReader.ClassFactory throwableFactory) {
            this.throwableFactory = throwableFactory;
        }

        private void setEnumFactory(JsonReader.ClassFactory enumFactory) {
            this.enumFactory = enumFactory;
        }

        @Override
        public boolean isUsingMaps() {
            return this.isUsingMaps;
        }

        @Override
        public boolean isFailOnUnknownType() {
            return this.isFailOnUnknownType;
        }

        @Override
        public int getMaxDepth() {
            return this.maxDepth;
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        @Override
        public JsonReader.MissingFieldHandler getMissingFieldHandler() {
            return this.missingFieldHandler;
        }

        @Override
        public Class<?> getUnknownTypeClass() {
            return this.unknownTypeClass;
        }

        public Collection<Class<?>> getNonCustomizableClasses() {
            return this.nonCustomizableClasses;
        }
    }
}

