/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.reflect.factories;

import com.cedarsoftware.util.reflect.Accessor;
import com.cedarsoftware.util.reflect.AccessorFactory;
import com.cedarsoftware.util.reflect.accessors.MethodAccessor;
import com.cedarsoftware.util.reflect.factories.NonStandardAccessorNames;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;

public class MappedMethodAccessorFactory
implements AccessorFactory {
    private static final int METHOD_MODIFIERS = 9;

    @Override
    public Accessor createAccessor(Field field, Map<String, Method> possibleAccessors) {
        String fieldName = field.getName();
        Optional<String> possibleMethod = NonStandardAccessorNames.instance().getMapping(field.getDeclaringClass(), fieldName);
        Method method = possibleAccessors.get(possibleMethod.orElse(MappedMethodAccessorFactory.createGetterName(fieldName)));
        if (method == null || (method.getModifiers() & 9) != 1) {
            return null;
        }
        return new MethodAccessor(field, method);
    }

    private static String createGetterName(String fieldName) {
        return "get" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
    }
}

