/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io;

import com.cedarsoftware.util.PrintStyle;
import com.cedarsoftware.util.io.ArgumentHelper;
import com.cedarsoftware.util.io.JsonWriter;
import com.cedarsoftware.util.io.MetaUtils;
import com.cedarsoftware.util.io.TypeWriter;
import com.cedarsoftware.util.io.WriteOptions;
import com.cedarsoftware.util.io.Writers;
import com.cedarsoftware.util.reflect.Accessor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class WriteOptionsBuilder {
    private static Map<Class<?>, JsonWriter.JsonClassWriter> BASE_WRITERS;
    private final WriteOptionsImplementation writeOptions;
    private final Map<Class<?>, Collection<String>> fieldNameBlackList = new HashMap();
    private final Map<Class<?>, Collection<String>> fieldSpecifiers = new HashMap();

    public WriteOptionsBuilder() {
        this.writeOptions = new WriteOptionsImplementation();
    }

    public WriteOptionsBuilder withDefaultOptimizations() {
        return this.withIsoDateTimeFormat().withShortMetaKeys().skipNullFields();
    }

    public WriteOptionsBuilder skipNullFields() {
        this.writeOptions.skippingNullFields = true;
        return this;
    }

    public WriteOptionsBuilder withPrettyPrint() {
        this.writeOptions.printStyle = PrintStyle.PRETTY_PRINT;
        return this;
    }

    public WriteOptionsBuilder withPrintStyle(PrintStyle style) {
        this.writeOptions.printStyle = style;
        return this;
    }

    public WriteOptionsBuilder writeLongsAsStrings() {
        this.writeOptions.writingLongsAsStrings = true;
        return this;
    }

    public WriteOptionsBuilder writeEnumsAsObject() {
        this.writeOptions.enumWriter = JsonWriter.nullWriter;
        return this;
    }

    public WriteOptionsBuilder doNotWritePrivateEnumFields() {
        this.writeOptions.enumPublicOnly = true;
        this.writeOptions.enumWriter = JsonWriter.nullWriter;
        return this;
    }

    public WriteOptionsBuilder writeEnumsAsPrimitives() {
        this.writeOptions.enumPublicOnly = false;
        this.writeOptions.enumWriter = new Writers.EnumsAsStringWriter();
        return this;
    }

    public WriteOptionsBuilder forceMapOutputAsKeysAndItems() {
        this.writeOptions.forcingMapFormatWithKeyArrays = true;
        return this;
    }

    public WriteOptionsBuilder doNotForceMapOutputAsKeysAndItems() {
        this.writeOptions.forcingMapFormatWithKeyArrays = false;
        return this;
    }

    public WriteOptionsBuilder withClassLoader(ClassLoader classLoader) {
        this.writeOptions.classLoader = classLoader;
        return this;
    }

    public static void addBaseWriter(Class<?> c, JsonWriter.JsonClassWriter writer) {
        BASE_WRITERS.put(c, writer);
    }

    public WriteOptionsBuilder writeLocalDateAsTimeStamp() {
        return this.withCustomWriter(LocalDate.class, new Writers.LocalDateAsTimestamp());
    }

    public WriteOptionsBuilder writeLocalDateWithFormat(DateTimeFormatter formatter) {
        return this.withCustomWriter(LocalDate.class, new Writers.LocalDateWriter(formatter));
    }

    public WriteOptionsBuilder withIsoDateTimeFormat() {
        return this.withDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    }

    public WriteOptionsBuilder withIsoDateFormat() {
        return this.withDateFormat("yyyy-MM-dd");
    }

    public WriteOptionsBuilder withDateFormat(String format) {
        this.writeOptions.dateFormat = format;
        return this;
    }

    public WriteOptionsBuilder withShortMetaKeys() {
        this.writeOptions.usingShortMetaKeys = true;
        return this;
    }

    public WriteOptionsBuilder neverShowTypeInfo() {
        this.writeOptions.typeWriter = TypeWriter.NEVER;
        return this;
    }

    public WriteOptionsBuilder alwaysShowTypeInfo() {
        this.writeOptions.typeWriter = TypeWriter.ALWAYS;
        return this;
    }

    public WriteOptionsBuilder showMinimalTypeInfo() {
        this.writeOptions.typeWriter = TypeWriter.MINIMAL;
        return this;
    }

    public WriteOptionsBuilder withFieldNameBlackList(Class<?> c, Collection<String> fields) {
        Collection collection = this.fieldNameBlackList.computeIfAbsent(c, f -> new LinkedHashSet());
        collection.addAll(fields);
        return this;
    }

    public WriteOptionsBuilder withFieldNameBlackListMap(Map<Class<?>, Collection<String>> map) {
        for (Map.Entry<Class<?>, Collection<String>> entry : map.entrySet()) {
            Collection collection = this.fieldNameBlackList.computeIfAbsent(entry.getKey(), f -> new LinkedHashSet());
            collection.addAll(entry.getValue());
        }
        return this;
    }

    public WriteOptionsBuilder withFieldSpecifier(Class<?> c, List<String> fields) {
        Collection collection = this.fieldSpecifiers.computeIfAbsent(c, f -> new LinkedHashSet());
        collection.addAll(fields);
        return this;
    }

    public WriteOptionsBuilder withFieldSpecifiersMap(Map<Class<?>, Collection<String>> map) {
        for (Map.Entry<Class<?>, Collection<String>> entry : map.entrySet()) {
            Collection collection = this.fieldSpecifiers.computeIfAbsent(entry.getKey(), f -> new LinkedHashSet());
            collection.addAll(entry.getValue());
        }
        return this;
    }

    public WriteOptionsBuilder withCustomTypeName(Class<?> type, String newTypeName) {
        return this.withCustomTypeName(type.getName(), newTypeName);
    }

    public WriteOptionsBuilder withCustomTypeName(String type, String newTypeName) {
        this.assertTypesAreBeingOutput();
        this.writeOptions.customTypeMap.put(type, newTypeName);
        return this;
    }

    public WriteOptionsBuilder withCustomTypeNameMap(Map<String, String> map) {
        this.assertTypesAreBeingOutput();
        this.writeOptions.customTypeMap.putAll(map);
        return this;
    }

    public WriteOptionsBuilder withCustomWriter(Class<?> c, JsonWriter.JsonClassWriter writer) {
        this.writeOptions.customWriters.put(c, writer);
        return this;
    }

    public WriteOptionsBuilder withCustomWriterMap(Map<? extends Class<?>, ? extends JsonWriter.JsonClassWriter> map) {
        this.writeOptions.customWriters.putAll(map);
        return this;
    }

    public WriteOptionsBuilder withNoCustomizationFor(Class<?> c) {
        this.writeOptions.nonCustomClasses.add(c);
        return this;
    }

    public WriteOptionsBuilder withNoCustomizationsFor(Collection<Class<?>> collection) {
        this.writeOptions.nonCustomClasses.addAll(collection);
        return this;
    }

    public WriteOptionsBuilder withCustomArgument(String name, Object o) {
        this.writeOptions.customArguments.put(name, o);
        return this;
    }

    public WriteOptionsBuilder withCustomArguments(Map<String, Object> map) {
        this.writeOptions.customArguments.putAll(map);
        return this;
    }

    public static Map toMap(WriteOptions options) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        if (options.isWritingLongsAsStrings()) {
            args.put("WLAS", Boolean.TRUE);
        }
        if (options.isSkippingNullFields()) {
            args.put("SKIP_NULL", Boolean.TRUE);
        }
        if (options.isForcingMapFormatWithKeyArrays()) {
            args.put("FORCE_MAP_FORMAT_ARRAY_KEYS_ITEMS", Boolean.TRUE);
        }
        if (options.isEnumPublicOnly()) {
            args.put("ENUM_PUBLIC_ONLY", Boolean.TRUE);
        }
        if (options.isNeverShowingType()) {
            args.put("TYPE", Boolean.FALSE);
        } else if (options.isAlwaysShowingType()) {
            args.put("TYPE", Boolean.TRUE);
        }
        if (options.isPrettyPrint()) {
            args.put("PRETTY_PRINT", Boolean.TRUE);
        }
        if (options.isUsingShortMetaKeys()) {
            args.put("SHORT_META_KEYS", Boolean.TRUE);
        }
        args.put("NOT_CUSTOM_WRITERS", options.getNonCustomClasses());
        args.put("CUSTOM_WRITERS", options.getCustomWriters());
        args.put("CLASSLOADER", options.getClassLoader());
        return args;
    }

    public static WriteOptionsBuilder fromMap(Map args) {
        Map stringBlackList;
        Map stringSpecifiers;
        Collection notCustomClasses;
        ClassLoader loader;
        boolean isEnumPublicOnly;
        Map typeNameMap;
        Object type;
        WriteOptionsBuilder builder = new WriteOptionsBuilder();
        if (ArgumentHelper.isTrue(args.get("SHORT_META_KEYS"))) {
            builder.withShortMetaKeys();
        }
        if (ArgumentHelper.isTrue(type = args.get("TYPE"))) {
            builder.alwaysShowTypeInfo();
        }
        if (Boolean.FALSE.equals(type) || "false".equals(args.get("TYPE"))) {
            builder.neverShowTypeInfo();
        }
        if ((typeNameMap = (Map)args.get("TYPE_NAME_MAP")) != null) {
            builder.withCustomTypeNameMap(typeNameMap);
        }
        if (ArgumentHelper.isTrue(args.get("PRETTY_PRINT"))) {
            builder.withPrintStyle(PrintStyle.PRETTY_PRINT);
        }
        if (ArgumentHelper.isTrue(args.get("WLAS"))) {
            builder.writeLongsAsStrings();
        }
        if (ArgumentHelper.isTrue(args.get("SKIP_NULL"))) {
            builder.skipNullFields();
        }
        if (isEnumPublicOnly = ArgumentHelper.isTrue(args.get("ENUM_PUBLIC_ONLY"))) {
            builder.doNotWritePrivateEnumFields();
        }
        if (ArgumentHelper.isTrue(args.get("FORCE_MAP_FORMAT_ARRAY_KEYS_ITEMS"))) {
            builder.forceMapOutputAsKeysAndItems();
        }
        builder.withClassLoader((loader = (ClassLoader)args.get("CLASSLOADER")) == null ? JsonWriter.class.getClassLoader() : loader);
        Map customWriters = (Map)args.get("CUSTOM_WRITERS");
        if (customWriters != null) {
            builder.withCustomWriterMap(customWriters);
        }
        if ((notCustomClasses = (Collection)args.get("NOT_CUSTOM_WRITERS")) != null) {
            builder.withNoCustomizationsFor(notCustomClasses);
        }
        if ((stringSpecifiers = (Map)args.get("FIELD_SPECIFIERS")) != null) {
            builder.withFieldSpecifiersMap(stringSpecifiers);
        }
        if ((stringBlackList = (Map)args.get("FIELD_NAME_BLACK_LIST")) != null) {
            builder.withFieldNameBlackListMap(stringBlackList);
        }
        return builder;
    }

    public WriteOptions build() {
        this.writeOptions.fieldSpecifiers.putAll(MetaUtils.convertStringFieldNamesToAccessors(this.fieldSpecifiers));
        this.writeOptions.fieldNameBlackList.putAll(MetaUtils.convertStringFieldNamesToAccessors(this.fieldNameBlackList));
        return new WriteOptionsImplementation(this.writeOptions);
    }

    private void assertTypesAreBeingOutput() {
        if (this.writeOptions.typeWriter == TypeWriter.NEVER) {
            throw new IllegalStateException("There is no need to set the type name map when types are never being written");
        }
    }

    static {
        HashMap temp = new HashMap();
        temp.put(String.class, new Writers.JsonStringWriter());
        temp.put(java.util.Date.class, new Writers.DateWriter());
        temp.put(BigInteger.class, new Writers.BigIntegerWriter());
        temp.put(BigDecimal.class, new Writers.BigDecimalWriter());
        temp.put(Date.class, new Writers.DateWriter());
        temp.put(Timestamp.class, new Writers.TimestampWriter());
        temp.put(Calendar.class, new Writers.CalendarWriter());
        temp.put(TimeZone.class, new Writers.TimeZoneWriter());
        temp.put(Locale.class, new Writers.LocaleWriter());
        temp.put(Class.class, new Writers.ClassWriter());
        temp.put(UUID.class, new Writers.UUIDWriter());
        temp.put(LocalDate.class, new Writers.LocalDateWriter());
        temp.put(LocalTime.class, new Writers.LocalTimeWriter());
        temp.put(LocalDateTime.class, new Writers.LocalDateTimeWriter());
        temp.put(ZonedDateTime.class, new Writers.ZonedDateTimeWriter());
        temp.put(OffsetDateTime.class, new Writers.OffsetDateTimeWriter());
        temp.put(YearMonth.class, new Writers.YearMonthWriter());
        temp.put(Year.class, new Writers.YearWriter());
        temp.put(ZoneOffset.class, new Writers.ZoneOffsetWriter());
        Writers.PrimitiveUtf8StringWriter stringWriter = new Writers.PrimitiveUtf8StringWriter();
        temp.put(StringBuilder.class, stringWriter);
        temp.put(StringBuffer.class, stringWriter);
        temp.put(URL.class, stringWriter);
        temp.put(ZoneOffset.class, stringWriter);
        Writers.PrimitiveValueWriter primitiveValueWriter = new Writers.PrimitiveValueWriter();
        temp.put(AtomicBoolean.class, primitiveValueWriter);
        temp.put(AtomicInteger.class, primitiveValueWriter);
        temp.put(AtomicLong.class, primitiveValueWriter);
        Class<?> zoneInfoClass = MetaUtils.classForName("sun.util.calendar.ZoneInfo", WriteOptions.class.getClassLoader());
        if (zoneInfoClass != null) {
            temp.put(zoneInfoClass, new Writers.TimeZoneWriter());
        }
        BASE_WRITERS = temp;
    }

    private static class WriteOptionsImplementation
    implements WriteOptions {
        private boolean usingShortMetaKeys = false;
        private boolean writingLongsAsStrings = false;
        private boolean skippingNullFields = false;
        private boolean forcingMapFormatWithKeyArrays = false;
        private boolean enumPublicOnly = false;
        private ClassLoader classLoader = WriteOptionsImplementation.class.getClassLoader();
        private JsonWriter.JsonClassWriter enumWriter;
        private final Map<Class<?>, JsonWriter.JsonClassWriter> customWriters;
        private final Map<String, String> customTypeMap;
        private final Collection<Class<?>> nonCustomClasses;
        private final Map<Class<?>, Collection<Accessor>> fieldSpecifiers;
        private final Map<Class<?>, Collection<Accessor>> fieldNameBlackList;
        private String dateFormat;
        private PrintStyle printStyle;
        private TypeWriter typeWriter;
        private final Map<String, Object> customArguments;

        private WriteOptionsImplementation() {
            this.customWriters = new HashMap(BASE_WRITERS);
            this.fieldNameBlackList = new HashMap();
            this.fieldSpecifiers = new HashMap();
            this.customTypeMap = new HashMap<String, String>();
            this.customArguments = new HashMap<String, Object>();
            this.nonCustomClasses = new HashSet();
            this.printStyle = PrintStyle.ONE_LINE;
            this.typeWriter = TypeWriter.MINIMAL;
            this.enumWriter = new Writers.EnumsAsStringWriter();
        }

        private WriteOptionsImplementation(WriteOptionsImplementation options) {
            this.usingShortMetaKeys = options.usingShortMetaKeys;
            this.typeWriter = options.typeWriter;
            this.printStyle = options.printStyle;
            this.writingLongsAsStrings = options.writingLongsAsStrings;
            this.skippingNullFields = options.skippingNullFields;
            this.forcingMapFormatWithKeyArrays = options.forcingMapFormatWithKeyArrays;
            this.enumPublicOnly = options.enumPublicOnly;
            this.classLoader = options.classLoader;
            this.enumWriter = options.enumWriter;
            this.customWriters = Collections.unmodifiableMap(options.customWriters);
            this.customTypeMap = Collections.unmodifiableMap(options.customTypeMap);
            this.nonCustomClasses = Collections.unmodifiableCollection(options.nonCustomClasses);
            this.fieldSpecifiers = Collections.unmodifiableMap(options.fieldSpecifiers);
            this.fieldNameBlackList = Collections.unmodifiableMap(options.fieldNameBlackList);
            this.dateFormat = options.dateFormat;
            this.customArguments = options.customArguments;
        }

        @Override
        public boolean isAlwaysShowingType() {
            return this.typeWriter == TypeWriter.ALWAYS;
        }

        @Override
        public boolean isNeverShowingType() {
            return this.typeWriter == TypeWriter.NEVER;
        }

        @Override
        public boolean isPrettyPrint() {
            return this.printStyle == PrintStyle.PRETTY_PRINT;
        }

        @Override
        public Object getCustomArgument(String name) {
            return this.customArguments.get(name);
        }

        @Override
        public WriteOptions ensurePrettyPrint() {
            this.printStyle = PrintStyle.PRETTY_PRINT;
            return this;
        }

        @Override
        public boolean isUsingShortMetaKeys() {
            return this.usingShortMetaKeys;
        }

        @Override
        public boolean isWritingLongsAsStrings() {
            return this.writingLongsAsStrings;
        }

        @Override
        public boolean isSkippingNullFields() {
            return this.skippingNullFields;
        }

        @Override
        public boolean isForcingMapFormatWithKeyArrays() {
            return this.forcingMapFormatWithKeyArrays;
        }

        @Override
        public boolean isEnumPublicOnly() {
            return this.enumPublicOnly;
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        @Override
        public JsonWriter.JsonClassWriter getEnumWriter() {
            return this.enumWriter;
        }

        @Override
        public Map<Class<?>, JsonWriter.JsonClassWriter> getCustomWriters() {
            return this.customWriters;
        }

        @Override
        public Map<String, String> getCustomTypeMap() {
            return this.customTypeMap;
        }

        @Override
        public Collection<Class<?>> getNonCustomClasses() {
            return this.nonCustomClasses;
        }

        @Override
        public Map<Class<?>, Collection<Accessor>> getFieldSpecifiers() {
            return this.fieldSpecifiers;
        }

        @Override
        public Map<Class<?>, Collection<Accessor>> getFieldNameBlackList() {
            return this.fieldNameBlackList;
        }

        @Override
        public String getDateFormat() {
            return this.dateFormat;
        }
    }
}

