/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io;

import com.cedarsoftware.util.io.FastReader;
import com.cedarsoftware.util.io.JsonIoException;
import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.JsonReader;
import com.cedarsoftware.util.io.ReadOptions;
import com.cedarsoftware.util.io.ReadOptionsBuilder;
import com.cedarsoftware.util.io.ReferenceTracker;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

class JsonParser {
    protected static final JsonObject EMPTY_OBJECT = new JsonObject();
    private static final JsonObject EMPTY_ARRAY = new JsonObject();
    private static final int STATE_READ_START_OBJECT = 0;
    private static final int STATE_READ_FIELD = 1;
    private static final int STATE_READ_VALUE = 2;
    private static final int STATE_READ_POST_VALUE = 3;
    private static final Map<String, String> stringCache = new HashMap<String, String>();
    private static final int DEFAULT_MAX_PARSE_DEPTH = 1000;
    private final FastReader input;
    private final StringBuilder strBuf = new StringBuilder(256);
    private final StringBuilder hexBuf = new StringBuilder();
    private final StringBuilder numBuf = new StringBuilder();
    private int curParseDepth = 0;
    private final ReadOptions readOptions;
    private final ReferenceTracker references;
    private static final int STRING_START = 0;
    private static final int STRING_SLASH = 1;
    private static final int HEX_DIGITS = 2;

    @Deprecated
    JsonParser(FastReader reader, Map<String, Object> args, int maxDepth, ReferenceTracker references) {
        this(reader, ReadOptionsBuilder.fromMap(args).withMaxDepth(maxDepth).build(), references);
    }

    @Deprecated
    JsonParser(FastReader reader, Map<String, Object> args, ReferenceTracker references) {
        this(reader, args, 1000, references);
    }

    JsonParser(FastReader reader, ReadOptions readOptions, ReferenceTracker references) {
        this.input = reader;
        this.readOptions = readOptions;
        this.references = references;
    }

    private Object readJsonObject() throws IOException {
        boolean done = false;
        String field = null;
        JsonObject object = new JsonObject();
        int state = 0;
        FastReader in = this.input;
        while (!done) {
            switch (state) {
                case 0: {
                    this.skipWhitespaceRead();
                    object.line = in.getLine();
                    object.col = in.getCol();
                    int c = this.skipWhitespaceRead();
                    if (c == 125) {
                        return new JsonObject();
                    }
                    in.pushback((char)c);
                    state = 1;
                    ++this.curParseDepth;
                    break;
                }
                case 1: {
                    int c = this.skipWhitespaceRead();
                    if (c == 34) {
                        String temp;
                        field = this.readString();
                        c = this.skipWhitespaceRead();
                        if (c != 58) {
                            this.error("Expected ':' between string field and value");
                        }
                        if (field.startsWith("@") && (temp = stringCache.get(field)) != null) {
                            field = temp;
                        }
                        state = 2;
                        break;
                    }
                    this.error("Expected quote");
                    break;
                }
                case 2: {
                    String substitute;
                    if (field == null) {
                        field = "@items";
                    }
                    Object value = this.readValue(object, false);
                    if ("@type".equals(field) && (substitute = this.readOptions.getTypeName(value.toString())) != null) {
                        value = substitute;
                    }
                    object.put(field, value);
                    if ("@id".equals(field)) {
                        this.references.put((Long)value, object);
                    }
                    state = 3;
                    break;
                }
                case 3: {
                    int c = this.skipWhitespaceRead();
                    if (c == -1) {
                        this.error("EOF reached before closing '}'");
                    }
                    if (c == 125) {
                        done = true;
                        --this.curParseDepth;
                        break;
                    }
                    if (c == 44) {
                        state = 1;
                        break;
                    }
                    this.error("Object not ended with '}'");
                }
            }
        }
        boolean useMaps = this.readOptions.isUsingMaps();
        if (useMaps && object.isLogicalPrimitive()) {
            return object.getPrimitiveValue();
        }
        return object;
    }

    Object readValue(JsonObject object, boolean top) throws IOException {
        int maxParseDepth = this.readOptions.getMaxDepth();
        if (this.curParseDepth > maxParseDepth) {
            return this.error("Maximum parsing depth exceeded");
        }
        int c = this.skipWhitespaceRead();
        if (c == 34) {
            return this.readString();
        }
        if (c >= 48 && c <= 57 || c == 45 || c == 78 || c == 73) {
            return this.readNumber(c);
        }
        switch (c) {
            case 123: {
                this.input.pushback('{');
                return this.readJsonObject();
            }
            case 91: {
                return this.readArray(object);
            }
            case 93: {
                this.input.pushback(']');
                return EMPTY_ARRAY;
            }
            case 70: 
            case 102: {
                this.readToken("false");
                return Boolean.FALSE;
            }
            case 78: 
            case 110: {
                this.readToken("null");
                return null;
            }
            case 84: 
            case 116: {
                this.readToken("true");
                return Boolean.TRUE;
            }
            case -1: {
                return top ? null : this.error("EOF reached prematurely");
            }
        }
        return this.error("Unknown JSON value type");
    }

    private Object[] readArray(JsonObject object) throws IOException {
        ArrayList<Object> array = new ArrayList<Object>();
        ++this.curParseDepth;
        while (true) {
            int c;
            Object o;
            if ((o = this.readValue(object, false)) != EMPTY_ARRAY) {
                array.add(o);
            }
            if ((c = this.skipWhitespaceRead()) == 93) break;
            if (c == 44) continue;
            this.error("Expected ',' or ']' inside array");
        }
        --this.curParseDepth;
        return array.toArray();
    }

    private void readToken(String token) throws IOException {
        int len = token.length();
        for (int i = 1; i < len; ++i) {
            int c = this.input.read();
            if (c == -1) {
                this.error("EOF reached while reading token: " + token);
            }
            c = Character.toLowerCase((char)c);
            char loTokenChar = token.charAt(i);
            if (loTokenChar == c) continue;
            this.error("Expected token: " + token);
        }
    }

    private Number readNumber(int c) throws IOException {
        FastReader in = this.input;
        boolean isFloat = false;
        if (JsonReader.isAllowNanAndInfinity() && (c == 45 || c == 78 || c == 73)) {
            boolean isNeg;
            boolean bl = isNeg = c == 45;
            if (isNeg) {
                c = this.input.read();
            }
            if (c == 73) {
                this.readToken("infinity");
                return isNeg ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            if (78 == c) {
                this.readToken("nan");
                return Double.NaN;
            }
            this.input.pushback((char)c);
            c = 45;
        }
        StringBuilder number = this.numBuf;
        number.setLength(0);
        number.appendCodePoint(c);
        while (true) {
            if ((c = in.read()) >= 48 && c <= 57 || c == 45 || c == 43) {
                number.appendCodePoint(c);
                continue;
            }
            if (c != 46 && c != 101 && c != 69) break;
            number.appendCodePoint(c);
            isFloat = true;
        }
        if (c != -1) {
            in.pushback((char)c);
        }
        try {
            if (isFloat) {
                return Double.parseDouble(number.toString());
            }
            return Long.parseLong(number.toString(), 10);
        }
        catch (Exception e) {
            return (Number)this.error("Invalid number: " + number, e);
        }
    }

    private String readString() throws IOException {
        StringBuilder str = this.strBuf;
        StringBuilder hex = this.hexBuf;
        str.setLength(0);
        int state = 0;
        FastReader in = this.input;
        while (true) {
            int c;
            if ((c = in.read()) == -1) {
                this.error("EOF reached while reading JSON string");
            }
            if (state == 0) {
                if (c == 34) break;
                if (c == 92) {
                    state = 1;
                    continue;
                }
                str.append((char)c);
                continue;
            }
            if (state == 1) {
                switch (c) {
                    case 92: {
                        str.append('\\');
                        break;
                    }
                    case 47: {
                        str.append('/');
                        break;
                    }
                    case 34: {
                        str.append('\"');
                        break;
                    }
                    case 39: {
                        str.append('\'');
                        break;
                    }
                    case 98: {
                        str.append('\b');
                        break;
                    }
                    case 102: {
                        str.append('\f');
                        break;
                    }
                    case 110: {
                        str.append('\n');
                        break;
                    }
                    case 114: {
                        str.append('\r');
                        break;
                    }
                    case 116: {
                        str.append('\t');
                        break;
                    }
                    case 117: {
                        hex.setLength(0);
                        state = 2;
                        break;
                    }
                    default: {
                        this.error("Invalid character escape sequence specified: " + c);
                    }
                }
                if (c == 117) continue;
                state = 0;
                continue;
            }
            if (c >= 48 && c <= 57 || c >= 65 && c <= 70 || c >= 97 && c <= 102) {
                hex.append((char)c);
                if (hex.length() != 4) continue;
                int value = Integer.parseInt(hex.toString(), 16);
                str.append((char)value);
                state = 0;
                continue;
            }
            this.error("Expected hexadecimal digits");
        }
        String s = str.toString();
        String translate = stringCache.get(s);
        return translate == null ? s : translate;
    }

    private int skipWhitespaceRead() throws IOException {
        int c;
        FastReader in = this.input;
        while ((c = in.read()) == 32 || c == 10 || c == 13 || c == 9) {
        }
        return c;
    }

    Object error(String msg) {
        throw new JsonIoException(this.getMessage(msg));
    }

    Object error(String msg, Exception e) {
        throw new JsonIoException(this.getMessage(msg), e);
    }

    String getMessage(String msg) {
        return msg + "\nline: " + this.input.getLine() + ", col: " + this.input.getCol() + "\n" + this.input.getLastSnippet();
    }

    static {
        stringCache.put("", "");
        stringCache.put("true", "true");
        stringCache.put("True", "True");
        stringCache.put("TRUE", "TRUE");
        stringCache.put("false", "false");
        stringCache.put("False", "False");
        stringCache.put("FALSE", "FALSE");
        stringCache.put("null", "null");
        stringCache.put("yes", "yes");
        stringCache.put("Yes", "Yes");
        stringCache.put("YES", "YES");
        stringCache.put("no", "no");
        stringCache.put("No", "No");
        stringCache.put("NO", "NO");
        stringCache.put("on", "on");
        stringCache.put("On", "On");
        stringCache.put("ON", "ON");
        stringCache.put("off", "off");
        stringCache.put("Off", "Off");
        stringCache.put("OFF", "OFF");
        stringCache.put("@id", "@id");
        stringCache.put("@ref", "@ref");
        stringCache.put("@items", "@items");
        stringCache.put("@type", "@type");
        stringCache.put("@keys", "@keys");
        stringCache.put("@i", "@id");
        stringCache.put("@r", "@ref");
        stringCache.put("@e", "@items");
        stringCache.put("@t", "@type");
        stringCache.put("@k", "@keys");
        stringCache.put("0", "0");
        stringCache.put("1", "1");
        stringCache.put("2", "2");
        stringCache.put("3", "3");
        stringCache.put("4", "4");
        stringCache.put("5", "5");
        stringCache.put("6", "6");
        stringCache.put("7", "7");
        stringCache.put("8", "8");
        stringCache.put("9", "9");
        JsonParser.EMPTY_OBJECT.type = JsonObject.class.getName();
        JsonParser.EMPTY_OBJECT.isFinished = true;
        JsonParser.EMPTY_ARRAY.type = Object[].class.getName();
        EMPTY_ARRAY.put("@items", new Object[0]);
        JsonParser.EMPTY_ARRAY.isFinished = true;
    }
}

