/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.reflect;

import com.cedarsoftware.util.reflect.Accessor;
import com.cedarsoftware.util.reflect.AccessorFactory;
import com.cedarsoftware.util.reflect.ClassDescriptor;
import com.cedarsoftware.util.reflect.FieldFilter;
import com.cedarsoftware.util.reflect.Injector;
import com.cedarsoftware.util.reflect.InjectorFactory;
import com.cedarsoftware.util.reflect.KnownFilteredFields;
import com.cedarsoftware.util.reflect.ReflectionUtils;
import com.cedarsoftware.util.reflect.accessors.FieldAccessor;
import com.cedarsoftware.util.reflect.factories.BooleanAccessorFactory;
import com.cedarsoftware.util.reflect.factories.EnumNameAccessorFactory;
import com.cedarsoftware.util.reflect.factories.MappedMethodAccessorFactory;
import com.cedarsoftware.util.reflect.factories.MappedMethodInjectorFactory;
import com.cedarsoftware.util.reflect.filters.EnumFilter;
import com.cedarsoftware.util.reflect.filters.GroovyFilter;
import com.cedarsoftware.util.reflect.filters.StaticFilter;
import com.cedarsoftware.util.reflect.injectors.FieldInjector;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class ClassDescriptors {
    private final List<FieldFilter> fieldFilters = new ArrayList<FieldFilter>();
    private final List<AccessorFactory> accessorFactories;
    private final List<InjectorFactory> injectorFactories;
    private final Map<Class<?>, ClassDescriptor> descriptors;
    private static final ClassDescriptors instance = new ClassDescriptors();

    private ClassDescriptors() {
        this.fieldFilters.add(new StaticFilter());
        this.fieldFilters.add(new GroovyFilter());
        this.fieldFilters.add(new EnumFilter());
        this.accessorFactories = new ArrayList<AccessorFactory>();
        this.accessorFactories.add(new MappedMethodAccessorFactory());
        this.accessorFactories.add(new BooleanAccessorFactory());
        this.accessorFactories.add(new EnumNameAccessorFactory());
        this.injectorFactories = new ArrayList<InjectorFactory>();
        this.injectorFactories.add(new MappedMethodInjectorFactory());
        this.descriptors = new ConcurrentHashMap();
    }

    public static ClassDescriptors instance() {
        return instance;
    }

    public Map<String, Accessor> getDeepAccessorMap(Class<?> classToTraverse) {
        LinkedHashMap<String, Accessor> accessors = new LinkedHashMap<String, Accessor>();
        for (Class<?> c = classToTraverse; c != null; c = c.getSuperclass()) {
            for (Map.Entry<String, Accessor> entry : this.getClassDescriptor(c).getAccessors().entrySet()) {
                String key = accessors.containsKey(entry.getKey()) ? c.getSimpleName() + '.' + entry.getKey() : entry.getKey();
                accessors.put(key, entry.getValue());
            }
        }
        return accessors;
    }

    public Map<String, Injector> getDeepInjectorMap(Class<?> classToTraverse) {
        LinkedHashMap<String, Injector> injectors = new LinkedHashMap<String, Injector>();
        for (Class<?> c = classToTraverse; c != null; c = c.getSuperclass()) {
            for (Map.Entry<String, Injector> entry : this.getClassDescriptor(c).getInjectors().entrySet()) {
                String key = injectors.containsKey(entry.getKey()) ? c.getSimpleName() + '.' + entry.getKey() : entry.getKey();
                injectors.put(key, entry.getValue());
            }
        }
        return injectors;
    }

    public Collection<Accessor> getDeepAccessorsForClass(Class<?> c) {
        return this.getDeepAccessorMap(c).values();
    }

    public ClassDescriptor getClassDescriptor(Class<?> c) {
        return this.descriptors.computeIfAbsent(c, this::buildDescriptor);
    }

    public void clearDescriptorCache() {
        this.descriptors.clear();
    }

    private ClassDescriptor buildDescriptor(Class<?> c) {
        Field[] declaredFields;
        Map<String, Method> possibleAccessors = ReflectionUtils.buildAccessorMap(c);
        Map<String, Method> possibleInjectors = ReflectionUtils.buildInjectorMap(c);
        ClassDescriptorImpl descriptor = new ClassDescriptorImpl();
        for (Field field : declaredFields = c.getDeclaredFields()) {
            boolean isKnownFilter = KnownFilteredFields.instance().isFieldFiltered(field);
            if (isKnownFilter || this.fieldFilters.stream().anyMatch(f -> f.filter(field))) continue;
            Optional<Accessor> accessor = this.accessorFactories.stream().map(factory -> factory.createAccessor(field, possibleAccessors)).filter(Objects::nonNull).findFirst();
            descriptor.addAccessor(field.getName(), accessor.orElseGet(() -> new FieldAccessor(field)));
            boolean isInjectionFiltered = KnownFilteredFields.instance().isInjectionFiltered(field);
            if (isInjectionFiltered) continue;
            Optional<Injector> injector = this.injectorFactories.stream().map(factory -> factory.createInjector(field, possibleInjectors)).filter(Objects::nonNull).findFirst();
            descriptor.addInjector(field.getName(), injector.orElseGet(() -> new FieldInjector(field)));
        }
        return descriptor;
    }

    public boolean addFilter(FieldFilter filter) {
        this.clearDescriptorCache();
        return this.fieldFilters.add(filter);
    }

    public boolean removeFilter(FieldFilter filter) {
        this.clearDescriptorCache();
        return this.fieldFilters.remove(filter);
    }

    public class ClassDescriptorImpl
    implements ClassDescriptor {
        private final Map<String, Accessor> accessors = new LinkedHashMap<String, Accessor>();
        private final Map<String, Injector> injectors = new LinkedHashMap<String, Injector>();

        public void addAccessor(String name, Accessor accessor) {
            this.accessors.put(name, accessor);
        }

        public void addInjector(String name, Injector injector) {
            this.injectors.put(name, injector);
        }

        @Override
        public Map<String, Accessor> getAccessors() {
            return this.accessors;
        }

        @Override
        public Map<String, Injector> getInjectors() {
            return this.injectors;
        }
    }
}

