/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io.factory;

import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.ReaderContext;
import com.cedarsoftware.util.io.factory.AbstractTemporalFactory;
import java.time.Year;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;

public class YearFactory
extends AbstractTemporalFactory<Year> {
    private static final DateTimeFormatter PARSER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).toFormatter();

    protected YearFactory(DateTimeFormatter dateFormatter, ZoneId zoneId) {
        super(dateFormatter, zoneId);
    }

    public YearFactory() {
        this(PARSER, ZoneId.systemDefault());
    }

    @Override
    protected Year fromString(String s) {
        try {
            return Year.parse(s, this.dateTimeFormatter);
        }
        catch (Exception e) {
            return Year.of(this.convertToZonedDateTime(s).getYear());
        }
    }

    @Override
    protected Year fromNumber(Number num) {
        return Year.of(num.intValue());
    }

    @Override
    protected Year fromJsonObject(JsonObject job, ReaderContext context) {
        Number year = (Number)job.get("year");
        return this.fromNumber(year);
    }
}

