/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.reflect.factories;

import com.cedarsoftware.util.reflect.Accessor;
import com.cedarsoftware.util.reflect.AccessorFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;

public class BooleanAccessorFactory
implements AccessorFactory {
    private static final int METHOD_MODIFIERS = 9;

    @Override
    public Accessor createAccessor(Field field, Map<String, Method> possibleMethods) throws Throwable {
        Class<?> c = field.getType();
        if (c != Boolean.class && c != Boolean.TYPE) {
            return null;
        }
        String name = field.getName();
        Method method = possibleMethods.get(BooleanAccessorFactory.createIsName(name));
        if (method == null || (method.getModifiers() & 9) != 1) {
            return null;
        }
        if (!method.getReturnType().isAssignableFrom(field.getType())) {
            return null;
        }
        try {
            return new Accessor(field, method);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static String createIsName(String fieldName) {
        return "is" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
    }
}

