/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.JsonWriter;
import com.cedarsoftware.io.MetaUtils;
import com.cedarsoftware.io.ReadOptionsBuilder;
import com.cedarsoftware.io.WriteOptions;
import com.cedarsoftware.io.Writers;
import com.cedarsoftware.io.reflect.Accessor;
import com.cedarsoftware.io.reflect.AccessorFactory;
import com.cedarsoftware.io.reflect.factories.GetMethodAccessorFactory;
import com.cedarsoftware.io.reflect.factories.IsMethodAccessorFactory;
import com.cedarsoftware.io.reflect.filters.FieldFilter;
import com.cedarsoftware.io.reflect.filters.MethodFilter;
import com.cedarsoftware.io.reflect.filters.field.EnumFieldFilter;
import com.cedarsoftware.io.reflect.filters.field.StaticFieldFilter;
import com.cedarsoftware.io.reflect.filters.method.DefaultMethodFilter;
import com.cedarsoftware.io.reflect.filters.method.NamedMethodFilter;
import com.cedarsoftware.util.ClassUtilities;
import com.cedarsoftware.util.Convention;
import com.cedarsoftware.util.ReflectionUtils;
import com.cedarsoftware.util.StringUtilities;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class WriteOptionsBuilder {
    public static final String ISO_DATE_FORMAT = "yyyy-MM-dd";
    public static final String ISO_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private static final Map<String, String> BASE_ALIAS_MAPPINGS = new ConcurrentHashMap<String, String>();
    private static final Map<Class<?>, JsonWriter.JsonClassWriter> BASE_WRITERS = new ConcurrentHashMap();
    private static final Set<Class<?>> BASE_NON_REFS = ConcurrentHashMap.newKeySet();
    static final Map<Class<?>, Set<String>> BASE_EXCLUDED_FIELD_NAMES = new ConcurrentHashMap();
    private static final Map<Class<?>, Map<String, String>> BASE_NONSTANDARD_GETTERS = new ConcurrentHashMap();
    private static final Map<String, FieldFilter> BASE_FIELD_FILTERS = new ConcurrentHashMap<String, FieldFilter>();
    private static final Map<String, MethodFilter> BASE_METHOD_FILTERS = new ConcurrentHashMap<String, MethodFilter>();
    private static final Map<String, AccessorFactory> BASE_ACCESSOR_FACTORIES = new ConcurrentHashMap<String, AccessorFactory>();
    private final DefaultWriteOptions options = new DefaultWriteOptions();

    public WriteOptionsBuilder() {
        this.options.nonStandardGetters.putAll(BASE_NONSTANDARD_GETTERS);
        this.options.aliasTypeNames.putAll(BASE_ALIAS_MAPPINGS);
        this.options.customWrittenClasses.putAll(BASE_WRITERS);
        this.options.nonRefClasses.addAll(BASE_NON_REFS);
        this.options.excludedFieldNames.putAll(BASE_EXCLUDED_FIELD_NAMES);
        this.options.fieldFilters.putAll(BASE_FIELD_FILTERS);
        this.options.methodFilters.putAll(BASE_METHOD_FILTERS);
        this.options.accessorFactories.putAll(BASE_ACCESSOR_FACTORIES);
    }

    public WriteOptionsBuilder(WriteOptions copy) {
        this();
        if (copy != null) {
            DefaultWriteOptions other = (DefaultWriteOptions)copy;
            this.options.allowNanAndInfinity = other.allowNanAndInfinity;
            this.options.closeStream = other.closeStream;
            this.options.classLoader = other.classLoader;
            this.options.enumPublicFieldsOnly = other.enumPublicFieldsOnly;
            this.options.forceMapOutputAsTwoArrays = other.forceMapOutputAsTwoArrays;
            this.options.prettyPrint = other.prettyPrint;
            this.options.shortMetaKeys = other.shortMetaKeys;
            this.options.showTypeInfo = other.showTypeInfo;
            this.options.skipNullFields = other.skipNullFields;
            this.options.writeLongsAsStrings = other.writeLongsAsStrings;
            this.options.includedFieldNames.clear();
            this.options.includedFieldNames.putAll(other.includedFieldNames);
            this.options.nonStandardGetters.clear();
            this.options.nonStandardGetters.putAll(other.nonStandardGetters);
            this.options.aliasTypeNames.clear();
            this.options.aliasTypeNames.putAll(other.aliasTypeNames);
            this.options.excludedFieldNames.clear();
            this.options.excludedFieldNames.putAll(other.excludedFieldNames);
            this.options.customWrittenClasses.clear();
            this.options.customWrittenClasses.putAll(other.customWrittenClasses);
            this.options.notCustomWrittenClasses.clear();
            this.options.notCustomWrittenClasses.addAll(other.notCustomWrittenClasses);
            this.options.nonRefClasses.clear();
            this.options.nonRefClasses.addAll(other.nonRefClasses);
            this.options.fieldFilters.clear();
            this.options.fieldFilters.putAll(other.fieldFilters);
            this.options.methodFilters.clear();
            this.options.methodFilters.putAll(other.methodFilters);
            this.options.accessorFactories.clear();
            this.options.accessorFactories.putAll(other.accessorFactories);
        }
    }

    public static void addPermanentAlias(Class<?> clazz, String alias) {
        BASE_ALIAS_MAPPINGS.put(clazz.getName(), alias);
    }

    public static void removePermanentAliasTypeNamesMatching(String classNamePattern) {
        String regex = StringUtilities.wildcardToRegexString((String)classNamePattern);
        Pattern pattern = Pattern.compile(regex);
        BASE_ALIAS_MAPPINGS.keySet().removeIf(key -> pattern.matcher((CharSequence)key).matches());
    }

    public static void addPermanentExcludedField(Class<?> clazz, String fieldName) {
        BASE_EXCLUDED_FIELD_NAMES.computeIfAbsent(clazz, cls -> ConcurrentHashMap.newKeySet()).add(fieldName);
    }

    public static void addPermanentNonRef(Class<?> clazz) {
        BASE_NON_REFS.add(clazz);
    }

    public static void addPermanentWriter(Class<?> clazz, JsonWriter.JsonClassWriter writer) {
        BASE_WRITERS.put(clazz, writer);
    }

    public static void addPermanentNonStandardGetter(Class<?> clazz, String field, String methodName) {
        BASE_NONSTANDARD_GETTERS.computeIfAbsent(clazz, cls -> new ConcurrentHashMap()).put(field, methodName);
    }

    public static void addPermanentFieldFilter(String name, FieldFilter fieldFilter) {
        BASE_FIELD_FILTERS.put(name, fieldFilter);
    }

    public static void addPermanentMethodFilter(String name, MethodFilter methodFilter) {
        BASE_METHOD_FILTERS.put(name, methodFilter);
    }

    public static void addPermanentNamedMethodFilter(String name, Class<?> clazz, String methodName) {
        BASE_METHOD_FILTERS.put(name, new NamedMethodFilter(clazz, methodName));
    }

    public static void addPermanentAccessorFactory(String name, AccessorFactory factory) {
        BASE_ACCESSOR_FACTORIES.put(name, factory);
    }

    public WriteOptionsBuilder classLoader(ClassLoader loader) {
        this.options.classLoader = loader;
        return this;
    }

    public WriteOptionsBuilder shortMetaKeys(boolean shortMetaKeys) {
        this.options.shortMetaKeys = shortMetaKeys;
        return this;
    }

    public WriteOptionsBuilder aliasTypeNames(Map<String, String> aliases) {
        aliases.forEach(this::addUniqueAlias);
        return this;
    }

    public WriteOptionsBuilder aliasTypeName(Class<?> type, String alias) {
        this.options.aliasTypeNames.put(type.getName(), alias);
        return this;
    }

    public WriteOptionsBuilder aliasTypeName(String typeName, String alias) {
        this.addUniqueAlias(typeName, alias);
        return this;
    }

    private void addUniqueAlias(String typeName, String alias) {
        Convention.throwIfClassNotFound((String)typeName, (ClassLoader)this.options.classLoader);
        Convention.throwIfKeyExists((Map)this.options.aliasTypeNames, (Object)typeName, (String)("Tried to create @type alias '" + alias + "' for '" + typeName + "', but it is already aliased to: " + (String)this.options.aliasTypeNames.get(typeName)));
        this.options.aliasTypeNames.put(typeName, alias);
    }

    public WriteOptionsBuilder removeAliasTypeNamesMatching(String typeNamePattern) {
        String regex = StringUtilities.wildcardToRegexString((String)typeNamePattern);
        Pattern pattern = Pattern.compile(regex);
        this.options.aliasTypeNames.keySet().removeIf(key -> pattern.matcher((CharSequence)key).matches());
        return this;
    }

    public WriteOptionsBuilder showTypeInfoAlways() {
        this.options.showTypeInfo = WriteOptions.ShowType.ALWAYS;
        return this;
    }

    public WriteOptionsBuilder showTypeInfoNever() {
        this.options.showTypeInfo = WriteOptions.ShowType.NEVER;
        return this;
    }

    public WriteOptionsBuilder showTypeInfoMinimal() {
        this.options.showTypeInfo = WriteOptions.ShowType.MINIMAL;
        return this;
    }

    public WriteOptionsBuilder prettyPrint(boolean prettyPrint) {
        this.options.prettyPrint = prettyPrint;
        return this;
    }

    public WriteOptionsBuilder writeLongsAsStrings(boolean writeLongsAsStrings) {
        this.options.writeLongsAsStrings = writeLongsAsStrings;
        return this;
    }

    public WriteOptionsBuilder skipNullFields(boolean skipNullFields) {
        this.options.skipNullFields = skipNullFields;
        return this;
    }

    public WriteOptionsBuilder forceMapOutputAsTwoArrays(boolean forceMapOutputAsTwoArrays) {
        this.options.forceMapOutputAsTwoArrays = forceMapOutputAsTwoArrays;
        return this;
    }

    public WriteOptionsBuilder allowNanAndInfinity(boolean allowNanAndInfinity) {
        this.options.allowNanAndInfinity = allowNanAndInfinity;
        return this;
    }

    public WriteOptionsBuilder writeEnumsAsString() {
        this.options.enumWriter = new Writers.EnumsAsStringWriter();
        return this;
    }

    public WriteOptionsBuilder writeEnumAsJsonObject(boolean writePublicFieldsOnly) {
        this.options.enumWriter = DefaultWriteOptions.nullWriter;
        this.options.enumPublicFieldsOnly = writePublicFieldsOnly;
        return this;
    }

    public WriteOptionsBuilder closeStream(boolean closeStream) {
        this.options.closeStream = closeStream;
        return this;
    }

    public WriteOptionsBuilder setCustomWrittenClasses(Map<Class<?>, JsonWriter.JsonClassWriter> customWrittenClasses) {
        this.options.customWrittenClasses.clear();
        this.addCustomWrittenClasses(customWrittenClasses);
        return this;
    }

    public WriteOptionsBuilder addCustomWrittenClasses(Map<Class<?>, JsonWriter.JsonClassWriter> customWrittenClasses) {
        this.options.customWrittenClasses.putAll(customWrittenClasses);
        return this;
    }

    public WriteOptionsBuilder addCustomWrittenClass(Class<?> clazz, JsonWriter.JsonClassWriter customWriter) {
        this.options.customWrittenClasses.put(clazz, customWriter);
        return this;
    }

    public WriteOptionsBuilder addNotCustomWrittenClass(Class<?> notCustomClass) {
        this.options.notCustomWrittenClasses.add(notCustomClass);
        return this;
    }

    public WriteOptionsBuilder setNotCustomWrittenClasses(Collection<Class<?>> notCustomClasses) {
        this.options.notCustomWrittenClasses.clear();
        this.options.notCustomWrittenClasses.addAll(notCustomClasses);
        return this;
    }

    public WriteOptionsBuilder addIncludedField(Class<?> clazz, String includedFieldName) {
        Convention.throwIfNull((Object)includedFieldName, (String)"includedFieldName cannot be null");
        this.options.includedFieldNames.computeIfAbsent(clazz, k -> new LinkedHashSet()).add(includedFieldName);
        return this;
    }

    public WriteOptionsBuilder addIncludedFields(Class<?> clazz, Collection<String> includedFieldNames) {
        this.options.includedFieldNames.computeIfAbsent(clazz, k -> new LinkedHashSet()).addAll(includedFieldNames);
        return this;
    }

    public WriteOptionsBuilder addIncludedFields(Map<Class<?>, Collection<String>> includedFieldNames) {
        includedFieldNames.forEach(this::addIncludedFields);
        return this;
    }

    public WriteOptionsBuilder addExcludedField(Class<?> clazz, String excludedFieldName) {
        this.options.excludedFieldNames.computeIfAbsent(clazz, k -> new LinkedHashSet()).add(excludedFieldName);
        return this;
    }

    public WriteOptionsBuilder addExcludedFields(Class<?> clazz, Collection<String> excludedFields) {
        this.options.excludedFieldNames.computeIfAbsent(clazz, k -> new LinkedHashSet()).addAll(excludedFields);
        return this;
    }

    public WriteOptionsBuilder addExcludedFields(Map<Class<?>, Collection<String>> excludedFieldNames) {
        excludedFieldNames.forEach(this::addExcludedFields);
        return this;
    }

    public WriteOptionsBuilder isoDateFormat() {
        return this.dateTimeFormat(ISO_DATE_FORMAT);
    }

    public WriteOptionsBuilder isoDateTimeFormat() {
        return this.dateTimeFormat(ISO_DATE_TIME_FORMAT);
    }

    public WriteOptionsBuilder longDateFormat() {
        this.addCustomWrittenClass(Date.class, new Writers.DateAsLongWriter());
        return this;
    }

    public WriteOptionsBuilder dateTimeFormat(String format) {
        this.addCustomWrittenClass(Date.class, new Writers.DateWriter(format));
        return this;
    }

    public WriteOptionsBuilder addNonStandardGetter(Class<?> c, String fieldName, String methodName) {
        Convention.throwIfNull(c, (String)"class cannot be null");
        Convention.throwIfNull((Object)fieldName, (String)"fieldName cannot be null");
        Convention.throwIfNull((Object)methodName, (String)"methodName cannot be null");
        this.options.nonStandardGetters.computeIfAbsent(c, cls -> new LinkedHashMap()).put(fieldName, methodName);
        return this;
    }

    public WriteOptionsBuilder addNonReferenceableClass(Class<?> clazz) {
        Convention.throwIfNull(clazz, (String)"clazz cannot be null");
        this.options.nonRefClasses.add(clazz);
        return this;
    }

    public WriteOptionsBuilder addCustomOption(String key, Object value) {
        if (key == null) {
            throw new JsonIoException("Custom option key must not be null.");
        }
        if (value == null) {
            this.options.customOptions.remove(key);
        } else {
            this.options.customOptions.put(key, value);
        }
        return this;
    }

    public WriteOptionsBuilder addFieldFilter(String filterName, FieldFilter filter) {
        this.options.fieldFilters.put(filterName, filter);
        return this;
    }

    public WriteOptionsBuilder removeFieldFilter(String filterName) {
        this.options.fieldFilters.remove(filterName);
        return this;
    }

    public WriteOptionsBuilder addMethodFilter(String filterName, MethodFilter methodFilter) {
        this.options.methodFilters.put(filterName, methodFilter);
        return this;
    }

    public WriteOptionsBuilder addNamedMethodFilter(String filterName, Class<?> clazz, String methodName) {
        this.options.methodFilters.put(filterName, new NamedMethodFilter(clazz, methodName));
        return this;
    }

    public WriteOptionsBuilder removeMethodFilter(String filterName) {
        this.options.methodFilters.remove(filterName);
        return this;
    }

    public WriteOptionsBuilder addAccessorFactory(String factoryName, AccessorFactory accessorFactory) {
        this.options.accessorFactories.put(factoryName, accessorFactory);
        return this;
    }

    public WriteOptionsBuilder removeAccessorFactory(String factoryName) {
        this.options.accessorFactories.remove(factoryName);
        return this;
    }

    public WriteOptions build() {
        this.options.clearCaches();
        this.options.includedFieldNames = Collections.unmodifiableMap(this.options.includedFieldNames);
        this.options.nonStandardGetters = Collections.unmodifiableMap(this.options.nonStandardGetters);
        this.options.aliasTypeNames = Collections.unmodifiableMap(this.options.aliasTypeNames);
        this.options.notCustomWrittenClasses = Collections.unmodifiableSet(this.options.notCustomWrittenClasses);
        this.options.nonRefClasses = Collections.unmodifiableSet(this.options.nonRefClasses);
        this.options.excludedFieldNames = Collections.unmodifiableMap(this.options.excludedFieldNames);
        this.options.fieldFilters = Collections.unmodifiableMap(this.options.fieldFilters);
        this.options.methodFilters = Collections.unmodifiableMap(this.options.methodFilters);
        this.options.accessorFactories = Collections.unmodifiableMap(this.options.accessorFactories);
        this.options.customWrittenClasses = Collections.unmodifiableMap(this.options.customWrittenClasses);
        this.options.customOptions = Collections.unmodifiableMap(this.options.customOptions);
        return this.options;
    }

    private static void loadBaseWriters() {
        Map<String, String> map = MetaUtils.loadMapDefinition("config/customWriters.txt");
        ClassLoader classLoader = WriteOptions.class.getClassLoader();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String className = entry.getKey();
            String writerClassName = entry.getValue();
            Class clazz = ClassUtilities.forName((String)className, (ClassLoader)classLoader);
            if (clazz == null) {
                System.out.println("Class: " + className + " not defined in the JVM, so custom writer: " + writerClassName + ", will not be used.");
                continue;
            }
            Class customWriter = ClassUtilities.forName((String)writerClassName, (ClassLoader)classLoader);
            if (customWriter == null) {
                System.out.println("Note: class not found (custom JsonClassWriter class): " + writerClassName + ", listed in resources/customWriters.txt as a custom writer for: " + className);
            }
            try {
                JsonWriter.JsonClassWriter writer = (JsonWriter.JsonClassWriter)customWriter.newInstance();
                WriteOptionsBuilder.addPermanentWriter(clazz, writer);
            }
            catch (Exception e) {
                System.out.println("Note: class failed to instantiate (a custom JsonClassWriter class): " + writerClassName + ", listed in resources/customWriters.txt as a custom writer for: " + className);
            }
        }
    }

    static void loadBaseNonRefs() {
        Set<String> set = MetaUtils.loadSetDefinition("config/nonRefs.txt");
        set.forEach(className -> {
            Class clazz = ClassUtilities.forName((String)className, (ClassLoader)WriteOptions.class.getClassLoader());
            if (clazz == null) {
                System.out.println("Class: " + className + " undefined.  Cannot be used as non-referenceable class, listed in resources/nonRefs.txt");
            }
            WriteOptionsBuilder.addPermanentNonRef(clazz);
        });
    }

    private static void loadBaseExcludedFields() {
        Map<Class<?>, Set<String>> allExcludedFields = ReadOptionsBuilder.loadClassToSetOfStrings("config/fieldsNotExported.txt");
        for (Map.Entry<Class<?>, Set<String>> entry : allExcludedFields.entrySet()) {
            Class<?> clazz = entry.getKey();
            Set<String> excludedFields = entry.getValue();
            for (String fieldName : excludedFields) {
                WriteOptionsBuilder.addPermanentExcludedField(clazz, fieldName);
            }
        }
    }

    private static void loadBaseNonStandardGetters() {
        Map<Class<?>, Map<String, String>> nonStandardGetterMap = ReadOptionsBuilder.loadClassToFieldAliasNameMapping("config/nonStandardGetters.txt");
        for (Map.Entry<Class<?>, Map<String, String>> entry : nonStandardGetterMap.entrySet()) {
            Class<?> clazz = entry.getKey();
            Map<String, String> pairingsMap = entry.getValue();
            for (Map.Entry<String, String> fieldToAltName : pairingsMap.entrySet()) {
                WriteOptionsBuilder.addPermanentNonStandardGetter(clazz, fieldToAltName.getKey(), fieldToAltName.getValue());
            }
        }
    }

    static {
        ReadOptionsBuilder.loadBaseAliasMappings(WriteOptionsBuilder::addPermanentAlias);
        WriteOptionsBuilder.loadBaseWriters();
        WriteOptionsBuilder.loadBaseNonRefs();
        WriteOptionsBuilder.loadBaseExcludedFields();
        WriteOptionsBuilder.loadBaseNonStandardGetters();
        WriteOptionsBuilder.addPermanentFieldFilter("static", new StaticFieldFilter());
        WriteOptionsBuilder.addPermanentFieldFilter("enum", new EnumFieldFilter());
        WriteOptionsBuilder.addPermanentMethodFilter("default", new DefaultMethodFilter());
        WriteOptionsBuilder.addPermanentAccessorFactory("get", new GetMethodAccessorFactory());
        WriteOptionsBuilder.addPermanentAccessorFactory("is", new IsMethodAccessorFactory());
    }

    static class DefaultWriteOptions
    implements WriteOptions {
        private boolean shortMetaKeys = false;
        private WriteOptions.ShowType showTypeInfo = WriteOptions.ShowType.MINIMAL;
        private boolean prettyPrint = false;
        private boolean writeLongsAsStrings = false;
        private boolean skipNullFields = false;
        private boolean forceMapOutputAsTwoArrays = false;
        private boolean allowNanAndInfinity = false;
        private boolean enumPublicFieldsOnly = false;
        private boolean closeStream = true;
        private JsonWriter.JsonClassWriter enumWriter = new Writers.EnumsAsStringWriter();
        private ClassLoader classLoader = WriteOptions.class.getClassLoader();
        private Map<Class<?>, Set<String>> includedFieldNames = new LinkedHashMap();
        private Map<Class<?>, Map<String, String>> nonStandardGetters = new LinkedHashMap();
        private Map<String, String> aliasTypeNames = new LinkedHashMap<String, String>();
        private Set<Class<?>> notCustomWrittenClasses = new LinkedHashSet();
        private Set<Class<?>> nonRefClasses = new LinkedHashSet();
        private Map<Class<?>, Set<String>> excludedFieldNames = new LinkedHashMap();
        private Map<String, FieldFilter> fieldFilters = new LinkedHashMap<String, FieldFilter>();
        private Map<String, MethodFilter> methodFilters = new LinkedHashMap<String, MethodFilter>();
        private Map<String, AccessorFactory> accessorFactories = new LinkedHashMap<String, AccessorFactory>();
        private Map<Class<?>, JsonWriter.JsonClassWriter> customWrittenClasses = new LinkedHashMap();
        private Map<String, Object> customOptions = new LinkedHashMap<String, Object>();
        private final Map<Class<?>, JsonWriter.JsonClassWriter> writerCache = new ConcurrentHashMap(200, 0.8f, Runtime.getRuntime().availableProcessors());
        private final Map<Class<?>, List<Accessor>> accessorsCache = new ConcurrentHashMap(200, 0.8f, Runtime.getRuntime().availableProcessors());
        private final Map<Class<?>, Map<String, Field>> classMetaCache = new ConcurrentHashMap(200, 0.8f, Runtime.getRuntime().availableProcessors());
        static final NullClass nullWriter = new NullClass();

        private DefaultWriteOptions() {
        }

        @Override
        public String getTypeNameAlias(String typeName) {
            String alias = this.aliasTypeNames.get(typeName);
            return alias == null ? typeName : alias;
        }

        @Override
        public Map<String, String> aliases() {
            return Collections.unmodifiableMap(this.aliasTypeNames);
        }

        @Override
        public boolean isAlwaysShowingType() {
            return this.showTypeInfo == WriteOptions.ShowType.ALWAYS;
        }

        @Override
        public boolean isNeverShowingType() {
            return this.showTypeInfo == WriteOptions.ShowType.NEVER;
        }

        @Override
        public boolean isMinimalShowingType() {
            return this.showTypeInfo == WriteOptions.ShowType.MINIMAL;
        }

        @Override
        public boolean isCustomWrittenClass(Class<?> clazz) {
            return this.customWrittenClasses.containsKey(clazz);
        }

        @Override
        public boolean isNotCustomWrittenClass(Class<?> clazz) {
            return this.notCustomWrittenClasses.contains(clazz);
        }

        @Override
        public List<Accessor> getAccessorsForClass(Class<?> c) {
            return this.accessorsCache.computeIfAbsent(c, this::buildDeepAccessors);
        }

        @Override
        public boolean isLongDateFormat() {
            JsonWriter.JsonClassWriter a = this.customWrittenClasses.get(Date.class);
            return a instanceof Writers.DateAsLongWriter;
        }

        @Override
        public boolean isNonReferenceableClass(Class<?> clazz) {
            return this.nonRefClasses.contains(clazz) || Number.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz) || String.class.isAssignableFrom(clazz) || clazz.isEnum();
        }

        @Override
        public boolean isShortMetaKeys() {
            return this.shortMetaKeys;
        }

        @Override
        public boolean isPrettyPrint() {
            return this.prettyPrint;
        }

        @Override
        public boolean isWriteLongsAsStrings() {
            return this.writeLongsAsStrings;
        }

        @Override
        public boolean isSkipNullFields() {
            return this.skipNullFields;
        }

        @Override
        public boolean isForceMapOutputAsTwoArrays() {
            return this.forceMapOutputAsTwoArrays;
        }

        @Override
        public boolean isAllowNanAndInfinity() {
            return this.allowNanAndInfinity;
        }

        @Override
        public boolean isEnumPublicFieldsOnly() {
            return this.enumPublicFieldsOnly;
        }

        @Override
        public boolean isCloseStream() {
            return this.closeStream;
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        @Override
        public JsonWriter.JsonClassWriter getCustomWriter(Class<?> c) {
            JsonWriter.JsonClassWriter writer = this.writerCache.computeIfAbsent(c, this::findCustomWriter);
            return writer == nullWriter ? null : writer;
        }

        public JsonWriter.JsonClassWriter findCustomWriter(Class<?> c) {
            JsonWriter.JsonClassWriter writer = MetaUtils.findClosest(c, this.customWrittenClasses, nullWriter);
            return writer != nullWriter ? writer : (MetaUtils.getClassIfEnum(c).isPresent() ? this.enumWriter : nullWriter);
        }

        @Override
        public Object getCustomOption(String key) {
            return this.customOptions.get(key);
        }

        @Override
        public Set<String> getIncludedFields(Class<?> c) {
            return Collections.unmodifiableSet(this.includedFieldNames.get(c));
        }

        @Override
        public Set<String> getExcludedFields(Class<?> c) {
            return Collections.unmodifiableSet(this.excludedFieldNames.get(c));
        }

        @Override
        public void clearCaches() {
            this.accessorsCache.clear();
        }

        private List<Accessor> buildDeepAccessors(Class<?> clazz) {
            Map<String, Field> fields = this.getDeepDeclaredFields(clazz);
            ArrayList<Accessor> accessors = new ArrayList<Accessor>(fields.size());
            for (Map.Entry<String, Field> entry : fields.entrySet()) {
                String uniqueFieldName;
                Field field = entry.getValue();
                Accessor accessor = this.findMethodAccessor(field, uniqueFieldName = entry.getKey());
                if (accessor != null && this.isMethodFiltered(clazz, accessor.getFieldOrMethodName())) {
                    accessor = null;
                }
                if (accessor == null) {
                    accessor = Accessor.createFieldAccessor(field, uniqueFieldName);
                }
                if (accessor == null) continue;
                accessors.add(accessor);
            }
            return Collections.unmodifiableList(accessors);
        }

        private boolean isMethodFiltered(Class<?> clazz, String methodName) {
            for (MethodFilter filter : this.methodFilters.values()) {
                if (!filter.filter(clazz, methodName)) continue;
                return true;
            }
            return false;
        }

        private Accessor findMethodAccessor(Field field, String uniqueFieldName) {
            for (AccessorFactory factory : this.accessorFactories.values()) {
                try {
                    Accessor accessor = factory.buildAccessor(field, this.nonStandardGetters, uniqueFieldName);
                    if (accessor == null) continue;
                    return accessor;
                }
                catch (Throwable throwable) {
                }
            }
            return null;
        }

        @Override
        public Map<String, Field> getDeepDeclaredFields(Class<?> c) {
            return this.classMetaCache.computeIfAbsent(c, this::buildWithIncludedMinusExcluded);
        }

        private Map<String, Field> buildWithIncludedMinusExcluded(Class<?> c) {
            Convention.throwIfNull(c, (String)"class cannot be null");
            LinkedHashMap<String, Field> map = new LinkedHashMap<String, Field>();
            HashSet<String> excluded = new HashSet<String>();
            HashSet includedFields = this.includedFieldNames.get(c);
            HashSet included = includedFields == null ? new HashSet() : includedFields;
            for (Class<?> curr = c; curr != Object.class; curr = curr.getSuperclass()) {
                List fields = ReflectionUtils.getDeclaredFields(curr);
                Set<String> excludedForClass = this.excludedFieldNames.get(curr);
                if (excludedForClass != null) {
                    excluded.addAll(excludedForClass);
                }
                for (Field field : fields) {
                    String fieldName = field.getName();
                    if (map.containsKey(fieldName)) {
                        fieldName = field.getDeclaringClass().getSimpleName() + '.' + fieldName;
                    }
                    if (this.isFieldFiltered(field) || excluded.contains(fieldName)) continue;
                    boolean isTransient = Modifier.isTransient(field.getModifiers());
                    boolean includedExplicitly = included.contains(fieldName);
                    if (isTransient && !includedExplicitly || !included.isEmpty() && !includedExplicitly) continue;
                    map.put(fieldName, field);
                }
            }
            return Collections.unmodifiableMap(map);
        }

        private boolean isFieldFiltered(Field field) {
            for (FieldFilter filter : this.fieldFilters.values()) {
                if (!filter.filter(field)) continue;
                return true;
            }
            return false;
        }

        private static final class NullClass
        implements JsonWriter.JsonClassWriter {
            private NullClass() {
            }
        }
    }
}

