/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonIo;
import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.Primitives;
import com.cedarsoftware.io.Unsafe;
import com.cedarsoftware.io.WriteOptions;
import com.cedarsoftware.io.WriteOptionsBuilder;
import com.cedarsoftware.util.ClassUtilities;
import com.cedarsoftware.util.convert.Converter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class MetaUtils {
    public static final String META_CLASS_FIELD_NAME = "metaClass";
    public static final String META_CLASS_NAME = "groovy.lang.MetaClass";
    private static final Map<String, Class<?>> nameToClass = new HashMap();
    private static final ConcurrentMap<String, CachedConstructor> constructors = new ConcurrentHashMap<String, CachedConstructor>();
    static final ThreadLocal<SimpleDateFormat> dateFormat = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ"));
    private static boolean useUnsafe = false;
    private static Unsafe unsafe;
    private static final Map<Class<?>, Supplier<Object>> DIRECT_CLASS_MAPPING;
    private static final Map<Class<?>, Supplier<Object>> ASSIGNABLE_CLASS_MAPPING;
    private static final Pattern extraQuotes;
    static final Pattern primArray;

    private MetaUtils() {
    }

    public static void setUseUnsafe(boolean state) {
        useUnsafe = state;
        if (state) {
            try {
                unsafe = new Unsafe();
            }
            catch (InvocationTargetException e) {
                useUnsafe = false;
            }
        }
    }

    public static Optional<Class<?>> getClassIfEnum(Class<?> c) {
        if (c.isEnum()) {
            return Optional.of(c);
        }
        if (!Enum.class.isAssignableFrom(c)) {
            return Optional.empty();
        }
        Class<?> enclosingClass = c.getEnclosingClass();
        return enclosingClass != null && enclosingClass.isEnum() ? Optional.of(enclosingClass) : Optional.empty();
    }

    static void throwIfSecurityConcern(Class<?> securityConcern, Class<?> c) {
        if (securityConcern.isAssignableFrom(c)) {
            throw new JsonIoException("For security reasons, json-io does not allow instantiation of: " + securityConcern.getName());
        }
    }

    static Object getArgForType(Converter converter, Class<?> argType) {
        if (Primitives.isPrimitive(argType)) {
            return converter.convert(null, argType);
        }
        Supplier<Object> directClassMapping = DIRECT_CLASS_MAPPING.get(argType);
        if (directClassMapping != null) {
            return directClassMapping.get();
        }
        for (Map.Entry<Class<?>, Supplier<Object>> entry : ASSIGNABLE_CLASS_MAPPING.entrySet()) {
            if (!entry.getKey().isAssignableFrom(argType)) continue;
            return entry.getValue().get();
        }
        if (argType.isArray()) {
            return Array.newInstance(argType.getComponentType(), 0);
        }
        return null;
    }

    public static List<Object> matchArgumentsToParameters(Converter converter, Collection<Object> values, Parameter[] parameterTypes, boolean useNull) {
        ArrayList<Object> answer = new ArrayList<Object>();
        if (parameterTypes == null || parameterTypes.length == 0) {
            return answer;
        }
        ArrayList<Object> copyValues = new ArrayList<Object>(values);
        for (Parameter parameter : parameterTypes) {
            Class<?> paramType = parameter.getType();
            Object value = MetaUtils.pickBestValue(paramType, copyValues);
            if (value == null) {
                value = useNull ? (paramType.isPrimitive() ? converter.convert(null, paramType) : null) : MetaUtils.getArgForType(converter, paramType);
            }
            answer.add(value);
        }
        return answer;
    }

    private static Object pickBestValue(Class<?> param, List<Object> values) {
        int[] distances = new int[values.size()];
        int i = 0;
        for (Object value : values) {
            distances[i++] = value == null ? -1 : ClassUtilities.computeInheritanceDistance(value.getClass(), param);
        }
        int index = MetaUtils.indexOfSmallestValue(distances);
        if (index >= 0) {
            Object valueBestMatching = values.get(index);
            values.remove(index);
            return valueBestMatching;
        }
        return null;
    }

    public static int indexOfSmallestValue(int[] array) {
        if (array == null || array.length == 0) {
            return -1;
        }
        int minValue = Integer.MAX_VALUE;
        int minIndex = -1;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] >= minValue || array[i] <= -1) continue;
            minValue = array[i];
            minIndex = i;
        }
        return minIndex;
    }

    public static String createCacheKey(Class<?> c, Collection<?> args) {
        StringBuilder s = new StringBuilder(c.getName());
        for (Object o : args) {
            if (o == null) {
                s.append(":null");
                continue;
            }
            s.append(':');
            s.append(o.getClass().getSimpleName());
        }
        return s.toString();
    }

    public static Object newInstance(Converter converter, Class<?> c, Collection<?> argumentValues) {
        block14: {
            String cacheKey;
            CachedConstructor cachedConstructor;
            MetaUtils.throwIfSecurityConcern(ProcessBuilder.class, c);
            MetaUtils.throwIfSecurityConcern(Process.class, c);
            MetaUtils.throwIfSecurityConcern(ClassLoader.class, c);
            MetaUtils.throwIfSecurityConcern(Constructor.class, c);
            MetaUtils.throwIfSecurityConcern(Method.class, c);
            MetaUtils.throwIfSecurityConcern(Field.class, c);
            if (c.getName().equals("java.lang.ProcessImpl")) {
                throw new IllegalArgumentException("For security reasons, json-io does not allow instantiation of: java.lang.ProcessImpl");
            }
            if (argumentValues == null) {
                argumentValues = new ArrayList();
            }
            if ((cachedConstructor = (CachedConstructor)constructors.get(cacheKey = MetaUtils.createCacheKey(c, argumentValues))) == null) {
                if (c.isInterface()) {
                    throw new JsonIoException("Cannot instantiate unknown interface: " + c.getName());
                }
                Constructor<?>[] declaredConstructors = c.getDeclaredConstructors();
                TreeSet<ConstructorWithValues> constructorOrder = new TreeSet<ConstructorWithValues>();
                ArrayList<Object> argValues = new ArrayList<Object>(argumentValues);
                for (Constructor<?> constructor : declaredConstructors) {
                    Parameter[] parameters = constructor.getParameters();
                    List<Object> argumentsNull = MetaUtils.matchArgumentsToParameters(converter, argValues, parameters, true);
                    List<Object> argumentsNonNull = MetaUtils.matchArgumentsToParameters(converter, argValues, parameters, false);
                    constructorOrder.add(new ConstructorWithValues(constructor, argumentsNull.toArray(), argumentsNonNull.toArray()));
                }
                for (ConstructorWithValues constructorWithValues : constructorOrder) {
                    Constructor<?> constructor = constructorWithValues.constructor;
                    try {
                        MetaUtils.trySetAccessible(constructor);
                        Object o = constructor.newInstance(constructorWithValues.argsNull);
                        constructors.put(cacheKey, new CachedConstructor(constructor, true));
                        return o;
                    }
                    catch (Exception ignore) {
                        try {
                            if (constructor.getParameterCount() <= 0) continue;
                            Object o = constructor.newInstance(constructorWithValues.argsNonNull);
                            constructors.put(cacheKey, new CachedConstructor(constructor, false));
                            return o;
                        }
                        catch (Exception exception) {
                        }
                    }
                }
                Object o = MetaUtils.tryUnsafeInstantiation(c);
                if (o != null) {
                    return o;
                }
            } else {
                ArrayList<Object> argValues = new ArrayList<Object>(argumentValues);
                Parameter[] parameters = cachedConstructor.constructor.getParameters();
                List<Object> arguments = MetaUtils.matchArgumentsToParameters(converter, argValues, parameters, cachedConstructor.useNullSetting);
                try {
                    Object o = cachedConstructor.constructor.newInstance(arguments.toArray());
                    return o;
                }
                catch (Exception o) {
                    Object o2 = MetaUtils.tryUnsafeInstantiation(c);
                    if (o2 == null) break block14;
                    return o2;
                }
            }
        }
        throw new JsonIoException("Unable to instantiate: " + c.getName());
    }

    private static Object tryUnsafeInstantiation(Class<?> c) {
        if (useUnsafe) {
            try {
                Object o = unsafe.allocateInstance(c);
                return o;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getLogMessage(String methodName, Object[] args) {
        return MetaUtils.getLogMessage(methodName, args, 64);
    }

    public static String getLogMessage(String methodName, Object[] args, int argCharLen) {
        StringBuilder sb = new StringBuilder();
        sb.append(methodName);
        sb.append('(');
        for (Object arg : args) {
            sb.append(MetaUtils.getJsonStringToMaxLength(arg, argCharLen));
            sb.append("  ");
        }
        String result = sb.toString().trim();
        return result + ')';
    }

    private static String getJsonStringToMaxLength(Object obj, int argCharLen) {
        WriteOptions options = new WriteOptionsBuilder().shortMetaKeys(true).showTypeInfoNever().build();
        String arg = JsonIo.toJson(obj, options);
        if (arg.length() > argCharLen) {
            arg = arg.substring(0, argCharLen) + "...";
        }
        return arg;
    }

    public static <K, V> V getValueWithDefaultForNull(Map map, K key, V defaultValue) {
        Object value = map.get(key);
        return value == null ? defaultValue : value;
    }

    public static <K, V> V getValueWithDefaultForMissing(Map map, K key, V defaultValue) {
        if (!map.containsKey(key)) {
            return defaultValue;
        }
        return map.get(key);
    }

    public static void setFieldValue(Field field, Object instance, Object value) {
        try {
            if (instance == null) {
                throw new JsonIoException("Attempting to set field: " + field.getName() + " on null object.");
            }
            field.set(instance, value);
        }
        catch (IllegalAccessException e) {
            throw new JsonIoException("Cannot set field: " + field.getName() + " on class: " + instance.getClass().getName() + " as field is not accessible.  Add a ClassFactory implementation to create the needed class, and use JsonReader.assignInstantiator() to associate your ClassFactory to the class: " + instance.getClass().getName(), e);
        }
    }

    public static void trySetAccessible(AccessibleObject object) {
        MetaUtils.safelyIgnoreException(() -> object.setAccessible(true));
    }

    public static <T> T safelyIgnoreException(Callable<T> callable, T defaultValue) {
        try {
            return callable.call();
        }
        catch (Throwable e) {
            return defaultValue;
        }
    }

    public static void safelyIgnoreException(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static int length(String s) {
        return s == null ? 0 : s.length();
    }

    public static int trimLength(String s) {
        return s == null ? 0 : s.trim().length();
    }

    public static boolean isPrimitive(Class<?> c) {
        return Primitives.isPrimitive(c);
    }

    public static boolean isLogicalPrimitive(Class<?> c) {
        return MetaUtils.isPrimitive(c) || c.equals(String.class) || Number.class.isAssignableFrom(c) || Date.class.isAssignableFrom(c) || c.isEnum() || c.equals(Class.class);
    }

    static Set<String> commaSeparatedStringToSet(String commaSeparatedString) {
        return Arrays.stream(commaSeparatedString.split(",")).map(String::trim).collect(Collectors.toSet());
    }

    public static Map<String, String> loadMapDefinition(String resName) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        try {
            String contents = MetaUtils.loadResourceAsString(resName);
            Scanner scanner = new Scanner(contents);
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (line.trim().startsWith("#") || line.isEmpty()) continue;
                String[] parts = line.split("=");
                map.put(parts[0].trim(), parts[1].trim());
            }
            scanner.close();
        }
        catch (Exception e) {
            throw new JsonIoException("Error reading in " + resName + ". The file should be in the resources folder. The contents are expected to have two strings separated by '='. You can use # or blank lines in the file, they will be skipped.");
        }
        return map;
    }

    public static Set<String> loadSetDefinition(String resName) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        try {
            String contents = MetaUtils.loadResourceAsString(resName);
            Scanner scanner = new Scanner(contents);
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine().trim();
                if (line.startsWith("#") || line.isEmpty()) continue;
                set.add(line);
            }
            scanner.close();
        }
        catch (Exception e) {
            throw new JsonIoException("Error reading in " + resName + ". The file should be in the resources folder. The contents have a single String per line.  You can use # (comment) or blank lines in the file, they will be skipped.");
        }
        return set;
    }

    public static String loadResourceAsString(String resourceName) {
        byte[] resourceBytes = MetaUtils.loadResourceAsBytes(resourceName);
        return new String(resourceBytes, StandardCharsets.UTF_8);
    }

    public static byte[] loadResourceAsBytes(String resourceName) {
        byte[] byArray;
        block9: {
            InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
            try {
                if (inputStream == null) {
                    throw new JsonIoException("Resource not found: " + resourceName);
                }
                byArray = MetaUtils.readInputStreamFully(inputStream);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new JsonIoException("Error reading resource: " + resourceName, e);
                }
            }
            inputStream.close();
        }
        return byArray;
    }

    private static byte[] readInputStreamFully(InputStream inputStream) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    public static String removeLeadingAndTrailingQuotes(String input) {
        Matcher m = extraQuotes.matcher(input);
        if (m.find()) {
            input = m.group(1);
        }
        return input;
    }

    public static <T> T findClosest(Class<?> clazz, Map<Class<?>, T> workerClasses, T defaultClass) {
        T closest = defaultClass;
        int minDistance = Integer.MAX_VALUE;
        for (Map.Entry<Class<?>, T> entry : workerClasses.entrySet()) {
            Class<?> clz = entry.getKey();
            if (clz == clazz) {
                return entry.getValue();
            }
            int distance = ClassUtilities.computeInheritanceDistance(clazz, clz);
            if (distance == -1 || distance >= minDistance) continue;
            minDistance = distance;
            closest = entry.getValue();
        }
        return closest;
    }

    static boolean isPrimitiveArrayUsingClassName(Class<?> arrayClass) {
        String className = arrayClass.getName();
        return primArray.matcher(className).matches();
    }

    static {
        DIRECT_CLASS_MAPPING = new HashMap();
        ASSIGNABLE_CLASS_MAPPING = new LinkedHashMap();
        extraQuotes = Pattern.compile("^\"*(.*?)\"*$");
        DIRECT_CLASS_MAPPING.put(Date.class, Date::new);
        DIRECT_CLASS_MAPPING.put(StringBuilder.class, StringBuilder::new);
        DIRECT_CLASS_MAPPING.put(StringBuffer.class, StringBuffer::new);
        DIRECT_CLASS_MAPPING.put(Locale.class, Locale::getDefault);
        DIRECT_CLASS_MAPPING.put(TimeZone.class, TimeZone::getDefault);
        DIRECT_CLASS_MAPPING.put(Timestamp.class, () -> new Timestamp(System.currentTimeMillis()));
        DIRECT_CLASS_MAPPING.put(java.sql.Date.class, () -> new java.sql.Date(System.currentTimeMillis()));
        DIRECT_CLASS_MAPPING.put(LocalDate.class, LocalDate::now);
        DIRECT_CLASS_MAPPING.put(LocalDateTime.class, LocalDateTime::now);
        DIRECT_CLASS_MAPPING.put(OffsetDateTime.class, OffsetDateTime::now);
        DIRECT_CLASS_MAPPING.put(ZonedDateTime.class, ZonedDateTime::now);
        DIRECT_CLASS_MAPPING.put(ZoneId.class, ZoneId::systemDefault);
        DIRECT_CLASS_MAPPING.put(AtomicBoolean.class, AtomicBoolean::new);
        DIRECT_CLASS_MAPPING.put(AtomicInteger.class, AtomicInteger::new);
        DIRECT_CLASS_MAPPING.put(AtomicLong.class, AtomicLong::new);
        DIRECT_CLASS_MAPPING.put(URL.class, () -> MetaUtils.safelyIgnoreException(() -> new URL("http://localhost"), null));
        DIRECT_CLASS_MAPPING.put(Object.class, Object::new);
        DIRECT_CLASS_MAPPING.put(String.class, () -> "");
        DIRECT_CLASS_MAPPING.put(BigInteger.class, () -> BigInteger.ZERO);
        DIRECT_CLASS_MAPPING.put(BigDecimal.class, () -> BigDecimal.ZERO);
        DIRECT_CLASS_MAPPING.put(Class.class, () -> String.class);
        DIRECT_CLASS_MAPPING.put(Calendar.class, Calendar::getInstance);
        DIRECT_CLASS_MAPPING.put(Instant.class, Instant::now);
        ASSIGNABLE_CLASS_MAPPING.put(EnumSet.class, () -> null);
        ASSIGNABLE_CLASS_MAPPING.put(List.class, ArrayList::new);
        ASSIGNABLE_CLASS_MAPPING.put(NavigableSet.class, TreeSet::new);
        ASSIGNABLE_CLASS_MAPPING.put(SortedSet.class, TreeSet::new);
        ASSIGNABLE_CLASS_MAPPING.put(Set.class, LinkedHashSet::new);
        ASSIGNABLE_CLASS_MAPPING.put(NavigableMap.class, TreeMap::new);
        ASSIGNABLE_CLASS_MAPPING.put(SortedMap.class, TreeMap::new);
        ASSIGNABLE_CLASS_MAPPING.put(Map.class, LinkedHashMap::new);
        ASSIGNABLE_CLASS_MAPPING.put(Collection.class, ArrayList::new);
        ASSIGNABLE_CLASS_MAPPING.put(Calendar.class, Calendar::getInstance);
        ASSIGNABLE_CLASS_MAPPING.put(LinkedHashSet.class, LinkedHashSet::new);
        nameToClass.put("boolean", Boolean.TYPE);
        nameToClass.put("char", Character.TYPE);
        nameToClass.put("byte", Byte.TYPE);
        nameToClass.put("short", Short.TYPE);
        nameToClass.put("int", Integer.TYPE);
        nameToClass.put("long", Long.TYPE);
        nameToClass.put("float", Float.TYPE);
        nameToClass.put("double", Double.TYPE);
        nameToClass.put("string", String.class);
        nameToClass.put("date", Date.class);
        nameToClass.put("class", Class.class);
        primArray = Pattern.compile("\\[+[ZBCDFIJS]");
    }

    private static class CachedConstructor {
        private final Constructor<?> constructor;
        private final boolean useNullSetting;

        CachedConstructor(Constructor<?> constructor, boolean useNullSetting) {
            this.constructor = constructor;
            this.useNullSetting = useNullSetting;
        }
    }

    private static class ConstructorWithValues
    implements Comparable<ConstructorWithValues> {
        final Constructor<?> constructor;
        final Object[] argsNull;
        final Object[] argsNonNull;

        ConstructorWithValues(Constructor<?> constructor, Object[] argsNull, Object[] argsNonNull) {
            this.constructor = constructor;
            this.argsNull = argsNull;
            this.argsNonNull = argsNonNull;
        }

        @Override
        public int compareTo(ConstructorWithValues other) {
            long score2;
            int mods = this.constructor.getModifiers();
            int otherMods = other.constructor.getModifiers();
            if (!Modifier.isPublic(mods) && Modifier.isPublic(otherMods)) {
                return 1;
            }
            if (Modifier.isPublic(mods) && !Modifier.isPublic(otherMods)) {
                return -1;
            }
            if (!Modifier.isProtected(mods) && Modifier.isProtected(otherMods)) {
                return 1;
            }
            if (Modifier.isProtected(mods) && !Modifier.isProtected(otherMods)) {
                return -1;
            }
            long score1 = this.scoreArgumentValues(this.argsNull);
            if (score1 < (score2 = this.scoreArgumentValues(other.argsNull))) {
                return 1;
            }
            if (score1 > score2) {
                return -1;
            }
            score1 = this.scoreArgumentValues(this.argsNonNull);
            if (score1 < (score2 = this.scoreArgumentValues(other.argsNonNull))) {
                return 1;
            }
            if (score1 > score2) {
                return -1;
            }
            String params1 = this.buildParameterTypeString(this.constructor);
            String params2 = this.buildParameterTypeString(other.constructor);
            return params1.compareTo(params2);
        }

        private long scoreArgumentValues(Object[] args) {
            if (args.length == 0) {
                return 0L;
            }
            int nonNull = 0;
            for (Object arg : args) {
                if (arg == null) continue;
                ++nonNull;
            }
            return (long)nonNull * 100L + (long)args.length * 50L;
        }

        private String buildParameterTypeString(Constructor<?> constructor) {
            Class<?>[] paramTypes = constructor.getParameterTypes();
            StringBuilder s = new StringBuilder();
            for (Class<?> paramType : paramTypes) {
                s.append(paramType.getName()).append(".");
            }
            return s.toString();
        }
    }

    static final class Dumpty
    extends Enum<Dumpty> {
        private static final /* synthetic */ Dumpty[] $VALUES;

        public static Dumpty[] values() {
            return (Dumpty[])$VALUES.clone();
        }

        public static Dumpty valueOf(String name) {
            return Enum.valueOf(Dumpty.class, name);
        }

        private static /* synthetic */ Dumpty[] $values() {
            return new Dumpty[0];
        }

        static {
            $VALUES = Dumpty.$values();
        }
    }
}

