/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io.factory;

import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.JsonReader;
import com.cedarsoftware.io.Resolver;
import com.cedarsoftware.util.ExceptionUtilities;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class RecordFactory
implements JsonReader.ClassFactory {
    private RecordFactory() {
    }

    @Override
    public boolean isObjectFinal() {
        return true;
    }

    public static class RecordReader
    implements JsonReader.JsonClassReader {
        @Override
        public Object read(Object o, Resolver resolver) {
            try {
                Object[] recordComponents;
                JsonObject jsonObj = (JsonObject)o;
                ArrayList<Class> lParameterTypes = new ArrayList<Class>(jsonObj.size());
                ArrayList<Object> lParameterValues = new ArrayList<Object>(jsonObj.size());
                Class<?> c = jsonObj.getRawType();
                Method getRecordComponents = Class.class.getMethod("getRecordComponents", new Class[0]);
                for (Object recordComponent : recordComponents = (Object[])getRecordComponents.invoke(c, new Object[0])) {
                    Class type = (Class)recordComponent.getClass().getMethod("getType", new Class[0]).invoke(recordComponent, new Object[0]);
                    lParameterTypes.add(type);
                    String parameterName = (String)recordComponent.getClass().getMethod("getName", new Class[0]).invoke(recordComponent, new Object[0]);
                    JsonObject paramValueJsonObj = new JsonObject();
                    paramValueJsonObj.setType(type);
                    paramValueJsonObj.setValue(jsonObj.get(parameterName));
                    if (resolver.valueToTarget(paramValueJsonObj)) {
                        lParameterValues.add(paramValueJsonObj.getTarget());
                        continue;
                    }
                    lParameterValues.add(paramValueJsonObj.getValue());
                }
                Constructor<?> constructor = c.getDeclaredConstructor(lParameterTypes.toArray(new Class[0]));
                ExceptionUtilities.safelyIgnoreException(() -> constructor.setAccessible(true));
                return constructor.newInstance(lParameterValues.toArray(new Object[0]));
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Record de-serialization only works with java>=16.", e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

