/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.JsonValue;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class JsonObject
extends JsonValue
implements Map<Object, Object> {
    private final Map<Object, Object> jsonStore = new LinkedHashMap<Object, Object>();
    private Integer hash = null;
    private Object[] items;
    private Object[] keys;
    private String typeString;

    public String toString() {
        String jType = this.typeString != null ? this.typeString : (this.type == null ? "not set" : this.type.getTypeName());
        String targetInfo = this.target == null ? "null" : jType;
        return "JsonObject(id:" + this.id + ", type:" + jType + ", target:" + targetInfo + ", line:" + this.line + ", col:" + this.col + ", size:" + this.size() + ")";
    }

    public boolean isMap() {
        return this.target instanceof Map || this.type != null && Map.class.isAssignableFrom(this.getRawType());
    }

    public boolean isCollection() {
        if (this.target instanceof Collection) {
            return true;
        }
        if (this.isMap()) {
            return false;
        }
        if (this.items != null && this.keys == null) {
            Class<?> type = this.getRawType();
            return type != null && !type.isArray();
        }
        return false;
    }

    @Override
    public boolean isArray() {
        if (this.target == null) {
            if (this.type != null) {
                return this.getRawType().isArray();
            }
            return this.items != null && this.keys == null;
        }
        return this.target.getClass().isArray();
    }

    public Object[] getItems() {
        return this.items;
    }

    public void setItems(Object[] array) {
        if (array == null) {
            throw new JsonIoException("Argument array cannot be null");
        }
        this.items = array;
        this.hash = null;
    }

    public Object[] getKeys() {
        return this.keys;
    }

    void setKeys(Object[] keys) {
        if (keys == null) {
            throw new JsonIoException("Argument 'keys' cannot be null");
        }
        this.keys = keys;
        this.hash = null;
    }

    public String getTypeString() {
        return this.typeString;
    }

    void setTypeString(String typeString) {
        this.typeString = typeString;
    }

    @Override
    public int size() {
        if (this.items != null) {
            return Array.getLength(this.items);
        }
        return this.jsonStore.size();
    }

    @Deprecated
    public int getLength() {
        return this.size();
    }

    public void setValue(Object o) {
        this.jsonStore.put("value", o);
        this.hash = null;
    }

    public Object getValue() {
        return this.jsonStore.get("value");
    }

    public boolean hasValue() {
        return this.size() == 1 && this.jsonStore.containsKey("value");
    }

    @Override
    public int hashCode() {
        if (this.hash == null) {
            int result = 1;
            if (this.keys != null) {
                result = 31 * result + this.hashCode(this.keys, new IdentityHashMap<Object, Integer>());
            }
            if (this.items != null) {
                result = 31 * result + this.hashCode(this.items, new IdentityHashMap<Object, Integer>());
            }
            if (!this.jsonStore.isEmpty()) {
                result = 31 * result + this.jsonStore.hashCode();
            }
            this.hash = result;
        }
        return this.hash;
    }

    private int hashCode(Object array, Map<Object, Integer> seen) {
        if (array == null) {
            return 1;
        }
        if (!array.getClass().isArray()) {
            return array.hashCode();
        }
        Integer cachedHash = seen.get(array);
        if (cachedHash != null) {
            return cachedHash;
        }
        seen.put(array, null);
        int result = 1;
        for (Object item : (Object[])array) {
            result = 31 * result + this.hashCode(item, seen);
        }
        seen.put(array, result);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JsonObject)) {
            return false;
        }
        JsonObject other = (JsonObject)obj;
        if (!JsonObject.shallowArrayEquals(this.items, other.items)) {
            return false;
        }
        if (!JsonObject.shallowArrayEquals(this.keys, other.keys)) {
            return false;
        }
        return this.jsonStore.equals(other.jsonStore);
    }

    private static boolean shallowArrayEquals(Object[] arr1, Object[] arr2) {
        int len2;
        if (arr1 == arr2) {
            return true;
        }
        if (arr1 == null || arr2 == null) {
            return false;
        }
        int len1 = Array.getLength(arr1);
        if (len1 != (len2 = Array.getLength(arr2))) {
            return false;
        }
        for (int i = 0; i < len1; ++i) {
            Object e1 = arr1[i];
            Object e2 = arr2[i];
            if (Objects.equals(e1, e2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size() < 1;
    }

    @Override
    public Object remove(Object key) {
        this.hash = null;
        return this.jsonStore.remove(key);
    }

    @Override
    public Object put(Object key, Object value) {
        this.hash = null;
        return this.jsonStore.put(key, value);
    }

    @Override
    public void putAll(Map<?, ?> map) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.jsonStore.clear();
        this.items = null;
        this.keys = null;
        this.hash = null;
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.keys != null) {
            for (Object k : this.keys) {
                if (!Objects.equals(key, k)) continue;
                return true;
            }
            return false;
        }
        return this.jsonStore.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.items != null) {
            for (Object v : this.items) {
                if (!Objects.equals(value, v)) continue;
                return true;
            }
            return false;
        }
        return this.jsonStore.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        if (this.keys != null && this.items != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!Objects.equals(key, this.keys[i])) continue;
                return this.items[i];
            }
            return null;
        }
        return this.jsonStore.get(key);
    }

    @Override
    public Set<Object> keySet() {
        if (this.keys != null) {
            return new LinkedHashSet<Object>(Arrays.asList(this.keys));
        }
        return this.jsonStore.keySet();
    }

    @Override
    public Collection<Object> values() {
        if (this.items != null) {
            LinkedHashSet<Object> valueList = new LinkedHashSet<Object>();
            Collections.addAll(valueList, this.items);
            return valueList;
        }
        return this.jsonStore.values();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        if (this.keys != null && this.items != null) {
            LinkedHashSet<Map.Entry<Object, Object>> entrySet = new LinkedHashSet<Map.Entry<Object, Object>>();
            int i = 0;
            while (i < this.keys.length) {
                final int index = i++;
                entrySet.add(new Map.Entry<Object, Object>(){

                    @Override
                    public Object getKey() {
                        return JsonObject.this.keys[index];
                    }

                    @Override
                    public Object getValue() {
                        return JsonObject.this.items[index];
                    }

                    @Override
                    public Object setValue(Object value) {
                        Object oldValue = JsonObject.this.items[index];
                        ((JsonObject)JsonObject.this).items[index] = value;
                        JsonObject.this.hash = null;
                        return oldValue;
                    }

                    @Override
                    public boolean equals(Object o) {
                        if (!(o instanceof Map.Entry)) {
                            return false;
                        }
                        Map.Entry e = (Map.Entry)o;
                        return Objects.equals(JsonObject.this.keys[index], e.getKey()) && Objects.equals(JsonObject.this.items[index], e.getValue());
                    }

                    @Override
                    public int hashCode() {
                        return (JsonObject.this.keys[index] == null ? 0 : JsonObject.this.keys[index].hashCode()) ^ (JsonObject.this.items[index] == null ? 0 : JsonObject.this.items[index].hashCode());
                    }
                });
            }
            return entrySet;
        }
        return this.jsonStore.entrySet();
    }

    Map.Entry<Object[], Object[]> asTwoArrays() {
        if (this.keys == null && this.items == null && !this.isReference()) {
            Object[] newKeys = new Object[this.jsonStore.size()];
            Object[] newValues = new Object[this.jsonStore.size()];
            int i = 0;
            for (Map.Entry<Object, Object> entry : this.jsonStore.entrySet()) {
                newKeys[i] = entry.getKey();
                newValues[i] = entry.getValue();
                ++i;
            }
            this.setKeys(newKeys);
            this.setItems(newValues);
            this.jsonStore.clear();
            return new AbstractMap.SimpleImmutableEntry<Object[], Object[]>(newKeys, newValues);
        }
        if (this.keys == null && this.items != null || this.keys != null && this.items == null) {
            throw new JsonIoException("@keys or @items cannot be empty if the other is not empty");
        }
        if (this.keys != null && this.items != null && Array.getLength(this.keys) != Array.getLength(this.items)) {
            throw new JsonIoException("@keys and @items must be same length");
        }
        return new AbstractMap.SimpleImmutableEntry<Object[], Object[]>(this.keys, this.items);
    }

    void rehashMaps() {
        if (this.keys == null || this.items == null) {
            return;
        }
        this.hash = null;
        Map targetMap = (Map)this.target;
        int len = this.keys.length;
        for (int i = 0; i < len; ++i) {
            Object key = this.keys[i];
            Object value = this.items[i];
            this.jsonStore.put(key, value);
            if (targetMap == null) continue;
            targetMap.put(key, value);
        }
        this.keys = null;
        this.items = null;
    }
}

