/*
 * Decompiled with CFR 0.152.
 */
package com.cedricwalter.maven.git;

import java.io.File;
import java.io.IOException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.util.FS;

public class BranchNameDetector {
    public static String getBranchName(String pathname) throws IOException {
        if (BranchNameDetector.inTravis()) {
            return BranchNameDetector.getTravisBranch();
        }
        File directory = new File(pathname);
        Repository repository = RepositoryCache.open((RepositoryCache.Key)RepositoryCache.FileKey.lenient((File)directory, (FS)FS.DETECTED), (boolean)true);
        return repository.getBranch();
    }

    private static boolean inTravis() {
        String travis = System.getProperty("TRAVIS");
        return !"".equals(travis) && "true".equals(travis);
    }

    private static String getTravisBranch() {
        return System.getProperty("TRAVIS_BRANCH");
    }
}

