/*
 * Decompiled with CFR 0.152.
 */
package com.cedricwalter.maven.git;

public class BranchNameFixer {
    private boolean release;
    private boolean toUpperCase;
    private boolean toLowerCase;
    private boolean forceNumericalVersion;
    private boolean filterOutBranchQualifier;

    public BranchNameFixer(boolean release, boolean forceNumericalVersion, boolean toUpperCase, boolean toLowerCase, boolean filterOutBranchQualifier) {
        this.release = release;
        this.forceNumericalVersion = forceNumericalVersion;
        this.toUpperCase = toUpperCase;
        this.toLowerCase = toLowerCase;
        this.filterOutBranchQualifier = filterOutBranchQualifier;
    }

    public String fixer(String branchName) {
        String newBranchName = branchName;
        if (!this.release) {
            newBranchName = newBranchName + "-SNAPSHOT";
        }
        if (this.filterOutBranchQualifier) {
            newBranchName = newBranchName.replace("bugfix/", "");
            newBranchName = newBranchName.replace("feature/", "");
            newBranchName = newBranchName.replace("hotfix/", "");
            newBranchName = newBranchName.replace("release/", "");
        } else {
            newBranchName = newBranchName.replace("/", "-");
        }
        if (this.forceNumericalVersion && !Character.isDigit(newBranchName.charAt(0))) {
            newBranchName = "0-" + newBranchName;
        }
        if (this.toUpperCase) {
            newBranchName = newBranchName.toUpperCase();
        }
        if (this.toLowerCase) {
            newBranchName = newBranchName.toLowerCase();
        }
        return newBranchName;
    }
}

