/*
 * Decompiled with CFR 0.152.
 */
package com.cedricwalter.maven.git;

import com.cedricwalter.maven.git.BranchNameDetector;
import com.cedricwalter.maven.git.BranchNameFixer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="pom", threadSafe=true)
public class GitMojo
extends AbstractMojo {
    private Log log = this.getLog();
    @Component
    private MavenProject mavenProject;
    @Component
    private MavenSession mavenSession;
    @Component
    private BuildPluginManager pluginManager;
    @Parameter(defaultValue="false")
    private boolean release;
    @Parameter(defaultValue="false")
    private boolean forceNumericalVersion;
    @Parameter(defaultValue="false")
    private boolean toUpperCase;
    @Parameter(defaultValue="false")
    private boolean toLowerCase;
    @Parameter(defaultValue="true")
    private boolean filterOutBranchQualifier;
    @Parameter(defaultValue="versionFromGitBranch")
    private String versionFromGitBranch;
    @Parameter(defaultValue="false")
    private boolean setVariable;
    @Parameter(defaultValue="false")
    private boolean setFile;
    @Parameter(defaultValue="version.txt")
    private String fileName;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            BranchNameFixer branchNameFixer = new BranchNameFixer(this.release, this.forceNumericalVersion, this.toUpperCase, this.toLowerCase, this.filterOutBranchQualifier);
            String branchName = BranchNameDetector.getBranchName(".");
            this.log.info((CharSequence)("branch  " + branchName));
            String newVersion = branchNameFixer.fixer(branchName);
            MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.codehaus.mojo"), (String)MojoExecutor.artifactId((String)"versions-maven-plugin"), (String)MojoExecutor.version((String)"2.3")), (String)MojoExecutor.goal((String)"set"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"generateBackupPoms"), (String)"false"), MojoExecutor.element((String)MojoExecutor.name((String)"newVersion"), (String)newVersion)}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
            this.log.info((CharSequence)("All pom changed to " + newVersion));
            if (this.isSetVariable()) {
                System.setProperty(this.getVersionFromGitBranch(), newVersion);
            }
            if (this.setFile) {
                this.writeFileWithVersion(newVersion);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private void writeFileWithVersion(String newVersion) throws IOException {
        File directory = new File("./target");
        if (!directory.exists()) {
            try {
                directory.mkdir();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        Path path = Paths.get(directory.getCanonicalPath() + "/" + this.fileName, new String[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write("version=" + newVersion);
        }
    }

    public Log getLog() {
        return this.log;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public MavenProject getMavenProject() {
        return this.mavenProject;
    }

    public void setMavenProject(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
    }

    public MavenSession getMavenSession() {
        return this.mavenSession;
    }

    public void setMavenSession(MavenSession mavenSession) {
        this.mavenSession = mavenSession;
    }

    public BuildPluginManager getPluginManager() {
        return this.pluginManager;
    }

    public void setPluginManager(BuildPluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    public boolean isRelease() {
        return this.release;
    }

    public void setRelease(boolean release) {
        this.release = release;
    }

    public boolean isForceNumericalVersion() {
        return this.forceNumericalVersion;
    }

    public void setForceNumericalVersion(boolean forceNumericalVersion) {
        this.forceNumericalVersion = forceNumericalVersion;
    }

    public boolean isToUpperCase() {
        return this.toUpperCase;
    }

    public void setToUpperCase(boolean toUpperCase) {
        this.toUpperCase = toUpperCase;
    }

    public boolean isToLowerCase() {
        return this.toLowerCase;
    }

    public void setToLowerCase(boolean toLowerCase) {
        this.toLowerCase = toLowerCase;
    }

    public boolean isFilterOutBranchQualifier() {
        return this.filterOutBranchQualifier;
    }

    public void setFilterOutBranchQualifier(boolean filterOutBranchQualifier) {
        this.filterOutBranchQualifier = filterOutBranchQualifier;
    }

    public String getVersionFromGitBranch() {
        return this.versionFromGitBranch;
    }

    public void setVersionFromGitBranch(String versionFromGitBranch) {
        this.versionFromGitBranch = versionFromGitBranch;
    }

    public boolean isSetVariable() {
        return this.setVariable;
    }

    public void setSetVariable(boolean setVariable) {
        this.setVariable = setVariable;
    }

    public boolean isSetFile() {
        return this.setFile;
    }

    public void setSetFile(boolean setFile) {
        this.setFile = setFile;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
}

