/*
 * Decompiled with CFR 0.152.
 */
package com.ceph.rados;

import com.ceph.rados.exceptions.ErrorCode;
import com.ceph.rados.exceptions.RadosAlreadyConnectedException;
import com.ceph.rados.exceptions.RadosArgumentOutOfDomainException;
import com.ceph.rados.exceptions.RadosException;
import com.ceph.rados.exceptions.RadosInvalidArgumentException;
import com.ceph.rados.exceptions.RadosNotFoundException;
import com.ceph.rados.exceptions.RadosOperationInProgressException;
import com.ceph.rados.exceptions.RadosPermissionException;
import com.ceph.rados.exceptions.RadosReadOnlyException;
import com.ceph.rados.exceptions.RadosTimeoutException;
import java.util.concurrent.Callable;

public class RadosBase {
    protected final <T extends Number> T handleReturnCode(Callable<T> callable, String errorMsg, Object ... errorMsgArgs) throws RadosException {
        Number result = (Number)this.call(callable);
        if (result.intValue() < 0) {
            RadosBase.throwException(result.intValue(), String.format(errorMsg, errorMsgArgs));
        }
        return (T)result;
    }

    private <T> T call(Callable<T> callable) throws RadosException {
        T result;
        try {
            result = callable.call();
        }
        catch (Exception ex) {
            String unknownErrorMsg = String.format("Unknown exception: %s: %s", ex.getClass().getSimpleName(), ex.getMessage());
            throw new RadosException(unknownErrorMsg, ex);
        }
        return result;
    }

    public static void throwException(int errorCode, String msg) throws RadosException {
        String exceptionMessage;
        ErrorCode errorCodeEnum = ErrorCode.getEnum(errorCode);
        if (errorCodeEnum != null) {
            exceptionMessage = String.format("%s; %s: %s", msg, errorCodeEnum.name(), errorCodeEnum.getErrorMessage());
            switch (errorCodeEnum) {
                case EPERM: {
                    throw new RadosPermissionException(exceptionMessage, errorCode);
                }
                case ENOENT: {
                    throw new RadosNotFoundException(exceptionMessage, errorCode);
                }
                case EINVAL: {
                    throw new RadosInvalidArgumentException(exceptionMessage, errorCode);
                }
                case EROFS: {
                    throw new RadosReadOnlyException(exceptionMessage, errorCode);
                }
                case EDOM: {
                    throw new RadosArgumentOutOfDomainException(exceptionMessage, errorCode);
                }
                case EISCONN: {
                    throw new RadosAlreadyConnectedException(exceptionMessage, errorCode);
                }
                case ETIMEDOUT: {
                    throw new RadosTimeoutException(exceptionMessage, errorCode);
                }
                case EINPROGRESS: {
                    throw new RadosOperationInProgressException(exceptionMessage, errorCode);
                }
            }
        } else {
            exceptionMessage = String.format("%s; error code: %d", msg, errorCode);
        }
        throw new RadosException(exceptionMessage, errorCode);
    }
}

