/*
 * Decompiled with CFR 0.152.
 */
package se.cgbystrom.netty;

import java.nio.charset.Charset;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.jboss.netty.util.CharsetUtil;

public class FlashPolicyHandler
extends FrameDecoder {
    private static final String XML = "<cross-domain-policy><allow-access-from domain=\"*\" to-ports=\"*\" /></cross-domain-policy>";
    private ChannelBuffer policyResponse = ChannelBuffers.copiedBuffer((CharSequence)"<cross-domain-policy><allow-access-from domain=\"*\" to-ports=\"*\" /></cross-domain-policy>", (Charset)CharsetUtil.UTF_8);

    public FlashPolicyHandler() {
    }

    public FlashPolicyHandler(ChannelBuffer policyResponse) {
        this.policyResponse = policyResponse;
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        boolean isFlashPolicyRequest;
        if (buffer.readableBytes() < 2) {
            return null;
        }
        short magic1 = buffer.getUnsignedByte(buffer.readerIndex());
        short magic2 = buffer.getUnsignedByte(buffer.readerIndex() + 1);
        boolean bl = isFlashPolicyRequest = magic1 == 60 && magic2 == 112;
        if (isFlashPolicyRequest) {
            buffer.skipBytes(buffer.readableBytes());
            channel.write((Object)this.policyResponse).addListener(ChannelFutureListener.CLOSE);
            return null;
        }
        ctx.getPipeline().remove((ChannelHandler)this);
        return buffer.readBytes(buffer.readableBytes());
    }
}

