/*
 * Decompiled with CFR 0.152.
 */
package se.cgbystrom.netty.http;

import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;

public class BandwidthMeterHandler
extends SimpleChannelHandler {
    private static final int RESOLUTION = 1000;
    private static final int HISTORY_SIZE = 60;
    private AtomicLong bytesSent = new AtomicLong();
    private AtomicLong bytesReceived = new AtomicLong();
    private AtomicLong bytesSentPerSecond = new AtomicLong();
    private AtomicLong bytesReceivedPerSecond = new AtomicLong();

    public BandwidthMeterHandler() {
    }

    public BandwidthMeterHandler(Timer timer) {
        timer.newTimeout((TimerTask)new CollectBandwidthStats(), 1000L, TimeUnit.MILLISECONDS);
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (e instanceof MessageEvent && ((MessageEvent)e).getMessage() instanceof ChannelBuffer) {
            ChannelBuffer b = (ChannelBuffer)((MessageEvent)e).getMessage();
            this.bytesReceived.addAndGet(b.readableBytes());
        }
        super.handleUpstream(ctx, e);
    }

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (e instanceof MessageEvent && ((MessageEvent)e).getMessage() instanceof ChannelBuffer) {
            ChannelBuffer b = (ChannelBuffer)((MessageEvent)e).getMessage();
            this.bytesSent.addAndGet(b.readableBytes());
        }
        super.handleDownstream(ctx, e);
    }

    public void reset() {
        this.bytesSent.set(0L);
        this.bytesReceived.set(0L);
    }

    public long getBytesSent() {
        return this.bytesSent.get();
    }

    public long getBytesReceived() {
        return this.bytesReceived.get();
    }

    public long getBytesSentPerSecond() {
        return this.bytesSentPerSecond.get();
    }

    public long getBytesReceivedPerSecond() {
        return this.bytesReceivedPerSecond.get();
    }

    private class CollectBandwidthStats
    implements TimerTask {
        private long lastTimestamp = 0L;
        private long lastBytesSent = BandwidthMeterHandler.access$000(BandwidthMeterHandler.this).get();
        private long lastBytesReceived = BandwidthMeterHandler.access$100(BandwidthMeterHandler.this).get();
        private LinkedList<Long> sentHistory = new LinkedList();
        private LinkedList<Long> receivedHistory = new LinkedList();

        private CollectBandwidthStats() {
        }

        public void run(Timeout timeout) throws Exception {
            if (timeout.isCancelled()) {
                return;
            }
            long timestamp = System.currentTimeMillis();
            long deltaTime = timestamp - this.lastTimestamp;
            long sent = BandwidthMeterHandler.this.bytesSent.get() - this.lastBytesSent;
            long received = BandwidthMeterHandler.this.bytesReceived.get() - this.lastBytesReceived;
            this.lastBytesSent = BandwidthMeterHandler.this.bytesSent.get();
            this.lastBytesReceived = BandwidthMeterHandler.this.bytesReceived.get();
            if (sent < 0L) {
                sent = 0L;
            }
            if (received < 0L) {
                received = 0L;
            }
            this.sentHistory.add(sent / deltaTime);
            this.receivedHistory.add(received / deltaTime);
            if (this.sentHistory.size() > 60) {
                this.sentHistory.removeFirst();
            }
            if (this.receivedHistory.size() > 60) {
                this.receivedHistory.removeFirst();
            }
            BandwidthMeterHandler.this.bytesSentPerSecond.set(this.average(this.sentHistory) * 1000L);
            BandwidthMeterHandler.this.bytesReceivedPerSecond.set(this.average(this.receivedHistory) * 1000L);
            this.lastTimestamp = timestamp;
            timeout.getTimer().newTimeout(timeout.getTask(), 1000L, TimeUnit.MILLISECONDS);
        }

        private Long average(Collection<Long> values) {
            if (values.isEmpty()) {
                return 0L;
            }
            long total = 0L;
            for (Long messageTiming : values) {
                total += messageTiming.longValue();
            }
            return total / (long)values.size();
        }
    }
}

