/*
 * Decompiled with CFR 0.152.
 */
package se.cgbystrom.netty.http;

import java.nio.charset.Charset;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.util.CharsetUtil;
import se.cgbystrom.netty.http.CachableHttpResponse;

public class CacheHandler
extends SimpleChannelHandler {
    private static Pattern maxAgePattern = Pattern.compile("max-age=\\d+");
    private ConcurrentHashMap<String, CacheEntry> cache = new ConcurrentHashMap();

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        HttpRequest request;
        CacheEntry ce;
        if (e instanceof MessageEvent && ((MessageEvent)e).getMessage() instanceof HttpRequest && (ce = this.cache.get((request = (HttpRequest)((MessageEvent)e).getMessage()).getUri())) != null && ce.expires > System.currentTimeMillis()) {
            ChannelFuture f = e.getChannel().write((Object)ce.content);
            f.addListener(ChannelFutureListener.CLOSE);
            if (!HttpHeaders.isKeepAlive((HttpMessage)request)) {
                f.addListener(ChannelFutureListener.CLOSE);
            }
            return;
        }
        super.handleUpstream(ctx, e);
    }

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        CachableHttpResponse r;
        if (e instanceof MessageEvent && ((MessageEvent)e).getMessage() instanceof CachableHttpResponse && (r = (CachableHttpResponse)((Object)((MessageEvent)e).getMessage())).getCacheMaxAge() > 0) {
            this.cache.putIfAbsent(r.getRequestUri(), new CacheEntry((HttpMessage)r, System.currentTimeMillis() + (long)(r.getCacheMaxAge() * 1000)));
        }
        super.handleDownstream(ctx, e);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        Channel ch = e.getChannel();
        Throwable cause = e.getCause();
        cause.printStackTrace();
        if (ch.isConnected()) {
            this.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
        response.setHeader("Content-Type", (Object)"text/plain; charset=UTF-8");
        response.setContent(ChannelBuffers.copiedBuffer((CharSequence)("Failure: " + status.toString() + "\r\n"), (Charset)CharsetUtil.UTF_8));
        ctx.getChannel().write((Object)response).addListener(ChannelFutureListener.CLOSE);
    }

    private static class CacheEntry {
        public HttpMessage content;
        public long expires;

        private CacheEntry(HttpMessage content, long expires) {
            this.content = content;
            this.expires = expires;
        }
    }
}

