/*
 * Decompiled with CFR 0.152.
 */
package se.cgbystrom.netty.http;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import javax.activation.MimetypesFileTypeMap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.codec.http.QueryStringDecoder;
import org.jboss.netty.util.CharsetUtil;
import se.cgbystrom.netty.http.CachableHttpResponse;

public class FileServerHandler
extends SimpleChannelUpstreamHandler {
    private String rootPath;
    private String stripFromUri;
    private int cacheMaxAge = -1;
    private boolean fromClasspath = false;
    private MimetypesFileTypeMap fileTypeMap = new MimetypesFileTypeMap();

    public FileServerHandler(String path) {
        if (path.startsWith("classpath://")) {
            this.fromClasspath = true;
            this.rootPath = path.replace("classpath://", "");
            if (this.rootPath.lastIndexOf("/") == this.rootPath.length() - 1) {
                this.rootPath = this.rootPath.substring(0, this.rootPath.length() - 1);
            }
        } else {
            this.rootPath = path;
        }
        this.rootPath = this.rootPath.replace(File.separatorChar, '/');
    }

    public FileServerHandler(String path, String stripFromUri) {
        this(path);
        this.stripFromUri = stripFromUri;
    }

    public FileServerHandler(String path, int cacheMaxAge) {
        this(path);
        this.cacheMaxAge = cacheMaxAge;
    }

    public FileServerHandler(String path, int cacheMaxAge, String stripFromUri) {
        this(path, cacheMaxAge);
        this.stripFromUri = stripFromUri;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        String path;
        HttpRequest request = (HttpRequest)e.getMessage();
        if (request.getMethod() != HttpMethod.GET) {
            this.sendError(ctx, HttpResponseStatus.METHOD_NOT_ALLOWED);
            return;
        }
        String uri = request.getUri();
        if (this.stripFromUri != null) {
            uri = uri.replaceFirst(this.stripFromUri, "");
        }
        if ((path = this.sanitizeUri(uri)) == null) {
            this.sendError(ctx, HttpResponseStatus.FORBIDDEN);
            return;
        }
        ChannelBuffer content = this.getFileContent(path);
        if (content == null) {
            this.sendError(ctx, HttpResponseStatus.NOT_FOUND);
            return;
        }
        String contentType = this.fileTypeMap.getContentType(path);
        CachableHttpResponse response = new CachableHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.setRequestUri(request.getUri());
        response.setCacheMaxAge(this.cacheMaxAge);
        response.setHeader("Content-Type", contentType);
        HttpHeaders.setContentLength((HttpMessage)response, (long)content.readableBytes());
        response.setContent(content);
        ChannelFuture writeFuture = e.getChannel().write((Object)response);
        if (!HttpHeaders.isKeepAlive((HttpMessage)request)) {
            writeFuture.addListener(ChannelFutureListener.CLOSE);
        }
    }

    private ChannelBuffer getFileContent(String path) {
        try {
            int r;
            InputStream is = this.fromClasspath ? ((Object)((Object)this)).getClass().getResourceAsStream(this.rootPath + path) : new FileInputStream(this.rootPath + path);
            if (is == null) {
                return null;
            }
            int maxSize = 524288;
            ByteArrayOutputStream out = new ByteArrayOutputStream(524288);
            byte[] bytes = new byte[524288];
            while ((r = is.read(bytes)) != -1) {
                out.write(bytes, 0, r);
            }
            ChannelBuffer cb = ChannelBuffers.copiedBuffer((byte[])out.toByteArray());
            out.close();
            is.close();
            return cb;
        }
        catch (IOException e) {
            return null;
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        Channel ch = e.getChannel();
        Throwable cause = e.getCause();
        if (cause instanceof TooLongFrameException) {
            this.sendError(ctx, HttpResponseStatus.BAD_REQUEST);
            return;
        }
        cause.printStackTrace();
        if (ch.isConnected()) {
            this.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private String sanitizeUri(String uri) throws URISyntaxException {
        try {
            uri = URLDecoder.decode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            try {
                uri = URLDecoder.decode(uri, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e1) {
                throw new Error();
            }
        }
        uri = uri.replace(File.separatorChar, '/');
        if (uri.contains(File.separator + ".") || uri.contains("." + File.separator) || uri.startsWith(".") || uri.endsWith(".")) {
            return null;
        }
        QueryStringDecoder decoder = new QueryStringDecoder(uri);
        if ((uri = decoder.getPath()).endsWith("/")) {
            uri = uri + "index.html";
        }
        return uri;
    }

    private void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
        response.setHeader("Content-Type", (Object)"text/plain; charset=UTF-8");
        response.setContent(ChannelBuffers.copiedBuffer((CharSequence)("Failure: " + status.toString() + "\r\n"), (Charset)CharsetUtil.UTF_8));
        ctx.getChannel().write((Object)response).addListener(ChannelFutureListener.CLOSE);
    }
}

