/*
 * Decompiled with CFR 0.152.
 */
package se.cgbystrom.netty.http;

import java.nio.charset.Charset;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;

public class SimpleResponseHandler
extends SimpleChannelUpstreamHandler {
    private String text;
    private HttpResponseStatus status = HttpResponseStatus.OK;

    public SimpleResponseHandler(String text) {
        this.text = text;
    }

    public SimpleResponseHandler(String text, HttpResponseStatus status) {
        this(text);
        this.status = status;
    }

    public SimpleResponseHandler(String text, int status) {
        this(text);
        this.status = HttpResponseStatus.valueOf((int)status);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, this.status);
        response.setHeader("Content-Type", (Object)"text/plain; charset=UTF-8");
        response.setContent(ChannelBuffers.copiedBuffer((CharSequence)this.text, (Charset)Charset.forName("UTF-8")));
        e.getChannel().write((Object)response).addListener(ChannelFutureListener.CLOSE);
    }
}

