/*
 * Decompiled with CFR 0.152.
 */
package se.cgbystrom.netty.http.websocket;

import java.net.URI;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.handler.codec.http.HttpRequestEncoder;
import org.jboss.netty.handler.codec.http.HttpResponseDecoder;
import se.cgbystrom.netty.http.websocket.WebSocketCallback;
import se.cgbystrom.netty.http.websocket.WebSocketClient;
import se.cgbystrom.netty.http.websocket.WebSocketClientHandler;

public class WebSocketClientFactory {
    private NioClientSocketChannelFactory socketChannelFactory = new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());

    public WebSocketClient newClient(URI url, WebSocketCallback callback) {
        ClientBootstrap bootstrap = new ClientBootstrap((ChannelFactory)this.socketChannelFactory);
        String protocol = url.getScheme();
        if (!protocol.equals("ws") && !protocol.equals("wss")) {
            throw new IllegalArgumentException("Unsupported protocol: " + protocol);
        }
        final WebSocketClientHandler clientHandler = new WebSocketClientHandler(bootstrap, url, callback);
        bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                pipeline.addLast("decoder", (ChannelHandler)new HttpResponseDecoder());
                pipeline.addLast("encoder", (ChannelHandler)new HttpRequestEncoder());
                pipeline.addLast("ws-handler", (ChannelHandler)clientHandler);
                return pipeline;
            }
        });
        return clientHandler;
    }
}

