/*
 * Decompiled with CFR 0.152.
 */
package se.cgbystrom.netty.http.websocket;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.codec.http.websocket.DefaultWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocket.WebSocketFrame;
import org.jboss.netty.handler.codec.http.websocket.WebSocketFrameDecoder;
import org.jboss.netty.handler.codec.http.websocket.WebSocketFrameEncoder;
import org.jboss.netty.util.CharsetUtil;
import se.cgbystrom.netty.http.websocket.WebSocketCallback;
import se.cgbystrom.netty.http.websocket.WebSocketClient;
import se.cgbystrom.netty.http.websocket.WebSocketException;

public class WebSocketClientHandler
extends SimpleChannelUpstreamHandler
implements WebSocketClient {
    private ClientBootstrap bootstrap;
    private URI url;
    private WebSocketCallback callback;
    private boolean handshakeCompleted = false;
    private Channel channel;

    public WebSocketClientHandler(ClientBootstrap bootstrap, URI url, WebSocketCallback callback) {
        this.bootstrap = bootstrap;
        this.url = url;
        this.callback = callback;
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        String path = this.url.getPath();
        if (this.url.getQuery() != null && this.url.getQuery().length() > 0) {
            path = this.url.getPath() + "?" + this.url.getQuery();
        }
        DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, path);
        request.addHeader("Upgrade", (Object)"WebSocket");
        request.addHeader("Connection", (Object)"Upgrade");
        request.addHeader("Host", (Object)this.url.getHost());
        request.addHeader("Origin", (Object)("http://" + this.url.getHost()));
        e.getChannel().write((Object)request);
        ctx.getPipeline().replace("encoder", "ws-encoder", (ChannelHandler)new WebSocketFrameEncoder());
        this.channel = e.getChannel();
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.callback.onDisconnect(this);
        this.handshakeCompleted = false;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (!this.handshakeCompleted) {
            HttpResponse response = (HttpResponse)e.getMessage();
            HttpResponseStatus status = new HttpResponseStatus(101, "Web Socket Protocol Handshake");
            boolean validStatus = response.getStatus().equals((Object)status);
            boolean validUpgrade = response.getHeader("Upgrade").equals("WebSocket");
            boolean validConnection = response.getHeader("Connection").equals("Upgrade");
            if (!(validStatus && validUpgrade && validConnection)) {
                throw new WebSocketException("Invalid handshake response");
            }
            this.handshakeCompleted = true;
            ctx.getPipeline().replace("decoder", "ws-decoder", (ChannelHandler)new WebSocketFrameDecoder());
            this.callback.onConnect(this);
            return;
        }
        if (e.getMessage() instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)e.getMessage();
            throw new WebSocketException("Unexpected HttpResponse (status=" + response.getStatus() + ", content=" + response.getContent().toString(CharsetUtil.UTF_8) + ")");
        }
        DefaultWebSocketFrame frame = (DefaultWebSocketFrame)e.getMessage();
        this.callback.onMessage(this, (WebSocketFrame)frame);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        Throwable t = e.getCause();
        this.callback.onError(t);
        e.getChannel().close();
    }

    @Override
    public ChannelFuture connect() {
        return this.bootstrap.connect((SocketAddress)new InetSocketAddress(this.url.getHost(), this.url.getPort()));
    }

    @Override
    public ChannelFuture disconnect() {
        return this.channel.close();
    }

    @Override
    public ChannelFuture send(WebSocketFrame frame) {
        return this.channel.write((Object)frame);
    }

    public URI getUrl() {
        return this.url;
    }

    public void setUrl(URI url) {
        this.url = url;
    }
}

