/*
 * Decompiled with CFR 0.152.
 */
package se.cgbystrom.netty.thrift;

import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import se.cgbystrom.netty.thrift.ThriftClientHandler;

public class TNettyTransport
extends TTransport {
    private final BlockingQueue<Byte> input;
    private final Channel channel;
    private final ChannelBuffer output = ChannelBuffers.dynamicBuffer();

    public TNettyTransport(Channel channel, ThriftClientHandler remote) {
        this.channel = channel;
        this.input = remote.getOutputQueue();
    }

    public void close() {
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public void open() throws TTransportException {
    }

    public int read(byte[] output, int offset, int length) throws TTransportException {
        int read = 0;
        int index = offset;
        int space = length - offset;
        while (space > 0) {
            byte aByte;
            output[index] = aByte = this.readAsynchrously();
            --space;
            ++index;
            ++read;
        }
        return read;
    }

    private byte readAsynchrously() {
        boolean interrupted = false;
        while (true) {
            try {
                byte aByte = this.input.take();
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
                return aByte;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
    }

    public void flush() throws TTransportException {
        ChannelBuffer flush = ChannelBuffers.dynamicBuffer();
        flush.writeBytes(this.output);
        this.channel.write((Object)flush).awaitUninterruptibly();
    }

    public void write(byte[] array, int offset, int length) throws TTransportException {
        this.output.writeBytes(Arrays.copyOfRange(array, offset, length));
    }
}

