/*
 * Decompiled with CFR 0.152.
 */
package se.cgbystrom.netty.thrift;

import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TTransport;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import se.cgbystrom.netty.thrift.TNettyChannelBuffer;
import se.cgbystrom.netty.thrift.ThriftHandler;

public class ThriftServerHandler
extends SimpleChannelUpstreamHandler
implements ThriftHandler {
    private TProcessor processor;
    private TProtocolFactory protocolFactory;
    private int responseSize = 4096;

    public ThriftServerHandler(TProcessor processor) {
        this.processor = processor;
        this.protocolFactory = new TBinaryProtocol.Factory();
    }

    public ThriftServerHandler(TProcessor processor, TProtocolFactory protocolFactory) {
        this.processor = processor;
        this.protocolFactory = protocolFactory;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        ChannelBuffer input;
        HttpRequest httpRequest = null;
        if (e.getMessage() instanceof HttpRequest) {
            httpRequest = (HttpRequest)e.getMessage();
            input = httpRequest.getContent();
        } else {
            input = (ChannelBuffer)e.getMessage();
        }
        ChannelBuffer output = ChannelBuffers.dynamicBuffer((int)this.responseSize);
        TProtocol protocol = this.protocolFactory.getProtocol((TTransport)new TNettyChannelBuffer(input, output));
        this.processor.process(protocol, protocol);
        if (httpRequest != null) {
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            response.setHeader("Content-Length", (Object)output.readableBytes());
            response.setContent(output);
            ChannelFuture future = e.getChannel().write((Object)response);
            if (!HttpHeaders.isKeepAlive((HttpMessage)httpRequest)) {
                future.addListener(ChannelFutureListener.CLOSE);
            }
        } else {
            e.getChannel().write((Object)output);
        }
    }

    public int getResponseSize() {
        return this.responseSize;
    }

    public void setResponseSize(int responseSize) {
        this.responseSize = responseSize;
    }
}

