/*
 * Decompiled with CFR 0.152.
 */
package se.cgbystrom.netty.thrift.http;

import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpRequestEncoder;
import org.jboss.netty.handler.codec.http.HttpResponseDecoder;
import se.cgbystrom.netty.thrift.ThriftHandler;
import se.cgbystrom.netty.thrift.http.HttpEncoder;

public class ThriftHttpClientPipelineFactory
implements ChannelPipelineFactory {
    private final ThriftHandler handler;
    private final String host;
    private final String uri;

    public ThriftHttpClientPipelineFactory(ThriftHandler handler, String host, String uri) {
        this.handler = handler;
        this.host = host;
        this.uri = uri;
    }

    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        pipeline.addLast("requestEncoder", (ChannelHandler)new HttpRequestEncoder());
        pipeline.addLast("channelEncoder", (ChannelHandler)new HttpEncoder(this.host, this.uri));
        pipeline.addLast("responseDecoder", (ChannelHandler)new HttpResponseDecoder());
        pipeline.addLast("aggregator", (ChannelHandler)new HttpChunkAggregator(0x100000));
        pipeline.addLast("thriftHandler", (ChannelHandler)this.handler);
        return pipeline;
    }
}

